find.pairs<-function(groups,morph.dist,pat.dist)
{

	taxes.1<-vector(length=0)
	taxes.2<-vector(length=0)
	group.1<-vector(length=0)
	group.2<-vector(length=0)
	pair.morph<-vector(length=0)
	pair.pat<-vector(length=0)

	for(i in 1:nrow(morph.dist))
	{
		for(j in i:ncol(morph.dist))
		{
			if(i!=j)
			{
				tax.1<-rownames(morph.dist)[i]
				tax.2<-colnames(morph.dist)[j]

				taxes.1<-c(taxes.1,tax.1)
				taxes.2<-c(taxes.2,tax.2)

				group.1<-c(group.1,groups[which(groups[,1]==tax.1),2])
				group.2<-c(group.2,groups[which(groups[,1]==tax.2),2])	

				pair.morph<-c(pair.morph,morph.dist[tax.1,tax.2])
				pair.pat<-c(pair.pat,pat.dist[tax.1,tax.2])
			}
		}
	}
	
	results<-data.frame(taxes.1,taxes.2,group.1,group.2,pair.morph,pair.pat)
	colnames(results)<-c("Taxon 1","Taxon 2","Group 1","Group 2","Morphological distance","Patristic distance")

	return(results)
}	


plot.groups<-function(data,col.point,col.line,lwd.shadow=NULL,...)
{
	groups<-unique(data$"Group 1")

	group.pairs<-vector(length=length(groups),mode="list")
	
	for(i in 1:nrow(data))
	{
		if(data[i,"Group 1"] == data[i,"Group 2"])
		{
			group.pairs[[which(groups==data[i,"Group 1"])]]<-c(group.pairs[[which(groups==data[i,"Group 1"])]],i)
		}
	}
			
		
	group.dists<-vector(length=length(groups),mode="list")
	for(i in 1:length(group.dists))
	{
		group.dists[[i]]<-cbind(data[group.pairs[[i]],"Morphological distance"],data[group.pairs[[i]],"Patristic distance"])
	}



	group.lin<-vector(length=length(groups),mode="list")
	for(i in 1:length(group.lin))
	{
		group.lin[[i]]<-loess(V1~V2,as.data.frame(group.dists[[i]]),span=1)
	}


	plot(group.dists[[1]][,2],group.dists[[1]][,1],xlab="Patristic Distance",
		ylab="Morphological Dissimilarity",col=col.point[[1]],
		xlim=c(min(data$"Patristic distance"),max(data$"Patristic distance")),
		ylim=c(min(data$"Morphological distance"),max(data$"Morphological distance")),...)

	for(i in 2:length(groups))
	{
		points(group.dists[[i]][,2],group.dists[[i]][,1],col=col.point[[i]],...)
	}

	if(is.null(lwd.shadow)==F)
	{
		for(i in 1:length(groups))
		{
			lines(sort(group.dists[[i]][,2]),sort(predict(group.lin[[i]])),col="white",lwd=lwd.shadow)
		}
	}

	for(i in 1:length(groups))
	{
		lines(sort(group.dists[[i]][,2]),sort(predict(group.lin[[i]])),col=col.line[[i]],...)
	}
}







char.sat<-function(tree,matrix,data,group,nsim)
{
	pat.dist<-as.matrix(distTips(tree,method = "patristic"))


	groups<-unique(data$"Group 1")

	group.pairs<-vector(length=length(groups),mode="list")
	
	for(i in 1:nrow(data))
	{
		if(data[i,"Group 1"] == data[i,"Group 2"])
		{
			group.pairs[[which(groups==data[i,"Group 1"])]]<-c(group.pairs[[which(groups==data[i,"Group 1"])]],i)
		}
	}
			
		
	group.dists<-vector(length=length(groups),mode="list")
	for(i in 1:length(group.dists))
	{
		group.dists[[i]]<-cbind(data[group.pairs[[i]],"Morphological distance"],data[group.pairs[[i]],"Patristic distance"])
	}


	sat.group<-vector(length=length(groups))
	for(i in 1:length(sat.group))
	{
		mm.group<-drm(V1~V2, data = as.data.frame(group.dists[[i]]), fct = MM.2())
		sat.group[i]<-coef(mm.group)[1]
	}


	
	models<-vector(length=ncol(matrix[[2]][[3]]),mode="list")
	for(i in 1:length(models))
	{
		char<-matrix[[2]][[3]][tree$tip.label,i]
		char[which(char=="")]<-NA

		test.tree<-drop.tip(tree,which(is.na(char)))
		char<-char[test.tree$tip.label]
	
		if(length(unique(char))>1)
		{
			models[[i]]<-fitMk(test.tree,char,model="ER")	
		}
		else(models[[i]]<-NA)
		
	}

	characters<-vector(length=ncol(matrix[[2]][[3]]),mode="list")

	for(i in 1:length(models))
	{
		if(length(models[[i]])>1)
		{
			sim.matrix<-matrix(nrow=nrow(models[[i]][[3]]),ncol=ncol(models[[i]][[3]])
			,data=models[[i]][[2]][models[[i]][[3]]])
	
			rownames(sim.matrix)<-colnames(sim.matrix)<-1:nrow(sim.matrix)
			for (j in 1:nrow(sim.matrix))
			{
				sim.matrix[j,j]<- -sum(sim.matrix[,j],na.rm=T)
			}

			characters[[i]]<-sim.Mk(tree,sim.matrix,nsim=nsim)
		}
		else(characters[[i]]<-NA)
	}

	sim.sat<-matrix(nrow=nsim,ncol=length(groups))	

	for(w in 1:nsim)
	{
		
	
		sim.matrix<-matrix
		sim.matrix[[2]][[3]]<-sim.matrix[[2]][[3]][tree$tip.label,]
	
		for(j in 1:ncol(sim.matrix[[2]][[3]]))
		{
			if(length(characters[[j]])>1)
			{
				sim.matrix[[2]][[3]][,j]<-characters[[j]][tree$tip.label,w]
			}	
			else(sim.matrix[[2]][[3]][,j]<-NA)
		}

	
		sim.dist<-MorphDistMatrix(sim.matrix,Distance="MORD")$DistanceMatrix

		sim.pairs<-find.pairs(group,sim.dist,pat.dist)
		

		group.pairs<-vector(length=length(groups),mode="list")
	
		for(i in 1:nrow(sim.pairs))
		{
			if(sim.pairs[i,"Group 1"] == sim.pairs[i,"Group 2"])
			{
				group.pairs[[which(groups==sim.pairs[i,"Group 1"])]]<-c(group.pairs[[which(groups==sim.pairs[i,"Group 1"])]],i)
			}
		}
			
		
		group.dists<-vector(length=length(groups),mode="list")
		for(i in 1:length(group.dists))
		{
			group.dists[[i]]<-cbind(sim.pairs[group.pairs[[i]],"Morphological distance"],sim.pairs[group.pairs[[i]],"Patristic distance"])
		}


		for(i in 1:length(groups))
		{
			mm.group<-drm(V1~V2, data = as.data.frame(group.dists[[i]]), fct = MM.2())
			sim.sat[w,i]<-coef(mm.group)[1]
		}

	}
	names(sat.group)<-groups
	colnames(sim.sat)<-groups
	results<-list(sat.group,sim.sat)
	names(results)<-c("Observed","Simulated")
	return(results)
}





char.sat.phylo<-function(tree,matrix,data,nsim)
{
	

	models<-vector(length=ncol(matrix[[2]][[3]]),mode="list")
	for(i in 1:length(models))
	{
		char<-matrix[[2]][[3]][,i]

		test.tree<-tree

		char<-char[test.tree$tip.label]
		char[which(char=="")]<-NA
		test.tree<-drop.tip(test.tree,which(is.na(char)))
	

		char<-char[test.tree$tip.label]
		if(length(unique(char))>1)
		{
			models[[i]]<-fitMk(test.tree,char,model="ER")	
		}
		else(models[[i]]<-NA)
	}	



	characters<-vector(length=ncol(matrix[[2]][[3]]),mode="list")
	{
		for(i in 1:length(models))
		{
			if(length(models[[i]])>1)
			{
				sim.matrix<-matrix(nrow=nrow(models[[i]][[3]]),ncol=ncol(models[[i]][[3]])
					,data=models[[i]][[2]][models[[i]][[3]]])
					
				rownames(sim.matrix)<-colnames(sim.matrix)<-1:nrow(sim.matrix)
				for (j in 1:nrow(sim.matrix))
				{
					sim.matrix[j,j]<- -sum(sim.matrix[,j],na.rm=T)
				}
	
				characters[[i]]<-sim.Mk(tree,sim.matrix,nsim=100)
			}
			else(characters[[i]]<-NA)

		}


	}

	nodes<-(length(tree$tip.label)+1):(length(tree$tip.label)+tree$Nnode)




	node.vmaxes<-matrix(nrow=length(nodes),ncol=2)
	colnames(node.vmaxes)<-c("Lower","Upper")



	for (i in 1:length(nodes))
	{

		desc.nodes<-getDescendants(tree,nodes[i])
		desc.tips<-desc.nodes[which(desc.nodes<=length(tree$tip.label))]

		in.tax<-tree$tip.label[desc.tips]
		in.pairs<-data[data[,1]%in%in.tax & data[,2]%in%in.tax,]


		if(is.null(nrow(in.pairs))==F && nrow(in.pairs)>=4)
		{
			in.dist<-cbind(as.numeric(in.pairs[,"Morphological distance"]),as.numeric(in.pairs[,"Patristic distance"]))
			tryCatch({
				mm.in<-drm(V1~V2, data = as.data.frame(in.dist), fct = MM.2())
				node.vmaxes[i,]<-yieldLoss(mm.in, interval = "as", level = 0.84, display = F)[[1]][3:4]
			},error=function(e){})
		}	
	}





	pat.dist<-as.matrix(distTips(tree,method = "patristic"))




	sim.node.vmaxes<-matrix(nrow=length(nodes),ncol=nsim)

	for(w in 1:nsim)
	{
		sim.matrix<-matrix
		sim.matrix[[2]][[3]]<-sim.matrix[[2]][[3]][tree$tip.label,]

		for(j in 1:ncol(sim.matrix[[2]][[3]]))
		{
			if(length(characters[[j]])>1)
			{
				sim.matrix[[2]][[3]][,j]<-characters[[j]][,w]
			}	
			else(sim.matrix[[2]][[3]][,j]<-NA)
			sim.matrix[[2]][[3]][is.na(matrix[[2]][[3]][tree$tip.label,j]),j]<-NA
		}



		sim.dist<-MorphDistMatrix(sim.matrix,Distance="MORD",TransformDistances = "none")$DistanceMatrix

		pat.dist<-pat.dist[rownames(sim.dist),colnames(sim.dist)]




		
	

		sim.pairs<-matrix(nrow=0,ncol=4)
		colnames(sim.pairs)<-c("Taxon 1","Taxon 2","Morphological distance","Patristic distance")



		for(i in 1:nrow(sim.dist))
		{
			for(j in i:ncol(sim.dist))
			{
	
				if(i!=j)
				{
					tax.1<-rownames(sim.dist)[i]
					tax.2<-colnames(sim.dist)[j]
					pair.morph<-sim.dist[tax.1,tax.2]
					pair.pat<-pat.dist[tax.1,tax.2]

		

					sim.pairs<-rbind(sim.pairs,c(tax.1,tax.2,pair.morph,pair.pat))
				}
			}	
		}





	
		for (i in 1:length(nodes))
		{
	
			desc.nodes<-getDescendants(tree,nodes[i])
			desc.tips<-desc.nodes[which(desc.nodes<=length(tree$tip.label))]

			in.tax<-tree$tip.label[desc.tips]
			in.pairs<-sim.pairs[data[,1]%in%in.tax & data[,2]%in%in.tax,]


			if(is.null(nrow(in.pairs))==F && nrow(in.pairs)>=4)
			{
				in.dist<-cbind(as.numeric(in.pairs[,"Morphological distance"]),as.numeric(in.pairs[,"Patristic distance"]))
				tryCatch({
		 			mm.in<-drm(V1~V2, data = as.data.frame(in.dist), fct = MM.2())
					sim.node.vmaxes[i,w]<-coef(mm.in) [1]
				},error=function(e){})
			}
		}
	}




	constrained<-vector(length=0)
	released<-vector(length=0)

	for(i in 1:length(nodes))
	{
		if(is.na(node.vmaxes[i,1])==F)
		{
			n<-length(sort(sim.node.vmaxes[i,]))
			if(n>1)
			{
				s<-sd(sort(sim.node.vmaxes[i,]))
				error<-qt(0.84,df=n-1)*s/sqrt(n)
				upper<-median(sim.node.vmaxes[i,],na.rm=T)+error
				lower<-median(sim.node.vmaxes[i,],na.rm=T)-error
		
				if(node.vmaxes[i,1]>upper)
				{
					released=c(released,nodes[i])
				}
				else if(node.vmaxes[i,2]<lower)
				{
					constrained<-c(constrained,nodes[i])
				}
			}
		}	
	}

	results<-list(released,constrained)
	names(results)<-c("Released","Constrained")
	return(results)
}



