# Early origins of divergent patterns of morphological evolution on the mammal and reptile stem-lineages

<https://doi.org/10.5061/dryad.9ghx3ffj5>

This README file was generated on 09/02/2024 by Neil Brocklehurst.

GENERAL INFORMATION

1\. Title of Dataset: Early origins of divergent patterns of morphological evolution on the mammal and reptile stem-lineages.

2\. Corresponding Author Information

```
Corresponding author

 Name: Neil Brocklehurst	
 Institution: University of Cambridge
 Address: Cambridge, UK
 Email: neilbrockpalaeo@gmail.com

Co authors

   David Ford, Roger Benson
```

3\. Recommended citation for this dataset:

Leimberger, K. G., Hadley, A. S., Frey, S. J. K., & Betts, M. G. (2023). Data from: Tropical plant–hummingbird interactions withstand short-term experimental removal of a common flowering plant. Dryad Digital Repository. <https://doi.org/10.5061/dryad.jwstqjqbh>

DATA & FILE OVERVIEW

1\. File List:

Fig_S2.tif
Fig_S3.tif
Fig_S4.tif
Fig_S5.tif
Fig_S6.tif
Supplementary_Data_1.docx
Supplementary_Data_2.nex
Supplementary_Data_3.nex
Supplementary_Data_4.tre
Supplementary_Data_5.tre
Supplementary_Data_6.tre
Supplementa...y_Data_7.R
Supplementa...y_Data_8.R
Supplementary_Data_9.nex
Supplementary_Data_10.nex
Supplementary_Data_11.nex
Supplementary_Data_12.nex
Supplementary_Data_13.nex
Supplementary_Data_14.tre
Supplementary_Data_15.tre
Supplementary_Data_16.tre
Supplementary_Data_17.tre
Supplementary_Data_18.tre
Supplementary_Data_19.csv
Supplementary_Data_20.xlsx
Supplementary_Data_21.xlsx

\#########################################################################

SUPPLEMENTARY FIGURES

Fig_S1.tf: Supplementary Figure 1- The phylogeny obtained through Fossilised Birth Death analysis of Supplementary Data 2, showing 95% confidence intervals on the node age posterior

Fig_S2.tif: Supplementary Figure 2 - The phylogeny obtained through Fossilised Birth Death analysis of Supplementary Data 2, showing posterior probability (support) for each node

Fig_S3.tif: Supplementary Figure 3 - The disparity (pairwise morphological dissimilarity) of reptiles and synapsids based on different anatomical regions: A) Skull; B) Antorbital skull; C) postorbital skull; D) postcranium

Fig_S4.tif: Supplementary Figure 4 - The disparity (pairwise morphological dissimilarity) of reptiles and synapsids based on different anatomical regions: A) Skull; B) Antorbital skull; C) postorbital skull; D) postcranium

Fig_S5.tif: Supplementary Figure 5 -  Comparison of patristic distances and morphological dissimilarity in synapsids (red) and reptiles (blue) within different anatomical regions. Each point represents a pairwise comparison of two taxa. The curves represent Loess-fitted regression curves. A) Skull; B) Antorbital skull; C) postorbital skull; D) postcranium

Fig_S6.tif: Supplementary Figure 5 - - The disparity (pairwise morphological dissimilarity) of amniotes subdivided by size: A) Small; B) Medium; C) Large; D) Very Large

\#########################################################################

SUPPLEMENTARY DATA FILES

Supplementary_Data_1.docx: Supplementary Data 1 - Modifications to the character list of Ford & Benson (2020); altered characters and added characters. The complete character list is used in the phylogenetic analysis and the analyses of disparity and constraint

The original matrix of Ford & Benson 2020 is available at:

Ford, D. P. & Benson, R. B. J. The Phylogeny of Early Amniotes and the Affinities of Parareptilia and Varanopidae (Dryad Digital Repository, 2019); <https://doi.org/10.5061/dryad.t4b8gthx8>

Supplementary_Data_2.nex: Supplementary data 2 - The analysis file for a Fossilised Birth Death analysis of the character-taxon matrix described herin in MrBayes v3.2.6

Supplementary_Data_3.nex: Supplementary data 3 - The analysis file for a Fossilised Birth Death analysis of the character-taxon matrix of Brocklehurst & Benson 2021 in MrBayes v3.2.6

The original character list and character taxon matrix of Brocklehurst & Benson 2020 is available at:

Brocklehurst, N., & Benson, R. J. (2021). Multiple paths to morphological diversification during the origin of amniotes. Nature Ecology & Evolution, 5(9), 1243-1249.

<https://www.nature.com/articles/s41559-019-1047-3#data-availability>

Supplementary_Data_4.tre: Supplementary data 4 - the maximum clade credibility tree produced by the Fossilised Birth Death analysis of Supplementary data 2, in nexus format

Branch lengths correspond to time

Supplementary_Data_5.tre: Supplementary data 6 - the maximum clade credibility tree produced by an undated analysis of Supplementary data 2, in nexus format.

Branch length correspond to morphological Change

Supplementary_Data_6.tre: Supplementary data 6 - the maximum clade credibility tree produced by an undated analysis of Supplementary data 3, in nexus format.

Branch length correspond to morphological change

Supplementary_Data_7.R: Supplementary Data 7- R code representing the new functions to carry out analyses of constraint over a phylogeny as described in this paper. Written in R v 3.6.1

Script should be run in R before Supplementary Data 8

Supplementary_Data_8.R: Supplementary Data 8 - R code representing the analyses of the datasets described in this paper. Written in R v 3.6.1

Script may be run out of the box, provided all supplementary data files are included in the working directory

Supplementary_Data_9.nex: Supplementary data 9 - The analysis file for an undated analysis of the cranial character-taxon matrix described herin in MrBayes v3.2.6

Supplementary_Data_10.nex: Supplementary data 10 - The analysis file for an undated analysis of the postcranial character-taxon matrix described herin in MrBayes v3.2.6

Supplementary_Data_11.nex: Supplementary data 11 - The analysis file for an undated analysis of the antorbital cranial character-taxon matrix described herin in MrBayes v3.2.6

Supplementary_Data_12.nex: Supplementary data 12 - The analysis file for an undated analysis of the postorbital character-taxon matrix described herin in MrBayes v3.2.6

Supplementary_Data_13.nex: Supplementary data 13- The analysis file for an undated analysis of the dental character-taxon matrix described herin in MrBayes v3.2.6

Supplementary_Data_14.tre: Supplementary data 14 - the maximum clade credibility tree produced by an undated analysis of Supplementary data 9, in nexus format.

Branch length correspond to cranial morphological change

Supplementary_Data_15.tre: Supplementary data 15 - the maximum clade credibility tree produced by an undated analysis of Supplementary data 10, in nexus format.

Branch length correspond to postcranial morphological change

Supplementary_Data_16.tre: Supplementary data 16 - the maximum clade credibility tree produced by an undated analysis of Supplementary data 11, in nexus format.

Branch length correspond to pre-orbital morphological change

Supplementary_Data_17.tre: Supplementary data 17 - the maximum clade credibility tree produced by an undated analysis of Supplementary data 12, in nexus format.

Branch length correspond to postorbital morphological change

Supplementary_Data_18.tre: Supplementary data 18 - the maximum clade credibility tree produced by an undated analysis of Supplementary data 13, in nexus format.

Branch length correspond to dental morphological change

Supplementary_Data_19.csv: Supplementary Data 19 - Analysis file giving body size categories for each species. Two columns: Taxon (the species name as represented in the tree file) and Size category (a numerical value between 1 and 4 indicating size category, with unused taxa scored NA)

Size category 1: small; 2: medium; 3: large; 4: very large

Supplementary_Data_20.xlsx:  Supplementary data 20 - Sources for first appearece dates used in the fossilised birth death analysis. Five columns: Taxon (the species name as represented in the tree file), Oldest occurence (the locality representing the oldest appearence in time of that taxon); Citation of occurence (the reference in which the occurence is recorded); Age of formation (the time interval of the formation represneting the oldest occurence); Citation of age (the reference giving the age of the occurence); Notes (any further details or justifications of ages)

Sources marked PBDB were taken from the paleobiology database (<https://paleobiodb.org/>)

Supplementary_Data_21.xlsx: Supplementary Data 20 - SOurces for the body size categories given in Supplementary Data 19. Three columns: Taxon (the species name as represented in the tree file) and Size category (a numerical value between 1 and 4 indicating size category, with unused taxa scored NA); Justification (sources and rationale for the assignment of the taxon to the body size category)

Size category 1: small; 2: medium; 3: large; 4: very large
