%% Example grid searches over dt*, phi_r for three different source polarisations

% This data is used to plot Figure 6. 

noise = 0.0001 ;

fast_true = 30;
tlag_true = 1.5 ;
tstar = 1.0 ;
spols = [45, 130, 285];
synth_stack = zeros(181,81);
fasts = -90:90;
dts = 0:0.05:4;
for i =1:3
    spol = spols(i);
    [trN,trE,trZ]=msac_splitwave2(fast_true,tlag_true,'spol',spol,'noise',noise);
    % apply the tstar value
    fref= 1/(2*trN.delta);
    [trF,trS]=msac_rotate(trN,trE,fast_true) ;
    trSA = msac_apply_tstar_operator(trS,fref,tstar) ;
    
    [trN,trE]=msac_rotate(trF,trSA,-fast_true) ;

    %bandpass filter data
    trN = msac_bpfilt(trN, 0.01, 0.3, 2,2);
    trE = msac_bpfilt(trE, 0.01, 0.3, 2,2);
    fref = 1/(2*trN.delta);
    % Measure difr grid for each synthetic
    difr_grid = dtstar_fast_gridsearch(trN, trE, trN.a, trN.f, fasts, dts, fref);
    synth_stack = synth_stack + difr_grid;
    writematrix(difr_grid, sprintf('./data/synthetics/Synthetic_spol_%3d_difr_grid.txt',spol));
end
writematrix(synth_stack, './data/synthetics/Synthetic_spol_stack_basic_example.txt');
