% [t1r,t2r]=msac_rotate(t1,t2,theta) - t1 = y or N; t2 = x or E
% Theta = angle in degrees (cw) to rotate t1 by.
%  * reference frame rotation *
%

function [tr1r,tr2r]=msac_rotate(tr1,tr2,theta)
%
%
% form conglomerate matrix

if (length(tr1)~=1 & length(tr2)~=1),error('Input must be single traces.') ;, end;

if ((tr1.npts-tr2.npts)~=0), error('Input traces must be the same length.') ;, end;


% first transpose t1, t2 if required, to make both row vectors

t1 = tr1.x1 ; 
t2 = tr2.x1 ;

t1reshaped=0; t2reshaped=0;

[r,c]=size(t1) ; if (r>1), t1 = t1' ; t1reshaped=1; , end
[r,c]=size(t2) ; if (r>1), t2 = t2' ; t2reshaped=1; , end
    
D=[t2;t1] ; % reversed, as t1 is y

% form rotatation matrix
R = [cosd(theta) -sind(theta); sind(theta) cosd(theta)] ;

% do rotation
DR=R*D;
t1r=DR(2,:) ;
t2r=DR(1,:) ;

if t1reshaped, t1r=t1r';, end
if t2reshaped, t2r=t2r';, end

tr1r = tr1; tr1r.x1 = t1r; tr1r.cmpaz = tr1r.cmpaz + theta ;
tr2r = tr2; tr2r.x1 = t2r; tr2r.cmpaz = tr2r.cmpaz + theta ;


return