% MSAC_BPFILT - Butterworth bandpass filter for SAC trace(s)
% Requires signal-processing toolbox.
function trF = msac_bpfilt(tr,f1,f2,n,npass)

[ndum nTr] = size(tr) ;

trF = tr ;

buf = designfilt('bandpassiir','FilterOrder',n, ...
    'HalfpowerFrequency1',f1,'HalfpowerFrequency2',f2, ...
    'SampleRate',1/tr.delta) ;

for iTr = 1:nTr

   tmp = filter(buf,tr.x1) ;

   if npass == 1
      trF(iTr).x1 = tmp ;
   elseif npass == 2
      tmp2 = filter(buf,tmp(end:-1:1)) ;
      trF(iTr).x1 = tmp2(end:-1:1) ;
   else
     error('SMAC_BUBP: NPASS must be 1 or 2.')
   end

end