@testset "Hadi & Simonoff 1993" begin

    @testset "Hadi & Simonoff 1993 - initial subset" begin
        # Create simple data
        rng = MersenneTwister(12345)
        n = 50
        x = collect(1:n)
        e = randn(rng, n) .* 2.0
        y = 5 .+ 5 .* x .+ e
        y[n] = y[n] * 2.0
        y[n-1] = y[n-1] * 2.0
        df = DataFrame(x = x, y = y)
        reg = createRegressionSetting(@formula(y ~ x), df)
        subset = hs93initialset(reg)
        @test !(49 in subset)
        @test !(50 in subset)
    end

    @testset "Hadi & Simonoff 1993 - basic subset" begin
        # Create simple data
        rng = MersenneTwister(12345)
        n = 50
        x = collect(1:n)
        e = randn(rng, n) .* 2.0
        y = 5 .+ 5 .* x .+ e
        y[n] = y[n] * 2.0
        y[n-1] = y[n-1] * 2.0
        df = DataFrame(x = x, y = y)
        reg = createRegressionSetting(@formula(y ~ x), df)
        initialsubset = hs93initialset(reg)
        basicsubset = hs93basicsubset(reg, initialsubset)
        @test !(49 in basicsubset)
        @test !(50 in basicsubset)
    end

    @testset "Hadi & Simonoff 1993 - Algorithm" begin
        # Create simple data
        rng = MersenneTwister(12345)
        n = 50
        x = collect(1:n)
        e = randn(rng, n) .* 2.0
        y = 5 .+ 5 .* x .+ e
        y[n] = y[n] * 2.0
        df = DataFrame(x = x, y = y)
        reg = createRegressionSetting(@formula(y ~ x), df)
        outset = hs93(reg)
        @test 50 in outset["outliers"]
    end

    @testset "Hadi & Simonoff 1993 - with Hadi & Simonoff random data" begin
        reg = createRegressionSetting(@formula(y ~ x1 + x2), hs93randomdata)
        outset = hs93(reg)
        @test 1 in outset["outliers"]
        @test 2 in outset["outliers"]
        @test 3 in outset["outliers"]
    end

end
