# Backwards Responsibility Tool

## Setup

After cloning the repository and installing [Rust](https://rustup.rs/), go to the root folder of the project (i.e. the one that contains `src`, `Cargo.toml`, etc.) and run:

    cargo build --release

The binary will then be located in `target/release/`.

## Reproducing the results from the paper

To reproduce the results from the paper, please refer to [experiments/readme.md](experiments/readme.md). Otherwise, continue reading here

## Usage

To compute the Shapley value of the states of a PRISM model, first make sure your model satisfies the following requirements:
* It does not contain probabilistic behaviour, i.e. all probabilities are 1.
* It has model type `mdp` (other model types are untested).
* It contains at least one label (that is used to identify the states that should be avoided).
* It is small (currently, models with ~30 states are tractable, but every additional state roughly doubles the runtime)

Assume your model is stored in `model.prism` and you want to use label `very_bad`. Use the following program to compute the responsibilities:

    bw-responsibility -p model.prism -b very_bad

To change the metric to Banzhaf, run the following:

    bw-responsibility -p model.prism -b very_bad -m banzhaf

So far, we have used the counterexample generated by PRISM. You can also specify a custom counterexample instead. For this, create a file that lists the states of the counter-example, with one state per line. You can either use PRISM's counterexample format (i.e. a list of values) or specify the values using the variable names in each state:

    (x=1,y=2, z=3)

You can now use the counterexample as follows:

    bw-responsibility -p model.prism -b very_bad -c counterexample_file.ce

## Grouping states

If your model has state labels (in addition to the "bad" label), you can also group states by labels as follows:

    bw-responsibility -p model.prism -b very_bad -g

Instead of analysing all combinations of states, the program will analyse all combinations of labels. For example, one coalition might contain all states that have either label `l1`, `l2` or `l6`.

Labels can overlap. If a state has no labels, a label `unlabelled` is automatically created.

## Stochastic engine

By default, the *exact* engine is used, which requires exponential runtime in the size of the model. For larger models, you can use the *stochastic engine* as follows:

    bw-responsibility -p model.prism -b very_bad -r 10s

Here, the argument specifies how many seconds the engine should spend sampling. Alternatively, you can specify the number of samples:

    bw-responsibility -p model.prism -b very_bad -r 50000

Note that, due to some inefficiencies in the processing of the result, this method is still not able to handle models of more than ~100 states.

## Running without PRISM

Instead of using a PRISM file, you can also input the raw state, transition and label file. This can be useful if you do not have PRISM installed. The format of these files needs to match PRISM's output when run with `--exportmodel`. You can then use these files as follows:

    bw-responsibility -s states.sta -t transitions.tra -l labels.lab -b very_bad -c counterexample_file.ce

Note that this option also requires you to specify the counterexample manually.

## Other options

You can redirect the responsibility values into a file using the following command:

    bw-responsibility -p model.prism -b very_bad -f output_file_name

For a full list, run:

    bw-responsibility -h

## Troubleshooting

If PRISM is not found, specify the path to PRISM as follows:

    bw-responsibility -p model.prism -b bad --prism-path "path/to/prism"

If PRISM does not find your Java installation, you can specify the Java home directory as follows.

    bw-responsibility -p model.prism -b bad --prism-java "path/to/java/home/"
