using Test, ClassicalOrthogonalPolynomials
using SumSpaces

@testset "ExtendedHermite" begin
    
    @testset "basics" begin
        s = 0.2;
        H̃ = ExtendedHermite(s)
        @test H̃ == H̃[:,1:∞]
        @test H̃[:,1:∞] == H̃
        @test H̃ == ExtendedHermite(s)
        @test H̃ != ExtendedHermite(-s)
        @test axes(H̃[1:1,:]) === (oneto(1), oneto(∞))

    end

    @testset "Evaluation" begin
        @testset "Extended Hermite" begin
            # Note that (-Δ)ˢexp(-x²) = ExtendedHermite(s)[x,1]
            tfa = (x, s) -> (2^(2*s*one(eltype(x)))*one(eltype(x))*gamma((s+1/2)*one(eltype(x)))/gamma(one(eltype(x))/2) * _₁F₁((s+1/2)*one(eltype(x)),one(eltype(x))/2,-x^2))
            ga = (x, s) -> x ≈ zero(eltype(x)) ? ( tfa(-eps(T), s) + tfa(eps(T), s) ) / 2 : tfa(x, s)

            x = -10:0.01:10
            @test ExtendedHermite(0.1)[x, 1] ≈ ga.(x,0.1)
            @test ExtendedHermite(1/3)[x, 1] ≈ ga.(x,1/3)
            @test ExtendedHermite(-1/4)[x, 1] ≈ ga.(x,-1/4)

            # Testing against evaluations of Mathematica's
            # 4^s x^(n - 2 Floor[n/2]) MeijerG[{{1/2 - n - s + 2 Floor[n/2]}, {1/2 - n - s + Floor[n/2]}}, {{0, 1/2 - n - s + 2 Floor[n/2]}, {1/2 - n + 2 Floor[n/2]}}, x^2]
            
            H̃ = ExtendedHermite(1/3)
            @test H̃[-5:0.5:5, 1] ≈ [-0.0316428060794014, -0.03818430803021798, -0.04731872485935767, -0.06085692276185753, 
            -0.08281442057274951, -0.12190480062903995, -0.1832067873504906, -0.1992873343386085, 0.05385369995853884, 
            0.6483831587447187, 1.0109361763121787, 0.6483831587447187, 0.05385369995853884, -0.1992873343386085, 
            -0.1832067873504906, -0.12190480062903995, -0.08281442057274951, -0.06085692276185753, -0.04731872485935767, 
            -0.03818430803021798, -0.0316428060794014]

            @test H̃[-5:0.5:5, 2] ≈ [0.005599174297400674, 0.007632929614621039, 0.01091865929954635, 0.016774932173479997, 
            0.02859899256432786, 0.051437099536700046, 0.06261029241141848, -0.07227557458455532, -0.4603181037432501, 
            -0.6183832780481707, 0., 0.6183832780481707, 0.4603181037432501, 0.07227557458455532, -0.06261029241141848, 
            -0.051437099536700046, -0.02859899256432786, -0.016774932173479997, -0.01091865929954635, -0.007632929614621039, 
            -0.005599174297400674]

            @test H̃[-5:0.5:5, 14] ≈ [-0.0002591095787768323, -0.06323515912084506, -0.1188017345322169, 3.0452126374158337, -8.64196044882063, 
            -13.478573026110052, 140.66009480599445, -402.1844248453923, 621.1119977047784, -498.8676149412729, 0., 
            498.8676149412729, -621.1119977047784, 402.1844248453923, -140.66009480599445, 13.478573026110052, 
            8.64196044882063, -3.0452126374158337, 0.1188017345322169, 0.06323515912084506, 0.0002591095787768323]

            H̃ = ExtendedHermite(-1/4)
            H̃[-5:0.5:5, 1] ≈ [0.31871305426474245, 0.33660668925540954, 0.3580260399038575, 0.3843898887473392, 0.4182252653078769, 
            0.4651446219310445, 0.5409896169418179, 0.6862949623891216, 0.9517145023321772, 1.283107145510403, 1.446409084632077, 
            1.283107145510403, 0.9517145023321772, 0.6862949623891216, 0.5409896169418179, 0.4651446219310445, 
            0.4182252653078769, 0.3843898887473392, 0.3580260399038575, 0.33660668925540954, 0.31871305426474245]
            
            @test H̃[-5:0.5:5, 2] ≈[-0.01645769680436135, -0.01947476588667623, -0.02359236508238414, -0.029531584944977894, 
            -0.0389744690302509, -0.05720706603612167, -0.10118768937675393, -0.1999990869910227, -0.32436036413388697, 
            -0.2941246450539123, 0., 0.2941246450539123, 0.32436036413388697, 0.1999990869910227, 0.10118768937675393, 
            0.05720706603612167, 0.0389744690302509, 0.029531584944977894, 0.02359236508238414, 0.01947476588667623, 
            0.01645769680436135]

            @test H̃[-5:0.5:5, 14] ≈[-0.0012033044637490447, -0.006320462019383755, 0.05358266268338687, 0.27320714502610616, 
            -2.1698000114865295, 2.859265830324969, 12.448556603599, -57.074986173729116, 103.76137526651756, 
            -89.64017413913012, 0., 89.64017413913012, -103.76137526651756, 57.074986173729116, -12.448556603599, 
            -2.859265830324969, 2.1698000114865295, -0.27320714502610616, -0.05358266268338687, 0.006320462019383755, 
            0.0012033044637490447]

            H̃ = ExtendedHermite(1.4)
            @test H̃[-5:0.5:5, 1] ≈[0.006838239365554519, 0.010821669555219947, 0.01858844988102117, 0.03629542161303194, 
            0.08100440110378611, 0.1491415148649539, -0.05191407177807103, -1.1759529690197372, -1.9365008850501797, 
            0.9530156521550297, 3.7790130842535445, 0.9530156521550297, -1.9365008850501797, -1.1759529690197372, 
            -0.05191407177807103, 0.1491415148649539, 0.08100440110378611, 0.03629542161303194, 0.01858844988102117, 
            0.010821669555219947, 0.006838239365554519]
            
            @test H̃[-5:0.5:5, 2] ≈[-0.0029250594211579005, -0.005348824209439654, -0.01107401712707714, -0.027179792861548386, 
            -0.06561704015379564, -0.03146241108754107, 0.5845522915734466, 1.5008738475586578, -0.7713937462168763, 
            -4.313590011274018, 0., 4.313590011274018, 0.7713937462168763, -1.5008738475586578, -0.5845522915734466, 
            0.03146241108754107, 0.06561704015379564, 0.027179792861548386, 0.01107401712707714, 0.005348824209439654, 
            0.0029250594211579005]

            @test H̃[-5:0.5:5, 14] ≈[0.17112056731457534, 1.5291701160250553, -16.41500579662569, 20.89794115951237, 305.84504344161195, 
            -1965.1258097916825, 6155.040437162327, -12113.735184856589, 15501.498534302558, -11321.716913526741, 0., 
            11321.716913526741, -15501.498534302558, 12113.735184856589, -6155.040437162327, 1965.1258097916825, 
            -305.84504344161195, -20.89794115951237, 16.41500579662569, -1.5291701160250553, -0.17112056731457534]
         end
    end

end