// This file is part of the Acts project.
//
// Copyright (C) 2020 CERN for the benefit of the Acts project
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.

// The entries within this file have been automatically created using the
// particle data files from the 2019 edition of the Review of Particle Physics
// by the Berkeley Particle Data Group.

#pragma once

#include <cstdint>

// Rows within the particle data table are sorted by their signed PDG particle
// number and are then stored column-wise. Since the PDG particle number column
// is sorted it can be used to quickly search for the index of a particle
// within all column arrays.

static constexpr uint32_t kParticlesCount = 536u;

static constexpr int32_t kParticlesPdgNumber[kParticlesCount] = {
    -9020213, -9010213, -9010211, -9000321, -9000311, -9000215, -9000213,
    -9000211, -204126,  -203338,  -203326,  -203322,  -203316,  -203312,
    -104324,  -104322,  -104314,  -104312,  -104122,  -103326,  -103316,
    -100323,  -100313,  -100213,  -100211,  -53122,   -43122,   -42212,
    -42112,   -33122,   -32224,   -32214,   -32212,   -32124,   -32114,
    -32112,   -31214,   -31114,   -30323,   -30313,   -30213,   -23224,
    -23222,   -23214,   -23212,   -23126,   -23124,   -23122,   -23114,
    -23112,   -22224,   -22222,   -22214,   -22212,   -22124,   -22122,
    -22114,   -22112,   -21214,   -21212,   -21114,   -21112,   -20433,
    -20325,   -20323,   -20315,   -20313,   -20213,   -14122,   -13324,
    -13314,   -13226,   -13224,   -13222,   -13216,   -13214,   -13212,
    -13126,   -13124,   -13122,   -13116,   -13114,   -13112,   -12226,
    -12224,   -12222,   -12216,   -12214,   -12212,   -12126,   -12122,
    -12116,   -12114,   -12112,   -11216,   -11212,   -11116,   -11114,
    -11112,   -10433,   -10431,   -10423,   -10421,   -10411,   -10325,
    -10323,   -10321,   -10315,   -10313,   -10311,   -10215,   -10213,
    -10211,   -5332,    -5232,    -5224,    -5222,    -5132,    -5122,
    -5114,    -5112,    -4334,    -4332,    -4324,    -4322,    -4314,
    -4312,    -4232,    -4224,    -4222,    -4214,    -4212,    -4132,
    -4122,    -4114,    -4112,    -3334,    -3324,    -3322,    -3314,
    -3312,    -3228,    -3226,    -3224,    -3222,    -3218,    -3216,
    -3214,    -3212,    -3128,    -3126,    -3124,    -3122,    -3118,
    -3116,    -3114,    -3112,    -2228,    -2226,    -2224,    -2222,
    -2218,    -2216,    -2214,    -2212,    -2128,    -2126,    -2124,
    -2122,    -2118,    -2116,    -2114,    -2112,    -1218,    -1216,
    -1214,    -1212,    -1118,    -1116,    -1114,    -1112,    -541,
    -535,     -533,     -531,     -525,     -523,     -521,     -515,
    -513,     -511,     -435,     -433,     -431,     -425,     -423,
    -421,     -415,     -413,     -411,     -329,     -327,     -325,
    -323,     -321,     -319,     -317,     -315,     -313,     -311,
    -219,     -217,     -215,     -213,     -211,     -24,      -16,
    -15,      -14,      -13,      -12,      -11,      -6,       -5,
    -4,       -3,       -2,       -1,       1,        2,        3,
    4,        5,        6,        11,       12,       13,       14,
    15,       16,       21,       22,       23,       24,       25,
    111,      113,      115,      117,      119,      130,      211,
    213,      215,      217,      219,      221,      223,      225,
    227,      229,      310,      311,      313,      315,      317,
    319,      321,      323,      325,      327,      329,      331,
    333,      335,      337,      411,      413,      415,      421,
    423,      425,      431,      433,      435,      441,      443,
    445,      511,      513,      515,      521,      523,      525,
    531,      533,      535,      541,      553,      555,      1112,
    1114,     1116,     1118,     1212,     1214,     1216,     1218,
    2112,     2114,     2116,     2118,     2122,     2124,     2126,
    2128,     2212,     2214,     2216,     2218,     2222,     2224,
    2226,     2228,     3112,     3114,     3116,     3118,     3122,
    3124,     3126,     3128,     3212,     3214,     3216,     3218,
    3222,     3224,     3226,     3228,     3312,     3314,     3322,
    3324,     3334,     4112,     4114,     4122,     4132,     4212,
    4214,     4222,     4224,     4232,     4312,     4314,     4322,
    4324,     4332,     4334,     5112,     5114,     5122,     5132,
    5222,     5224,     5232,     5332,     10111,    10113,    10115,
    10211,    10213,    10215,    10221,    10223,    10225,    10311,
    10313,    10315,    10321,    10323,    10325,    10331,    10333,
    10411,    10421,    10423,    10431,    10433,    10441,    10443,
    10551,    10553,    11112,    11114,    11116,    11212,    11216,
    12112,    12114,    12116,    12122,    12126,    12212,    12214,
    12216,    12222,    12224,    12226,    13112,    13114,    13116,
    13122,    13124,    13126,    13212,    13214,    13216,    13222,
    13224,    13226,    13314,    13324,    14122,    20113,    20213,
    20223,    20313,    20315,    20323,    20325,    20333,    20433,
    20443,    20553,    20555,    21112,    21114,    21212,    21214,
    22112,    22114,    22122,    22124,    22212,    22214,    22222,
    22224,    23112,    23114,    23122,    23124,    23126,    23212,
    23214,    23222,    23224,    30113,    30213,    30223,    30313,
    30323,    30443,    31114,    31214,    32112,    32114,    32124,
    32212,    32214,    32224,    33122,    42112,    42212,    43122,
    53122,    100111,   100113,   100211,   100213,   100221,   100313,
    100323,   100331,   100333,   100441,   100443,   100445,   100553,
    100555,   103316,   103326,   104122,   104312,   104314,   104322,
    104324,   110551,   120553,   200553,   203312,   203316,   203322,
    203326,   203338,   204126,   300553,   1000223,  9000111,  9000113,
    9000115,  9000211,  9000213,  9000215,  9000221,  9000311,  9000321,
    9000443,  9000553,  9010111,  9010113,  9010211,  9010213,  9010221,
    9010443,  9010553,  9020113,  9020213,  9020221,  9020443,  9030221,
    9050225,  9060225,  9080225,  9090225,
};

static constexpr int8_t kParticlesThreeCharge[kParticlesCount] = {
    -3, -3, -3, -3, 0,  -3, -3, -3, -3, 3,  0,  0,  3,  3,  -3, -3, 0,  0,  -3,
    0,  3,  -3, 0,  -3, -3, 0,  0,  -3, 0,  0,  -6, -3, -3, -3, 0,  0,  0,  3,
    -3, 0,  -3, -3, -3, 0,  0,  0,  0,  0,  3,  3,  -6, -6, -3, -3, -3, -3, 0,
    0,  0,  0,  3,  3,  -3, -3, -3, 0,  0,  -3, -3, 0,  3,  -3, -3, -3, 0,  0,
    0,  0,  0,  0,  3,  3,  3,  -6, -6, -6, -3, -3, -3, -3, -3, 0,  0,  0,  0,
    0,  3,  3,  3,  -3, -3, 0,  0,  -3, -3, -3, -3, 0,  0,  0,  -3, -3, -3, 3,
    0,  -3, -3, 3,  0,  3,  3,  0,  0,  -3, -3, 0,  0,  -3, -6, -6, -3, -3, 0,
    -3, 0,  0,  3,  0,  0,  3,  3,  -3, -3, -3, -3, 0,  0,  0,  0,  0,  0,  0,
    0,  3,  3,  3,  3,  -6, -6, -6, -6, -3, -3, -3, -3, -3, -3, -3, -3, 0,  0,
    0,  0,  0,  0,  0,  0,  3,  3,  3,  3,  -3, 0,  0,  0,  -3, -3, -3, 0,  0,
    0,  -3, -3, -3, 0,  0,  0,  -3, -3, -3, -3, -3, -3, -3, -3, 0,  0,  0,  0,
    0,  -3, -3, -3, -3, -3, -3, 0,  3,  0,  3,  0,  3,  -2, 1,  -2, 1,  -2, 1,
    -1, 2,  -1, 2,  -1, 2,  -3, 0,  -3, 0,  -3, 0,  0,  0,  0,  3,  0,  0,  0,
    0,  0,  0,  0,  3,  3,  3,  3,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  3,  3,  3,  3,  3,  0,  0,  0,  0,  3,  3,  3,  0,  0,  0,  3,  3,  3,
    0,  0,  0,  0,  0,  0,  3,  3,  3,  0,  0,  0,  3,  0,  0,  -3, -3, -3, -3,
    0,  0,  0,  0,  0,  0,  0,  0,  3,  3,  3,  3,  3,  3,  3,  3,  6,  6,  6,
    6,  -3, -3, -3, -3, 0,  0,  0,  0,  0,  0,  0,  0,  3,  3,  3,  3,  -3, -3,
    0,  0,  -3, 0,  0,  3,  0,  3,  3,  6,  6,  3,  0,  0,  3,  3,  0,  0,  -3,
    -3, 0,  -3, 3,  3,  0,  -3, 0,  0,  0,  3,  3,  3,  0,  0,  0,  0,  0,  0,
    3,  3,  3,  0,  0,  3,  0,  0,  3,  3,  0,  0,  0,  0,  -3, -3, -3, 0,  0,
    0,  0,  0,  3,  3,  3,  3,  3,  6,  6,  6,  -3, -3, -3, 0,  0,  0,  0,  0,
    0,  3,  3,  3,  -3, 0,  3,  0,  3,  0,  0,  0,  3,  3,  0,  3,  0,  0,  0,
    -3, -3, 0,  0,  0,  0,  3,  3,  3,  3,  6,  6,  -3, -3, 0,  0,  0,  0,  0,
    3,  3,  0,  3,  0,  0,  3,  0,  -3, 0,  0,  0,  3,  3,  3,  6,  0,  0,  3,
    0,  0,  0,  0,  3,  3,  0,  0,  3,  0,  0,  0,  0,  0,  0,  0,  -3, 0,  3,
    0,  0,  3,  3,  0,  0,  0,  -3, -3, 0,  0,  -3, 3,  0,  0,  0,  0,  0,  3,
    3,  3,  0,  0,  3,  0,  0,  0,  0,  3,  3,  0,  0,  0,  0,  3,  0,  0,  0,
    0,  0,  0,  0,
};

static constexpr float kParticlesMassMeV[kParticlesCount] = {
    1655.0f,   1660.0f,       1810.0f,     824.0f,      824.0f,
    1700.0f,   1354.0f,       980.0f,      2881.63f,    2252.0f,
    2025.0f,   1690.0f,       2025.0f,     1690.0f,     2792.4f,
    2816.73f,  2794.1f,       2820.26f,    2628.11f,    1950.0f,
    1950.0f,   1421.0f,       1421.0f,     1465.0f,     1300.0f,
    1810.0f,   1800.0f,       1710.0f,     1710.0f,     1670.0f,
    1570.0f,   1570.0f,       1650.0f,     1720.0f,     1570.0f,
    1650.0f,   1720.0f,       1570.0f,     1718.0f,     1718.0f,
    1720.0f,   1940.0f,       1750.0f,     1940.0f,     1750.0f,
    2110.0f,   1890.0f,       1600.0f,     1940.0f,     1750.0f,
    1920.0f,   1900.0f,       1920.0f,     1530.0f,     1720.0f,
    1900.0f,   1920.0f,       1530.0f,     1720.0f,     1900.0f,
    1920.0f,   1900.0f,       2459.5f,     1819.0f,     1403.0f,
    1819.0f,   1403.0f,       1230.0f,     2592.25f,    1823.0f,
    1823.0f,   1915.0f,       1670.0f,     1660.0f,     1915.0f,
    1670.0f,   1660.0f,       1830.0f,     1690.0f,     1405.1f,
    1915.0f,   1670.0f,       1660.0f,     1950.0f,     1710.0f,
    1860.0f,   1685.0f,       1710.0f,     1440.0f,     1950.0f,
    1860.0f,   1685.0f,       1710.0f,     1440.0f,     1950.0f,
    1860.0f,   1950.0f,       1710.0f,     1860.0f,     2535.11f,
    2317.8f,   2420.8f,       2300.0f,     2300.0f,     1773.0f,
    1272.0f,   1430.0f,       1773.0f,     1272.0f,     1430.0f,
    1670.6f,   1229.5f,       1467.0f,     6046.1f,     5791.9f,
    5830.32f,  5810.56f,      5797.0f,     5619.6f,     5834.74f,
    5815.64f,  2765.9f,       2695.2f,     2645.57f,    2578.4f,
    2646.38f,  2579.2f,       2467.93f,    2518.41f,    2453.97f,
    2517.5f,   2452.9f,       2470.91f,    2286.46f,    2518.48f,
    2453.75f,  1672.45f,      1531.8f,     1314.86f,    1535.0f,
    1321.71f,  2030.0f,       1775.0f,     1382.8f,     1189.37f,
    2030.0f,   1775.0f,       1383.7f,     1192.642f,   2100.0f,
    1820.0f,   1519.5f,       1115.683f,   2030.0f,     1775.0f,
    1387.2f,   1197.449f,     1930.0f,     1880.0f,     1232.0f,
    1610.0f,   1930.0f,       1675.0f,     1232.0f,     938.272081f,
    2180.0f,   1880.0f,       1515.0f,     1610.0f,     1930.0f,
    1675.0f,   1232.0f,       939.565413f, 2180.0f,     1880.0f,
    1515.0f,   1610.0f,       1930.0f,     1880.0f,     1232.0f,
    1610.0f,   6274.9f,       5839.85f,    5415.4f,     5366.88f,
    5739.5f,   5324.7f,       5279.33f,    5739.5f,     5324.7f,
    5279.64f,  2569.1f,       2112.2f,     1968.34f,    2460.7f,
    2006.85f,  1864.83f,      2465.4f,     2010.26f,    1869.65f,
    2045.0f,   1776.0f,       1425.6f,     891.66f,     493.677f,
    2045.0f,   1776.0f,       1432.4f,     895.55f,     497.611f,
    1967.0f,   1688.8f,       1316.9f,     775.26f,     139.57061f,
    80379.0f,  0.0f,          1776.86f,    0.0f,        105.6583745f,
    0.0f,      0.5109989461f, 173100.0f,   4180.0f,     1270.0f,
    93.0f,     2.16f,         4.67f,       4.67f,       2.16f,
    93.0f,     1270.0f,       4180.0f,     173100.0f,   0.5109989461f,
    0.0f,      105.6583745f,  0.0f,        1776.86f,    0.0f,
    0.0f,      0.0f,          91187.6f,    80379.0f,    125100.0f,
    134.977f,  775.26f,       1316.9f,     1688.8f,     1967.0f,
    497.611f,  139.57061f,    775.26f,     1316.9f,     1688.8f,
    1967.0f,   547.862f,      782.65f,     1275.5f,     1667.0f,
    2018.0f,   497.611f,      497.611f,    895.55f,     1432.4f,
    1776.0f,   2045.0f,       493.677f,    891.66f,     1425.6f,
    1776.0f,   2045.0f,       957.78f,     1019.461f,   1525.0f,
    1854.0f,   1869.65f,      2010.26f,    2465.4f,     1864.83f,
    2006.85f,  2460.7f,       1968.34f,    2112.2f,     2569.1f,
    2983.9f,   3096.9f,       3556.17f,    5279.64f,    5324.7f,
    5739.5f,   5279.33f,      5324.7f,     5739.5f,     5366.88f,
    5415.4f,   5839.85f,      6274.9f,     9460.3f,     9912.21f,
    1610.0f,   1232.0f,       1880.0f,     1930.0f,     1610.0f,
    1515.0f,   1880.0f,       2180.0f,     939.565413f, 1232.0f,
    1675.0f,   1930.0f,       1610.0f,     1515.0f,     1880.0f,
    2180.0f,   938.272081f,   1232.0f,     1675.0f,     1930.0f,
    1610.0f,   1232.0f,       1880.0f,     1930.0f,     1197.449f,
    1387.2f,   1775.0f,       2030.0f,     1115.683f,   1519.5f,
    1820.0f,   2100.0f,       1192.642f,   1383.7f,     1775.0f,
    2030.0f,   1189.37f,      1382.8f,     1775.0f,     2030.0f,
    1321.71f,  1535.0f,       1314.86f,    1531.8f,     1672.45f,
    2453.75f,  2518.48f,      2286.46f,    2470.91f,    2452.9f,
    2517.5f,   2453.97f,      2518.41f,    2467.93f,    2579.2f,
    2646.38f,  2578.4f,       2645.57f,    2695.2f,     2765.9f,
    5815.64f,  5834.74f,      5619.6f,     5797.0f,     5810.56f,
    5830.32f,  5791.9f,       6046.1f,     1467.0f,     1229.5f,
    1670.6f,   1467.0f,       1229.5f,     1670.6f,     1350.0f,
    1170.0f,   1617.0f,       1430.0f,     1272.0f,     1773.0f,
    1430.0f,   1272.0f,       1773.0f,     1704.0f,     1416.0f,
    2300.0f,   2300.0f,       2420.8f,     2317.8f,     2535.11f,
    3414.71f,  3525.38f,      9859.4f,     9899.3f,     1860.0f,
    1710.0f,   1950.0f,       1860.0f,     1950.0f,     1440.0f,
    1710.0f,   1685.0f,       1860.0f,     1950.0f,     1440.0f,
    1710.0f,   1685.0f,       1860.0f,     1710.0f,     1950.0f,
    1660.0f,   1670.0f,       1915.0f,     1405.1f,     1690.0f,
    1830.0f,   1660.0f,       1670.0f,     1915.0f,     1660.0f,
    1670.0f,   1915.0f,       1823.0f,     1823.0f,     2592.25f,
    1230.0f,   1230.0f,       1281.9f,     1403.0f,     1819.0f,
    1403.0f,   1819.0f,       1426.4f,     2459.5f,     3510.67f,
    9892.878f, 10163.7f,      1900.0f,     1920.0f,     1900.0f,
    1720.0f,   1530.0f,       1920.0f,     1900.0f,     1720.0f,
    1530.0f,   1920.0f,       1900.0f,     1920.0f,     1750.0f,
    1940.0f,   1600.0f,       1890.0f,     2110.0f,     1750.0f,
    1940.0f,   1750.0f,       1940.0f,     1720.0f,     1720.0f,
    1670.0f,   1718.0f,       1718.0f,     3773.13f,    1570.0f,
    1720.0f,   1650.0f,       1570.0f,     1720.0f,     1650.0f,
    1570.0f,   1570.0f,       1670.0f,     1710.0f,     1710.0f,
    1800.0f,   1810.0f,       1300.0f,     1465.0f,     1300.0f,
    1465.0f,   1294.0f,       1421.0f,     1421.0f,     1475.0f,
    1680.0f,   3637.5f,       3686.097f,   3927.2f,     10023.26f,
    10268.65f, 1950.0f,       1950.0f,     2628.11f,    2820.26f,
    2794.1f,   2816.73f,      2792.4f,     10232.5f,    10255.46f,
    10355.2f,  1690.0f,       2025.0f,     1690.0f,     2025.0f,
    2252.0f,   2881.63f,      10579.4f,    1425.0f,     980.0f,
    1354.0f,   1700.0f,       980.0f,      1354.0f,     1700.0f,
    475.0f,    824.0f,        824.0f,      4039.0f,     10889.9f,
    1810.0f,   1660.0f,       1810.0f,     1660.0f,     990.0f,
    4191.0f,   10992.9f,      1655.0f,     1655.0f,     1408.8f,
    4421.0f,   1506.0f,       1936.0f,     2010.0f,     2297.0f,
    2350.0f,
};

static constexpr const char* kParticlesName[kParticlesCount] = {
    "a(1)(1640)-",
    "pi(1)(1600)-",
    "pi(1800)-",
    "K(0)*(700)-",
    "K(0)*(700)~0",
    "a(2)(1700)-",
    "pi(1)(1400)-",
    "a(0)(980)-",
    "Lambda(c)(2880)~-",
    "Omega(2250)~+",
    "Xi(2030)~0",
    "Xi(1690)~0",
    "Xi(2030)~+",
    "Xi(1690)~+",
    "Xi(c)(2790)~-",
    "Xi(c)(2815)~-",
    "Xi(c)(2790)~0",
    "Xi(c)(2815)~0",
    "Lambda(c)(2625)~-",
    "Xi(1950)~0",
    "Xi(1950)~+",
    "K*(1410)-",
    "K*(1410)~0",
    "rho(1450)-",
    "pi(1300)-",
    "Lambda(1810)~",
    "Lambda(1800)~",
    "N(1710)~-",
    "N(1710)~0",
    "Lambda(1670)~",
    "Delta(1600)~--",
    "Delta(1600)~-",
    "N(1650)~-",
    "N(1720)~-",
    "Delta(1600)~0",
    "N(1650)~0",
    "N(1720)~0",
    "Delta(1600)~+",
    "K*(1680)-",
    "K*(1680)~0",
    "rho(1700)-",
    "Sigma(1940)~-",
    "Sigma(1750)~-",
    "Sigma(1940)~0",
    "Sigma(1750)~0",
    "Lambda(2110)~",
    "Lambda(1890)~",
    "Lambda(1600)~",
    "Sigma(1940)~+",
    "Sigma(1750)~+",
    "Delta(1920)~--",
    "Delta(1910)~--",
    "Delta(1920)~-",
    "N(1535)~-",
    "N(1700)~-",
    "Delta(1910)~-",
    "Delta(1920)~0",
    "N(1535)~0",
    "N(1700)~0",
    "Delta(1910)~0",
    "Delta(1920)~+",
    "Delta(1910)~+",
    "D(s1)(2460)-",
    "K(2)(1820)-",
    "K(1)(1400)-",
    "K(2)(1820)~0",
    "K(1)(1400)~0",
    "a(1)(1260)-",
    "Lambda(c)(2595)~-",
    "Xi(1820)~0",
    "Xi(1820)~+",
    "Sigma(1915)~-",
    "Sigma(1670)~-",
    "Sigma(1660)~-",
    "Sigma(1915)~0",
    "Sigma(1670)~0",
    "Sigma(1660)~0",
    "Lambda(1830)~",
    "Lambda(1690)~",
    "Lambda(1405)~",
    "Sigma(1915)~+",
    "Sigma(1670)~+",
    "Sigma(1660)~+",
    "Delta(1930)~--",
    "Delta(1700)~--",
    "Delta(1900)~--",
    "N(1680)~-",
    "Delta(1700)~-",
    "N(1440)~-",
    "Delta(1930)~-",
    "Delta(1900)~-",
    "N(1680)~0",
    "Delta(1700)~0",
    "N(1440)~0",
    "Delta(1930)~0",
    "Delta(1900)~0",
    "Delta(1930)~+",
    "Delta(1700)~+",
    "Delta(1900)~+",
    "D(s1)(2536)-",
    "D(s0)*(2317)-",
    "D(1)(2420)~0",
    "D(0)*(2300)~0",
    "D(0)*(2300)-",
    "K(2)(1770)-",
    "K(1)(1270)-",
    "K(0)*(1430)-",
    "K(2)(1770)~0",
    "K(1)(1270)~0",
    "K(0)*(1430)~0",
    "pi(2)(1670)-",
    "b(1)(1235)-",
    "a(0)(1450)-",
    "Omega(b)~+",
    "Xi(b)~0",
    "Sigma(b)*~-",
    "Sigma(b)~-",
    "Xi(b)~+",
    "Lambda(b)~0",
    "Sigma(b)*~+",
    "Sigma(b)~+",
    "Omega(c)(2770)~0",
    "Omega(c)~0",
    "Xi(c)(2645)~-",
    "Xi(c)'~-",
    "Xi(c)(2645)~0",
    "Xi(c)'~0",
    "Xi(c)~-",
    "Sigma(c)(2520)~--",
    "Sigma(c)(2455)~--",
    "Sigma(c)(2520)~-",
    "Sigma(c)(2455)~-",
    "Xi(c)~0",
    "Lambda(c)~-",
    "Sigma(c)(2520)~0",
    "Sigma(c)(2455)~0",
    "Omega~+",
    "Xi(1530)~0",
    "Xi~0",
    "Xi(1530)~+",
    "Xi~+",
    "Sigma(2030)~-",
    "Sigma(1775)~-",
    "Sigma(1385)~-",
    "Sigma~-",
    "Sigma(2030)~0",
    "Sigma(1775)~0",
    "Sigma(1385)~0",
    "Sigma~0",
    "Lambda(2100)~",
    "Lambda(1820)~",
    "Lambda(1520)~",
    "Lambda~",
    "Sigma(2030)~+",
    "Sigma(1775)~+",
    "Sigma(1385)~+",
    "Sigma~+",
    "Delta(1950)~--",
    "Delta(1905)~--",
    "Delta(1232)~--",
    "Delta(1620)~--",
    "Delta(1950)~-",
    "N(1675)~-",
    "Delta(1232)~-",
    "p~",
    "N(2190)~-",
    "Delta(1905)~-",
    "N(1520)~-",
    "Delta(1620)~-",
    "Delta(1950)~0",
    "N(1675)~0",
    "Delta(1232)~0",
    "n~",
    "N(2190)~0",
    "Delta(1905)~0",
    "N(1520)~0",
    "Delta(1620)~0",
    "Delta(1950)~+",
    "Delta(1905)~+",
    "Delta(1232)~+",
    "Delta(1620)~+",
    "B(c)-",
    "B(s2)*(5840)~0",
    "B(s)*~0",
    "B(s)~0",
    "B(2)*(5747)-",
    "B*-",
    "B-",
    "B(2)*(5747)~0",
    "B*~0",
    "B~0",
    "D(s2)*(2573)-",
    "D(s)*-",
    "D(s)-",
    "D(2)*(2460)~0",
    "D*(2007)~0",
    "D~0",
    "D(2)*(2460)-",
    "D*(2010)-",
    "D-",
    "K(4)*(2045)-",
    "K(3)*(1780)-",
    "K(2)*(1430)-",
    "K*(892)-",
    "K-",
    "K(4)*(2045)~0",
    "K(3)*(1780)~0",
    "K(2)*(1430)~0",
    "K*(892)~0",
    "K~0",
    "a(4)(1970)-",
    "rho(3)(1690)-",
    "a(2)(1320)-",
    "rho(770)-",
    "pi-",
    "W-",
    "nu(tau)~",
    "tau+",
    "nu(mu)~",
    "mu+",
    "nu(e)~",
    "e+",
    "t~",
    "b~",
    "c~",
    "s~",
    "u~",
    "d~",
    "d",
    "u",
    "s",
    "c",
    "b",
    "t",
    "e-",
    "nu(e)",
    "mu-",
    "nu(mu)",
    "tau-",
    "nu(tau)",
    "g",
    "gamma",
    "Z0",
    "W+",
    "H0",
    "pi0",
    "rho(770)0",
    "a(2)(1320)0",
    "rho(3)(1690)0",
    "a(4)(1970)0",
    "K(L)0",
    "pi+",
    "rho(770)+",
    "a(2)(1320)+",
    "rho(3)(1690)+",
    "a(4)(1970)+",
    "eta",
    "omega(782)",
    "f(2)(1270)",
    "omega(3)(1670)",
    "f(4)(2050)",
    "K(S)0",
    "K0",
    "K*(892)0",
    "K(2)*(1430)0",
    "K(3)*(1780)0",
    "K(4)*(2045)0",
    "K+",
    "K*(892)+",
    "K(2)*(1430)+",
    "K(3)*(1780)+",
    "K(4)*(2045)+",
    "eta'(958)",
    "phi(1020)",
    "f(2)'(1525)",
    "phi(3)(1850)",
    "D+",
    "D*(2010)+",
    "D(2)*(2460)+",
    "D0",
    "D*(2007)0",
    "D(2)*(2460)0",
    "D(s)+",
    "D(s)*+",
    "D(s2)*(2573)+",
    "eta(c)(1S)",
    "J/psi(1S)",
    "chi(c2)(1P)",
    "B0",
    "B*0",
    "B(2)*(5747)0",
    "B+",
    "B*+",
    "B(2)*(5747)+",
    "B(s)0",
    "B(s)*0",
    "B(s2)*(5840)0",
    "B(c)+",
    "Upsilon(1S)",
    "chi(b2)(1P)",
    "Delta(1620)-",
    "Delta(1232)-",
    "Delta(1905)-",
    "Delta(1950)-",
    "Delta(1620)0",
    "N(1520)0",
    "Delta(1905)0",
    "N(2190)0",
    "n",
    "Delta(1232)0",
    "N(1675)0",
    "Delta(1950)0",
    "Delta(1620)+",
    "N(1520)+",
    "Delta(1905)+",
    "N(2190)+",
    "p",
    "Delta(1232)+",
    "N(1675)+",
    "Delta(1950)+",
    "Delta(1620)++",
    "Delta(1232)++",
    "Delta(1905)++",
    "Delta(1950)++",
    "Sigma-",
    "Sigma(1385)-",
    "Sigma(1775)-",
    "Sigma(2030)-",
    "Lambda",
    "Lambda(1520)",
    "Lambda(1820)",
    "Lambda(2100)",
    "Sigma0",
    "Sigma(1385)0",
    "Sigma(1775)0",
    "Sigma(2030)0",
    "Sigma+",
    "Sigma(1385)+",
    "Sigma(1775)+",
    "Sigma(2030)+",
    "Xi-",
    "Xi(1530)-",
    "Xi0",
    "Xi(1530)0",
    "Omega-",
    "Sigma(c)(2455)0",
    "Sigma(c)(2520)0",
    "Lambda(c)+",
    "Xi(c)0",
    "Sigma(c)(2455)+",
    "Sigma(c)(2520)+",
    "Sigma(c)(2455)++",
    "Sigma(c)(2520)++",
    "Xi(c)+",
    "Xi(c)'0",
    "Xi(c)(2645)0",
    "Xi(c)'+",
    "Xi(c)(2645)+",
    "Omega(c)0",
    "Omega(c)(2770)0",
    "Sigma(b)-",
    "Sigma(b)*-",
    "Lambda(b)0",
    "Xi(b)-",
    "Sigma(b)+",
    "Sigma(b)*+",
    "Xi(b)0",
    "Omega(b)-",
    "a(0)(1450)0",
    "b(1)(1235)0",
    "pi(2)(1670)0",
    "a(0)(1450)+",
    "b(1)(1235)+",
    "pi(2)(1670)+",
    "f(0)(1370)",
    "h(1)(1170)",
    "eta(2)(1645)",
    "K(0)*(1430)0",
    "K(1)(1270)0",
    "K(2)(1770)0",
    "K(0)*(1430)+",
    "K(1)(1270)+",
    "K(2)(1770)+",
    "f(0)(1710)",
    "h(1)(1415)",
    "D(0)*(2300)+",
    "D(0)*(2300)0",
    "D(1)(2420)0",
    "D(s0)*(2317)+",
    "D(s1)(2536)+",
    "chi(c0)(1P)",
    "h(c)(1P)",
    "chi(b0)(1P)",
    "h(b)(1P)",
    "Delta(1900)-",
    "Delta(1700)-",
    "Delta(1930)-",
    "Delta(1900)0",
    "Delta(1930)0",
    "N(1440)0",
    "Delta(1700)0",
    "N(1680)0",
    "Delta(1900)+",
    "Delta(1930)+",
    "N(1440)+",
    "Delta(1700)+",
    "N(1680)+",
    "Delta(1900)++",
    "Delta(1700)++",
    "Delta(1930)++",
    "Sigma(1660)-",
    "Sigma(1670)-",
    "Sigma(1915)-",
    "Lambda(1405)",
    "Lambda(1690)",
    "Lambda(1830)",
    "Sigma(1660)0",
    "Sigma(1670)0",
    "Sigma(1915)0",
    "Sigma(1660)+",
    "Sigma(1670)+",
    "Sigma(1915)+",
    "Xi(1820)-",
    "Xi(1820)0",
    "Lambda(c)(2595)+",
    "a(1)(1260)0",
    "a(1)(1260)+",
    "f(1)(1285)",
    "K(1)(1400)0",
    "K(2)(1820)0",
    "K(1)(1400)+",
    "K(2)(1820)+",
    "f(1)(1420)",
    "D(s1)(2460)+",
    "chi(c1)(1P)",
    "chi(b1)(1P)",
    "Upsilon(2)(1D)",
    "Delta(1910)-",
    "Delta(1920)-",
    "Delta(1910)0",
    "N(1700)0",
    "N(1535)0",
    "Delta(1920)0",
    "Delta(1910)+",
    "N(1700)+",
    "N(1535)+",
    "Delta(1920)+",
    "Delta(1910)++",
    "Delta(1920)++",
    "Sigma(1750)-",
    "Sigma(1940)-",
    "Lambda(1600)",
    "Lambda(1890)",
    "Lambda(2110)",
    "Sigma(1750)0",
    "Sigma(1940)0",
    "Sigma(1750)+",
    "Sigma(1940)+",
    "rho(1700)0",
    "rho(1700)+",
    "omega(1650)",
    "K*(1680)0",
    "K*(1680)+",
    "psi(3770)",
    "Delta(1600)-",
    "N(1720)0",
    "N(1650)0",
    "Delta(1600)0",
    "N(1720)+",
    "N(1650)+",
    "Delta(1600)+",
    "Delta(1600)++",
    "Lambda(1670)",
    "N(1710)0",
    "N(1710)+",
    "Lambda(1800)",
    "Lambda(1810)",
    "pi(1300)0",
    "rho(1450)0",
    "pi(1300)+",
    "rho(1450)+",
    "eta(1295)",
    "K*(1410)0",
    "K*(1410)+",
    "eta(1475)",
    "phi(1680)",
    "eta(c)(2S)",
    "psi(2S)",
    "chi(c2)(3930)",
    "Upsilon(2S)",
    "chi(b2)(2P)",
    "Xi(1950)-",
    "Xi(1950)0",
    "Lambda(c)(2625)+",
    "Xi(c)(2815)0",
    "Xi(c)(2790)0",
    "Xi(c)(2815)+",
    "Xi(c)(2790)+",
    "chi(b0)(2P)",
    "chi(b1)(2P)",
    "Upsilon(3S)",
    "Xi(1690)-",
    "Xi(2030)-",
    "Xi(1690)0",
    "Xi(2030)0",
    "Omega(2250)-",
    "Lambda(c)(2880)+",
    "Upsilon(4S)",
    "omega(1420)",
    "a(0)(980)0",
    "pi(1)(1400)0",
    "a(2)(1700)0",
    "a(0)(980)+",
    "pi(1)(1400)+",
    "a(2)(1700)+",
    "f(0)(500)",
    "K(0)*(700)0",
    "K(0)*(700)+",
    "psi(4040)",
    "Upsilon(10860)",
    "pi(1800)0",
    "pi(1)(1600)0",
    "pi(1800)+",
    "pi(1)(1600)+",
    "f(0)(980)",
    "psi(4160)",
    "Upsilon(11020)",
    "a(1)(1640)0",
    "a(1)(1640)+",
    "eta(1405)",
    "psi(4415)",
    "f(0)(1500)",
    "f(2)(1950)",
    "f(2)(2010)",
    "f(2)(2300)",
    "f(2)(2340)",
};
