/*
 * This file is part of the GROMACS molecular simulation package.
 *
 * Copyright 2019- The GROMACS Authors
 * and the project initiators Erik Lindahl, Berk Hess and David van der Spoel.
 * Consult the AUTHORS/COPYING files and https://www.gromacs.org for details.
 *
 * GROMACS is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 *
 * GROMACS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with GROMACS; if not, see
 * https://www.gnu.org/licenses, or write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * If you want to redistribute modifications to GROMACS, please
 * consider that scientific software is very special. Version
 * control is crucial - bugs must be traceable. We will be happy to
 * consider code for inclusion in the official distribution, but
 * derived work must not be called official GROMACS. Details are found
 * in the README & COPYING files - if they are missing, get the
 * official version at https://www.gromacs.org.
 *
 * To help us fund GROMACS development, we humbly ask that you cite
 * the research papers on the package. Check out https://www.gromacs.org.
 */

/*! \internal \file
 * \brief
 * This file defines a box with 72 SPC/E water molecules for use in tests
 *
 * The 72 water molecules are taken from the 216 SPC liquid system. This results
 * in a more inhomogeneous system and also one that makes the tests smaller.
 *
 * \author Berk Hess <hess@kth.se>
 * \ingroup module_nbnxm
 */

#include <vector>

#include "gromacs/math/vec.h"

//! A cubic simulation box matching spc72Coordinates defined below
static const matrix spc72Box = { { 1.86206, 0.0, 0.0 }, { 0.0, 1.86206, 0.0 }, { 0.0, 0.0, 1.86206 } };

//! Coordinates of 72 SPC molecules taken from the standard 216 SPC system
static const std::vector<gmx::RVec> spc72Coordinates = {
    { 0.005, 0.600, 0.244 }, { -0.017, 0.690, 0.270 }, { 0.051, 0.610, 0.161 },
    { 0.155, 0.341, 0.735 }, { 0.140, 0.284, 0.660 },  { 0.081, 0.402, 0.734 },
    { 1.853, 0.500, 0.554 }, { 1.788, 0.505, 0.484 },  { 1.809, 0.533, 0.632 },
    { 0.732, 1.356, 1.314 }, { 0.724, 1.291, 1.245 },  { 0.767, 1.434, 1.270 },
    { 1.746, 1.593, 0.575 }, { 1.735, 1.666, 0.637 },  { 1.708, 1.518, 0.621 },
    { 1.759, 0.582, 0.800 }, { 1.673, 0.542, 0.815 },  { 1.787, 0.608, 0.888 },
    { 0.965, 0.529, 0.941 }, { 0.912, 0.531, 1.020 },  { 0.902, 0.533, 0.869 },
    { 0.091, 0.598, 1.836 }, { 0.091, 0.507, 1.806 },  { 0.174, 0.634, 1.804 },
    { 0.796, 1.279, 0.780 }, { 0.731, 1.331, 0.734 },  { 0.799, 1.196, 0.733 },
    { 0.737, 0.813, 0.145 }, { 0.765, 0.723, 0.130 },  { 0.771, 0.835, 0.231 },
    { 0.547, 1.092, 0.477 }, { 0.529, 1.089, 0.571 },  { 0.463, 1.072, 0.436 },
    { 0.729, 1.093, 1.672 }, { 0.781, 1.129, 1.744 },  { 0.762, 1.004, 1.660 },
    { 0.570, 1.373, 1.080 }, { 0.625, 1.297, 1.099 },  { 0.544, 1.361, 0.988 },
    { 1.431, 1.407, 1.448 }, { 1.471, 1.367, 1.526 },  { 1.398, 1.332, 1.397 },
    { 0.544, 0.321, 1.628 }, { 0.458, 0.278, 1.627 },  { 0.579, 0.307, 1.540 },
    { 1.482, 0.418, 0.684 }, { 1.396, 0.411, 0.641 },  { 1.490, 0.336, 0.734 },
    { 0.383, 1.854, 0.680 }, { 0.421, 1.821, 0.599 },  { 0.458, 1.885, 0.731 },
    { 1.132, 1.589, 1.714 }, { 1.043, 1.553, 1.717 },  { 1.155, 1.588, 1.621 },
    { 0.395, 1.440, 0.467 }, { 0.368, 1.353, 0.437 },  { 0.315, 1.491, 0.468 },
    { 0.305, 1.125, 0.948 }, { 0.295, 1.202, 0.892 },  { 0.271, 1.153, 1.033 },
    { 0.724, 1.826, 1.501 }, { 0.768, 1.794, 1.579 },  { 0.660, 1.759, 1.479 },
    { 0.514, 0.998, 0.125 }, { 0.597, 0.957, 0.101 },  { 0.482, 1.036, 0.043 },
    { 1.315, 0.291, 1.516 }, { 1.404, 0.271, 1.488 },  { 1.300, 0.382, 1.490 },
    { 0.062, 0.829, 0.562 }, { 0.100, 0.870, 0.484 },  { -0.009, 0.888, 0.588 },
    { 0.236, 1.600, 0.680 }, { 0.202, 1.585, 0.592 },  { 0.267, 1.691, 0.679 },
    { 0.071, 1.691, 0.164 }, { 0.075, 1.759, 0.097 },  { 0.089, 1.609, 0.116 },
    { 1.692, 0.825, 0.708 }, { 1.604, 0.794, 0.687 },  { 1.733, 0.751, 0.752 },
    { 1.579, 1.053, 0.254 }, { 1.484, 1.038, 0.253 },  { 1.612, 0.993, 0.321 },
    { 0.255, 0.444, 1.549 }, { 0.315, 0.457, 1.623 },  { 0.201, 0.370, 1.575 },
    { 0.517, 1.454, 0.771 }, { 0.540, 1.448, 0.678 },  { 0.432, 1.499, 0.771 },
    { 1.290, 1.247, 1.248 }, { 1.225, 1.308, 1.284 },  { 1.238, 1.177, 1.208 },
    { 1.161, 0.046, 0.549 }, { 1.234, 0.006, 0.596 },  { 1.172, 0.017, 0.459 },
    { 0.200, 0.931, 1.248 }, { 0.256, 0.920, 1.171 },  { 0.213, 0.850, 1.299 },
    { 1.653, 0.813, 0.403 }, { 1.632, 0.721, 0.384 },  { 1.697, 0.810, 0.488 },
    { 1.138, 1.632, 1.408 }, { 1.106, 1.554, 1.363 },  { 1.080, 1.702, 1.379 },
    { 0.309, 0.377, 1.834 }, { 0.270, 0.293, 1.810 },  { 0.356, 0.359, 1.915 },
    { 1.437, 1.245, 1.000 }, { 1.416, 1.156, 0.973 },  { 1.405, 1.252, 1.090 },
    { 1.424, 1.753, 0.580 }, { 1.415, 1.709, 0.496 },  { 1.382, 1.694, 0.643 },
    { 0.842, 0.793, 0.396 }, { 0.827, 0.699, 0.405 },  { 0.773, 0.834, 0.448 },
    { 1.184, 0.226, 0.775 }, { 1.151, 0.212, 0.686 },  { 1.273, 0.191, 0.774 },
    { 1.645, 1.631, 0.294 }, { 1.700, 1.553, 0.302 },  { 1.633, 1.661, 0.384 },
    { 0.990, 0.346, 1.386 }, { 1.000, 0.372, 1.477 },  { 1.076, 0.311, 1.362 },
    { 1.202, 0.168, 0.212 }, { 1.264, 0.196, 0.145 },  { 1.128, 0.131, 0.163 },
    { 1.107, 1.012, 1.474 }, { 1.103, 1.064, 1.393 },  { 1.098, 1.077, 1.544 },
    { 1.100, 1.061, 1.152 }, { 1.055, 1.105, 1.080 },  { 1.038, 0.995, 1.183 },
    { 1.136, 0.703, 0.486 }, { 1.042, 0.696, 0.470 },  { 1.176, 0.703, 0.399 },
    { 0.205, 0.758, 0.832 }, { 0.160, 0.782, 0.751 },  { 0.153, 0.798, 0.901 },
    { 0.014, 1.547, 1.653 }, { -0.068, 1.593, 1.633 }, { -0.011, 1.455, 1.659 },
    { 0.937, 0.550, 0.310 }, { 0.940, 0.460, 0.342 },  { 1.018, 0.561, 0.260 },
    { 1.594, 0.494, 1.709 }, { 1.526, 0.554, 1.740 },  { 1.597, 0.508, 1.614 },
    { 1.317, 0.968, 0.261 }, { 1.326, 0.873, 0.258 },  { 1.237, 0.982, 0.311 },
    { 0.818, 0.220, 0.930 }, { 0.896, 0.264, 0.962 },  { 0.843, 0.128, 0.924 },
    { 1.063, 1.375, 0.602 }, { 1.080, 1.291, 0.646 },  { 1.144, 1.425, 0.613 },
    { 0.402, 0.050, 1.093 }, { 0.419, -0.043, 1.079 }, { 0.426, 0.092, 1.010 },
    { 1.638, 1.025, 0.883 }, { 1.604, 1.095, 0.826 },  { 1.670, 0.959, 0.822 },
    { 1.398, 1.680, 1.499 }, { 1.380, 1.610, 1.437 },  { 1.312, 1.714, 1.522 },
    { 0.233, 0.934, 0.223 }, { 0.220, 0.964, 0.133 },  { 0.299, 0.865, 0.215 },
    { 1.441, 0.685, 0.696 }, { 1.354, 0.700, 0.734 },  { 1.463, 0.595, 0.721 },
    { 0.337, 1.268, 0.247 }, { 0.344, 1.178, 0.215 },  { 0.250, 1.273, 0.286 },
    { 0.898, 0.118, 0.200 }, { 0.911, 0.132, 0.106 },  { 0.829, 0.180, 0.223 },
    { 1.836, 1.848, 1.626 }, { 1.827, 1.886, 1.713 },  { 1.760, 1.789, 1.619 },
    { 1.709, 1.339, 0.320 }, { 1.682, 1.260, 0.274 },  { 1.803, 1.329, 0.333 },
    { 0.565, 0.045, 0.300 }, { 0.507, 0.057, 0.225 },  { 0.526, -0.026, 0.350 },
    { 1.628, 0.075, 0.522 }, { 1.564, 0.147, 0.528 },  { 1.585, 0.001, 0.564 },
    { 0.217, 0.088, 1.291 }, { 0.299, 0.084, 1.242 },  { 0.231, 0.028, 1.365 },
    { 1.107, 1.599, 0.835 }, { 1.035, 1.596, 0.772 },  { 1.184, 1.575, 0.784 },
    { 0.526, 0.552, 0.449 }, { 0.434, 0.575, 0.446 },  { 0.527, 0.459, 0.471 },
    { 1.370, 0.230, 1.838 }, { 1.436, 0.291, 1.805 },  { 1.357, 0.168, 1.766 },
    { 0.265, 0.145, 0.335 }, { 0.205, 0.108, 0.401 },  { 0.215, 0.142, 0.254 },
    { 0.640, 0.255, 0.072 }, { 0.592, 0.297, 0.143 },  { 0.603, 0.167, 0.066 },
    { 1.053, 1.444, 1.188 }, { 1.050, 1.387, 1.111 },  { 1.105, 1.519, 1.161 },
    { 1.220, 0.833, 1.310 }, { 1.162, 0.770, 1.266 },  { 1.167, 0.868, 1.382 },
    { 0.826, 1.515, 0.927 }, { 0.920, 1.501, 0.924 },  { 0.788, 1.433, 0.895 },
    { 0.947, 0.419, 0.683 }, { 0.950, 0.388, 0.592 },  { 0.861, 0.392, 0.715 },
    { 0.532, 1.697, 0.437 }, { 0.627, 1.686, 0.437 },  { 0.498, 1.614, 0.471 },
    { 1.398, 1.337, 0.222 }, { 1.405, 1.361, 0.314 },  { 1.433, 1.412, 0.175 },
    { 0.212, 1.702, 1.770 }, { 0.262, 1.670, 1.695 },  { 0.127, 1.724, 1.734 },
    { 0.699, 0.270, 0.386 }, { 0.669, 0.287, 0.475 },  { 0.636, 0.206, 0.352 },
    { 1.364, 0.635, 1.746 }, { 1.350, 0.721, 1.707 },  { 1.276, 0.603, 1.766 },
    { 1.316, 1.494, 0.695 }, { 1.355, 1.490, 0.782 },  { 1.366, 1.430, 0.644 },
    { 0.532, 0.838, 0.958 }, { 0.442, 0.838, 0.927 },  { 0.526, 0.856, 1.052 },
    { 1.373, 0.209, 0.411 }, { 1.349, 0.299, 0.436 },  { 1.302, 0.180, 0.354 },
    { 0.863, 0.622, 1.815 }, { 0.776, 0.662, 1.825 },  { 0.847, 0.528, 1.822 },
    { 1.783, 0.582, 1.418 }, { 1.875, 0.567, 1.396 },  { 1.784, 0.663, 1.469 },
    { 0.613, 0.312, 1.111 }, { 0.548, 0.299, 1.042 },  { 0.683, 0.250, 1.090 },
    { 0.672, 0.064, 0.643 }, { 0.713, 0.018, 0.570 },  { 0.745, 0.093, 0.698 },
    { 0.944, 0.065, 0.742 }, { 0.972, -0.020, 0.777 }, { 1.010, 0.086, 0.676 },
    { 1.518, 1.398, 0.544 }, { 1.542, 1.340, 0.617 },  { 1.585, 1.383, 0.478 },
    { 1.383, 0.745, 0.981 }, { 1.424, 0.776, 1.062 },  { 1.382, 0.650, 0.990 },
    { 1.430, 0.711, 0.228 }, { 1.484, 0.752, 0.161 },  { 1.487, 0.704, 0.304 },
    { 0.594, 1.349, 0.251 }, { 0.504, 1.319, 0.264 },  { 0.591, 1.399, 0.170 },
    { 0.012, 1.346, 0.947 }, { 0.035, 1.286, 1.017 },  { 0.082, 1.411, 0.947 },
    { 0.975, 0.631, 1.569 }, { 0.951, 0.615, 1.661 },  { 0.916, 0.701, 1.541 },
    { 0.424, 0.348, 0.217 }, { 0.386, 0.282, 0.276 },  { 0.371, 0.426, 0.232 },
    { 1.796, 1.062, 1.504 }, { 1.834, 0.988, 1.550 },  { 1.725, 1.025, 1.453 },
    { 0.776, 1.177, 1.110 }, { 0.821, 1.160, 1.027 },  { 0.783, 1.095, 1.158 },
    { 1.646, 1.672, 1.639 }, { 1.620, 1.703, 1.726 },  { 1.566, 1.678, 1.587 },
    { 0.939, 1.027, 0.909 }, { 0.975, 0.941, 0.888 },  { 0.899, 1.057, 0.828 },
    { 1.706, 1.046, 1.150 }, { 1.617, 1.024, 1.177 },  { 1.704, 1.046, 1.054 },
    { 1.111, 0.060, 1.299 }, { 1.057, -0.014, 1.271 }, { 1.161, 0.083, 1.221 },
    { 1.054, 1.138, 1.722 }, { 0.985, 1.166, 1.783 },  { 1.121, 1.206, 1.729 },
    { 0.779, 1.078, 0.328 }, { 0.689, 1.092, 0.359 },  { 0.823, 1.161, 0.344 },
    { 0.597, 1.033, 1.410 }, { 0.652, 1.088, 1.466 },  { 0.659, 0.982, 1.358 },
    { 1.397, 0.447, 1.174 }, { 1.329, 0.477, 1.236 },  { 1.349, 0.431, 1.093 },
    { 0.342, 1.754, 1.444 }, { 0.432, 1.725, 1.434 },  { 0.289, 1.686, 1.404 },
    { 0.002, 1.006, 0.356 }, { -0.063, 0.996, 0.287 }, { 0.085, 0.984, 0.314 },
    { 0.447, 0.278, 0.844 }, { 0.353, 0.299, 0.848 },  { 0.468, 0.279, 0.751 },
    { 1.114, 1.213, 0.176 }, { 1.193, 1.266, 0.182 },  { 1.111, 1.183, 0.086 },
    { 1.481, 1.728, 1.247 }, { 1.396, 1.723, 1.205 },  { 1.462, 1.727, 1.341 },
    { 1.138, 0.825, 0.006 }, { 1.188, 0.906, 0.011 },  { 1.068, 0.836, 0.071 },
    { 0.413, 1.587, 1.126 }, { 0.451, 1.503, 1.103 },  { 0.357, 1.569, 1.201 },
    { 0.578, 0.590, 1.601 }, { 0.575, 0.494, 1.609 },  { 0.523, 0.621, 1.673 },
    { 0.002, 0.779, 1.615 }, { 0.016, 0.699, 1.667 },  { -0.021, 0.846, 1.679 },
    { 0.992, 0.139, 1.797 }, { 1.059, 0.117, 1.732 },  { 0.944, 0.212, 1.759 },
    { 0.241, 0.160, 1.602 }, { 0.156, 0.128, 1.634 },  { 0.267, 0.096, 1.536 },
    { 0.586, 0.808, 1.228 }, { 0.602, 0.794, 1.321 },  { 0.589, 0.720, 1.190 },
    { 1.289, 1.008, 0.944 }, { 1.228, 0.995, 1.016 },  { 1.348, 0.933, 0.949 },
    { 1.187, 0.580, 0.165 }, { 1.275, 0.613, 0.184 },  { 1.150, 0.643, 0.104 },
    { 0.128, 0.363, 1.323 }, { 0.163, 0.288, 1.275 },  { 0.200, 0.392, 1.379 },
    { 0.061, 1.186, 1.158 }, { 0.104, 1.123, 1.216 },  { -0.028, 1.154, 1.150 },
    { 0.280, 0.690, 1.377 }, { 0.248, 0.623, 1.436 },  { 0.354, 0.649, 1.331 },
    { 1.833, 0.972, 1.801 }, { 1.749, 0.997, 1.840 },  { 1.892, 1.044, 1.823 },
    { 0.141, 1.603, 0.414 }, { 0.133, 1.634, 0.323 },  { 0.051, 1.606, 0.448 },
    { 1.560, 0.559, 0.427 }, { 1.601, 0.486, 0.380 },  { 1.511, 0.517, 0.498 },
    { 0.996, 0.813, 0.704 }, { 1.063, 0.744, 0.703 },  { 0.913, 0.766, 0.693 },
    { 0.868, 1.729, 1.730 }, { 0.942, 1.789, 1.717 },  { 0.842, 1.741, 1.821 },
    { 1.789, 1.270, 1.671 }, { 1.723, 1.273, 1.741 },  { 1.770, 1.190, 1.624 },
    { 0.429, 1.108, 1.723 }, { 0.516, 1.097, 1.684 },  { 0.368, 1.089, 1.651 },
    { 1.645, 0.313, 0.302 }, { 1.704, 0.328, 0.228 },  { 1.596, 0.235, 0.279 },
    { 0.911, 0.913, 1.641 }, { 0.949, 0.979, 1.583 },  { 0.986, 0.867, 1.678 },
    { 1.058, 1.317, 0.952 }, { 1.003, 1.272, 0.889 },  { 1.144, 1.321, 0.910 },
    { 0.511, 1.081, 0.739 }, { 0.447, 1.108, 0.805 },  { 0.568, 1.019, 0.785 },
    { 0.285, 0.503, 0.910 }, { 0.233, 0.459, 0.843 },  { 0.298, 0.591, 0.877 },
    { 0.674, 0.539, 0.187 }, { 0.623, 0.512, 0.263 },  { 0.764, 0.515, 0.208 },
    { 1.260, 0.591, 1.441 }, { 1.173, 0.593, 1.479 },  { 1.286, 0.683, 1.435 },
    { 1.148, 0.087, 1.574 }, { 1.181, 0.176, 1.561 },  { 1.138, 0.052, 1.485 },
    { 0.210, 1.415, 0.061 }, { 0.289, 1.413, 0.116 },  { 0.243, 1.432, -0.027 },
    { 0.105, 0.047, 0.820 }, { 0.094, 0.131, 0.776 },  { 0.190, 0.015, 0.790 },
    { 0.575, 1.728, 0.881 }, { 0.542, 1.639, 0.896 },  { 0.629, 1.721, 0.802 },
    { 0.964, 0.679, 1.295 }, { 0.968, 0.634, 1.380 },  { 0.908, 0.624, 1.241 },
    { 0.038, 0.532, 1.056 }, { 0.032, 0.488, 1.141 },  { 0.123, 0.504, 1.021 },
    { 0.421, 0.753, 0.165 }, { 0.436, 0.844, 0.141 },  { 0.509, 0.717, 0.178 },
    { 1.324, 0.904, 1.624 }, { 1.329, 0.928, 1.716 },  { 1.236, 0.931, 1.596 },
    { 0.732, 0.704, 0.718 }, { 0.709, 0.614, 0.743 },  { 0.700, 0.757, 0.790 },
    { 1.583, 0.679, 1.262 }, { 1.557, 0.609, 1.201 },  { 1.652, 0.639, 1.315 },
    { 0.528, 1.467, 1.839 }, { 0.579, 1.460, 1.758 },  { 0.442, 1.434, 1.816 },
    { 0.840, 0.459, 1.175 }, { 0.892, 0.425, 1.247 },  { 0.758, 0.410, 1.179 },
    { 0.898, 1.762, 1.289 }, { 0.833, 1.708, 1.245 },  { 0.851, 1.801, 1.363 },
    { 0.240, 0.537, 0.438 }, { 0.236, 0.629, 0.414 },  { 0.156, 0.520, 0.481 },
    { 0.167, 1.257, 1.465 }, { 0.226, 1.189, 1.433 },  { 0.091, 1.209, 1.499 },
    { 1.448, 0.931, 1.184 }, { 1.365, 0.938, 1.232 },  { 1.495, 0.860, 1.227 },
    { 1.046, 0.926, 0.250 }, { 1.016, 1.015, 0.233 },  { 0.981, 0.891, 0.312 },
    { 1.697, 1.681, 1.059 }, { 1.786, 1.691, 1.095 },  { 1.641, 1.677, 1.137 },
    { 1.264, 1.681, 1.111 }, { 1.261, 1.758, 1.053 },  { 1.309, 1.615, 1.059 },
    { 0.199, 1.529, 0.946 }, { 0.223, 1.579, 1.024 },  { 0.189, 1.595, 0.877 },
    { 0.413, 1.850, 0.088 }, { 0.320, 1.848, 0.112 },  { 0.418, 1.798, 0.008 },
    { 0.748, 1.654, 0.109 }, { 0.692, 1.593, 0.061 },  { 0.687, 1.715, 0.150 },
    { 1.458, 0.115, 0.761 }, { 1.436, 0.025, 0.739 },  { 1.548, 0.110, 0.793 },
    { 1.338, 1.663, 0.337 }, { 1.244, 1.654, 0.324 },  { 1.377, 1.616, 0.263 },
    { 0.088, 0.231, 0.153 }, { 0.016, 0.278, 0.110 },  { 0.044, 0.168, 0.210 },
    { 1.283, 0.951, 0.550 }, { 1.362, 0.897, 0.559 },  { 1.214, 0.888, 0.528 },
    { 0.885, 1.501, 1.606 }, { 0.812, 1.459, 1.652 },  { 0.879, 1.593, 1.632 },
    { 0.807, 1.803, 0.428 }, { 0.762, 1.842, 0.353 },  { 0.895, 1.783, 0.396 },
    { 1.804, 1.664, 1.361 }, { 1.744, 1.596, 1.392 },  { 1.797, 1.733, 1.427 },
    { 0.013, 0.096, 1.087 }, { 0.082, 0.103, 1.154 },  { 0.061, 0.086, 1.005 },
    { 0.056, 0.190, 0.535 }, { -0.034, 0.159, 0.535 }, { 0.058, 0.259, 0.469 },
    { 1.309, 1.603, 0.061 }, { 1.221, 1.598, 0.023 },  { 1.352, 1.673, 0.013 },
    { 1.001, 1.275, 1.418 }, { 0.975, 1.323, 1.340 },  { 0.991, 1.338, 1.490 },
    { 0.869, 1.045, 0.628 }, { 0.849, 1.047, 0.534 },  { 0.928, 0.971, 0.638 },
    { 1.581, 1.502, 0.042 }, { 1.536, 1.586, 0.051 },  { 1.669, 1.518, 0.078 },
    { 0.163, 1.528, 1.312 }, { 0.147, 1.436, 1.331 },  { 0.078, 1.570, 1.325 },
    { 1.732, 1.393, 1.356 }, { 1.708, 1.363, 1.443 },  { 1.774, 1.318, 1.315 },
    { 1.219, 1.169, 0.712 }, { 1.239, 1.106, 0.781 },  { 1.248, 1.127, 0.631 },
    { 0.916, 1.795, 0.997 }, { 0.927, 1.762, 1.087 },  { 0.870, 1.724, 0.951 },
    { 0.692, 1.417, 0.534 }, { 0.775, 1.399, 0.489 },  { 0.626, 1.372, 0.482 },
    { 1.596, 0.304, 1.445 }, { 1.601, 0.229, 1.386 },  { 1.664, 0.364, 1.414 },
    { 0.110, 1.254, 0.395 }, { 0.064, 1.171, 0.384 },  { 0.119, 1.263, 0.490 },
    { 0.366, 0.651, 1.780 }, { 0.375, 0.705, 1.858 },  { 0.371, 0.561, 1.813 },
    { 0.709, 0.281, 1.425 }, { 0.703, 0.185, 1.419 },  { 0.803, 0.298, 1.433 },
    { 1.778, 0.392, 0.025 }, { 1.709, 0.415, -0.038 }, { 1.818, 0.476, 0.049 },
    { 1.573, 0.890, 1.471 }, { 1.582, 0.815, 1.413 },  { 1.492, 0.872, 1.520 },
    { 1.797, 0.031, 0.294 }, { 1.793, -0.063, 0.279 }, { 1.726, 0.048, 0.357 },
    { 1.286, 1.295, 1.789 }, { 1.312, 1.386, 1.777 },  { 1.349, 1.245, 1.737 },
    { 0.702, 0.764, 1.460 }, { 0.657, 0.684, 1.486 },  { 0.735, 0.800, 1.543 },
    { 1.472, 1.539, 0.971 }, { 1.527, 1.610, 1.005 },  { 1.526, 1.461, 0.980 },
    { 0.796, 0.342, 1.743 }, { 0.707, 0.346, 1.708 },  { 0.785, 0.316, 1.835 },
    { 1.487, 1.196, 1.625 }, { 1.548, 1.170, 1.694 },  { 1.492, 1.124, 1.561 },
    { 0.315, 1.419, 1.668 }, { 0.356, 1.333, 1.667 },  { 0.233, 1.407, 1.620 },
    { 0.000, 0.814, 1.008 }, { -0.002, 0.723, 1.036 }, { -0.041, 0.862, 1.081 },
    { 1.032, 0.288, 0.415 }, { 0.963, 0.222, 0.421 },  { 1.089, 0.257, 0.345 },
    { 0.701, 0.456, 0.847 }, { 0.753, 0.382, 0.877 },  { 0.610, 0.427, 0.857 },
    { 1.627, 0.171, 1.737 }, { 1.648, 0.209, 1.652 },  { 1.644, 0.241, 1.800 },
    { 0.323, 0.958, 1.510 }, { 0.400, 0.939, 1.457 },  { 0.255, 0.898, 1.478 },
    { 0.821, 1.189, 0.033 }, { 0.815, 1.128, 0.107 },  { 0.784, 1.270, 0.067 },
    { 0.715, 1.616, 1.172 }, { 0.756, 1.581, 1.093 },  { 0.623, 1.628, 1.149 },
    { 1.505, 1.805, 1.833 }, { 1.540, 1.873, 1.775 },  { 1.506, 1.846, 1.920 },
    { 0.838, 0.896, 1.211 }, { 0.751, 0.856, 1.204 },  { 0.885, 0.839, 1.272 },
    { 1.331, 1.018, 0.010 }, { 1.334, 0.992, 0.102 },  { 1.328, 1.113, 0.011 },
    { 1.740, 1.770, 0.797 }, { 1.736, 1.738, 0.887 },  { 1.811, 1.835, 0.798 },
    { 0.197, 1.145, 0.013 }, { 0.278, 1.144, -0.037 }, { 0.177, 1.238, 0.025 },
    { 0.122, 1.292, 0.675 }, { 0.041, 1.320, 0.716 },  { 0.186, 1.359, 0.698 },
    { 0.657, 1.362, 1.581 }, { 0.666, 1.268, 1.596 },  { 0.667, 1.373, 1.486 },
    { 1.674, 0.094, 1.271 }, { 1.766, 0.107, 1.246 },  { 1.645, 0.018, 1.221 },
    { 0.406, 0.320, 0.534 }, { 0.332, 0.379, 0.519 },  { 0.378, 0.237, 0.494 },
    { 1.602, 1.329, 0.808 }, { 1.539, 1.298, 0.873 },  { 1.685, 1.292, 0.836 },
    { 0.504, 0.525, 1.274 }, { 0.581, 0.508, 1.329 },  { 0.504, 0.454, 1.210 },
    { 0.939, 1.622, 0.615 }, { 0.864, 1.660, 0.569 },  { 0.946, 1.533, 0.580 },
    { 1.222, 0.448, 0.958 }, { 1.230, 0.403, 0.874 },  { 1.131, 0.478, 0.961 },
    { 1.162, 0.079, 1.002 }, { 1.152, 0.158, 0.948 },  { 1.090, 0.022, 0.974 },
    { 0.951, 1.274, 0.372 }, { 1.002, 1.247, 0.297 },  { 1.015, 1.296, 0.439 },
    { 0.570, 1.596, 1.430 }, { 0.637, 1.550, 1.379 },  { 0.518, 1.527, 1.471 },
    { 1.490, 0.038, 0.235 }, { 1.467, -0.050, 0.265 }, { 1.472, 0.095, 0.309 },
    { 1.274, 0.440, 0.514 }, { 1.201, 0.390, 0.477 },  { 1.247, 0.531, 0.509 },
    { 1.673, 0.249, 0.968 }, { 1.723, 0.211, 1.040 },  { 1.656, 0.339, 0.995 },
    { 1.625, 1.226, 0.027 }, { 1.594, 1.313, 0.049 },  { 1.593, 1.170, 0.098 },
    { 1.002, 1.711, 0.243 }, { 0.926, 1.677, 0.196 },  { 0.988, 1.805, 0.248 }
};
