import numpy
import efel
import math
import csv
import pandas as pd
import matplotlib.pyplot as plt
from scipy.stats import circvar
import pycircstat

model_name='OLM_1811'

data_csv = pd.read_csv("./" + model_name + "/" + model_name + "_1059_[200]_noise_1_soma_rec_theta_excit_15_percent_long.dat", sep=' ', header=None, index_col=False) #you need to change this to whatever the Theta_excitation.py gives back
time_data = data_csv[0].tolist()
voltage_data = data_csv[1].tolist()
        
trace = {}
trace["T"] = time_data
trace["V"] = voltage_data
trace["stim_start"] = [500]
trace["stim_end"] = [30500]
traces = [trace]

if 'stim_start' in trace and 'stim_end' in trace:
    print('szerintem letezik')
    print(trace["stim_start"])
    print(trace["stim_end"])

efel.setThreshold(-20)

features = efel.getFeatureValues(traces, ["peak_time"])

peaks = features[0]["peak_time"]
peaks = peaks - 500 #shift, so it will look like we started the excitation at 0 ms


freq = 0.007
dc_comp = 0.011
amp =  0.01
phase = 0.0

time_data = numpy.array(time_data)

rate_vector = dc_comp +  amp * numpy.sin(2 * 3.14159265 * freq * time_data + phase)

periods = freq * 30000 
bin_szam = 18
time = 30 #seconds
time_per_bin = time / bin_szam  #stim lenght / number of bins


angle = []
decimal = []

for i in range(len(peaks)):
    decimal = (peaks[i]*freq - math.floor(peaks[i]*freq))
    angle.append(decimal *360)

print(len(peaks))

circvar_of_peaks = circvar(angle, high = 360, low= 0)
mean_vector_length = 1 - circvar_of_peaks

angle_in_rad = numpy.deg2rad(angle)

uniformity = pycircstat.raospacing(angle_in_rad)
print(uniformity)
masik_uniformity = pycircstat.rayleigh(angle_in_rad)
print(masik_uniformity)

df = pd.DataFrame({'Model_name': model_name, 'Raos Uniformity': uniformity, 'Mean_vector_length': mean_vector_length})
df.to_csv('Theta_statistics_' + model_name + '.csv', index=False, encoding='utf-8')

#print(angle)

n, bins, patches = plt.hist(angle, edgecolor= 'black', bins=range(0, 360 + 20, 20))

spike_rate = n / time_per_bin
#spike_rate = numpy.array(spike_rate)
#print(spike_rate)
#print(bins)

angle_groups = [0, 20, 40, 60, 80, 100, 120, 140, 160, 180, 200, 220, 240, 260, 280, 300, 320, 340]
plt.figure()
plt.bar(angle_groups, spike_rate, label=model_name, width=20, align='edge', edgecolor='k', color='b')

plt.title(model_name, fontsize = 16)
plt.xlabel('Angle', fontsize = 12)
plt.xticks(fontsize = 12)
plt.ylabel('Spikerate', fontsize=12)
plt.yticks(fontsize = 12)
plt.savefig('./' + model_name + '/'+ model_name +'_soma_rec_theta_excit_spikerate_vs_angle_long.svg')
plt.show()



