import quantities
import pkg_resources
try:
    import cPickle as pickle
except:
    import pickle
import gzip
from hippounit import plottools
import matplotlib.pyplot as plt
import os
import numpy

from quantities import mV, nA, ms, V, s
import json
import collections
import pandas
#from scipy import stats
from sklearn.neighbors import KernelDensity

# adding the result data to dictionary
data_dict = collections.OrderedDict()


base_dir= '/home/tarluca/hippounit_for_HS_OLM/models/New_models_SURF/PSP_silent/results/PSP_attenuation/'
save_dir = '/home/tarluca/hippounit_for_HS_OLM/models/New_models_SURF/PSP_silent/'
csv_dir = '/home/tarluca/hippounit_for_HS_OLM/models/New_models_SURF/'

if not os.path.exists(save_dir):
    os.makedirs(save_dir)


for models in os.listdir(base_dir):


    data_dict[models] = {}
    with open(base_dir +models+'/EPSP_amps.json') as f:
        data_dict[models]['EPSP_amps']=json.load(f, object_pairs_hook=collections.OrderedDict)


    synapse_data = pandas.read_csv(csv_dir + models + '_optimized_number_of_synapses.csv', header=None)
    number_of_excit_syns = numpy.array(synapse_data[3])
    number_of_excit_syns = number_of_excit_syns[1:-1] #the 0 is the heather, the last is the soma, we should exclude both
    #number_of_excit_syns = numpy.rint(number_of_excit_syns)
    print(len(number_of_excit_syns))
    print(len(data_dict[models]['EPSP_amps']))
    i = 0
    for key in data_dict[models]['EPSP_amps']:
        data_dict[models]['EPSP_amps'][key].update(number_of_excit_synapses = number_of_excit_syns[i])
        i = i+1
        #print(data_dict[models]['EPSP_amps'][key])


#data_dict[models]['number_of_excit_syns'] = number_of_excit_syns


# loading observation
with open('/home/tarluca/hippounit_for_HS_OLM/target_features/feat_PSP_attenuation_target_data.json') as f:
    observation = json.load(f, object_pairs_hook=collections.OrderedDict)

# loading stimuli file
stim_file = pkg_resources.resource_filename("hippounit", "tests/stimuli/PSP_attenuation_stim/stim_PSP_attenuation_test.json")

with open(stim_file, 'r') as f:
    config = json.load(f, object_pairs_hook=collections.OrderedDict)

#plot features

for key, val in observation.items():
    try:
        observation[key] = float(val)
    except ValueError:
        quantity_parts = val.split(" ")
        number = float(quantity_parts[0])
        units = " ".join(quantity_parts[1:])
        observation[key] = quantities.Quantity(number, units)

myKeys = list(data_dict.keys())
myKeys.sort()
data_dict = {i: data_dict[i] for i in myKeys}

print(list(data_dict.keys()))

dists = numpy.array(config['target_distances'])

colors = ['green', 'limegreen', 'seagreen', 'darkolivegreen', 'darkviolet', 'indigo', 'darkmagenta', 'mediumvioletred']

fig=plt.figure()
ax = plt.axes()
i = 0

for models in data_dict:

    EPSPs_soma = numpy.array([])
    number_of_excit_syns_current = numpy.array([])
    distances = []
    weighted_EPSP = numpy.array([])

    for k, v in data_dict[models]['EPSP_amps'].items() :

        distances.append(data_dict[models]['EPSP_amps'][k]['distance'])

        number_of_excit_syns_current = numpy.array(data_dict[models]['EPSP_amps'][k]['number_of_excit_synapses'])
        number_of_excit_syns_current = numpy.asarray(number_of_excit_syns_current, dtype='float64')
        number_of_excit_syns_current = numpy.rint(number_of_excit_syns_current)

        single_EPSP_amp = numpy.asarray(data_dict[models]['EPSP_amps'][k]['EPSP_amp_soma'], dtype='float64')

        EPSPs_soma = numpy.append(EPSPs_soma, numpy.repeat(numpy.array(single_EPSP_amp),number_of_excit_syns_current))
    #print(models)
    #print(numpy.median(EPSPs_soma))
    #print(numpy.mean(EPSPs_soma))
    #print(len(EPSPs_soma))

    kde = KernelDensity(bandwidth=0.015, kernel='gaussian')
    kde.fit(EPSPs_soma[:, None])
    x_d = numpy.linspace(min(EPSPs_soma), max(EPSPs_soma), 1000)
    #x_d = numpy.linspace(min(EPSPs_soma), 0.03, 1000)
    #x_d = numpy.linspace(-0.03, max(EPSPs_soma), 1000)
    x_d = numpy.linspace(0.35, 1.1, 1000)

    log_density = kde.score_samples(x_d[:, None])

    ax.plot(x_d, numpy.exp(log_density), color=colors[i], label = models)

    plt.title('Silent')
    i = i+1

ax.set_xlabel('Peak amplitude on soma (mV)', fontsize = 16)
ax.set_ylabel('Density', fontsize = 16)

ax.grid()

"""
for label in ax.xaxis.get_ticklabels()[::2]:
    label.set_visible(False)
"""
ax.tick_params(labelsize=14)
fig.set_figwidth(5)

#lgd = ax.legend(bbox_to_anchor=(1.0, 1.0), loc = 'upper left')
plt.savefig(save_dir + '/Kernel_density_of_somatic_psps.svg', dpi=300, bbox_inches='tight')

plt.show()



