import numpy
import efel
import math
import csv
import pandas as pd
import matplotlib.pyplot as plt
import os.path

model_name=['OLM_1811', 'OLM_1812', 'OLM_1821', 'OLM_1831', 'HS_0731', 'HS_5091', 'HS_5101', 'HS_5102']
synapse_numbers = [20, 40, 60, 80, 100, 200, 300, 400, 500]
total_number_of_synapses = [7063, 4777, 7311, 9767, 10621, 10331, 16570, 15243]
total_number_of_synapses_50 = [1596, 976, 1227, 1611.6, 3032, 2481, 3060, 2710]
total_number_of_synapses_350 = [700.7, 269, 1181, 1829, 1067.5, 606, 2038, 2706]

syn_num_for_percent = numpy.array(synapse_numbers)

synapse_percent_OLM_1811 = (syn_num_for_percent / total_number_of_synapses_350[0])*100
synapse_percent_OLM_1812 = (syn_num_for_percent / total_number_of_synapses_350[1])*100
synapse_percent_OLM_1821 = (syn_num_for_percent / total_number_of_synapses_350[2])*100
synapse_percent_OLM_1831 = (syn_num_for_percent / total_number_of_synapses_350[3])*100

synapse_percent_HS_0731 = (syn_num_for_percent / total_number_of_synapses_350[4])*100
synapse_percent_HS_5091 = (syn_num_for_percent / total_number_of_synapses_350[5])*100
synapse_percent_HS_5101 = (syn_num_for_percent / total_number_of_synapses_350[6])*100
synapse_percent_HS_5102 = (syn_num_for_percent / total_number_of_synapses_350[7])*100



distance = 350
start = [200]
duration = [1200]

traces_results={}
trace = {}
efel.setThreshold(-20)



for j in range(len(model_name)):
    synapses = {}
    for i in range(len(synapse_numbers)):
        if os.path.isfile("./" + model_name[j] + "/" + model_name[j] + "_" + str(synapse_numbers[i]) + "_[" + str(distance) + "]_noise_1_soma_rec_excit.dat") == True:
            data_csv = pd.read_csv("./" + model_name[j] + "/" + model_name[j] + "_" + str(synapse_numbers[i]) + "_[" + str(distance) + "]_noise_1_soma_rec_excit.dat", sep=' ', header=None, index_col=False)

            time_data = data_csv[0].tolist()
            voltage_data = data_csv[1].tolist()
            synapses[synapse_numbers[i]] = [time_data,voltage_data]
        else:
            print("I can't find it")

    traces_results[model_name[j]]= synapses

model_spikerates = {}

for key1, value in traces_results.items():
    model_name=key1
    spikerates = []
    for key, value in traces_results[model_name].items():

        synapse_number=key
        trace['T'] = traces_results[model_name][synapse_number][0]
        trace['V'] = traces_results[model_name][synapse_number][1]
        trace["stim_start"] = start
        trace["stim_end"] = duration

        traces = [trace]
        spikecount_feat = efel.getFeatureValues(traces, ["Spikecount"])
        spikecount=spikecount_feat[0]["Spikecount"]
        spikerate = spikecount / (numpy.array(duration)/1000)
        spikerates.append(spikerate)

    model_spikerates[model_name] = spikerates

print(model_spikerates)

plt.figure()
plt.plot(synapse_percent_OLM_1811, model_spikerates['OLM_1811'], linestyle='-', marker='o', label = 'OLM_1811', color= 'indigo')
plt.plot(synapse_percent_OLM_1812[:6], model_spikerates['OLM_1812'][:6], linestyle='-', marker='o', label = 'OLM_1812', color= 'darkmagenta')
plt.plot(synapse_percent_OLM_1821, model_spikerates['OLM_1821'], linestyle='-', marker='o', label = 'OLM_1821', color= 'darkviolet')
plt.plot(synapse_percent_OLM_1831, model_spikerates['OLM_1831'], linestyle='-', marker='o', label = 'OLM_1831', color= 'mediumvioletred')
plt.plot(synapse_percent_HS_0731, model_spikerates['HS_0731'], linestyle='-', marker='o', label = 'HS_0731', color= 'green')
plt.plot(synapse_percent_HS_5091, model_spikerates['HS_5091'], linestyle='-', marker='o', label = 'HS_5091', color= 'limegreen')
plt.plot(synapse_percent_HS_5101, model_spikerates['HS_5101'], linestyle='-', marker='o', label = 'HS_5101', color= 'seagreen')
plt.plot(synapse_percent_HS_5102, model_spikerates['HS_5102'], linestyle='-', marker='o', label = 'HS_5102', color= 'darkolivegreen')
plt.legend()
plt.grid(True)
#plt.title('Spikerate at different percentages of active excitatory synapses', fontsize=14)
plt.xlabel('Percentage of activated synapses', fontsize = 14)
#plt.ylabel('Spikerate', fontsize = 12)
plt.savefig('./spikerates_synapses_noise1_percent_of_dist_350_new.svg')
plt.show()
