
try:
    import cPickle as pickle
except:
    import pickle
import gzip
from hippounit import plottools
import matplotlib.pyplot as plt
import os
import numpy

base_dir= '/mnt/csoport31-2/Modellezo_csapat/HS_OLM/Active_models/'
name = 'Validation_chosen_ones_hs'

# adding the result data to dictionary
data_dict={}

big_errors_spiking = []
all_features = []
spiking_features = []

for models in os.listdir(base_dir + name + '/results/somaticfeat_gulyas_data/'):
    print(models)
    if os.path.exists(base_dir + name + '/results/somaticfeat_gulyas_data/'+models+'/soma_errors.p') and os.path.exists(base_dir + name + '/results/somaticfeat_gulyas_data/'+models+'/soma_features.p'):
        data_dict[models]={}
        data_dict[models]['features']=pickle.load(gzip.GzipFile(base_dir + name + '/results/somaticfeat_gulyas_data/'+models+'/soma_features.p', "rb"))
        data_dict[models]['errors']=pickle.load(gzip.GzipFile(base_dir + name + '/results/somaticfeat_gulyas_data/'+models+'/soma_errors.p', "rb"))
    hibaszamlalo = 0
    mennyi_ilyen_feature = 0

    for i in range(len(data_dict[models]['errors']['features_names'])):
        feature_name=data_dict[models]['errors']['features_names'][i]
        if 'ISI' in feature_name or 'Spikecount' in feature_name or 'Mean_frequency' in feature_name or 'inv_time' in feature_name or 'time_to_last' in feature_name:
            mennyi_ilyen_feature = mennyi_ilyen_feature +1
            x = data_dict[models]['errors']['feature_results_dict'][feature_name]
            if x > 2:
                hibaszamlalo = hibaszamlalo+1
    big_errors_spiking.append(hibaszamlalo)
    spiking_features.append(mennyi_ilyen_feature)

print(spiking_features)
print(big_errors_spiking)



   # break

colors= ['green', 'limegreen', 'seagreen', 'darkolivegreen']
#colors= ['indigo', 'darkmagenta', 'darkviolet', 'mediumvioletred']

# subplots of absolute features

try:
    colormap = plt.cm.spectral     
except:
    colormap = plt.cm.nipy_spectral

import matplotlib.gridspec as gridspec
#gs = gridspec.GridSpec(2, 4) #,width_ratios=[4,1,2,1]
fig, axs3 = plt.subplots(4,4)
fig.set_size_inches(18, 14)
print(fig.get_size_inches())
t = fig.suptitle('', fontsize=16)

gs = gridspec.GridSpec(4, 4, height_ratios=[1,1,1,1], wspace=0.3, hspace=0.3, bottom = 0.05, top=0.95, left= 0.15, right = 0.95)

# to make colouring work at each subplots
#ax0 = fig.add_subplot(gs[0])
ax0=plt.subplot(gs[0])

plt.gca().set_prop_cycle(plt.cycler('color', colormap(numpy.linspace(0, 0.9, len(data_dict.keys())+1)))) # +1 nedded for the experiment
plt.subplot(gs[1])
plt.gca().set_prop_cycle(plt.cycler('color', colormap(numpy.linspace(0, 0.9, len(data_dict.keys())+1)))) # +1 nedded for the experiment
plt.subplot(gs[2])
plt.gca().set_prop_cycle(plt.cycler('color', colormap(numpy.linspace(0, 0.9, len(data_dict.keys())+1)))) # +1 nedded for the experiment
plt.subplot(gs[3])
plt.gca().set_prop_cycle(plt.cycler('color', colormap(numpy.linspace(0, 0.9, len(data_dict.keys())+1)))) # +1 nedded for the experiment
plt.subplot(gs[4])
plt.gca().set_prop_cycle(plt.cycler('color', colormap(numpy.linspace(0, 0.9, len(data_dict.keys())+1)))) # +1 nedded for the experiment
plt.subplot(gs[5])
plt.gca().set_prop_cycle(plt.cycler('color', colormap(numpy.linspace(0, 0.9, len(data_dict.keys())+1)))) # +1 nedded for the experiment
plt.subplot(gs[6])
plt.gca().set_prop_cycle(plt.cycler('color', colormap(numpy.linspace(0, 0.9, len(data_dict.keys())+1)))) # +1 nedded for the experiment
plt.subplot(gs[7])
plt.gca().set_prop_cycle(plt.cycler('color', colormap(numpy.linspace(0, 0.9, len(data_dict.keys())+1)))) # +1 nedded for the experiment
plt.subplot(gs[8])
plt.gca().set_prop_cycle(plt.cycler('color', colormap(numpy.linspace(0, 0.9, len(data_dict.keys())+1)))) # +1 nedded for the experiment
plt.subplot(gs[9])
plt.gca().set_prop_cycle(plt.cycler('color', colormap(numpy.linspace(0, 0.9, len(data_dict.keys())+1)))) # +1 nedded for the experiment
plt.subplot(gs[10])
plt.gca().set_prop_cycle(plt.cycler('color', colormap(numpy.linspace(0, 0.9, len(data_dict.keys())+1)))) # +1 nedded for the experiment
plt.subplot(gs[11])
plt.gca().set_prop_cycle(plt.cycler('color', colormap(numpy.linspace(0, 0.9, len(data_dict.keys())+1)))) # +1 nedded for the experiment
plt.subplot(gs[12])
plt.gca().set_prop_cycle(plt.cycler('color', colormap(numpy.linspace(0, 0.9, len(data_dict.keys())+1)))) # +1 nedded for the experiment
plt.subplot(gs[13])
plt.gca().set_prop_cycle(plt.cycler('color', colormap(numpy.linspace(0, 0.9, len(data_dict.keys())+1)))) # +1 nedded for the experiment
plt.subplot(gs[14])
plt.gca().set_prop_cycle(plt.cycler('color', colormap(numpy.linspace(0, 0.9, len(data_dict.keys())+1)))) # +1 nedded for the experiment
plt.subplot(gs[15])
plt.gca().set_prop_cycle(plt.cycler('color', colormap(numpy.linspace(0, 0.9, len(data_dict.keys())+1)))) # +1 nedded for the experiment


#axs.tight_layout()
# plot model features
for z, key in enumerate(data_dict.keys()):

    x_ISIs=[]
    xerr_ISIs=[]
    labels_ISIs = []

    x_ISIs2=[]
    xerr_ISIs2=[]
    labels_ISIs2 = []

    x_ISIs3=[]
    xerr_ISIs3=[]
    labels_ISIs3 = []

    x_amps=[]
    xerr_amps=[]
    labels_amps = []

    x_smallT=[]
    xerr_smallT=[]
    labels_smallT = []

    x_smallT2=[]
    xerr_smallT2=[]
    labels_smallT2 = []

    x_smallT3=[]
    xerr_smallT3=[]
    labels_smallT3 = []

    x_spikecount=[]
    xerr_spikecount=[]
    labels_spikecount = []

    x_v=[]
    xerr_v=[]
    labels_v = []

    x_v2=[]
    xerr_v2=[]
    labels_v2 = []

    x_v3=[]
    xerr_v3=[]
    labels_v3 = []

    x_bigT=[]
    xerr_bigT=[]
    labels_bigT = []

    x_invT=[]
    xerr_invT=[]
    labels_invT = []

    x_relV=[]
    xerr_relV=[]
    labels_relV = []

    x_relV2=[]
    xerr_relV2=[]
    labels_relV2 = []

    x_relV3=[]
    xerr_relV3=[]
    labels_relV3 = []

    x_h=[]
    xerr_h=[]
    labels_h = []

    x_sag_amp=[]
    xerr_sag_amp=[]
    labels_sag_amp = []

    x_sag_ratio=[]
    xerr_sag_ratio=[]
    labels_sag_ratio = []
    # key is the name of the model
    for i in range (len(data_dict[key]['features']['features_names'])):
        feature_name=data_dict[key]['features']['features_names'][i]
        if 'inv_first_ISI' in feature_name:
            x_ISIs.append(data_dict[key]['features']['feature_results_dict'][feature_name]['feature mean'])
            xerr_ISIs.append(data_dict[key]['features']['feature_results_dict'][feature_name]['feature sd'])
            labels_ISIs.append(feature_name)
        if 'inv_last_ISI' in feature_name:
            x_ISIs2.append(data_dict[key]['features']['feature_results_dict'][feature_name]['feature mean'])
            xerr_ISIs2.append(data_dict[key]['features']['feature_results_dict'][feature_name]['feature sd'])
            labels_ISIs2.append(feature_name)
        if 'mean_frequency' in feature_name:
            x_ISIs3.append(data_dict[key]['features']['feature_results_dict'][feature_name]['feature mean'])
            xerr_ISIs3.append(data_dict[key]['features']['feature_results_dict'][feature_name]['feature sd'])
            labels_ISIs3.append(feature_name)
        if 'AP_amplitude.' in feature_name:
            x_amps.append(data_dict[key]['features']['feature_results_dict'][feature_name]['feature mean'])
            xerr_amps.append(data_dict[key]['features']['feature_results_dict'][feature_name]['feature sd'])
            labels_amps.append(feature_name)
        if 'AP_width' in feature_name:
            x_smallT.append(data_dict[key]['features']['feature_results_dict'][feature_name]['feature mean'])
            xerr_smallT.append(data_dict[key]['features']['feature_results_dict'][feature_name]['feature sd'])
            labels_smallT.append(feature_name)
        if 'AP_fall_time' in feature_name:
            x_smallT2.append(data_dict[key]['features']['feature_results_dict'][feature_name]['feature mean'])
            xerr_smallT2.append(data_dict[key]['features']['feature_results_dict'][feature_name]['feature sd'])
            labels_smallT2.append(feature_name)
        if 'AP_rise_time' in feature_name:
            x_smallT3.append(data_dict[key]['features']['feature_results_dict'][feature_name]['feature mean'])
            xerr_smallT3.append(data_dict[key]['features']['feature_results_dict'][feature_name]['feature sd'])
            labels_smallT3.append(feature_name)
        if 'Spikecount.' in feature_name:
            x_spikecount.append(data_dict[key]['features']['feature_results_dict'][feature_name]['feature mean'])
            xerr_spikecount.append(data_dict[key]['features']['feature_results_dict'][feature_name]['feature sd'])
            labels_spikecount.append(feature_name)
        if 'voltage_base' in feature_name:
            x_v.append(data_dict[key]['features']['feature_results_dict'][feature_name]['feature mean'])
            xerr_v.append(data_dict[key]['features']['feature_results_dict'][feature_name]['feature sd'])
            labels_v.append(feature_name)
        if 'AP_begin_voltage' in feature_name:
            x_v2.append(data_dict[key]['features']['feature_results_dict'][feature_name]['feature mean'])
            xerr_v2.append(data_dict[key]['features']['feature_results_dict'][feature_name]['feature sd'])
            labels_v2.append(feature_name)
        if 'AHP_depth_abs' in feature_name:
            x_v3.append(data_dict[key]['features']['feature_results_dict'][feature_name]['feature mean'])
            xerr_v3.append(data_dict[key]['features']['feature_results_dict'][feature_name]['feature sd'])
            labels_v3.append(feature_name)
        if 'inv_time_to_first_spike' in feature_name:
            x_invT.append(data_dict[key]['features']['feature_results_dict'][feature_name]['feature mean'])
            xerr_invT.append(data_dict[key]['features']['feature_results_dict'][feature_name]['feature sd'])
            labels_invT.append(feature_name)
        if 'voltage_deflection.' in feature_name:
            x_relV.append(data_dict[key]['features']['feature_results_dict'][feature_name]['feature mean'])
            xerr_relV.append(data_dict[key]['features']['feature_results_dict'][feature_name]['feature sd'])
            labels_relV.append(feature_name)
        if 'voltage_deflection_begin' in feature_name:
            x_relV2.append(data_dict[key]['features']['feature_results_dict'][feature_name]['feature mean'])
            xerr_relV2.append(data_dict[key]['features']['feature_results_dict'][feature_name]['feature sd'])
            labels_relV2.append(feature_name)
        if 'sag_amplitude'in feature_name:
            x_relV3.append(data_dict[key]['features']['feature_results_dict'][feature_name]['feature mean'])
            xerr_relV3.append(data_dict[key]['features']['feature_results_dict'][feature_name]['feature sd'])
            labels_relV3.append(feature_name)
        if 'sag_ratio1' in feature_name:
            x_sag_ratio.append(data_dict[key]['features']['feature_results_dict'][feature_name]['feature mean'])
            xerr_sag_ratio.append(data_dict[key]['features']['feature_results_dict'][feature_name]['feature sd'])
            labels_sag_ratio.append(feature_name)
        #x.append(data_dict[key]['features']['feature_results_dict'][feature_name]['feature mean'])
        #y.append(i)
        #xerr.append(data_dict[key]['features']['feature_results_dict'][feature_name]['feature sd'])

    y_v = range(len(x_v), 0, -1)
    plt.subplot(gs[0])
    #plt.gca().set_prop_cycle(plt.cycler('color', colormap(numpy.linspace(0, 0.9, len(data_dict.keys())+1)))) # +1 nedded for the experiment
    plt.errorbar(x_v, y_v, xerr=xerr_v, marker='o', linestyle='none', label=key,  clip_on=False, color=colors[z])

    y_v2=range(len(x_v2), 0, -1)
    plt.subplot(gs[13])
    #plt.gca().set_prop_cycle(plt.cycler('color', colormap(numpy.linspace(0, 0.9, len(data_dict.keys())+1)))) # +1 nedded for the experiment
    plt.errorbar(x_v2, y_v2, xerr=xerr_v2, marker='o', linestyle='none', label=key,  clip_on=False, color=colors[z])

    y_v3=range(len(x_v3), 0, -1)
    plt.subplot(gs[3])
    #plt.gca().set_prop_cycle(plt.cycler('color', colormap(numpy.linspace(0, 0.9, len(data_dict.keys())+1)))) # +1 nedded for the experiment
    plt.errorbar(x_v3, y_v3, xerr=xerr_v3, marker='o', linestyle='none', label=key,  clip_on=False, color=colors[z])

    y_relV=range(len(x_relV), 0, -1)
    plt.subplot(gs[1])
    #plt.gca().set_prop_cycle(plt.cycler('color', colormap(numpy.linspace(0, 0.9, len(data_dict.keys())+1)))) # +1 nedded for the experiment
    plt.errorbar(x_relV, y_relV, xerr=xerr_relV, marker='o', linestyle='none', label=key,  clip_on=False, color=colors[z])

    y_relV2=range(len(x_relV2), 0, -1)
    plt.subplot(gs[2])
    #plt.gca().set_prop_cycle(plt.cycler('color', colormap(numpy.linspace(0, 0.9, len(data_dict.keys())+1)))) # +1 nedded for the experiment
    plt.errorbar(x_relV2, y_relV2, xerr=xerr_relV2, marker='o', linestyle='none', label=key,  clip_on=False, color=colors[z])

    y_relV3=range(len(x_relV3), 0, -1)
    plt.subplot(gs[14])
    #plt.gca().set_prop_cycle(plt.cycler('color', colormap(numpy.linspace(0, 0.9, len(data_dict.keys())+1)))) # +1 nedded for the experiment
    plt.errorbar(x_relV3, y_relV3, xerr=xerr_relV3, marker='o', linestyle='none', label=key,  clip_on=False, color=colors[z])

    y_ISIs=range(len(x_ISIs), 0, -1)
    plt.subplot(gs[6])
    #plt.gca().set_prop_cycle(plt.cycler('color', colormap(numpy.linspace(0, 0.9, len(data_dict.keys())+1)))) # +1 nedded for the experiment
    plt.errorbar(x_ISIs, y_ISIs, xerr=xerr_ISIs, marker='o', linestyle='none', label=key,  clip_on=False, color=colors[z])

    y_ISIs2=range(len(x_ISIs2), 0, -1)
    plt.subplot(gs[7])
    #plt.gca().set_prop_cycle(plt.cycler('color', colormap(numpy.linspace(0, 0.9, len(data_dict.keys())+1)))) # +1 nedded for the experiment
    plt.errorbar(x_ISIs2, y_ISIs2, xerr=xerr_ISIs2, marker='o', linestyle='none', label=key,  clip_on=False, color=colors[z])

    y_ISIs3=range(len(x_ISIs3), 0, -1)
    plt.subplot(gs[4])
    #plt.gca().set_prop_cycle(plt.cycler('color', colormap(numpy.linspace(0, 0.9, len(data_dict.keys())+1)))) # +1 nedded for the experiment
    plt.errorbar(x_ISIs3, y_ISIs3, xerr=xerr_ISIs3, marker='o', linestyle='none', label=key,  clip_on=False, color=colors[z])

    y_amps=range(len(x_amps), 0, -1)
    plt.subplot(gs[8])
    #plt.gca().set_prop_cycle(plt.cycler('color', colormap(numpy.linspace(0, 0.9, len(data_dict.keys())+1)))) # +1 nedded for the experiment
    plt.errorbar(x_amps, y_amps, xerr=xerr_amps, marker='o', linestyle='none', label=key,  clip_on=False, color=colors[z])

    y_smallT=range(len(x_smallT), 0, -1)
    plt.subplot(gs[9])
    #plt.gca().set_prop_cycle(plt.cycler('color', colormap(numpy.linspace(0, 0.9, len(data_dict.keys())+1)))) # +1 nedded for the experiment
    plt.errorbar(x_smallT, y_smallT, xerr=xerr_smallT, marker='o', linestyle='none', label=key,  clip_on=False, color=colors[z])

    y_smallT2=range(len(x_smallT2), 0, -1)
    plt.subplot(gs[10])
    #plt.gca().set_prop_cycle(plt.cycler('color', colormap(numpy.linspace(0, 0.9, len(data_dict.keys())+1)))) # +1 nedded for the experiment
    plt.errorbar(x_smallT2, y_smallT2, xerr=xerr_smallT2, marker='o', linestyle='none', label=key,  clip_on=False, color=colors[z])

    y_smallT3=range(len(x_smallT3), 0, -1)
    plt.subplot(gs[11])
    #plt.gca().set_prop_cycle(plt.cycler('color', colormap(numpy.linspace(0, 0.9, len(data_dict.keys())+1)))) # +1 nedded for the experiment
    plt.errorbar(x_smallT3, y_smallT3, xerr=xerr_smallT3, marker='o', linestyle='none', label=key,  clip_on=False, color=colors[z])

    y_spikecount=range(len(x_spikecount), 0, -1)
    plt.subplot(gs[12])
    #plt.gca().set_prop_cycle(plt.cycler('color', colormap(numpy.linspace(0, 0.9, len(data_dict.keys())+1)))) # +1 nedded for the experiment
    plt.errorbar(x_spikecount, y_spikecount, xerr=xerr_spikecount, marker='o', linestyle='none', label=key,  clip_on=False, color=colors[z])

    y_sag_ratio=range(len(x_sag_ratio), 0, -1)
    plt.subplot(gs[15])
    #plt.gca().set_prop_cycle(plt.cycler('color', colormap(numpy.linspace(0, 0.9, len(data_dict.keys())+1)))) # +1 nedded for the experiment
    plt.errorbar(x_sag_ratio, y_sag_ratio, xerr=xerr_sag_ratio, marker='o', linestyle='none', label=key,  clip_on=False, color=colors[z])
    #plt.errorbar(x, y, xerr=xerr, marker='o', linestyle='none', label=key,  clip_on=False)

    y_invT = range(len(x_invT), 0, -1)
    plt.subplot(gs[5])
    plt.errorbar(x_invT, y_invT, xerr=xerr_invT, marker='o', linestyle='none', label=key,  clip_on=False, color=colors[z])


# adding experimental features

x_ISIs=[]
xerr_ISIs=[]
labels_ISIs = []

x_ISIs2=[]
xerr_ISIs2=[]
labels_ISIs2 = []

x_ISIs3=[]
xerr_ISIs3=[]
labels_ISIs3 = []

x_amps=[]
xerr_amps=[]
labels_amps = []

x_smallT=[]
xerr_smallT=[]
labels_smallT = []

x_smallT2=[]
xerr_smallT2=[]
labels_smallT2 = []

x_smallT3=[]
xerr_smallT3=[]
labels_smallT3 = []

x_spikecount=[]
xerr_spikecount=[]
labels_spikecount = []

x_v=[]
xerr_v=[]
labels_v = []

x_v2=[]
xerr_v2=[]
labels_v2 = []

x_v3=[]
xerr_v3=[]
labels_v3 = []

x_bigT=[]
xerr_bigT=[]
labels_bigT = []

x_invT=[]
xerr_invT=[]
labels_invT = []

x_relV=[]
xerr_relV=[]
labels_relV = []

x_relV2=[]
xerr_relV2=[]
labels_relV2 = []

x_relV3=[]
xerr_relV3=[]
labels_relV3 = []

x_h=[]
xerr_h=[]
labels_h = []

x_sag_ratio=[]
xerr_sag_ratio=[]
labels_sag_ratio = []

for i in range (len(data_dict[key]['features']['features_names'])):
    feature_name=data_dict[key]['features']['features_names'][i]
    if 'inv_first_ISI' in feature_name:
        x_ISIs.append(float(data_dict[key]['features']['observation'][feature_name]['Mean']))
        xerr_ISIs.append(float(data_dict[key]['features']['observation'][feature_name]['Std']))
        feature_name = feature_name.split(".", 1)[1]
        step_name = feature_name.split("p")[1]
        labels_ISIs.append(step_name)
    if 'inv_last_ISI' in feature_name:
        x_ISIs2.append(float(data_dict[key]['features']['observation'][feature_name]['Mean']))
        xerr_ISIs2.append(float(data_dict[key]['features']['observation'][feature_name]['Std']))
        feature_name = feature_name.split(".", 1)[1]
        step_name = feature_name.split("p")[1]
        labels_ISIs2.append(step_name)
    if 'mean_frequency' in feature_name:
        x_ISIs3.append(float(data_dict[key]['features']['observation'][feature_name]['Mean']))
        xerr_ISIs3.append(float(data_dict[key]['features']['observation'][feature_name]['Std']))
        feature_name = feature_name.split(".", 1)[1]
        step_name = feature_name.split("p")[1]
        labels_ISIs3.append(step_name)
    if 'AP_amplitude.' in feature_name:
        x_amps.append(float(data_dict[key]['features']['observation'][feature_name]['Mean']))
        xerr_amps.append(float(data_dict[key]['features']['observation'][feature_name]['Std']))
        feature_name = feature_name.split(".", 1)[1]
        step_name = feature_name.split("p")[1]
        labels_amps.append(step_name)
    if 'AP_width' in feature_name:
        x_smallT.append(float(data_dict[key]['features']['observation'][feature_name]['Mean']))
        xerr_smallT.append(float(data_dict[key]['features']['observation'][feature_name]['Std']))
        feature_name = feature_name.split(".", 1)[1]
        step_name = feature_name.split("p")[1]
        labels_smallT.append(step_name)
    if 'AP_fall_time' in feature_name:
        x_smallT2.append(float(data_dict[key]['features']['observation'][feature_name]['Mean']))
        xerr_smallT2.append(float(data_dict[key]['features']['observation'][feature_name]['Std']))
        feature_name = feature_name.split(".", 1)[1]
        labels_smallT2.append(step_name)
    if 'AP_rise_time' in feature_name:
        x_smallT3.append(float(data_dict[key]['features']['observation'][feature_name]['Mean']))
        xerr_smallT3.append(float(data_dict[key]['features']['observation'][feature_name]['Std']))
        feature_name = feature_name.split(".", 1)[1]
        step_name = feature_name.split("p")[1]
        labels_smallT3.append(step_name)
    if 'Spikecount.' in feature_name:
        x_spikecount.append(float(data_dict[key]['features']['observation'][feature_name]['Mean']))
        xerr_spikecount.append(float(data_dict[key]['features']['observation'][feature_name]['Std']))
        feature_name = feature_name.split(".", 1)[1]
        step_name = feature_name.split("p")[1]
        labels_spikecount.append(step_name)
    if 'voltage_base' in feature_name:
        x_v.append(float(data_dict[key]['features']['observation'][feature_name]['Mean']))
        xerr_v.append(float(data_dict[key]['features']['observation'][feature_name]['Std']))
        feature_name = feature_name.split(".", 1)[1]
        step_name = feature_name.split("p")[1]
        labels_v.append(step_name)
    if 'AP_begin_voltage' in feature_name:
        x_v2.append(float(data_dict[key]['features']['observation'][feature_name]['Mean']))
        xerr_v2.append(float(data_dict[key]['features']['observation'][feature_name]['Std']))
        feature_name = feature_name.split(".", 1)[1]
        step_name = feature_name.split("p")[1]
        labels_v2.append(step_name)
    if 'AHP_depth_abs' in feature_name:
        x_v3.append(float(data_dict[key]['features']['observation'][feature_name]['Mean']))
        xerr_v3.append(float(data_dict[key]['features']['observation'][feature_name]['Std']))
        feature_name = feature_name.split(".", 1)[1]
        step_name = feature_name.split("p")[1]
        labels_v3.append(step_name)
    if 'inv_time_to_first_spike' in feature_name:
        x_invT.append(float(data_dict[key]['features']['observation'][feature_name]['Mean']))
        xerr_invT.append(float(data_dict[key]['features']['observation'][feature_name]['Std']))
        feature_name = feature_name.split(".", 1)[1]
        step_name = feature_name.split("p")[1]
        labels_invT.append(step_name)
    if 'voltage_deflection.' in feature_name:
        x_relV.append(float(data_dict[key]['features']['observation'][feature_name]['Mean']))
        xerr_relV.append(float(data_dict[key]['features']['observation'][feature_name]['Std']))
        feature_name = feature_name.split(".", 1)[1]
        step_name = feature_name.split("p")[1]
        labels_relV.append(step_name)
    if 'voltage_deflection_begin' in feature_name:
        x_relV2.append(float(data_dict[key]['features']['observation'][feature_name]['Mean']))
        xerr_relV2.append(float(data_dict[key]['features']['observation'][feature_name]['Std']))
        feature_name = feature_name.split(".", 1)[1]
        step_name = feature_name.split("p")[1]
        labels_relV2.append(step_name)
    if 'sag_amplitude'in feature_name:
        x_relV3.append(float(data_dict[key]['features']['observation'][feature_name]['Mean']))
        xerr_relV3.append(float(data_dict[key]['features']['observation'][feature_name]['Std']))
        feature_name = feature_name.split(".", 1)[1]
        step_name = feature_name.split("p")[1]
        labels_relV3.append(step_name)
    if 'sag_ratio1' in feature_name:
        x_sag_ratio.append(float(data_dict[key]['features']['observation'][feature_name]['Mean']))
        xerr_sag_ratio.append(float(data_dict[key]['features']['observation'][feature_name]['Std']))
        feature_name = feature_name.split(".", 1)[1]
        step_name = feature_name.split("p")[1]
        labels_sag_ratio.append(step_name)


#opt_features=['inv_first_ISI.Step0.2']
y_v=range(len(x_v), 0, -1)
print(y_v)
plt.subplot(gs[0])
plt.subplot(gs[0]).set_title('Voltage base', fontsize=16)
plt.errorbar(x_v, y_v, xerr=xerr_v, marker='*', linestyle='none', label='Experiment',  clip_on=False)
plt.yticks(range(len(labels_v), 0, -1), labels_v, fontsize = 12)
#print plt.yticks(labels)
#plt.yticks(color = 'red')
plt.xticks(fontsize = 12)
plt.xlabel('mV', fontsize=12)
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)
plt.grid(True)

y_v2=range(len(x_v2), 0, -1)
plt.subplot(gs[13])
plt.subplot(gs[13]).set_title('AP begin voltage', fontsize=16)
plt.errorbar(x_v2, y_v2, xerr=xerr_v2, marker='*', linestyle='none', label='Experiment',  clip_on=False)
plt.yticks(range(len(labels_v2), 0, -1), labels_v2, fontsize = 12)
#print plt.yticks(labels)
#plt.yticks(color = 'red')
plt.xticks(fontsize = 12)
plt.xlabel('mV', fontsize=12)
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)
plt.grid(True)

y_v3=range(len(x_v3), 0, -1)
plt.subplot(gs[3])
plt.subplot(gs[3]).set_title('AHP depth (absolute value)', fontsize=16)
plt.errorbar(x_v3, y_v3, xerr=xerr_v3, marker='*', linestyle='none', label='Experiment',  clip_on=False)
plt.yticks(range(len(labels_v3), 0, -1), labels_v3, fontsize = 12)
#print plt.yticks(labels)
#plt.yticks(color = 'red')
plt.xticks(fontsize = 12)
plt.xlabel('mV', fontsize=12)
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)
plt.grid(True)

y_relV=range(len(x_relV), 0, -1)
plt.subplot(gs[1])
plt.subplot(gs[1]).set_title('Voltage deflection', fontsize=16)
plt.errorbar(x_relV, y_relV, xerr=xerr_relV, marker='*', linestyle='none', label='Experiment',  clip_on=False)
plt.yticks(range(len(labels_relV), 0, -1), labels_relV, fontsize = 12)
plt.xticks(fontsize = 12)
plt.xlabel('mV', fontsize=12)
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)
plt.grid(True)

y_relV2=range(len(x_relV2), 0, -1)
plt.subplot(gs[2])
plt.subplot(gs[2]).set_title('Voltage defl. at the begining', fontsize=16)
plt.errorbar(x_relV2, y_relV2, xerr=xerr_relV2, marker='*', linestyle='none', label='Experiment',  clip_on=False)
plt.yticks(range(len(labels_relV2), 0, -1), labels_relV2, fontsize = 12)
plt.xticks(fontsize = 12)
plt.xlabel('mV', fontsize=12)
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)
plt.grid(True)

y_relV3=range(len(x_relV3), 0, -1)
plt.subplot(gs[14])
plt.subplot(gs[14]).set_title('Sag amplitude', fontsize=16)
plt.errorbar(x_relV3, y_relV3, xerr=xerr_relV3, marker='*', linestyle='none', label='Experiment',  clip_on=False)
plt.yticks(range(len(labels_relV3), 0, -1), labels_relV3, fontsize = 12)
plt.xticks(fontsize = 12)
plt.xlabel('mV', fontsize=12)
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)
plt.grid(True)

y_ISIs=range(len(x_ISIs), 0, -1)
plt.subplot(gs[6])
plt.subplot(gs[6]).set_title('First ISI (inverse)', fontsize=16)
plt.errorbar(x_ISIs, y_ISIs, xerr=xerr_ISIs, marker='*', linestyle='none', label='Experiment',  clip_on=False)
plt.yticks(range(len(labels_ISIs), 0, -1), labels_ISIs, fontsize = 12)
plt.xticks(fontsize = 12)
plt.xlabel('Hz', fontsize=12)
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)
plt.grid(True)

y_ISIs2=range(len(x_ISIs2), 0, -1)
plt.subplot(gs[7])
plt.subplot(gs[7]).set_title('Last ISI (inverse)', fontsize=16)
plt.errorbar(x_ISIs2, y_ISIs2, xerr=xerr_ISIs2, marker='*', linestyle='none', label='Experiment',  clip_on=False)
plt.yticks(range(len(labels_ISIs2), 0, -1), labels_ISIs2, fontsize = 12)
plt.xticks(fontsize = 12)
plt.xlabel('Hz', fontsize=12)
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)
lgd = plt.legend(bbox_to_anchor=(1.1, 0.99), loc = 'upper left', ncol = 1, fontsize = 10)
plt.grid(True)

y_ISIs3=range(len(x_ISIs3), 0, -1)
plt.subplot(gs[4])
plt.subplot(gs[4]).set_title('Mean frequency', fontsize=16)
plt.errorbar(x_ISIs3, y_ISIs3, xerr=xerr_ISIs3, marker='*', linestyle='none', label='Experiment',  clip_on=False)
plt.yticks(range(len(labels_ISIs3), 0, -1), labels_ISIs3, fontsize = 12)
plt.xticks(fontsize = 12)
plt.xlabel('Hz', fontsize=12)
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)
plt.grid(True)

y_amps=range(len(x_amps), 0, -1)
plt.subplot(gs[8])
plt.subplot(gs[8]).set_title('AP amplitude', fontsize=16)
plt.errorbar(x_amps, y_amps, xerr=xerr_amps, marker='*', linestyle='none', label='Experiment',  clip_on=False)
plt.yticks(range(len(labels_amps), 0, -1), labels_amps, fontsize = 12)
plt.xticks(fontsize = 12)
plt.xlabel('mV', fontsize=12)
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)
plt.grid(True)

y_smallT=range(len(x_smallT), 0, -1)
plt.subplot(gs[9])
plt.subplot(gs[9]).set_title('AP width', fontsize=16)
plt.errorbar(x_smallT, y_smallT, xerr=xerr_smallT, marker='*', linestyle='none', label='Experiment',  clip_on=False)
plt.yticks(range(len(labels_smallT), 0, -1), labels_smallT, fontsize = 12)
plt.xticks(fontsize = 12)
plt.xlabel('ms', fontsize=12)
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)
plt.grid(True)

y_smallT2=range(len(x_smallT2), 0, -1)
plt.subplot(gs[10])
plt.subplot(gs[10]).set_title('AP fall time', fontsize=16)
plt.errorbar(x_smallT2, y_smallT2, xerr=xerr_smallT2, marker='*', linestyle='none', label='Experiment',  clip_on=False)
plt.yticks(range(len(labels_smallT2), 0, -1), labels_smallT2, fontsize = 12)
plt.xticks(fontsize = 12)
plt.xlabel('ms', fontsize=12)
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)
plt.grid(True)

y_smallT3=range(len(x_smallT3), 0, -1)
plt.subplot(gs[11])
plt.subplot(gs[11]).set_title('AP rise time', fontsize=16)
plt.errorbar(x_smallT3, y_smallT3, xerr=xerr_smallT3, marker='*', linestyle='none', label='Experiment',  clip_on=False)
plt.yticks(range(len(labels_smallT3), 0, -1), labels_smallT3, fontsize = 12)
plt.xticks(fontsize = 12)
plt.xlabel('ms', fontsize=12)
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)
plt.grid(True)

y_spikecount=range(len(x_spikecount), 0, -1)
plt.subplot(gs[12])
plt.subplot(gs[12]).set_title('Spikecount', fontsize=16)
plt.errorbar(x_spikecount, y_spikecount, xerr=xerr_spikecount, marker='*', linestyle='none', label='Experiment',  clip_on=False)
plt.yticks(range(len(labels_spikecount), 0, -1), labels_spikecount, fontsize = 12)
plt.xticks(fontsize = 12)
plt.xlabel('number of spikes', fontsize=12)
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)
plt.grid(True)


y_sag_ratio=range(len(x_sag_ratio), 0, -1)
plt.subplot(gs[15])
plt.subplot(gs[15]).set_title('Sag ratio', fontsize=16)
plt.errorbar(x_sag_ratio, y_sag_ratio, xerr=xerr_sag_ratio, marker='*', linestyle='none', label='Experiment',  clip_on=False)
plt.yticks(range(len(labels_sag_ratio), 0, -1), labels_sag_ratio, fontsize = 12)
plt.xticks(fontsize = 12)
plt.xlabel('Ratio', fontsize=12)
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)
plt.grid(True)

y_invT=range(len(x_invT), 0, -1)
plt.subplot(gs[5])
plt.subplot(gs[5]).set_title('Inverse time to first spike', fontsize=16)
plt.errorbar(x_invT, y_invT, xerr=xerr_invT, marker='*', linestyle='none', label='Experiment',  clip_on=False)
plt.yticks(range(len(labels_invT), 0, -1), labels_invT, fontsize = 12)
plt.xticks(fontsize = 12)
plt.xlabel('Hz', fontsize=12)
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)
plt.grid(True)

handles, labels = ax0.get_legend_handles_labels()
#fig.legend(bbox_to_anchor=(1.1, 1.2), loc = 'upper left', ncol = 4, fontsize = 8)
#lgd = fig.legend(handles, labels, loc = "upper right", bbox_to_anchor=(1.1, 0.95) )# bbox_extra_artists does not work with it


#plt.legend(bbox_to_anchor=(1.1, 1.05), ncol = 1, fontsize = 8)
#plt.legend(bbox_to_anchor=(0., 1.02, 1., .102), loc=3, ncol=2, mode="expand", borderaxespad=0, prop={'size':8})
#plt.savefig(base_dir + name + '/' + name + '_absolute_features_subplots_try_reverse_csini.svg', bbox_extra_artists=(lgd, t,), bbox_inches='tight')




plt.show()
