import json
import collections

""" !!! EDIT THIS PART !!! """
# Load data
with open('/home/tarluca/HS_OLM_story/BluePyEfe/CA1_OLM_new_all_features_nyiri_project_2_with_sag_time_ljp/features.json') as f:
    data = json.load(f, object_pairs_hook=collections.OrderedDict)

num_measurements = 8

"""-----------------------"""

#print data

opt_data = collections.OrderedDict()
opt_data["features"] = collections.OrderedDict()

opt_data["stimuli"] = collections.OrderedDict()

#main_key = data.keys()[0]

stim_list = [-0.18,-0.12,-0.04, 0.04, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6]
feature_list = ["AHP_depth_abs", "AHP_time_from_peak", "AP2_amp", "AP_amplitude", "AP_begin_voltage", "AP_duration_half_width", "AP_fall_time", "AP_rise_time", "APlast_amp", "Spikecount", "inv_first_ISI", "inv_last_ISI", "inv_time_to_first_spike", "steady_state_voltage", "voltage_base", "voltage_deflection", "voltage_deflection_begin", "sag_amplitude", "sag_ratio1", "sag_time_constant"]  

for key, stim_dict in data.items():
    split_key = key.split('_')
    #print split_key
    stim = split_key[0].capitalize() + split_key[1]
    # stim_list.append(float(split_key[1]))
    #print stim
    if float(split_key[1]) in stim_list:
        for i in range(len(data[key]["soma"])):
            #opt_data["features"].update({feat:{"weight": "1"}})
            feat = data[key]["soma"][i]['feature']
            value = data[key]["soma"][i]['val']
            if feat in feature_list:
                if feat not in opt_data["features"].keys() and data[key]["soma"][i]['n'] == num_measurements: # we don't want to use those values that are not the mean of all the measurements
                    opt_data["features"][feat]=collections.OrderedDict({"weight": "1"})
                if data[key]["soma"][i]['n'] == num_measurements:
                    opt_data["features"][feat].update({"stimAmp_"+split_key[1]: {"Std" : float(value[1]), "Mean": float(value[0])}})

opt_data["stimuli"]= collections.OrderedDict({"amplitudes" : sorted(stim_list), "delay":200, "duration":800})

ordered_opt_data = collections.OrderedDict(reversed(opt_data.items()))
#print valid_data

file_name_opt_data= './RAW_olm_feat_opt_ljp.json'
with open(file_name_opt_data, 'w') as outfile:
    json.dump(ordered_opt_data, outfile, indent=4)
