import neuron
from neuron import h
import pandas
import matplotlib.pyplot as plt
import numpy as np
import math
from scipy import stats

# We are loading the models

source_dir = "/home/tarluca/HS_OLM_story/hippounit_for_HS_OLM/models/New_models_SURF/"

#filenames = ['HS_0731.hoc', 'OLM_1821.hoc', 'OLM_1811.hoc', 'OLM_1812.hoc', 'OLM_1831.hoc', 'HS_5091.hoc', 'HS_5101.hoc', 'HS_5102.hoc']

#filenames = ['HS_0731_optimized.hoc', 'OLM_1821_optimized.hoc', 'OLM_1811_optimized.hoc', 'OLM_1812_optimized.hoc', 'OLM_1831_optimized.hoc', 'HS_5091_optimized.hoc', 'HS_5101_optimized.hoc', 'HS_5102_optimized.hoc']

filenames = ['OLM_1811_optimized.hoc', 'OLM_1812_optimized.hoc', 'OLM_1821_optimized.hoc', 'OLM_1831_optimized.hoc', 'HS_0731_optimized.hoc', 'HS_5091_optimized.hoc', 'HS_5101_optimized.hoc', 'HS_5102_optimized.hoc']

#filenames = ['181_OLM_02_cell_01_pucer_silent.hoc']


def model_loading(source_dir, filename):
    h.load_file("subiter.hoc")
    h.load_file("stdrun.hoc")
    hoc_name = source_dir+filename
    neuron.load_mechanisms(source_dir + "/modfiles/")

    h.load_file(1, hoc_name)


# Calculating the number of synapses on the whole dendritic arbor

def synapses_distribution(segment_list, diam_list, distance_list, number_of_gneg_synapses, number_of_gpos_synapses,
                          coefficients_excitatory, coefficients_inhibitory, gneg_dens_soma, gpos_dens_soma,
                          num_gneg_soma_list, num_gpos_soma_list):
    total_num_of_gneg = 0
    total_num_of_gpos = 0
    total_length = 0

    for sec in h.basal:
        length = sec.L
        segment_number = sec.nseg
        print(sec, sec.nseg)
        total_length = total_length + length
        for seg in sec:
            segment_list.append(str(sec) + str(seg.x))
            h.distance(sec=h.soma)
            dist = (h.distance(seg.x, sec=sec))
            distance_list.append(dist)
            diameter = seg.diam
            diam_list.append(diameter)
            num_gneg = (coefficients_excitatory[0] + (coefficients_excitatory[1] * dist) + (
                        coefficients_excitatory[2] * diameter)) * ((length*diameter*math.pi) / segment_number)
            if num_gneg < 0:
                num_gneg = 0
            num_gpos = (coefficients_inhibitory[0] + (coefficients_inhibitory[1] * dist) + (
                        coefficients_inhibitory[2] * diameter)) * ((length*diameter*math.pi) / segment_number)
            if num_gpos < 0:
                num_gpos = 0
            number_of_gneg_synapses.append(num_gneg)
            number_of_gpos_synapses.append(num_gpos)
            total_num_of_gneg = total_num_of_gneg + num_gneg
            total_num_of_gpos = total_num_of_gpos + num_gpos

    for sec in h.somatic:
        soma_height = sec.L
        soma_r = sec.diam / 2
        soma_area = 2 * math.pi * soma_r * soma_height
        segment_list.append(str(sec))
        distance_list.append(0)
        diam_list.append(sec.diam)
        num_gneg_soma = soma_area * gneg_dens_soma
        num_gpos_soma = soma_area * gpos_dens_soma
        num_gneg_soma_list.append(num_gneg_soma)
        num_gpos_soma_list.append(num_gpos_soma)
        total_num_of_gneg_with_soma = total_num_of_gneg + num_gneg_soma
        total_num_of_gpos_with_soma = total_num_of_gpos + num_gpos_soma

    return total_num_of_gneg, total_num_of_gpos, total_length, total_num_of_gneg_with_soma, total_num_of_gpos_with_soma


# Arrange the distances and synapse numbers to groups for the bar chart, then plot the barchart

def summaries_for_barchart(name_of_model, segment_distance_list, number_of_excitatory_syn_list,
                           number_of_inhibitory_syn_list):
    sum_of_excitatory = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    sum_of_inhibitory = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    # print(len(number_of_excitatory_syn_list))
    for i in range(len(segment_distance_list)):
        if segment_distance_list[i] == 0:
            sum_of_excitatory[0] = sum_of_excitatory[0] + number_of_excitatory_syn_list[-1]
            sum_of_inhibitory[0] = sum_of_inhibitory[0] + number_of_inhibitory_syn_list[-1]
        elif segment_distance_list[i] < 50:
            sum_of_excitatory[1] = sum_of_excitatory[1] + number_of_excitatory_syn_list[i]
            sum_of_inhibitory[1] = sum_of_inhibitory[1] + number_of_inhibitory_syn_list[i]
        elif 100 > segment_distance_list[i] >= 50:
            sum_of_excitatory[2] = sum_of_excitatory[2] + number_of_excitatory_syn_list[i]
            sum_of_inhibitory[2] = sum_of_inhibitory[2] + number_of_inhibitory_syn_list[i]
        elif 150 > segment_distance_list[i] >= 100:
            sum_of_excitatory[3] = sum_of_excitatory[3] + number_of_excitatory_syn_list[i]
            sum_of_inhibitory[3] = sum_of_inhibitory[3] + number_of_inhibitory_syn_list[i]
        elif 200 > segment_distance_list[i] >= 150:
            sum_of_excitatory[4] = sum_of_excitatory[4] + \
                                   number_of_excitatory_syn_list[i]
            sum_of_inhibitory[4] = sum_of_inhibitory[4] + \
                                   number_of_inhibitory_syn_list[i]
        elif 250 > segment_distance_list[i] >= 200:
            sum_of_excitatory[5] = sum_of_excitatory[5] + \
                                   number_of_excitatory_syn_list[i]
            sum_of_inhibitory[5] = sum_of_inhibitory[5] + \
                                   number_of_inhibitory_syn_list[i]
        elif 300 > segment_distance_list[i] >= 250:
            sum_of_excitatory[6] = sum_of_excitatory[6] + \
                                   number_of_excitatory_syn_list[i]
            sum_of_inhibitory[6] = sum_of_inhibitory[6] + \
                                   number_of_inhibitory_syn_list[i]
        elif 350 > segment_distance_list[i] >= 300:
            sum_of_excitatory[7] = sum_of_excitatory[7] + \
                                   number_of_excitatory_syn_list[i]
            sum_of_inhibitory[7] = sum_of_inhibitory[7] + \
                                   number_of_inhibitory_syn_list[i]
        elif 400 > segment_distance_list[i] >= 350:
            sum_of_excitatory[8] = sum_of_excitatory[8] + \
                                   number_of_excitatory_syn_list[i]
            sum_of_inhibitory[8] = sum_of_inhibitory[8] + \
                                   number_of_inhibitory_syn_list[i]
        elif 450 > segment_distance_list[i] >= 400:
            sum_of_excitatory[9] = sum_of_excitatory[9] + \
                                   number_of_excitatory_syn_list[i]
            sum_of_inhibitory[9] = sum_of_inhibitory[9] + \
                                   number_of_inhibitory_syn_list[i]
        elif 500 > segment_distance_list[i] >= 450:
            sum_of_excitatory[10] = sum_of_excitatory[10] + \
                                    number_of_excitatory_syn_list[i]
            sum_of_inhibitory[10] = sum_of_inhibitory[10] + \
                                    number_of_inhibitory_syn_list[i]
        else:
            sum_of_excitatory[11] = sum_of_excitatory[11] + \
                                    number_of_excitatory_syn_list[i]
            sum_of_inhibitory[11] = sum_of_inhibitory[11] + \
                                    number_of_inhibitory_syn_list[i]

    distance_groups = [-50, 0, 50, 100, 150, 200, 250, 300, 350, 400, 450, 500]

    plt.figure()
    plt.rc('xtick', labelsize=15)  # fontsize of the tick labels
    plt.rc('ytick', labelsize=15)
    plt.bar(distance_groups, sum_of_excitatory, label="Excitatory", width=50, align='edge', edgecolor='k', color='r')
    plt.bar(distance_groups, sum_of_inhibitory, label="Inhibitory", width=50, align='edge', edgecolor='k', color='b')
    plt.legend()
    plt.ylim([0, 3000])
    plt.xlabel('Distance')
    plt.ylabel('Num. syn')

    plt.title(name_of_model)
    plt.savefig(name_of_model + '_num_syns.svg')
    #plt.show()

    sum_of_exc = np.array(sum_of_excitatory)
    sum_of_inhib = np.array(sum_of_inhibitory)
    ratio_excit_inhib = sum_of_exc / sum_of_inhib

    plt.figure()
    plt.rc('xtick', labelsize=15)  # fontsize of the tick labels
    plt.rc('ytick', labelsize=15)
    plt.bar(distance_groups, ratio_excit_inhib, label="Ratio", width=50, align='edge', edgecolor='k', color='orange')
    plt.legend()
    #plt.ylim([0, 10])
    plt.xlabel('Distance')
    plt.ylabel('Num. syn')

    plt.title(name_of_model)
    plt.savefig(name_of_model + '_ratio_syns.svg')
    # We now calculate the conductances, the argument lists should be complete beforehand by the "synapse distribution" function
    
    return sum_of_excitatory, sum_of_inhibitory, distance_groups


def calculate_conductances(segment_list, number_of_gneg_synapses, number_of_gpos_synapses, morph_name, syn_size_factor_excit, syn_size_factor_inhib):
    # Conductance parameters
    rate_excit = [3] * len(segment_list)
    rate_inhib = [30] * len(segment_list)
    tau_excit = 0.0127 #3 ms, ez csak a decay!
    tau_inhib = 0.012
    gmax_excit = [0.8 * syn_size_factor_excit] * len(segment_list)
    gmax_inhib = [0.5 * syn_size_factor_inhib] * len(segment_list)
    gpas = [5e-5] * len(segment_list)  # need confirmation, in the same unit as the synaptic conductance (nS/um2)
    areas = []
    conductance_per_area_excit = []
    conductance_per_area_inhib = []

    for sec in h.basal:
        length_section = sec.L
        num_segments = sec.nseg
        length_segments = length_section / num_segments
        for seg in sec:
            diameter = seg.diam
            areas.append(2 * math.pi * (diameter / 2) * length_segments)
    for sec in h.somatic:
        diameter = sec.diam
        length = sec.L
        areas.append(2 * math.pi * (diameter / 2) * length)

    syn_per_area_excit = np.array(number_of_gneg_synapses) / np.array(areas)
    syn_per_area_inhib = np.array(number_of_gpos_synapses) / np.array(areas)


    np.savetxt(morph_name + '_syn_per_area_excit.dat', syn_per_area_excit)
    np.savetxt(morph_name + '_syn_per_area_inhib.dat', syn_per_area_inhib)

    conductance_per_area_excit = syn_per_area_excit * rate_excit * tau_excit * gmax_excit
    conductance_per_area_inhib = syn_per_area_inhib * rate_inhib * tau_inhib * gmax_inhib

    gpa_all = conductance_per_area_excit + conductance_per_area_inhib + gpas 
    erev_all = (np.array(conductance_per_area_excit) * 0 + np.array(conductance_per_area_inhib) * (-70) + np.array(
        gpas) * (-65)) / np.array(gpa_all)
    total_excit = np.array(conductance_per_area_excit) * np.array(areas)
    total_inhib = np.array(conductance_per_area_inhib) * np.array(areas)

    return gpa_all, erev_all, total_excit, total_inhib, conductance_per_area_excit, conductance_per_area_inhib, gpas


# Coefficients for the equations that calcualtes the synapses numbers - given by a separate matlab script

"""
HS_coeff_exc = [0.1437, -0.002, 3.5421]
HS_coeff_inhib = [-0.0273, -0.001, 0.838]
OLM_coeff_exc = [1.4281, -0.0024, 0.977]
OLM_coeff_inhib = [-0.0477, 0.0003, 0.3351]
"""
# Coeffs from num/surface:

HS_coeff_exc = [0.728, -3.7372e-04, 0.0728]
HS_coeff_inhib = [0.1405, -1.0232e-04, 0.0249]
OLM_coeff_exc = [0.7886, -7.9527e-04, -0.1672]
OLM_coeff_inhib = [0.0735, 5.0049e-05, 0.0014]

# Soma synapse density averages for 1 um soma membrane - given by a separate matlab script
HS_gneg_soma_dens = 0.4185
HS_gpos_soma_dens = 0.15175
OLM_gneg_soma_dens = 0.22875
OLM_gpos_soma_dens = 0.03675


# Arrange data to plot all the morphologies

def do_all_morphs(filenames):
    dendritic_arbor_length_HS = []
    dendritic_arbor_length_OLM = []
    Total_excitatory_synapses_HS = []
    Total_excitatory_synapses_OLM = []
    Total_excitatory_synapses_with_soma_HS = []
    Total_excitatory_synapses_with_soma_OLM = []
    Total_inhibitory_synapses_HS = []
    Total_inhibitory_synapses_OLM = []
    Total_inhibitory_synapses_with_soma_HS = []
    Total_inhibitory_synapses_with_soma_OLM = []
    
    fig, axs = plt.subplots(2, 4, sharex=True, sharey=True, figsize=(4 * 4, 2 * 4))
    axs = axs.flatten()

    for i, filename in enumerate(filenames):
        model_loading(source_dir, filename)
        just_name = filename.split(".")

        if "OLM" in filename:
            syn_size_fact_exc = 1
            syn_size_fact_inhib = 1
            OLM_segment_list = []
            OLM_segment_diam_list = []
            OLM_segment_distance_list = []
            OLM_number_of_excitatory_syn_list = []
            OLM_number_of_inhibitory_syn_list = []
            OLM_number_of_excitatory_syn_list_with_soma = []
            OLM_number_of_inhibitory_syn_list_with_soma = []
            total_number_of_synapses = synapses_distribution(OLM_segment_list, OLM_segment_diam_list,
                                                             OLM_segment_distance_list,
                                                             OLM_number_of_excitatory_syn_list,
                                                             OLM_number_of_inhibitory_syn_list, OLM_coeff_exc,
                                                             OLM_coeff_inhib, OLM_gneg_soma_dens, OLM_gpos_soma_dens,
                                                             OLM_number_of_excitatory_syn_list_with_soma,
                                                             OLM_number_of_inhibitory_syn_list_with_soma)
            Total_excitatory_synapses_OLM.append(total_number_of_synapses[0])
            Total_inhibitory_synapses_OLM.append(total_number_of_synapses[1])
            dendritic_arbor_length_OLM.append(total_number_of_synapses[2])
            Total_excitatory_synapses_with_soma_OLM.append(total_number_of_synapses[3])
            Total_inhibitory_synapses_with_soma_OLM.append(total_number_of_synapses[4])
            df = pandas.DataFrame({'Segment_list': OLM_segment_list, 'Diameter': np.array(OLM_segment_diam_list),
                                   'Distance': np.array(OLM_segment_distance_list), 'Number_excitatory_syn': np.array(
                    OLM_number_of_excitatory_syn_list + OLM_number_of_excitatory_syn_list_with_soma),
                                   'Number_inhibitory_syn': np.array(
                                       OLM_number_of_inhibitory_syn_list + OLM_number_of_inhibitory_syn_list_with_soma)})
            df.to_csv(just_name[0] + '_number_of_synapses.csv', index=False, encoding='utf-8')

            sum_of_excitatory, sum_of_inhibitory, distance_groups = summaries_for_barchart(just_name[0], OLM_segment_distance_list,
                                                                                            OLM_number_of_excitatory_syn_list + OLM_number_of_excitatory_syn_list_with_soma,
                                                                                            OLM_number_of_inhibitory_syn_list + OLM_number_of_inhibitory_syn_list_with_soma)
                                                                                            

            axs[i].bar(distance_groups, sum_of_excitatory, label="Excitatory", width=50, align='edge', edgecolor='k', color='r')
            axs[i].bar(distance_groups, sum_of_inhibitory, label="Inhibitory", width=50, align='edge', edgecolor='k', color='b')
            axs[i].set_ylim([0, 3000])
            #axs[i].set_xlabel('Distance (um)')
            #axs[i].set_ylabel('Num. syn')
            axs[i].spines['right'].set_visible(False)
            axs[i].spines['top'].set_visible(False)
            cell_name = just_name[0].split('_')
            axs[i].set_title(cell_name[0] + '_' + cell_name[1], fontsize = 16)
            axs[i].tick_params(axis='both', which='major', labelsize=15)


            synaptic_conductances_OLM = calculate_conductances(OLM_segment_list,
                                                               OLM_number_of_excitatory_syn_list + OLM_number_of_excitatory_syn_list_with_soma,
                                                               OLM_number_of_inhibitory_syn_list + OLM_number_of_inhibitory_syn_list_with_soma, just_name[0], syn_size_fact_exc, syn_size_fact_inhib)
            df2 = pandas.DataFrame({'Segment_list': OLM_segment_list, 'gpa_all': synaptic_conductances_OLM[0],
                                    'erev_all': synaptic_conductances_OLM[1],
                                    'total_excit': synaptic_conductances_OLM[2],
                                    'total_inhib': synaptic_conductances_OLM[3],
                                    'conductance_per_area_excit': synaptic_conductances_OLM[4],
                                    'conductance_per_area_inhib': synaptic_conductances_OLM[5],
                                    'gpas': synaptic_conductances_OLM[6]})
            df2.to_csv(just_name[0] + '_conductances.csv', index=False, encoding='utf-8')        
        
        else:

            syn_size_fact_exc = 1
            syn_size_fact_inhib = 1.15
            HS_segment_list = []
            HS_segment_diam_list = []
            HS_segment_distance_list = []
            HS_number_of_excitatory_syn_list = []
            HS_number_of_inhibitory_syn_list = []
            HS_number_of_excitatory_syn_list_with_soma = []
            HS_number_of_inhibitory_syn_list_with_soma = []
            total_number_of_synapses = synapses_distribution(HS_segment_list, HS_segment_diam_list,
                                                             HS_segment_distance_list, HS_number_of_excitatory_syn_list,
                                                             HS_number_of_inhibitory_syn_list, HS_coeff_exc,
                                                             HS_coeff_inhib, HS_gneg_soma_dens, HS_gpos_soma_dens,
                                                             HS_number_of_excitatory_syn_list_with_soma,
                                                             HS_number_of_inhibitory_syn_list_with_soma)
            Total_excitatory_synapses_HS.append(total_number_of_synapses[0])
            Total_inhibitory_synapses_HS.append(total_number_of_synapses[1])
            dendritic_arbor_length_HS.append(total_number_of_synapses[2])
            Total_excitatory_synapses_with_soma_HS.append(total_number_of_synapses[3])
            Total_inhibitory_synapses_with_soma_HS.append(total_number_of_synapses[4])
            # print(len(HS_segment_list), len(HS_segment_diam_list), len(HS_segment_distance_list), len(HS_number_of_excitatory_syn_list_with_soma), len(HS_number_of_inhibitory_syn_list_with_soma))
            df = pandas.DataFrame({'Segment_list': HS_segment_list, 'Diameter': np.array(HS_segment_diam_list),
                                   'Distance': np.array(HS_segment_distance_list), 'Number_excitatory_syn': np.array(
                    HS_number_of_excitatory_syn_list + HS_number_of_excitatory_syn_list_with_soma),
                                   'Number_inhibitory_syn': np.array(
                                       HS_number_of_inhibitory_syn_list + HS_number_of_inhibitory_syn_list_with_soma)})
            df.to_csv(just_name[0] + '_number_of_synapses.csv', index=False, encoding='utf-8')

            sum_of_excitatory, sum_of_inhibitory, distance_groups = summaries_for_barchart(just_name[0], HS_segment_distance_list,
                                                                                            HS_number_of_excitatory_syn_list + HS_number_of_excitatory_syn_list_with_soma,
                                                                                            HS_number_of_inhibitory_syn_list + HS_number_of_inhibitory_syn_list_with_soma)

            axs[i].bar(distance_groups, sum_of_excitatory, label="Excitatory", width=50, align='edge', edgecolor='k', color='r')
            axs[i].bar(distance_groups, sum_of_inhibitory, label="Inhibitory", width=50, align='edge', edgecolor='k', color='b')
            axs[i].set_ylim([0, 3000])
            #axs[i].set_xlabel('Distance (um)')
            #axs[i].set_ylabel('Num. syn')
            axs[i].spines['right'].set_visible(False)
            axs[i].spines['top'].set_visible(False) 
            cell_name = just_name[0].split('_')
            axs[i].set_title(cell_name[0] + '_' + cell_name[1], fontsize = 16)
            axs[i].tick_params(axis='both', which='major', labelsize=15)                                                                               


            synaptic_conductances_HS = calculate_conductances(HS_segment_list,
                                                              HS_number_of_excitatory_syn_list + HS_number_of_excitatory_syn_list_with_soma,
                                                              HS_number_of_inhibitory_syn_list + HS_number_of_inhibitory_syn_list_with_soma, just_name[0], syn_size_fact_exc, syn_size_fact_inhib)
            df2 = pandas.DataFrame({'Segment_list': HS_segment_list, 'gpa_all': synaptic_conductances_HS[0],
                                    'erev_all': synaptic_conductances_HS[1], 'total_excit': synaptic_conductances_HS[2],
                                    'total_inhib': synaptic_conductances_HS[3],
                                    'conductance_per_area_excit': synaptic_conductances_HS[4],
                                    'conductance_per_area_inhib': synaptic_conductances_HS[5],
                                    'gpas': synaptic_conductances_HS[6]})
            df2.to_csv(just_name[0] + '_conductances.csv', index=False, encoding='utf-8')

    #axs[3].legend(bbox_to_anchor=(1.0, 1.0), loc = 'upper left', frameon=False)
    axs[0].set_ylabel('Num. syn', fontsize = 16)
    axs[4].set_ylabel('Num. syn', fontsize = 16)
    axs[4].set_xlabel('Distance (um)', fontsize = 16)
    axs[5].set_xlabel('Distance (um)', fontsize = 16)
    axs[6].set_xlabel('Distance (um)', fontsize = 16)
    axs[7].set_xlabel('Distance (um)', fontsize = 16)
    axs[3].legend(frameon=False, fontsize = 14)           
    fig.savefig('num_syns_SUBPLOTS.svg')       

    return dendritic_arbor_length_HS, dendritic_arbor_length_OLM, Total_excitatory_synapses_HS, Total_excitatory_synapses_OLM, Total_inhibitory_synapses_HS, Total_inhibitory_synapses_OLM, Total_excitatory_synapses_with_soma_HS, Total_excitatory_synapses_with_soma_OLM, Total_inhibitory_synapses_with_soma_HS, Total_inhibitory_synapses_with_soma_OLM, synaptic_conductances_HS, synaptic_conductances_OLM


# Dotty plot making - we have the somas included!!!

total_database_for_plots = do_all_morphs(filenames)
df = pandas.DataFrame(
    {'dendritic_arbor_length_HS': total_database_for_plots[0], 'dendritic_arbor_length_OLM': total_database_for_plots[1],
     'Total_excitatory_synapses_HS': total_database_for_plots[6], \
     'Total_excitatory_synapses_OLM': total_database_for_plots[7], 'Total_inhibitory_synapses_HS': total_database_for_plots[8],
     'Total_inhibitory_synapses_OLM': total_database_for_plots[9]})

df.to_csv('Total_numbers.csv', index=False, encoding='utf-8')


def dotty_plot(total_data_for_plots):
    labels = ['OLM', 'HS']

    y1 = [total_data_for_plots[0], total_data_for_plots[1]]
    y2 = [total_data_for_plots[6], total_data_for_plots[7]]
    y3 = [total_data_for_plots[8], total_data_for_plots[9]]

    colors = ['green', 'limegreen', 'seagreen', 'darkolivegreen']
    colors2 = ['indigo', 'darkmagenta', 'darkviolet', 'mediumvioletred']
    morph_names_HS = ['HS_0731', 'HS_5091', 'HS_5101', 'HS_5102']
    morph_names_OLM = ['OLM_1811', 'OLM_1812', 'OLM_1821', 'OLM_1831']

    fig, axs = plt.subplots(1, 3, figsize=(3 * 4, 1 * 4))
    plt.subplots_adjust(wspace=0.7, hspace=0.8)

    axs[0].scatter([1] * len(y1[1]), y1[1], color=colors2, s = 150) # s - markersize
    axs[0].scatter([2] * len(y1[0]), y1[0], color=colors, s = 150)
    axs[0].set_xticks([1, 2])
    axs[0].set_xticklabels(['OLM', 'HS'])
    axs[0].set_ylabel('# Arbor length (um)', fontsize = 16)
    axs[0].margins(0.5)
    axs[0].spines['right'].set_visible(False)
    axs[0].spines['top'].set_visible(False)

    axs[1].scatter([1] * len(y2[1]), y2[1], color=colors2, s = 150)
    axs[1].scatter([2] * len(y2[0]), y2[0], color=colors, s = 150)
    axs[1].set_xticks([1, 2])
    axs[1].set_xticklabels(['OLM', 'HS'])
    axs[1].set_ylabel('# Number of excitatory synapses', fontsize = 16)
    axs[1].set_ylim(0, max(y2[0]) + 1000)
    axs[1].margins(0.5)
    axs[1].spines['right'].set_visible(False)
    axs[1].spines['top'].set_visible(False)

    for i, j in enumerate(y3[1]):
        axs[2].scatter(1, j, color=colors2[i], label=morph_names_OLM[i], s = 150)
    for i, j in enumerate(y3[0]):
        axs[2].scatter(2, j, color=colors[i], label=morph_names_HS[i], s = 150)


    axs[2].set_xticks([1, 2])
    axs[2].set_xticklabels(['OLM', 'HS'])
    axs[2].set_ylabel('# Number of inhibitory synapses', fontsize = 16)
    lgd = axs[2].legend(bbox_to_anchor=(1.05, 0), loc='lower left', frameon=False, fontsize = 14)
    axs[2].set_ylim(0, max(y3[0]) + 1000)
    axs[2].margins(0.5)
    axs[2].spines['right'].set_visible(False)
    axs[2].spines['top'].set_visible(False)
    plt.savefig('Cell_compare_statistics_with_soma.svg', bbox_extra_artists=(lgd,), bbox_inches='tight')


def current_plots(filenames):

    all_morph_data_for_plot = {}
    all_names = []
    
    fig, axs = plt.subplots(2, 4, sharex=True, sharey=True, figsize=(4 * 4, 2 * 4))
    axs = axs.flatten()
    
    for i, filename in enumerate(filenames):
        model_loading(source_dir, filename)
        just_name = filename.split(".")
        all_names.append(just_name[0])
        synapse_data = pandas.read_csv(just_name[0]+'_number_of_synapses.csv', header=None)
        conductance_data = pandas.read_csv(just_name[0] + '_conductances.csv', header=None)

        distances = np.array(synapse_data[2])
        distances = distances[1:]
        distances = distances.astype(float) # convert all elements to float

        gpa_all_list = np.array(conductance_data[1])
        gpa_all_list = gpa_all_list[1:]
        gpa_all_list = gpa_all_list.astype(float) # convert all elements to float       

        erev_all_list = np.array(conductance_data[2])
        erev_all_list = erev_all_list[1:]
        erev_all_list = erev_all_list.astype(float) # convert all elements to float

        excit_list = np.array(conductance_data[5])
        excit_list = excit_list[1:]
        excit_list = excit_list.astype(float) # convert all elements to float

        inhib_list = np.array(conductance_data[6])
        inhib_list = inhib_list[1:]
        inhib_list = inhib_list.astype(float) # convert all elements to float

        gpas_list = np.array(conductance_data[7])
        gpas_list = gpas_list[1:]
        gpas_list = gpas_list.astype(float) # convert all elements to float

        axs[i].plot(distances, gpa_all_list, 'o', color='orange', markeredgewidth = 0.0, alpha = 0.6)
        axs[i].plot(distances, excit_list, 'o', color='r', markeredgewidth = 0.0, alpha = 0.6)
        axs[i].plot(distances, inhib_list, 'o', color='b', markeredgewidth = 0.0, alpha = 0.6)
        axs[i].plot(distances, gpas_list, 'o', color='k', markeredgewidth = 0.0, alpha = 0.6)
        axs[i].spines['right'].set_visible(False)
        axs[i].spines['top'].set_visible(False)
        #plt.ylim(0, 0.12)
        #axs[i].set_xlabel('Distance (um)')
        #axs[i].set_ylabel('Conductance (nS/um2)')
        #cell_name = just_name[0].split('_')
        #axs[i].set_title(cell_name[0] + '_' + cell_name[1], fontsize = 16)
        axs[i].set_xticklabels(' ')
        axs[i].set_yticklabels(' ')
    plt.savefig('Conductances_subplots.png', transparent=True, dpi = 500)

    #plt.show()

def erev_plots(filenames):
    all_names = []

    fig, axs = plt.subplots(2, 4, sharex=True, sharey=True, figsize=(4 * 4, 2 * 4))
    axs = axs.flatten()

    colors = ['green', 'limegreen', 'seagreen', 'darkolivegreen']
    colors2 = ['indigo', 'darkmagenta', 'darkviolet', 'mediumvioletred']

    for i, filename in enumerate(filenames):
        model_loading(source_dir, filename)
        just_name = filename.split(".")
        all_names.append(just_name[0])
        synapse_data = pandas.read_csv(just_name[0] + '_number_of_synapses.csv', header=None)
        conductance_data = pandas.read_csv(just_name[0] + '_conductances.csv', header=None)
        print(just_name[0])
        distances = np.array(synapse_data[2])
        distances = distances[1:]
        distances = distances.astype(float)  # convert all elements to float

        erev_all_list = np.array(conductance_data[2])
        erev_all_list = erev_all_list[1:]
        erev_all_list = erev_all_list.astype(float)

        if just_name[0] == 'HS_0731_optimized':
            dot_color = colors[0]
        elif just_name[0] == 'HS_5091_optimized':
            dot_color = colors[1]
        elif just_name[0] == 'HS_5101_optimized':
            dot_color = colors[2]
        elif just_name[0] == 'HS_5102_optimized':
            dot_color = colors[3]
        elif just_name[0] == 'OLM_1811_optimized':
            dot_color = colors2[0]
        elif just_name[0] == 'OLM_1812_optimized':
            dot_color = colors2[1]
        elif just_name[0] == 'OLM_1821_optimized':
            dot_color = colors2[2]
        elif just_name[0] == 'OLM_1831_optimized':
            dot_color = colors2[3]


        axs[i].plot(distances, erev_all_list, 'o', color=dot_color, markeredgewidth = 0.0, alpha = 0.6)
        cell_name = just_name[0].split('_')
        axs[i].set_title(cell_name[0] + '_' + cell_name[1], fontsize = 16)
        axs[i].set_xlabel('Distance from soma', fontsize = 14)
        axs[i].set_ylabel('Reversal potential', fontsize = 14)

    plt.savefig('Erev vs. distance.svg')
    plt.savefig('Erev_vs_distance.png', transparent=True, dpi = 500)

#dotty_plot(total_database_for_plots)
#current_plots(filenames)
erev_plots(filenames)

def skewness_calculations(filenames):

    all_names = []
    skewness_of_excit_list = []
    skewness_of_inhib_list = []


    for i, filename in enumerate(filenames):
        model_loading(source_dir, filename)
        just_name = filename.split(".")
        all_names.append(just_name[0])
        synapse_data = pandas.read_csv(just_name[0]+'_number_of_synapses.csv', header=None)

        #Beolvasas

        distances = np.array(synapse_data[2])
        distances = distances[1:]
        distances = distances.astype(float) # convert all elements to float

        excit_syn_num = np.array(synapse_data[3])
        excit_syn_num = excit_syn_num[1:]
        excit_syn_num = excit_syn_num.astype(float) # convert all elements to float

        inhib_syn_num = np.array(synapse_data[4])
        inhib_syn_num = inhib_syn_num[1:]
        inhib_syn_num = inhib_syn_num.astype(float) # convert all elements to float

        #Sorting - alapvetoen nem a distance szerinti növekvo sorrendben van, ez utan mar abban lesz

        distances_inds = distances.argsort()
        sorted_distances = distances[distances_inds]
        sorted_excit_syns = excit_syn_num[distances_inds]
        sorted_inhib_syns = inhib_syn_num[distances_inds]

        #Feldolgozas

        numbers_at_distances_excit = np.array([])
        numbers_at_distances_inhib = np.array([])

        #Fel kell kerekiteni
        for u in range(len(sorted_distances)):
            sorted_excit_syns[u] = np.rint(sorted_excit_syns[u])
            sorted_inhib_syns[u] = np.rint(sorted_inhib_syns[u])


            numbers_at_distances_excit = np.append(numbers_at_distances_excit, np.repeat(sorted_distances[u], sorted_excit_syns[u]))
            numbers_at_distances_inhib = np.append(numbers_at_distances_inhib, np.repeat(sorted_distances[u], sorted_inhib_syns[u]))

        #Skewness szamolas

        skewness_of_excit = stats.skew(numbers_at_distances_excit)
        skewness_of_excit_list.append(skewness_of_excit)
        skewness_of_inhib = stats.skew(numbers_at_distances_inhib)
        skewness_of_inhib_list.append(skewness_of_inhib)


    df3 = pandas.DataFrame({'Model name': all_names, 'Skewness of excitatory input': skewness_of_excit_list, 'Skewness of inhibitory input': skewness_of_inhib_list})
    df3.to_csv('Skewness_all_models.csv', index=False, encoding='utf-8')
    #print(numbers_at_distances_excit)

def ttest_for_skewness(filename):

    skewness_HS = pandas.read_csv(filename, header=None, skiprows = range(1,5), nrows=5)
    skewness_OLM = pandas.read_csv(filename, header=None, nrows = 5)

    skewness_excit_HS = np.array(skewness_HS[1])
    skewness_excit_HS = skewness_excit_HS[1:]
    skewness_excit_HS = skewness_excit_HS.astype(float)
    skewness_inhib_HS = np.array(skewness_HS[2])
    skewness_inhib_HS = skewness_inhib_HS[1:]
    skewness_inhib_HS = skewness_inhib_HS.astype(float)

    skewness_excit_OLM = np.array(skewness_OLM[1])
    skewness_excit_OLM = skewness_excit_OLM[1:]
    skewness_excit_OLM = skewness_excit_OLM.astype(float)
    skewness_inhib_OLM = np.array(skewness_OLM[2])
    skewness_inhib_OLM = skewness_inhib_OLM[1:]
    skewness_inhib_OLM = skewness_inhib_OLM.astype(float)

    T_skewness_excit = stats.ttest_ind(skewness_excit_HS, skewness_excit_OLM)
    T_skewness_inhib = stats.ttest_ind(skewness_inhib_HS, skewness_inhib_OLM)

    print(T_skewness_excit, T_skewness_inhib)


def ttest_for_total_numbers(total_data_for_plots):

    arbor_length_HS = total_data_for_plots[0]
    arbor_length_OLM = total_data_for_plots[1]
    Excit_syn_number_HS = total_data_for_plots[6]
    Excit_syn_number_OLM = total_data_for_plots[7]
    Inhib_syn_number_HS = total_data_for_plots[8]
    Inhib_syn_number_OLM = total_data_for_plots[9]

    T_arbor = stats.ttest_ind(arbor_length_HS, arbor_length_OLM)
    T_excit = stats.ttest_ind(Excit_syn_number_HS, Excit_syn_number_OLM)
    T_inhib = stats.ttest_ind(Inhib_syn_number_HS, Inhib_syn_number_OLM)

    print(T_arbor, T_excit, T_inhib)


#skewness_calculations(filenames)
#ttest_for_total_numbers(total_database_for_plots)
#ttest_for_skewness('Skewness_all_models.csv')
