clear all;
close all;

% HS and OLM soma data - sizes and numbers are given with number/um2 soma surface area
% these are partially reconstructed somas!

HS_soma_volume = [758.739, 818.995, 384.678];
HS_soma_area = [319.898, 374.104, 148.614];
HS_soma_gneg_num = [0.435, 0.243, 0.579];
HS_soma_gpos_num = [0.197, 0.160, 0.141];
HS_soma_gneg_size = [0.074, 0.067, 0.087];
HS_soma_gpos_size = [0.053, 0.043, 0.038];


OLM_soma_volume = [726.090, 929.938, 695.857, 873.187];
OLM_soma_area = [327.241, 581.339, 281.689, 371.443];
OLM_soma_gneg_num = [0.333, 0.177, 0.217, 0.188];
OLM_soma_gpos_num = [0.083, 0.015, 0.025, 0.024];
OLM_soma_gneg_size = [0.097, 0.041, 0.059, 0.047];
OLM_soma_gpos_size = [0.072, 0.031, 0.022, 0.014];

HS_gneg_density = HS_soma_gneg_num.*HS_soma_area;
avg_HS_gneg_density = mean(HS_gneg_density)
HS_gpos_density = HS_soma_gpos_num.*HS_soma_area;
avg_HS_gpos_density = mean(HS_gpos_density)
OLM_gneg_density = OLM_soma_gneg_num.*OLM_soma_area;
avg_OLM_gneg_density = mean(OLM_gneg_density)
OLM_gpos_density = OLM_soma_gpos_num.*OLM_soma_area;
avg_OLM_gpos_density = mean(OLM_gpos_density)

%% Fitting

hs_area_gneg_num = fitlm(HS_soma_area, HS_soma_gneg_num);
hs_area_gpos_num = fitlm(HS_soma_area, HS_soma_gpos_num);
hs_area_gneg_size = fitlm(HS_soma_area, HS_soma_gneg_size);
hs_area_gpos_size = fitlm(HS_soma_area, HS_soma_gpos_size);

hs_volume_gneg_num = fitlm(HS_soma_volume, HS_soma_gneg_num);
hs_volume_gpos_num = fitlm(HS_soma_volume, HS_soma_gpos_num);
hs_volume_gneg_size = fitlm(HS_soma_volume, HS_soma_gneg_size);
hs_volume_gpos_size = fitlm(HS_soma_volume, HS_soma_gpos_size);

olm_area_gneg_num = fitlm(OLM_soma_area, OLM_soma_gneg_num);
olm_area_gpos_num = fitlm(OLM_soma_area, OLM_soma_gpos_num);
olm_area_gneg_size = fitlm(OLM_soma_area, OLM_soma_gneg_size);
olm_area_gpos_size = fitlm(OLM_soma_area, OLM_soma_gpos_size);

olm_volume_gneg_num = fitlm(OLM_soma_volume, OLM_soma_gneg_num);
olm_volume_gpos_num = fitlm(OLM_soma_volume, OLM_soma_gpos_num);
olm_volume_gneg_size = fitlm(OLM_soma_volume, OLM_soma_gneg_size);
olm_volume_gpos_size = fitlm(OLM_soma_volume, OLM_soma_gpos_size);

%% Spearman

[rho_area_num_gneg_HS, pval_area_num_gneg_HS]= corr(HS_soma_area', HS_soma_gneg_num','rows','pairwise','Type','Spearman');
[rho_area_num_gpos_HS, pval_area_num_gpos_HS]= corr(HS_soma_area', HS_soma_gpos_num','rows','pairwise','Type','Spearman');

[rho_volume_num_gneg_HS, pval_volume_num_gneg_HS]= corr(HS_soma_volume', HS_soma_gneg_num','rows','pairwise','Type','Spearman');
[rho_volume_num_gpos_HS, pval_volume_num_gpos_HS]= corr(HS_soma_volume', HS_soma_gpos_num','rows','pairwise','Type','Spearman');

[rho_area_size_gneg_HS, pval_area_size_gneg_HS]= corr(HS_soma_area', HS_soma_gneg_size','rows','pairwise','Type','Spearman');
[rho_area_size_gpos_HS, pval_area_size_gpos_HS]= corr(HS_soma_area', HS_soma_gpos_size','rows','pairwise','Type','Spearman');

[rho_volume_size_gneg_HS, pval_volume_size_gneg_HS]= corr(HS_soma_volume', HS_soma_gneg_size','rows','pairwise','Type','Spearman');
[rho_volume_size_gpos_HS, pval_volume_size_gpos_HS]= corr(HS_soma_volume', HS_soma_gpos_size','rows','pairwise','Type','Spearman');


[rho_area_num_gneg_OLM, pval_area_num_gneg_OLM]= corr(OLM_soma_area', OLM_soma_gneg_num','rows','pairwise','Type','Spearman');
[rho_area_num_gpos_OLM, pval_area_num_gpos_OLM]= corr(OLM_soma_area', OLM_soma_gpos_num','rows','pairwise','Type','Spearman');

[rho_volume_num_gneg_OLM, pval_volume_num_gneg_OLM]= corr(OLM_soma_volume', OLM_soma_gneg_num','rows','pairwise','Type','Spearman');
[rho_volume_num_gpos_OLM, pval_volume_num_gpos_OLM]= corr(OLM_soma_volume', OLM_soma_gpos_num','rows','pairwise','Type','Spearman');

[rho_area_size_gneg_OLM, pval_area_size_gneg_OLM]= corr(OLM_soma_area', OLM_soma_gneg_size','rows','pairwise','Type','Spearman');
[rho_area_size_gpos_OLM, pval_area_size_gpos_OLM]= corr(OLM_soma_area', OLM_soma_gpos_size','rows','pairwise','Type','Spearman');

[rho_volume_size_gneg_OLM, pval_volume_size_gneg_OLM]= corr(OLM_soma_volume', OLM_soma_gneg_size','rows','pairwise','Type','Spearman');
[rho_volume_size_gpos_OLM, pval_volume_size_gpos_OLM]= corr(OLM_soma_volume', OLM_soma_gpos_size','rows','pairwise','Type','Spearman');

%% Plotting

figure(1)
hold on;
scatter(HS_soma_area, HS_soma_gneg_num, 'ob', 'filled');
scatter(OLM_soma_area, OLM_soma_gneg_num, 'og', 'filled');
title('Number of gneg synapses vs. Soma area')
legend('Gneg HS','Gneg OLM');
xlabel('Area')
ylabel('Number of synapses / um2 soma')
xlim([0 max(OLM_soma_area)+10])
ylim([0 max(HS_soma_gneg_num)+0.1])
txt=['R^2 gns HS:' num2str(hs_area_gneg_num.Rsquared.Ordinary)];
txt2 = ['R^2 gns OLM:' num2str(olm_area_gneg_num.Rsquared.Ordinary)];
txt3 = ['rho HS:' num2str(rho_area_num_gneg_HS)];
txt4 = ['pval HS:' num2str(pval_area_num_gneg_HS)];
txt5 = ['rho OLM:' num2str(rho_area_num_gneg_OLM)];
txt6 = ['pval OLM:' num2str(pval_area_num_gneg_OLM)];
text(450,0.5,txt)
text(450,0.45,txt2)
text(450,0.4,txt3)
text(450,0.35,txt4)
text(450,0.3,txt5)
text(450,0.25,txt6)

figure(2)
hold on;
scatter(HS_soma_area, HS_soma_gpos_num, 'ob', 'filled');
scatter(OLM_soma_area, OLM_soma_gpos_num, 'og', 'filled');
title('Number of gpos synapses vs. Soma area')
legend('Gpos HS','Gpos OLM');
xlabel('Area')
ylabel('Number of synapses / um2 soma')
xlim([0 max(OLM_soma_area)+10])
ylim([0 max(HS_soma_gpos_num)+0.1])
txt7=['R^2 gns HS:' num2str(hs_area_gpos_num.Rsquared.Ordinary)];
txt8 = ['R^2 gns OLM:' num2str(olm_area_gpos_num.Rsquared.Ordinary)];
txt9 = ['rho HS:' num2str(rho_area_num_gpos_HS)];
txt10 = ['pval HS:' num2str(pval_area_num_gpos_HS)];
txt11 = ['rho OLM:' num2str(rho_area_num_gpos_OLM)];
txt12 = ['pval OLM:' num2str(pval_area_num_gpos_OLM)];
text(450,0.2,txt7)
text(450,0.18,txt8)
text(450,0.16,txt9)
text(450,0.14,txt10)
text(450,0.12,txt11)
text(450,0.1,txt12)

figure(3)
hold on;
scatter(HS_soma_area, HS_soma_gneg_size, 'ob', 'filled');
scatter(OLM_soma_area, OLM_soma_gneg_size, 'og', 'filled');
title('Size of gneg synapses vs. Soma area')
legend('Gneg HS','Gneg OLM');
xlabel('Area')
ylabel('Size of synapses / um2 soma')
xlim([0 max(OLM_soma_area)+10])
ylim([0 max(HS_soma_gneg_size)+0.1])
txt13=['R^2 gns HS:' num2str(hs_area_gneg_size.Rsquared.Ordinary)];
txt14 = ['R^2 gns OLM:' num2str(olm_area_gneg_size.Rsquared.Ordinary)];
txt15 = ['rho HS:' num2str(rho_area_size_gneg_HS)];
txt16 = ['pval HS:' num2str(pval_area_size_gneg_HS)];
txt17 = ['rho OLM:' num2str(rho_area_size_gneg_OLM)];
txt18 = ['pval OLM:' num2str(pval_area_size_gneg_OLM)];
text(450,0.14,txt13)
text(450,0.13,txt14)
text(450,0.12,txt15)
text(450,0.11,txt16)
text(450,0.1,txt17)
text(450,0.09,txt18)

figure(4)
hold on;
scatter(HS_soma_area, HS_soma_gpos_size, 'ob', 'filled');
scatter(OLM_soma_area, OLM_soma_gpos_size, 'og', 'filled');
title('Size of gpos synapses vs. Soma area')
legend('Gpos HS','Gpos OLM');
xlabel('Area')
ylabel('Size of synapses / um2 soma')
xlim([0 max(OLM_soma_area)+10])
ylim([0 max(HS_soma_gpos_size)+0.1])
txt19=['R^2 gns HS:' num2str(hs_area_gpos_size.Rsquared.Ordinary)];
txt20 = ['R^2 gns OLM:' num2str(olm_area_gpos_size.Rsquared.Ordinary)];
txt21 = ['rho HS:' num2str(rho_area_size_gpos_HS)];
txt22 = ['pval HS:' num2str(pval_area_size_gpos_HS)];
txt23 = ['rho OLM:' num2str(rho_area_size_gpos_OLM)];
txt24 = ['pval OLM:' num2str(pval_area_size_gpos_OLM)];
text(450,0.12,txt19)
text(450,0.11,txt20)
text(450,0.1,txt21)
text(450,0.09,txt22)
text(450,0.08,txt23)
text(450,0.07,txt24)

%%

figure(5)
hold on;
scatter(HS_soma_volume, HS_soma_gneg_num, 'ob', 'filled');
scatter(OLM_soma_volume, OLM_soma_gneg_num, 'og', 'filled');
title('Number of gneg synapses vs. Soma volume')
legend('Gneg HS','Gneg OLM');
xlabel('Volume')
ylabel('Number of synapses / um3 soma')
xlim([0 max(OLM_soma_volume)+10])
ylim([0 max(HS_soma_gneg_num)+0.1])
txt25=['R^2 gns HS:' num2str(hs_volume_gneg_num.Rsquared.Ordinary)];
txt26 = ['R^2 gns OLM:' num2str(olm_volume_gneg_num.Rsquared.Ordinary)];
txt27 = ['rho HS:' num2str(rho_volume_num_gneg_HS)];
txt28 = ['pval HS:' num2str(pval_volume_num_gneg_HS)];
txt29 = ['rho OLM:' num2str(rho_volume_num_gneg_OLM)];
txt30 = ['pval OLM:' num2str(pval_volume_num_gneg_OLM)];
text(800,0.5,txt25)
text(800,0.45,txt26)
text(800,0.4,txt27)
text(800,0.35,txt28)
text(800,0.3,txt29)
text(800,0.25,txt30)

figure(6)
hold on;
scatter(HS_soma_volume, HS_soma_gpos_num, 'ob', 'filled');
scatter(OLM_soma_volume, OLM_soma_gpos_num, 'og', 'filled');
title('Number of gpos synapses vs. Soma volume')
legend('Gpos HS','Gpos OLM');
xlabel('Volume')
ylabel('Number of synapses / um3 soma')
xlim([0 max(OLM_soma_volume)+10])
ylim([0 max(HS_soma_gpos_num)+0.1])
txt31=['R^2 gns HS:' num2str(hs_volume_gpos_num.Rsquared.Ordinary)];
txt32 = ['R^2 gns OLM:' num2str(olm_volume_gpos_num.Rsquared.Ordinary)];
txt33 = ['rho HS:' num2str(rho_volume_num_gpos_HS)];
txt34 = ['pval HS:' num2str(pval_volume_num_gpos_HS)];
txt35 = ['rho OLM:' num2str(rho_volume_num_gpos_OLM)];
txt36 = ['pval OLM:' num2str(pval_volume_num_gpos_OLM)];
text(800,0.2,txt31)
text(800,0.18,txt32)
text(800,0.16,txt33)
text(800,0.14,txt34)
text(800,0.12,txt35)
text(800,0.1,txt36)

figure(7)
hold on;
scatter(HS_soma_volume, HS_soma_gneg_size, 'ob', 'filled');
scatter(OLM_soma_volume, OLM_soma_gneg_size, 'og', 'filled');
title('Size of gneg synapses vs. Soma volume')
legend('Gneg HS','Gneg OLM');
xlabel('Volume')
ylabel('Size of synapses / um3 soma')
xlim([0 max(OLM_soma_volume)+10])
ylim([0 max(HS_soma_gneg_size)+0.1])
txt37=['R^2 gns HS:' num2str(hs_volume_gneg_size.Rsquared.Ordinary)];
txt38 = ['R^2 gns OLM:' num2str(olm_volume_gneg_size.Rsquared.Ordinary)];
txt39 = ['rho HS:' num2str(rho_volume_size_gneg_HS)];
txt40 = ['pval HS:' num2str(pval_volume_size_gneg_HS)];
txt41 = ['rho OLM:' num2str(rho_volume_size_gneg_OLM)];
txt42 = ['pval OLM:' num2str(pval_volume_size_gneg_OLM)];
text(800,0.14,txt37)
text(800,0.13,txt38)
text(800,0.12,txt39)
text(800,0.11,txt40)
text(800,0.1,txt41)
text(800,0.09,txt42)

figure(8)
hold on;
scatter(HS_soma_volume, HS_soma_gpos_size, 'ob', 'filled');
scatter(OLM_soma_volume, OLM_soma_gpos_size, 'og', 'filled');
title('Size of gpos synapses vs. Soma volume')
legend('Gpos HS','Gpos OLM');
xlabel('Volume')
ylabel('Size of synapses / um3 soma')
xlim([0 max(OLM_soma_area)+10])
ylim([0 max(HS_soma_gpos_size)+0.1])
txt43=['R^2 gns HS:' num2str(hs_volume_gpos_size.Rsquared.Ordinary)];
txt44 = ['R^2 gns OLM:' num2str(olm_volume_gpos_size.Rsquared.Ordinary)];
txt45 = ['rho HS:' num2str(rho_volume_size_gpos_HS)];
txt46 = ['pval HS:' num2str(pval_volume_size_gpos_HS)];
txt47 = ['rho OLM:' num2str(rho_volume_size_gpos_OLM)];
txt48 = ['pval OLM:' num2str(pval_volume_size_gpos_OLM)];
text(800,0.12,txt43)
text(800,0.11,txt44)
text(800,0.1,txt45)
text(800,0.09,txt46)
text(800,0.08,txt47)
text(800,0.07,txt48)