%% Data HS

length_of_segments_HS = [20.11, 4.60, 11.09, 8.36, 6.88, 4.05, 12.77, 8.18, 2.19, 5.72, 10.05, 10.27, 2.62,...
3.13, 5.35, 12.07, 16.37, 13.53, 17.52, 14.83, 22.49, 20.96, 18.86, 23.93, 30.65, 8.09, 2.41, 7.41, 13.22,...
8.40, 10.45, 34.65, 27.54, 14.08, 18.27, 26.67, 6.09];

distance_from_soma_HS = [166.00, 187.00, 187.00, 406.00, 200.70, 208.00, 208.00, 200.00, 200.00, 207.00, 215.80,...
58.30, 5.30, 13.30, 13.30, 38.40, 10.00, 179.40, 149.60, 226.70, 199.40, 215.70, 60.00, 70.00, 104.90, 43.10,...
52.40, 52.40, 285.90, 304.40, 304.40, 259.00, 308.00, 33.00, 113.70, 135.90, 127.30];

dendritic_order_HS = [3, 4, 4, 4, 3, 4, 4, 4, 4, 5, 5, 2, 1, 2, 2, 2, 2, 4, 5, 4, 3, 5, 2, 2, 4, 1, 2, 2, 5, 6, 6, 4, 5, 2, 7, 9, 8];

dendrite_volume_HS = [1.785, 0.777, 0.930, 1.847, 2.912, 0.640, 2.344, 0.576, 1.869, 0.822, 1.779, 2.755, 2.772, 0.860,...
3.340, 1.564, 0.855, 1.297, 0.940, 0.608, 0.595, 0.624, 2.387, 1.228, 0.606, 2.544, 2.282, 0.941, 0.676, 0.358, 0.459,...
0.347, 0.429, 2.177, 1.194, 0.986, 1.642];

surface_area_HS = [7.381, 4.561, 5.162, 7.495, 9.611, 3.689, 7.697, 3.811, 7.329, 4.133, 7.484, 8.064, 6.991, 3.528,...
7.234, 6.561, 4.800, 6.513, 5.082, 4.886, 4.190, 4.202, 7.219, 4.958, 3.913, 6.884, 7.584, 3.926, 3.953, 2.530,...
3.061, 2.566, 3.939, 6.415, 5.059, 4.898, 6.897];

perimeter_HS = [5.878, 3.613, 4.151, 5.857, 6.709, 3.343, 6.210, 3.233, 5.426, 3.733, 5.550, 6.521, 6.350, 3.673, 6.636,...
5.343, 4.177, 5.016, 4.370, 3.574, 3.575, 3.315, 6.413, 4.371, 3.100, 6.534, 6.077, 3.389, 3.288, 2.285, 2.770,...
2.180, 2.665, 5.821, 4.287, 4.071, 5.403];

neurolucida_diam_HS = [1.200, 0.800, 1.100, 0.400, 1.200, 0.800, 1.200, 0.900, 1.100, 1.000, 1.000, 1.500, 1.600, 1.000,...
1.600, 1.300, NaN, 1.300, 0.800, 0.700, 0.700, 0.900, 1.600, 1.100, 0.700, 1.300, 1.300, 1.300, 0.700, 0.500, 0.700,...
0.500, 0.600, 1.600, 0.800, 0.900, 1.100];

number_gneg_syn_HS = [5.918, 3.482, 5.319, NaN, 8.719, 2.223, 5.795, 2.200, 3.658, 2.796, 6.965, 8.669, 4.206, 2.877,...
4.676, 5.303, NaN, 5.615, 3.767, 2.495, 2.579, 3.339, 7.369, 4.721, 2.154, 5.190, 4.981, 3.914, 2.344, 1.787,...
1.722, 1.356, 3.304, 5.112, 5.199, 4.349, 5.582];

gneg_syn_size_per_length_HS = [0.796, 0.812, 0.544, NaN, 1.055, 0.445, 1.089, 0.759, 0.604, 0.652, 0.940, 1.682,...
0.536, 0.448, 0.621, 1.161, NaN, 1.005, 0.746, 0.431, 0.404, 0.410, 1.253, 0.947, 0.329, 0.990, 1.246, 0.722,...
0.350, 0.241, 0.308, 0.217, 0.358, 0.675, 0.747, 0.574, 0.867];

gneg_syn_size_per_area_HS = [0.108, 0.178, 0.105, NaN, 0.110, 0.121, 0.142, 0.199, 0.082, 0.158, 0.126, 0.209,...
0.077, 0.127, 0.086, 0.177, NaN, 0.154, 0.147, 0.088, 0.096, 0.097, 0.174, 0.191, 0.084, 0.144, 0.164, 0.184,...
0.089, 0.095, 0.101, 0.085, 0.091, 0.105, 0.148, 0.117, 0.126];

number_gpos_syn_HS = [0.995, 0.435, 0.811, NaN, 1.453, 1.235, 0.626, 0.489, 1.372, 0.524, 1.293, 1.266, 0.765, 0.959,...
2.992, 1.492, NaN, 0.443, 0.571, 0.405, 0.534, 0.429, 1.007, 0.543, 0.522, 1.359, 1.660, 0.405, 0.832, 0.834,...
0.096, 0.144, 0.762, 0.994, 0.547, 0.375, 1.149];

gpos_syn_size_per_length_HS = [0.166, 0.082, 0.123, NaN, 0.242, 0.206, 0.112, 0.161, 0.311, 0.174, 0.259, 0.201,...
0.148, 0.629, 0.471, 0.344, NaN, 0.130, 0.185, 0.081, 0.118, 0.080, 0.191, 0.118, 0.099, 0.258, 0.225, 0.034,...
0.138, 0.191, 0.037, 0.035, 0.124, 0.164, 0.095, 0.089, 0.177];

gpos_syn_size_per_area_HS = [0.022, 0.018, 0.024, NaN, 0.025, 0.056, 0.015, 0.042, 0.042, 0.042, 0.035, 0.025,...
0.021, 0.178, 0.065, 0.052, NaN, 0.020, 0.036, 0.017, 0.028, 0.019, 0.026, 0.024, 0.025, 0.037, 0.030, 0.009,...
0.035, 0.075, 0.012, 0.014, 0.031, 0.026, 0.019, 0.018, 0.026];
    

dendrite_volume_without_mito_HS = [1.570, 0.692, 0.807, 1.621, 2.703, 0.542, 2.144, 0.514, 1.791, 0.700, 1.614, ...
2.529, 2.600, 0.715, 2.933, 1.384, 0.746, 1.171, 0.833, 0.535, 0.484, 0.523, 2.182, 1.077, 0.503, 2.304, 2.005, ...
0.859, 0.580, 0.305, 0.385, 0.266, 0.259, 2.006, 1.081, 0.931, 1.421,];

volume_ratio_HS = dendrite_volume_HS ./ dendrite_volume_without_mito_HS;
mean_volume_ratio_HS = mean(volume_ratio_HS);

diameter_from_volume_HS = sqrt(4.*dendrite_volume_HS./pi);
diameter_from_area_HS = (surface_area_HS ./ pi);
diameter_from_perimeter_HS = (perimeter_HS ./pi);


hs_diameter_table = 'hs_diams.xlsx';
writematrix(diameter_from_volume_HS', hs_diameter_table,'Sheet',1,'Range','B2');
writematrix(diameter_from_area_HS', hs_diameter_table ,'Sheet',1,'Range','C2');
writematrix(diameter_from_perimeter_HS', hs_diameter_table ,'Sheet',1,'Range','D2');
writematrix(distance_from_soma_HS', hs_diameter_table ,'Sheet',1,'Range','E2');
writematrix(dendritic_order_HS', hs_diameter_table ,'Sheet',1,'Range','F2');

cell_ids_HS = [141, 141, 141, 141, 141, 141, 141, 141, 141, 141, 141, 141, 141, 141, 141, 141, 111, 131,... 
    131, 131, 131, 131, 131, 131, 131, 131, 131, 131, 133, 133, 133, 132, 181, 181, 181, 181, 181];

HS_cell1_diams = diameter_from_volume_HS(1:16);
HS_cell2_diams = diameter_from_volume_HS(17);
HS_cell3_diams = diameter_from_volume_HS(18:28);
HS_cell4_diams = diameter_from_volume_HS(29:31);
HS_cell5_diams = diameter_from_volume_HS(32);
HS_cell6_diams = diameter_from_volume_HS(33:37);

%% Branching points

bp_dist_HS = [187.00, 204.00, 20.00, 52.00, 304.00, 127.00, 136.00];
bp_order_HS = [3, 3, 1, 1, 5, 7, 8];
bp_volume_HS = [5.349, 5.936, 19.858, 5.906, 2.516, 1.035, 0.697];
bp_area_HS = [25.319, 16.627, 43.668, 20.742, 13.424, 5.813, 5.055];
bp_gneg_syn_number_per_area_HS = [0.869, 0.842, 0.595, 0.627, 0.521, 2.924, 2.770];
bp_gneg_syn_size_per_area_HS = [0.188, 0.168, 0.128, 0.274, 0.163, 0.212, 0.259];
bp_gpos_syn_number_per_area_HS = [0.079, 0.060, 0.115, 0.096, 0.149, 0.516, 0.396];
bp_gpos_syn_size_per_area_HS = [0.079, 0.004, 0.044, 0.088, 0.019, 0.051, 0.044];

bp_dist_OLM = [180.00, 11.00, 28.00, 202.30, 19.60, 27.90, 155.90, 6.00, 34.20, 396.00, 410.90];
bp_order_OLM = [2, 1, 2, 6, 1, 2, 3, 1, 1, 6, 7];
bp_volume_OLM = [8.934, 16.890, 15.834, 3.396, 6.512, 4.136, 1.454, 14.861, 5.376, 7.957, 3.347];
bp_area_OLM = [23.339, 37.062, 41.370, 19.376, 22.315, 17.293, 16.474, 47.130, 22.278, 43.043, 24.492];
bp_gneg_syn_number_per_area_OLM = [0.600, 0.405, 0.290, 0.103, 0.358, 0.463, 0.607, 0.467, 0.224, 0.372, 0.490];
bp_gneg_syn_size_per_area_OLM = [0.290, 0.096, 0.064, 0.053, 0.070, 0.145, 0.186, 0.141, 0.065, 0.141, 0.198];
bp_gpos_syn_number_per_area_OLM = [0.043, 0.054, 0.169, 0.052, 0.134, 0.116, 0.000, 0.170, 0.180, 0.070, 0.041];
bp_gpos_syn_size_per_area_OLM = [0.023, 0.043, 0.084, 0.057, 0.075, 0.028, 0.000, 0.044, 0.066, 0.009, 0.018];

%% Fitting - HS

dist_dfv_HS = fitlm(distance_from_soma_HS, diameter_from_volume_HS);
dist_dfa_HS = fitlm(distance_from_soma_HS, diameter_from_area_HS);
dist_dfp_HS = fitlm(distance_from_soma_HS, diameter_from_perimeter_HS);
dist_neuroluc_HS = fitlm(distance_from_soma_HS, neurolucida_diam_HS);

order_dfv_HS = fitlm(dendritic_order_HS, diameter_from_volume_HS);
order_dfa_HS = fitlm(dendritic_order_HS, diameter_from_area_HS);
order_dfp_HS = fitlm(dendritic_order_HS, diameter_from_perimeter_HS);
order_neuroluc_HS = fitlm(dendritic_order_HS, neurolucida_diam_HS);

neuroluc_dfv_HS = fitlm(neurolucida_diam_HS, diameter_from_volume_HS);
neuroluc_dfa_HS = fitlm(neurolucida_diam_HS, diameter_from_area_HS);
neuroluc_dfp_HS = fitlm(neurolucida_diam_HS, diameter_from_perimeter_HS);

filter_nans_HS = isnan(neurolucida_diam_HS);
filter_for_others_HS = ~filter_nans_HS;
filtered_diam_HS = diameter_from_volume_HS(filter_for_others_HS);
filtered_diam_a_HS = diameter_from_area_HS(filter_for_others_HS);
filtered_diam_p_HS = diameter_from_perimeter_HS(filter_for_others_HS);
filtered_neuroluc_HS = neurolucida_diam_HS(filter_for_others_HS);

% r_square_1 = 1 - (sum((diameter_from_volume-neurolucida_diam).^2, 'omitnan')/sum((diameter_from_volume-mean(diameter_from_volume)).^2, 'omitnan'))
% r_square_2 = 1 - (sum((diameter_from_area-neurolucida_diam).^2, 'omitnan')/sum((diameter_from_area-mean(diameter_from_area)).^2, 'omitnan'));
% r_square_3 = 1 - (sum((diameter_from_perimeter-neurolucida_diam).^2, 'omitnan')/sum((diameter_from_perimeter-mean(diameter_from_perimeter)).^2, 'omitnan'));


r_square_1b_HS = 1 - (sum((filtered_diam_HS-filtered_neuroluc_HS).^2, 'omitnan')/sum((filtered_diam_HS-mean(filtered_diam_HS)).^2, 'omitnan'));
r_square_2b_HS = 1 - (sum((filtered_diam_a_HS-filtered_neuroluc_HS).^2, 'omitnan')/sum((filtered_diam_a_HS-mean(filtered_diam_a_HS)).^2, 'omitnan'));
r_square_3b_HS = 1 - (sum((filtered_diam_p_HS-filtered_neuroluc_HS).^2, 'omitnan')/sum((filtered_diam_p_HS-mean(filtered_diam_p_HS)).^2, 'omitnan'));

volume_area_HS = fitlm(diameter_from_volume_HS, diameter_from_area_HS);
volume_perim_HS = fitlm(diameter_from_volume_HS, diameter_from_perimeter_HS);
area_perim_HS =fitlm(diameter_from_area_HS, diameter_from_perimeter_HS);

dfs_ngns_HS = fitlm(distance_from_soma_HS, number_gneg_syn_HS);
dfs_ngps_HS = fitlm(distance_from_soma_HS, number_gpos_syn_HS);

do_ngns_HS = fitlm(dendritic_order_HS, number_gneg_syn_HS);
do_ngps_HS = fitlm(dendritic_order_HS, number_gpos_syn_HS);

diam_ngns_HS = fitlm(diameter_from_volume_HS, number_gneg_syn_HS);
diam_ngps_HS = fitlm(diameter_from_volume_HS, number_gpos_syn_HS);

dfs_gnsl_HS = fitlm(distance_from_soma_HS, gneg_syn_size_per_length_HS);
dfs_gpsl_HS = fitlm(distance_from_soma_HS, gpos_syn_size_per_length_HS);

do_gnsl_HS = fitlm(dendritic_order_HS, gneg_syn_size_per_length_HS);
do_gpsl_HS = fitlm(dendritic_order_HS, gpos_syn_size_per_length_HS);

diam_gnsl_HS = fitlm(diameter_from_volume_HS, gneg_syn_size_per_length_HS);
diam_gpsl_HS = fitlm(diameter_from_volume_HS, gpos_syn_size_per_length_HS);

dfs_gnsa_HS = fitlm(distance_from_soma_HS, gneg_syn_size_per_area_HS)
dfs_gpsa_HS = fitlm(distance_from_soma_HS, gpos_syn_size_per_area_HS)

do_gnsa_HS = fitlm(dendritic_order_HS, gneg_syn_size_per_area_HS)
do_gpsa_HS = fitlm(dendritic_order_HS, gpos_syn_size_per_area_HS)

diam_gnsa_HS = fitlm(diameter_from_volume_HS, gneg_syn_size_per_area_HS)
diam_gpsa_HS = fitlm(diameter_from_volume_HS, gpos_syn_size_per_area_HS)



%% Data - OLM

length_of_segments_OLM = [5.97, 2.70, 1.07, 1.93, 38.07, 5.17, 23.75, 10.16, 10.24, 15.38, 2.99, 9.27, 14.46,...
21.02, 24.48, 21.74, 18.33, 6.24, 6.16, 45.54, 5.60, 4.87, 18.57, 19.94, 27.74, 1.90, 3.96, 10.99, 33.54, 36.95,...
47.75, 15.19, 3.23, 8.92, 15.26, 22.67, 42.39, 36.38, 26.88, 24.62, 21.17, 4.71, 15.66, 28.32, 57.28, 35.95, 59.16,...
3.45, 5.15, 16.64, 15.93, 5.66, 21.29];

distance_from_soma_OLM = [9.00, 27.00, 32.50, 32.50, 13.30, 15.60, 289.60, 346.00, 356.00, 200.00, 177.00, 180.00,...
180.00, 291.60, 204.00, 221.00, 322.00, 3.00, 10.50, 23.13, 28.00, 0.00, 135.39, 155.96, 186.56, 200.00, 202.30,...
202.30, 230.26, 244.70, 281.65, 1.00, 19.60, 19.60, 9.34, 1.00, 35.91, 27.90, 27.90, 31.78, 125.00, 150.00,...
150.00, 114.48, 180.22, 0.00, 36.00, 36.00, 0.00, 6.00, 395.70, 410.90, 410.90];

dendritic_order_OLM = [1, 1, 2, 2, 1, 1, 3, 4, 5, 3, 2, 3, 3, 5, 4, 3, 4, 1, 2, 2, 3, 3, 4, 4, 5, 6, 7, 7, 7, 7, 7, 1, 2, 2, 2, 1, 3, 3, 3, 2, 3, 4, 4, 4, 4, 1, 2, 2, 1, 2, 7, 8, 8];

dendrite_volume_OLM = [3.011, 1.322, 0.550, 0.901, 0.758, 3.112, 0.838, 0.500, 0.283, 1.764, 3.424, 1.080, 1.151,...
0.506, 0.896, 0.932, 0.569, 4.806, 0.854, 1.840, 0.621, 2.390, 0.551, 0.477, 0.522, 0.799, 0.566, 0.534, 0.394,...
0.161, 0.310, 1.705, 0.861, 0.648, 0.678, 3.039, 0.746, 0.592, 0.303, 0.444, 0.421, 0.269, 0.247, 0.235, 0.448,...
2.215, 0.421, 0.918, 1.102, 0.793, 0.737, 0.256, 0.342];

surface_area_OLM = [7.990, 5.319, 3.607, 4.277, 3.729, 8.483, 3.994, 2.976, 2.047, 6.439, 8.106, 4.749, 4.928, 3.669,...
4.761, 4.555, 4.146, 9.837, 4.004, 5.893, 3.585, 6.611, 3.582, 3.585, 3.675, 4.876, 4.333, 4.038, 3.299, 1.989,...
2.807, 5.449, 4.064, 3.364, 3.766, 7.145, 4.065, 3.362, 2.211, 2.554, 4.024, 3.190, 2.609, 2.138, 3.742, 6.696,...
2.677, 4.013, 4.353, 4.310, 4.940, 2.168, 2.814];

perimeter_OLM = [6.427, 4.633, 3.056, 3.728, 3.562, 6.426, 3.477, 2.392, 1.679, 5.014, 7.149, 3.895, 4.338, 2.433,...
3.505, 3.259, 2.725, 9.044, 3.256, 5.574, 2.765, 6.341, 2.911, 2.850, 3.210, 3.790, 4.012, 3.216, 2.392, 1.745,...
2.226, 4.973, 2.753, 2.955, 3.127, 6.582, 3.510, 2.929, 1.994, 2.318, 2.549, 2.219, 1.745, 1.713, 2.953, 6.281,...
2.520, 3.673, 4.162, 3.626, 3.561, 1.938, 2.389];

neurolucida_diam_OLM = [NaN, NaN, NaN, NaN, NaN, NaN, 1.000, 1.000, 1.000, 1.100, 1.000, 0.900, 0.900, 0.800, 1.100,...
0.900, 0.800, 1.800, 1.600, NaN, 1.500, 1.500, 0.800, 0.800, 1.000, 0.700, 0.700, 0.700, 0.800, 0.700, 0.700,...
1.200, 1.400, 1.100, 1.100, 2.000, 1.000, 1.000, 0.700, 0.800, 0.700, 0.700, 0.700, 0.700, 0.600, 1.300, 0.900,...
NaN, 1.100, 0.700, 1.000, 0.900, 0.900];

number_gneg_syn_OLM = [NaN, NaN, NaN, NaN, NaN, NaN, 1.137, 0.985, 0.977, 1.820, 3.012, 2.481, 2.490, 1.189, 1.307,...
1.518, 1.146, 4.009, 2.599, 3.074, 3.034, 3.081, 2.423, 2.809, 2.416, 2.638, 1.767, 2.365, 1.669, 0.920, 1.152,...
2.896, 3.095, 1.906, 1.966, 2.735, 2.548, 1.924, 1.339, 0.690, 3.165, 1.912, 1.916, 1.130, 1.711, 2.810, 1.470,...
2.317, 2.913, 2.344, 2.448, 0.354, 1.174];

gneg_syn_size_per_length_OLM = [NaN, NaN, NaN, NaN, NaN, NaN, 0.224, 0.150, 0.120, 0.466, 0.662, 0.708, 0.537,...
0.223, 0.283, 0.293, 0.310, 0.376, 0.398, 0.331, 0.529, 0.453, 0.395, 0.438, 0.379, 0.508, 0.250, 0.417, 0.190,...
0.162, 0.137, 0.368, 0.291, 0.317, 0.334, 0.426, 0.339, 0.285, 0.171, 0.102, 0.408, 0.422, 0.285, 0.122, 0.235,...
0.286, 0.312, 0.365, 0.577, 0.212, 0.580, 0.109, 0.272];

gneg_syn_size_per_area_OLM = [NaN, NaN, NaN, NaN, NaN, NaN, 0.056, 0.050, 0.059, 0.072, 0.082, 0.149, 0.109,...
0.061, 0.059, 0.064, 0.075, 0.038, 0.099, 0.050, 0.148, 0.077, 0.110, 0.122, 0.103, 0.104, 0.058, 0.103, 0.058,...
0.081, 0.049, 0.067, 0.072, 0.094, 0.089, 0.060, 0.083, 0.085, 0.078, 0.040, 0.101, 0.132, 0.109, 0.057, 0.063,...
0.043, 0.072, 0.091, 0.133, 0.079, 0.117, 0.050, 0.097];

number_gpos_syn_OLM = [NaN, NaN, NaN, NaN, NaN, NaN, 0.421, 0.197, 0.293, 0.780, 0.335, 0.431, 0.830, 0.381, 0.286,...
0.138, 0.873, 1.283, 0.487, 0.307, 0.178, 0.000, 0.269, 0.100, 0.324, 0.000, 0.000, 0.546, 0.119, 0.081, 0.188,...
0.592, 0.619, 0.673, 0.131, 0.706, 0.236, 0.385, 0.260, 0.284, 0.236, 0.000, 0.255, 0.282, 0.227, 0.278, 0.186,...
0.290, 0.000, 0.240, 0.502, 0.17, 0.376];

gpos_syn_size_per_length_OLM = [NaN, NaN, NaN, NaN, NaN, NaN, 0.149, 0.055, 0.020, 0.238, 0.166, 0.172, 0.220,...
0.078, 0.079, 0.014, 0.232, 0.232, 0.121, 0.000, 0.025, 0.145, 0.049, 0.017, 0.026, 0.000, 0.000, 0.052, 0.020,...
0.010, 0.037, 0.134, 0.213, 0.127, 0.017, 0.126, 0.024, 0.055, 0.042, 0.041, 0.016, 0.000, 0.041, 0.034, 0.031,...
0.036, 0.017, 0.037, 0.000, 0.027, 0.106, 0.070, 0.053];

gpos_syn_size_per_area_OLM = [NaN, NaN, NaN, NaN, NaN, NaN, 0.037, 0.018, 0.010, 0.037, 0.021, 0.036, 0.045,...
0.021, 0.017, 0.003, 0.056, 0.024, 0.030, 0.000, 0.007, 0.015, 0.014, 0.005, 0.007, 0.000, 0.000, 0.013, 0.006,...
0.005, 0.013, 0.025, 0.052, 0.038, 0.005, 0.018, 0.006, 0.016, 0.019, 0.016, 0.004, 0.000, 0.016, 0.016, 0.008,...
0.005, 0.006, 0.009, 0.000, 0.006, 0.021, 0.032, 0.019];

dendrite_volume_without_mito_OLM = [2.598, 1.111, 0.465, 0.807, 0.679, 2.776, 0.762, 0.465, 0.237, 1.662, 3.331,...
1.013, 1.072, 0.462, 0.813, 0.897, 0.524, 4.245, 0.719, 1.722, 0.581, 2.136, 0.509, 0.437, 0.498, 0.769, 0.566,...
0.493, 0.363, 0.144, 0.278, 1.536, 0.814, 0.575, 0.635, 2.491, 0.672, 0.587, 0.272, 0.394, 0.371, 0.250, 0.217,...
0.206, 0.408, 2.003, 0.383, 0.856, 1.006, 0.748, 0.669, 0.227, 0.311];

volume_ratio_OLM = dendrite_volume_OLM ./ dendrite_volume_without_mito_OLM;

mean_volume_ratio_OLM = mean(volume_ratio_OLM);



diameter_from_volume_OLM = sqrt(4.*dendrite_volume_OLM./pi);
diameter_from_area_OLM = (surface_area_OLM ./ pi);
diameter_from_perimeter_OLM = (perimeter_OLM ./pi);

olm_diameter_table = 'olm_diams.xlsx';
writematrix(diameter_from_volume_OLM', olm_diameter_table,'Sheet',1,'Range','B2');
writematrix(diameter_from_area_OLM', olm_diameter_table ,'Sheet',1,'Range','C2');
writematrix(diameter_from_perimeter_OLM', olm_diameter_table ,'Sheet',1,'Range','D2');
writematrix(distance_from_soma_OLM', olm_diameter_table ,'Sheet',1,'Range','E2');
writematrix(dendritic_order_OLM', olm_diameter_table ,'Sheet',1,'Range','F2');

cell_ids_OLM = [272, 273, 273, 273, 274, 276, 221, 221, 221, 221, 221, 221, 221, 222, 222, 222, 222, 281, 281, ...
    281, 281, 281, 281, 281, 281, 281, 281, 281, 281, 281, 281, 281, 281, 281, 281, 281, 301, 301, 301, 301, ...
    301, 301, 301, 301, 301, 301, 301, 301, 301, 301, 302, 302, 302];

OLM_cell1_diams = diameter_from_volume_OLM(1);
OLM_cell2_diams = diameter_from_volume_OLM(2:4);
OLM_cell3_diams = diameter_from_volume_OLM(5);
OLM_cell4_diams = diameter_from_volume_OLM(6);
OLM_cell5_diams = diameter_from_volume_OLM(7:13);
OLM_cell6_diams = diameter_from_volume_OLM(14:17);
OLM_cell7_diams = diameter_from_volume_OLM(18:36);
OLM_cell8_diams = diameter_from_volume_OLM(37:50);
OLM_cell9_diams = diameter_from_volume_OLM(51:53);

%% Fitting - OLM

dist_dfv_OLM = fitlm(distance_from_soma_OLM, diameter_from_volume_OLM);
dist_dfa_OLM = fitlm(distance_from_soma_OLM, diameter_from_area_OLM);
dist_dfp_OLM = fitlm(distance_from_soma_OLM, diameter_from_perimeter_OLM);
dist_neuroluc_OLM = fitlm(distance_from_soma_OLM, neurolucida_diam_OLM);

order_dfv_OLM = fitlm(dendritic_order_OLM, diameter_from_volume_OLM);
order_dfa_OLM = fitlm(dendritic_order_OLM, diameter_from_area_OLM);
order_dfp_OLM = fitlm(dendritic_order_OLM, diameter_from_perimeter_OLM);
order_neuroluc_OLM = fitlm(dendritic_order_OLM, neurolucida_diam_OLM);

neuroluc_dfv_OLM = fitlm(neurolucida_diam_OLM, diameter_from_volume_OLM);
%neuroluc_dfv_b = fitlm(diameter_from_volume, neurolucida_diam) ugyanazt
%adja mint a masik

neuroluc_dfa_OLM = fitlm(neurolucida_diam_OLM, diameter_from_area_OLM);
neuroluc_dfp_OLM = fitlm(neurolucida_diam_OLM, diameter_from_perimeter_OLM);

filter_nans_OLM = isnan(neurolucida_diam_OLM);
filter_for_others_OLM = ~filter_nans_OLM;
filtered_diam_OLM = diameter_from_volume_OLM(filter_for_others_OLM);
filtered_diam_a_OLM = diameter_from_area_OLM(filter_for_others_OLM);
filtered_diam_p_OLM = diameter_from_perimeter_OLM(filter_for_others_OLM);
filtered_neuroluc_OLM = neurolucida_diam_OLM(filter_for_others_OLM);

r_square_1b_OLM = 1 - (sum((filtered_diam_OLM-filtered_neuroluc_OLM).^2, 'omitnan')/sum((filtered_diam_OLM-mean(filtered_diam_OLM)).^2, 'omitnan'));
r_square_2b_OLM = 1 - (sum((filtered_diam_a_OLM-filtered_neuroluc_OLM).^2, 'omitnan')/sum((filtered_diam_a_OLM-mean(filtered_diam_a_OLM)).^2, 'omitnan'));
r_square_3b_OLM = 1 - (sum((filtered_diam_p_OLM-filtered_neuroluc_OLM).^2, 'omitnan')/sum((filtered_diam_p_OLM-mean(filtered_diam_p_OLM)).^2, 'omitnan'));

volume_area_OLM = fitlm(diameter_from_volume_OLM, diameter_from_area_OLM);
volume_perim_OLM = fitlm(diameter_from_volume_OLM, diameter_from_perimeter_OLM);
area_perim_OLM =fitlm(diameter_from_area_OLM, diameter_from_perimeter_OLM);

dfs_ngns_OLM = fitlm(distance_from_soma_OLM, number_gneg_syn_OLM);
dfs_ngps_OLM = fitlm(distance_from_soma_OLM, number_gpos_syn_OLM);

do_ngns_OLM = fitlm(dendritic_order_OLM, number_gneg_syn_OLM);
do_ngps_OLM = fitlm(dendritic_order_OLM, number_gpos_syn_OLM);

diam_ngns_OLM = fitlm(diameter_from_volume_OLM, number_gneg_syn_OLM);
diam_ngps_OLM = fitlm(diameter_from_volume_OLM, number_gpos_syn_OLM);

dfs_gnsl_OLM = fitlm(distance_from_soma_OLM, gneg_syn_size_per_length_OLM);
dfs_gpsl_OLM = fitlm(distance_from_soma_OLM, gpos_syn_size_per_length_OLM);

do_gnsl_OLM = fitlm(dendritic_order_OLM, gneg_syn_size_per_length_OLM);
do_gpsl_OLM = fitlm(dendritic_order_OLM, gpos_syn_size_per_length_OLM);

diam_gnsl_OLM = fitlm(diameter_from_volume_OLM, gneg_syn_size_per_length_OLM);
diam_gpsl_OLM = fitlm(diameter_from_volume_OLM, gpos_syn_size_per_length_OLM);

dfs_gnsa_OLM = fitlm(distance_from_soma_OLM, gneg_syn_size_per_area_OLM)
dfs_gpsa_OLM = fitlm(distance_from_soma_OLM, gpos_syn_size_per_area_OLM)

do_gnsa_OLM = fitlm(dendritic_order_OLM, gneg_syn_size_per_area_OLM)
do_gpsa_OLM = fitlm(dendritic_order_OLM, gpos_syn_size_per_area_OLM)

diam_gnsa_OLM = fitlm(diameter_from_volume_OLM, gneg_syn_size_per_area_OLM)
diam_gpsa_OLM = fitlm(diameter_from_volume_OLM, gpos_syn_size_per_area_OLM)

%% Spearman

[rho_dist_num_gneg_HS, pval_dist_num_gneg_HS]= corr(distance_from_soma_HS',number_gneg_syn_HS','rows','pairwise','Type','Spearman');
[rho_dist_num_gneg_OLM, pval_dist_num_gneg_OLM]= corr(distance_from_soma_OLM',number_gneg_syn_OLM','rows','pairwise','Type','Spearman');

[rho_dist_num_gpos_HS, pval_dist_num_gpos_HS]= corr(distance_from_soma_HS',number_gpos_syn_HS','rows','pairwise','Type','Spearman');
[rho_dist_num_gpos_OLM, pval_dist_num_gpos_OLM]= corr(distance_from_soma_OLM',number_gpos_syn_OLM','rows','pairwise','Type','Spearman');

[rho_dist_size_gneg_HS, pval_dist_size_gneg_HS]= corr(distance_from_soma_HS',gneg_syn_size_per_length_HS','rows','pairwise','Type','Spearman');
[rho_dist_size_gneg_OLM, pval_dist_size_gneg_OLM]= corr(distance_from_soma_OLM',gneg_syn_size_per_length_OLM','rows','pairwise','Type','Spearman');

[rho_dist_size_gpos_HS, pval_dist_size_gpos_HS]= corr(distance_from_soma_HS',gpos_syn_size_per_length_HS','rows','pairwise','Type','Spearman');
[rho_dist_size_gpos_OLM, pval_dist_size_gpos_OLM]= corr(distance_from_soma_OLM',gpos_syn_size_per_length_OLM','rows','pairwise','Type','Spearman');

[rho_dist_size_gneg_HS_2, pval_dist_size_gneg_HS_2]= corr(distance_from_soma_HS',gneg_syn_size_per_area_HS','rows','pairwise','Type','Spearman');
[rho_dist_size_gneg_OLM_2, pval_dist_size_gneg_OLM_2]= corr(distance_from_soma_OLM',gneg_syn_size_per_area_OLM','rows','pairwise','Type','Spearman');

[rho_dist_size_gpos_HS_2, pval_dist_size_gpos_HS_2]= corr(distance_from_soma_HS',gpos_syn_size_per_area_HS','rows','pairwise','Type','Spearman');
[rho_dist_size_gpos_OLM_2, pval_dist_size_gpos_OLM_2]= corr(distance_from_soma_OLM',gpos_syn_size_per_area_OLM','rows','pairwise','Type','Spearman');


[rho_diam_num_gneg_HS, pval_diam_num_gneg_HS]= corr(diameter_from_volume_HS',number_gneg_syn_HS','rows','pairwise','Type','Spearman');
[rho_diam_num_gneg_OLM, pval_diam_num_gneg_OLM]= corr(diameter_from_volume_OLM',number_gneg_syn_OLM','rows','pairwise','Type','Spearman');

[rho_diam_num_gpos_HS, pval_diam_num_gpos_HS]= corr(diameter_from_volume_HS',number_gpos_syn_HS','rows','pairwise','Type','Spearman');
[rho_diam_num_gpos_OLM, pval_diam_num_gpos_OLM]= corr(diameter_from_volume_OLM',number_gpos_syn_OLM','rows','pairwise','Type','Spearman');

[rho_diam_size_gneg_HS, pval_diam_size_gneg_HS]= corr(diameter_from_volume_HS',gneg_syn_size_per_length_HS','rows','pairwise','Type','Spearman');
[rho_diam_size_gneg_OLM, pval_diam_size_gneg_OLM]= corr(diameter_from_volume_OLM',gneg_syn_size_per_length_OLM','rows','pairwise','Type','Spearman');

[rho_diam_size_gpos_HS, pval_diam_size_gpos_HS]= corr(diameter_from_volume_HS',gpos_syn_size_per_length_HS','rows','pairwise','Type','Spearman');
[rho_diam_size_gpos_OLM, pval_diam_size_gpos_OLM]= corr(diameter_from_volume_OLM',gpos_syn_size_per_length_OLM','rows','pairwise','Type','Spearman');

[rho_diam_size_gneg_HS_2, pval_diam_size_gneg_HS_2]= corr(diameter_from_volume_HS',gneg_syn_size_per_area_HS','rows','pairwise','Type','Spearman');
[rho_diam_size_gneg_OLM_2, pval_diam_size_gneg_OLM_2]= corr(diameter_from_volume_OLM',gneg_syn_size_per_area_OLM','rows','pairwise','Type','Spearman');

[rho_diam_size_gpos_HS_2, pval_diam_size_gpos_HS_2]= corr(diameter_from_volume_HS',gpos_syn_size_per_area_HS','rows','pairwise','Type','Spearman');
[rho_diam_size_gpos_OLM_2, pval_diam_size_gpos_OLM_2]= corr(diameter_from_volume_OLM',gpos_syn_size_per_area_OLM','rows','pairwise','Type','Spearman');


[rho_order_num_gneg_HS, pval_order_num_gneg_HS]= corr(dendritic_order_HS',number_gneg_syn_HS','rows','pairwise','Type','Spearman');
[rho_order_num_gneg_OLM, pval_order_num_gneg_OLM]= corr(dendritic_order_OLM',number_gneg_syn_OLM','rows','pairwise','Type','Spearman');

[rho_order_num_gpos_HS, pval_order_num_gpos_HS]= corr(dendritic_order_HS',number_gpos_syn_HS','rows','pairwise','Type','Spearman');
[rho_order_num_gpos_OLM, pval_order_num_gpos_OLM]= corr(dendritic_order_OLM',number_gpos_syn_OLM','rows','pairwise','Type','Spearman');

[rho_order_size_gneg_HS, pval_order_size_gneg_HS]= corr(dendritic_order_HS',gneg_syn_size_per_length_HS','rows','pairwise','Type','Spearman');
[rho_order_size_gneg_OLM, pval_order_size_gneg_OLM]= corr(dendritic_order_OLM',gneg_syn_size_per_length_OLM','rows','pairwise','Type','Spearman');

[rho_order_size_gpos_HS, pval_order_size_gpos_HS]= corr(dendritic_order_HS',gpos_syn_size_per_length_HS','rows','pairwise','Type','Spearman');
[rho_order_size_gpos_OLM, pval_order_size_gpos_OLM]= corr(dendritic_order_OLM',gpos_syn_size_per_length_OLM','rows','pairwise','Type','Spearman');

[rho_order_size_gneg_HS_2, pval_order_size_gneg_HS_2]= corr(dendritic_order_HS',gneg_syn_size_per_area_HS','rows','pairwise','Type','Spearman');
[rho_order_size_gneg_OLM_2, pval_order_size_gneg_OLM_2]= corr(dendritic_order_OLM',gneg_syn_size_per_area_OLM','rows','pairwise','Type','Spearman');

[rho_order_size_gpos_HS_2, pval_order_size_gpos_HS_2]= corr(dendritic_order_HS',gpos_syn_size_per_area_HS','rows','pairwise','Type','Spearman');
[rho_order_size_gpos_OLM_2, pval_order_size_gpos_OLM_2]= corr(dendritic_order_OLM',gpos_syn_size_per_area_OLM','rows','pairwise','Type','Spearman');

%% Plotting

figure(1)
hold on;
scatter(distance_from_soma_HS, number_gneg_syn_HS, "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880]);
lsline
scatter(distance_from_soma_OLM, number_gneg_syn_OLM, "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560]);
lsline
title('Number of gneg synapses vs. Distance')
legend('Gneg HS', 'Gneg fitted line HS', 'Gneg OLM', 'Gneg fitted line OLM');
xlabel('Distance')
ylabel('Number of synapses / um dend')
txt=['R^2 gns HS:' num2str(dfs_ngns_HS.Rsquared.Ordinary)];
txt2 = ['R^2 gns OLM:' num2str(dfs_ngns_OLM.Rsquared.Ordinary)];
txt37 = ['rho HS:' num2str(rho_dist_num_gneg_HS)];
txt38 = ['pval HS:' num2str(pval_dist_num_gneg_HS)];
txt39 = ['rho OLM:' num2str(rho_dist_num_gneg_OLM)];
txt40 = ['pval OLM:' num2str(pval_dist_num_gneg_OLM)];
text(300,5,txt)
text(300,4.5,txt2)
text(300,4,txt37)
text(300,3.5,txt38)
text(300,3,txt39)
text(300,2.5,txt40)

figure(2)
hold on;
scatter(distance_from_soma_HS, number_gpos_syn_HS, "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880]);
lsline
scatter(distance_from_soma_OLM, number_gpos_syn_OLM, "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560]);
lsline
title('Number of gpos synapses vs. Distance')
legend('Gpos HS', 'Gpos fitted line HS', 'Gpos OLM', 'Gpos fitted line OLM');
xlabel('Distance')
ylabel('Number of synapses / um dend')
txt3=['R^2 gps HS:' num2str(dfs_ngps_HS.Rsquared.Ordinary)];
txt4=['R^2 gps OLM:' num2str(dfs_ngps_OLM.Rsquared.Ordinary)];
txt41 = ['rho HS:' num2str(rho_dist_num_gpos_HS)];
txt42 = ['pval HS:' num2str(pval_dist_num_gpos_HS)];
txt43 = ['rho OLM:' num2str(rho_dist_num_gpos_OLM)];
txt44 = ['pval OLM:' num2str(pval_dist_num_gpos_OLM)];
text(300,2,txt3)
text(300,1.75,txt4)
text(300,1.5,txt41)
text(300,1.25,txt42)
text(300,1,txt43)
text(300,0.75,txt44)

figure(3)
hold on;
scatter(distance_from_soma_HS, gneg_syn_size_per_length_HS, "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880]);
lsline
scatter(distance_from_soma_OLM, gneg_syn_size_per_length_OLM, "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560]);
lsline
title('size of gneg synapses / length vs. Distance')
legend('Gneg HS', 'Gneg fitted line HS', 'Gneg OLM', 'Gneg fitted line OLM');
xlabel('Distance')
ylabel('syn size / um dend')
txt5=['R^2 gns HS:' num2str(dfs_gnsl_HS.Rsquared.Ordinary)];
txt6 = ['R^2 gns OLM:' num2str(dfs_gnsl_OLM.Rsquared.Ordinary)];
txt45 = ['rho HS:' num2str(rho_dist_size_gneg_HS)];
txt46 = ['pval HS:' num2str(pval_dist_size_gneg_HS)];
txt47 = ['rho OLM:' num2str(rho_dist_size_gneg_OLM)];
txt48 = ['pval OLM:' num2str(pval_dist_size_gneg_OLM)];
text(300,1,txt5)
text(300,0.9,txt6)
text(300,0.8,txt45)
text(300,0.7,txt46)
text(300,0.6,txt47)
text(300,0.5,txt48)

figure(4)
hold on;
scatter(distance_from_soma_HS, gpos_syn_size_per_length_HS, "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880]);
lsline
scatter(distance_from_soma_OLM, gpos_syn_size_per_length_OLM, "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560]);
lsline
title('size of gpos synapses / length vs. Distance')
legend('Gpos HS', 'Gpos fitted line HS', 'Gpos OLM', 'Gpos fitted line OLM');
xlabel('Distance')
ylabel('syn size / um dend')
txt7=['R^2 gps HS:' num2str(dfs_gpsl_HS.Rsquared.Ordinary)];
txt8=['R^2 gps OLM:' num2str(dfs_gpsl_OLM.Rsquared.Ordinary)];
txt49 = ['rho HS:' num2str(rho_dist_size_gpos_HS)];
txt50 = ['pval HS:' num2str(pval_dist_size_gpos_HS)];
txt51 = ['rho OLM:' num2str(rho_dist_size_gpos_OLM)];
txt52 = ['pval OLM:' num2str(pval_dist_size_gpos_OLM)];
text(300,0.5,txt7)
text(300,0.45,txt8)
text(300,0.4,txt49)
text(300,0.35,txt50)
text(300,0.3,txt51)
text(300,0.25,txt52)

figure(5)
hold on;
scatter(distance_from_soma_HS, gneg_syn_size_per_area_HS, "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880]);
lsline
scatter(distance_from_soma_OLM, gneg_syn_size_per_area_OLM, "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560]);
lsline
title('size of gneg synapses / area vs. Distance')
legend('Gneg HS', 'Gneg fitted line HS', 'Gneg OLM', 'Gneg fitted line OLM');
xlabel('Distance')
ylabel('syn size / um area')
txt9=['R^2 gns HS:' num2str(dfs_gnsa_HS.Rsquared.Ordinary)];
txt10 = ['R^2 gns OLM:' num2str(dfs_gnsa_OLM.Rsquared.Ordinary)];
txt53 = ['rho HS:' num2str(rho_dist_size_gneg_HS_2)];
txt54 = ['pval HS:' num2str(pval_dist_size_gneg_HS_2)];
txt55 = ['rho OLM:' num2str(rho_dist_size_gneg_OLM_2)];
txt56 = ['pval OLM:' num2str(pval_dist_size_gneg_OLM_2)];
text(300,0.15,txt9)
text(300,0.14,txt10)
text(300,0.13,txt53)
text(300,0.12,txt54)
text(300,0.11,txt55)
text(300,0.10,txt56)

figure(6)
hold on;
scatter(distance_from_soma_HS, gpos_syn_size_per_area_HS, "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880]);
lsline
scatter(distance_from_soma_OLM, gpos_syn_size_per_area_OLM, "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560]);
lsline
title('size of gpos synapses / area vs. Distance')
legend('Gpos HS', 'Gpos fitted line HS', 'Gpos OLM', 'Gpos fitted line OLM');
xlabel('Distance')
ylabel('syn size / um area')
txt11=['R^2 gps HS:' num2str(dfs_gpsa_HS.Rsquared.Ordinary)];
txt12=['R^2 gps OLM:' num2str(dfs_gpsa_OLM.Rsquared.Ordinary)];
txt57 = ['rho HS:' num2str(rho_dist_size_gpos_HS_2)];
txt58 = ['pval HS:' num2str(pval_dist_size_gpos_HS_2)];
txt59 = ['rho OLM:' num2str(rho_dist_size_gpos_OLM_2)];
txt60 = ['pval OLM:' num2str(pval_dist_size_gpos_OLM_2)];
text(300,0.13,txt11)
text(300,0.12,txt12)
text(300,0.11,txt57)
text(300,0.1,txt58)
text(300,0.09,txt59)
text(300,0.08,txt60)

%%

figure(7)
hold on;
scatter(diameter_from_volume_HS, number_gneg_syn_HS, "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880]);
lsline
scatter(diameter_from_volume_OLM, number_gneg_syn_OLM, "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560]);
lsline
title('Number of gneg synapses vs. Diam')
legend('Gneg HS', 'Gneg fitted line HS', 'Gneg OLM', 'Gneg fitted line OLM');
xlabel('Diameter')
ylabel('Number of synapses / um dend')
txt13=['R^2 gns HS:' num2str(diam_ngns_HS.Rsquared.Ordinary)];
txt14 = ['R^2 gns OLM:' num2str(diam_ngns_OLM.Rsquared.Ordinary)];
txt61 = ['rho HS:' num2str(rho_diam_num_gneg_HS)];
txt62 = ['pval HS:' num2str(pval_diam_num_gneg_HS)];
txt63 = ['rho OLM:' num2str(rho_diam_num_gneg_OLM)];
txt64 = ['pval OLM:' num2str(pval_diam_num_gneg_OLM)];
text(2,5,txt13)
text(2,4.75,txt14)
text(2,4.5,txt61)
text(2,4.25,txt62)
text(2,4,txt63)
text(2,3.75,txt64)

figure(8)
hold on;
scatter(diameter_from_volume_HS, number_gpos_syn_HS, "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880]);
lsline
scatter(diameter_from_volume_OLM, number_gpos_syn_OLM, "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560]);
lsline
title('Number of gpos synapses vs. Diameter')
legend('Gpos HS', 'Gpos fitted line HS', 'Gpos OLM', 'Gpos fitted line OLM');
xlabel('Diameter')
ylabel('Number of synapses / um dend')
txt15=['R^2 gps HS:' num2str(diam_ngps_HS.Rsquared.Ordinary)];
txt16=['R^2 gps OLM:' num2str(diam_ngps_OLM.Rsquared.Ordinary)];
txt65 = ['rho HS:' num2str(rho_diam_num_gpos_HS)];
txt66 = ['pval HS:' num2str(pval_diam_num_gpos_HS)];
txt67 = ['rho OLM:' num2str(rho_diam_num_gpos_OLM)];
txt68 = ['pval OLM:' num2str(pval_diam_num_gpos_OLM)];
text(2,2,txt15)
text(2,1.90,txt16)
text(2,1.8,txt65)
text(2,1.7,txt66)
text(2,1.6,txt67)
text(2,1.5,txt68)

figure(9)
hold on;
scatter(diameter_from_volume_HS, gneg_syn_size_per_length_HS, "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880]);
lsline
scatter(diameter_from_volume_OLM, gneg_syn_size_per_length_OLM, "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560]);
lsline
title('size of gneg synapses / length vs. Diameter')
legend('Gneg HS', 'Gneg fitted line HS', 'Gneg OLM', 'Gneg fitted line OLM');
xlabel('Diameter')
ylabel('syn size / um dend')
txt17=['R^2 gns HS:' num2str(diam_gnsl_HS.Rsquared.Ordinary)];
txt18 = ['R^2 gns OLM:' num2str(diam_gnsl_OLM.Rsquared.Ordinary)];
txt69 = ['rho HS:' num2str(rho_diam_size_gneg_HS)];
txt70 = ['pval HS:' num2str(pval_diam_size_gneg_HS)];
txt71 = ['rho OLM:' num2str(rho_diam_size_gneg_OLM)];
txt72 = ['pval OLM:' num2str(pval_diam_size_gneg_OLM)];
text(2,2,txt17)
text(2,1.9,txt18)
text(2,1.8,txt69)
text(2,1.7,txt70)
text(2,1.6,txt71)
text(2,1.5,txt72)

figure(10)
hold on;
scatter(diameter_from_volume_HS, gpos_syn_size_per_length_HS, "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880]);
lsline
scatter(diameter_from_volume_OLM, gpos_syn_size_per_length_OLM, "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560]);
lsline
title('size of gpos synapses / length vs. Diameter')
legend('Gpos HS', 'Gpos fitted line HS', 'Gpos OLM', 'Gpos fitted line OLM');
xlabel('Diameter')
ylabel('syn size / um dend')
txt19=['R^2 gps HS:' num2str(diam_gpsl_HS.Rsquared.Ordinary)];
txt20=['R^2 gps OLM:' num2str(diam_gpsl_OLM.Rsquared.Ordinary)];
txt73 = ['rho HS:' num2str(rho_diam_size_gpos_HS)];
txt74 = ['pval HS:' num2str(pval_diam_size_gpos_HS)];
txt75 = ['rho OLM:' num2str(rho_diam_size_gpos_OLM)];
txt76 = ['pval OLM:' num2str(pval_diam_size_gpos_OLM)];
text(2,1,txt19)
text(2,0.9,txt20)
text(2,0.8,txt73)
text(2,0.7,txt74)
text(2,0.6,txt75)
text(2,0.5,txt76)

figure(11)
hold on;
scatter(diameter_from_volume_HS, gneg_syn_size_per_area_HS, "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880]);
lsline
scatter(diameter_from_volume_OLM, gneg_syn_size_per_area_OLM, "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560]);
lsline
title('size of gneg synapses / area vs. Diameter')
legend('Gneg HS', 'Gneg fitted line HS', 'Gneg OLM', 'Gneg fitted line OLM');
xlabel('Diameter')
ylabel('syn size / um area')
txt21=['R^2 gns HS:' num2str(diam_gnsa_HS.Rsquared.Ordinary)];
txt22 = ['R^2 gns OLM:' num2str(diam_gnsa_OLM.Rsquared.Ordinary)];
txt77 = ['rho HS:' num2str(rho_diam_size_gneg_HS_2)];
txt78 = ['pval HS:' num2str(pval_diam_size_gneg_HS_2)];
txt79 = ['rho OLM:' num2str(rho_diam_size_gneg_OLM_2)];
txt80 = ['pval OLM:' num2str(pval_diam_size_gneg_OLM_2)];
text(2,0.14,txt21)
text(2,0.13,txt22)
text(2,0.12,txt77)
text(2,0.11,txt78)
text(2,0.1,txt79)
text(2,0.09,txt80)

figure(12)
hold on;
scatter(diameter_from_volume_HS, gpos_syn_size_per_area_HS, "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880]);
lsline
scatter(diameter_from_volume_OLM, gpos_syn_size_per_area_OLM, "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560]);
lsline
title('size of gpos synapses / area vs. Diameter')
legend('Gpos HS', 'Gpos fitted line HS', 'Gpos OLM', 'Gpos fitted line OLM');
xlabel('Diameter')
ylabel('syn size / um area')
txt23=['R^2 gps HS:' num2str(diam_gpsa_HS.Rsquared.Ordinary)];
txt24=['R^2 gps OLM:' num2str(diam_gpsa_OLM.Rsquared.Ordinary)];
txt81 = ['rho HS:' num2str(rho_diam_size_gpos_HS_2)];
txt82 = ['pval HS:' num2str(pval_diam_size_gpos_HS_2)];
txt83 = ['rho OLM:' num2str(rho_diam_size_gpos_OLM_2)];
txt84 = ['pval OLM:' num2str(pval_diam_size_gpos_OLM_2)];
text(2,0.13,txt23)
text(2,0.12,txt24)
text(2,0.11,txt81)
text(2,0.10,txt82)
text(2,0.09,txt83)
text(2,0.08,txt84)

%%

figure(13)
hold on;
scatter(dendritic_order_HS, number_gneg_syn_HS, "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880]);
lsline
scatter(dendritic_order_OLM, number_gneg_syn_OLM, "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560]);
lsline
title('Number of gneg synapses vs. Order')
legend('Gneg HS', 'Gneg fitted line HS', 'Gneg OLM', 'Gneg fitted line OLM');
xlabel('Order')
ylabel('Number of synapses / um dend')
txt25=['R^2 gns HS:' num2str(do_ngns_HS.Rsquared.Ordinary)];
txt26 = ['R^2 gns OLM:' num2str(do_ngns_OLM.Rsquared.Ordinary)];
txt85 = ['rho HS:' num2str(rho_order_num_gneg_HS)];
txt86 = ['pval HS:' num2str(pval_order_num_gneg_HS)];
txt87 = ['rho OLM:' num2str(rho_order_num_gneg_OLM)];
txt88 = ['pval OLM:' num2str(pval_order_num_gneg_OLM)];
text(6,6,txt25)
text(6,5.5,txt26)
text(6,5,txt85)
text(6,4.5,txt86)
text(6,4,txt87)
text(6,3.5,txt88)

figure(14)
hold on;
scatter(dendritic_order_HS, number_gpos_syn_HS, "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880]);
lsline
scatter(dendritic_order_OLM, number_gpos_syn_OLM, "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560]);
lsline
title('Number of gpos synapses vs. Order')
legend('Gpos HS', 'Gpos fitted line HS', 'Gpos OLM', 'Gpos fitted line OLM');
xlabel('Order')
ylabel('Number of synapses / um dend')
txt27=['R^2 gps HS:' num2str(do_ngps_HS.Rsquared.Ordinary)];
txt28=['R^2 gps OLM:' num2str(do_ngps_OLM.Rsquared.Ordinary)];
txt89 = ['rho HS:' num2str(rho_order_num_gpos_HS)];
txt90 = ['pval HS:' num2str(pval_order_num_gpos_HS)];
txt91 = ['rho OLM:' num2str(rho_order_num_gpos_OLM)];
txt92 = ['pval OLM:' num2str(pval_order_num_gpos_OLM)];
text(6,2,txt27)
text(6,1.7,txt28)
text(6,1.5,txt89)
text(6,1.3,txt90)
text(6,1.1,txt91)
text(6,0.9,txt92)

figure(15)
hold on;
scatter(dendritic_order_HS, gneg_syn_size_per_length_HS, "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880]);
lsline
scatter(dendritic_order_OLM, gneg_syn_size_per_length_OLM, "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560]);
lsline
title('size of gneg synapses / length vs. Order')
legend('Gneg HS', 'Gneg fitted line HS', 'Gneg OLM', 'Gneg fitted line OLM');
xlabel('Order')
ylabel('syn size / um dend')
txt29=['R^2 gns HS:' num2str(do_gnsl_HS.Rsquared.Ordinary)];
txt30 = ['R^2 gns OLM:' num2str(do_gnsl_OLM.Rsquared.Ordinary)];
txt93 = ['rho HS:' num2str(rho_order_size_gneg_HS)];
txt94 = ['pval HS:' num2str(pval_order_size_gneg_HS)];
txt95 = ['rho OLM:' num2str(rho_order_size_gneg_OLM)];
txt96 = ['pval OLM:' num2str(pval_order_size_gneg_OLM)];
text(6,2,txt29)
text(6,1.7,txt30)
text(6,1.5,txt93)
text(6,1.3,txt94)
text(6,1.1,txt95)
text(6,0.9,txt96)

figure(16)
hold on;
scatter(dendritic_order_HS, gpos_syn_size_per_length_HS, "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880]);
lsline
scatter(dendritic_order_OLM, gpos_syn_size_per_length_OLM, "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560]);
lsline
title('size of gpos synapses / length vs. Order')
legend('Gpos HS', 'Gpos fitted line HS', 'Gpos OLM', 'Gpos fitted line OLM');
xlabel('Order')
ylabel('syn size / um dend')
txt31=['R^2 gps HS:' num2str(do_gpsl_HS.Rsquared.Ordinary)];
txt32=['R^2 gps OLM:' num2str(do_gpsl_OLM.Rsquared.Ordinary)];
txt93 = ['rho HS:' num2str(rho_order_size_gpos_HS)];
txt94 = ['pval HS:' num2str(pval_order_size_gpos_HS)];
txt95 = ['rho OLM:' num2str(rho_order_size_gpos_OLM)];
txt96 = ['pval OLM:' num2str(pval_order_size_gpos_OLM)];
text(6,1,txt31)
text(6,0.9,txt32)
text(6,0.8,txt93)
text(6,0.7,txt94)
text(6,0.6,txt95)
text(6,0.5,txt96)

figure(17)
hold on;
scatter(dendritic_order_HS, gneg_syn_size_per_area_HS, "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880]);
lsline
scatter(dendritic_order_OLM, gneg_syn_size_per_area_OLM, "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560]);
lsline
title('size of gneg synapses / area vs. Order')
legend('Gneg HS', 'Gneg fitted line HS', 'Gneg OLM', 'Gneg fitted line OLM');
xlabel('Order')
ylabel('syn size / um area')
txt33=['R^2 gns HS:' num2str(do_gnsa_HS.Rsquared.Ordinary)];
txt34 = ['R^2 gns OLM:' num2str(do_gnsa_OLM.Rsquared.Ordinary)];
txt97 = ['rho HS:' num2str(rho_order_size_gneg_HS_2)];
txt98 = ['pval HS:' num2str(pval_order_size_gneg_HS_2)];
txt99 = ['rho OLM:' num2str(rho_order_size_gneg_OLM_2)];
txt100 = ['pval OLM:' num2str(pval_order_size_gneg_OLM_2)];
text(6,0.16,txt33)
text(6,0.155,txt34)
text(6,0.15,txt97)
text(6,0.145,txt98)
text(6,0.14,txt99)
text(6,0.135,txt100)

figure(18)
hold on;
scatter(dendritic_order_HS, gpos_syn_size_per_area_HS, "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880]);
lsline
scatter(dendritic_order_OLM, gpos_syn_size_per_area_OLM, "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560]);
lsline
title('size of gpos synapses / area vs. Order')
legend('Gpos HS', 'Gpos fitted line HS', 'Gpos OLM', 'Gpos fitted line OLM');
xlabel('Order')
ylabel('syn size / um area')
txt35=['R^2 gps HS:' num2str(do_gpsa_HS.Rsquared.Ordinary)];
txt36=['R^2 gps OLM:' num2str(do_gpsa_OLM.Rsquared.Ordinary)];
txt101 = ['rho HS:' num2str(rho_order_size_gpos_HS_2)];
txt102 = ['pval HS:' num2str(pval_order_size_gpos_HS_2)];
txt103 = ['rho OLM:' num2str(rho_order_size_gpos_OLM_2)];
txt104 = ['pval OLM:' num2str(pval_order_size_gpos_OLM_2)];
text(6,0.13,txt35)
text(6,0.125,txt36)
text(6,0.12,txt101)
text(6,0.115,txt102)
text(6,0.11,txt103)
text(6,0.105,txt104)


%% Concat with branching points

all_dist_HS = cat(2,distance_from_soma_HS, bp_dist_HS);
all_dist_OLM = cat(2,distance_from_soma_OLM, bp_dist_OLM);

all_order_HS = cat(2,dendritic_order_HS, bp_order_HS);
all_order_OLM = cat(2,dendritic_order_OLM, bp_order_OLM);

number_gneg_syn_per_are_with_bp_HS = cat(2,(number_gneg_syn_HS./surface_area_HS), bp_gneg_syn_number_per_area_HS);
number_gneg_syn_per_are_with_bp_OLM = cat(2,(number_gneg_syn_OLM./surface_area_OLM), bp_gneg_syn_number_per_area_OLM);
number_gpos_syn_per_are_with_bp_HS = cat(2,(number_gpos_syn_HS./surface_area_HS), bp_gpos_syn_number_per_area_HS);
number_gpos_syn_per_are_with_bp_OLM = cat(2,(number_gpos_syn_OLM./surface_area_OLM), bp_gpos_syn_number_per_area_OLM);

size_gneg_syn_per_are_with_bp_HS = cat(2,gneg_syn_size_per_area_HS, bp_gneg_syn_size_per_area_HS);
size_gneg_syn_per_are_with_bp_OLM = cat(2,gneg_syn_size_per_area_OLM, bp_gneg_syn_size_per_area_OLM);
size_gpos_syn_per_are_with_bp_HS = cat(2,gpos_syn_size_per_area_HS, bp_gpos_syn_size_per_area_HS);
size_gpos_syn_per_are_with_bp_OLM = cat(2,gpos_syn_size_per_area_OLM, bp_gpos_syn_size_per_area_OLM);

[rho_dist_num_gneg_bp_HS, pval_dist_num_gneg_bp_HS]= corr(all_dist_HS',number_gneg_syn_per_are_with_bp_HS','rows','pairwise','Type','Spearman');
[rho_dist_num_gneg_bp_OLM, pval_dist_num_gneg_bp_OLM]= corr(all_dist_OLM',number_gneg_syn_per_are_with_bp_OLM','rows','pairwise','Type','Spearman');

[rho_dist_num_gpos_bp_HS, pval_dist_num_gpos_bp_HS]= corr(all_dist_HS',number_gpos_syn_per_are_with_bp_HS','rows','pairwise','Type','Spearman');
[rho_dist_num_gpos_bp_OLM, pval_dist_num_gpos_bp_OLM]= corr(all_dist_OLM',number_gpos_syn_per_are_with_bp_OLM','rows','pairwise','Type','Spearman');

[rho_dist_size_gneg_bp_HS, pval_dist_size_gneg_bp_HS]= corr(all_dist_HS', size_gneg_syn_per_are_with_bp_HS','rows','pairwise','Type','Spearman');
[rho_dist_size_gneg_bp_OLM, pval_dist_size_gneg_bp_OLM]= corr(all_dist_OLM',size_gneg_syn_per_are_with_bp_OLM','rows','pairwise','Type','Spearman');

[rho_dist_size_gpos_bp_HS, pval_dist_size_gpos_bp_HS]= corr(all_dist_HS', size_gpos_syn_per_are_with_bp_HS','rows','pairwise','Type','Spearman');
[rho_dist_size_gpos_bp_OLM, pval_dist_size_gpos_bp_OLM]= corr(all_dist_OLM',size_gpos_syn_per_are_with_bp_OLM','rows','pairwise','Type','Spearman');

[rho_order_num_gneg_bp_HS, pval_order_num_gneg_bp_HS]= corr(all_order_HS',number_gneg_syn_per_are_with_bp_HS','rows','pairwise','Type','Spearman');
[rho_order_num_gneg_bp_OLM, pval_order_num_gneg_bp_OLM]= corr(all_order_OLM',number_gneg_syn_per_are_with_bp_OLM','rows','pairwise','Type','Spearman');

[rho_order_num_gpos_bp_HS, pval_order_num_gpos_bp_HS]= corr(all_order_HS',number_gpos_syn_per_are_with_bp_HS','rows','pairwise','Type','Spearman');
[rho_order_num_gpos_bp_OLM, pval_order_num_gpos_bp_OLM]= corr(all_order_OLM',number_gpos_syn_per_are_with_bp_OLM','rows','pairwise','Type','Spearman');

[rho_order_size_gneg_bp_HS, pval_order_size_gneg_bp_HS]= corr(all_order_HS', size_gneg_syn_per_are_with_bp_HS','rows','pairwise','Type','Spearman');
[rho_order_size_gneg_bp_OLM, pval_order_size_gneg_bp_OLM]= corr(all_order_OLM',size_gneg_syn_per_are_with_bp_OLM','rows','pairwise','Type','Spearman');

[rho_order_size_gpos_bp_HS, pval_order_size_gpos_bp_HS]= corr(all_order_HS', size_gpos_syn_per_are_with_bp_HS','rows','pairwise','Type','Spearman');
[rho_order_size_gpos_bp_OLM, pval_order_size_gpos_bp_OLM]= corr(all_order_OLM',size_gpos_syn_per_are_with_bp_OLM','rows','pairwise','Type','Spearman');

%% Plots with branching points

figure(19)
hold on;
scatter(distance_from_soma_HS, (number_gneg_syn_HS./surface_area_HS), "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880]);
scatter(bp_dist_HS, bp_gneg_syn_number_per_area_HS, "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880], 'filled');
scatter(distance_from_soma_OLM, (number_gneg_syn_OLM./surface_area_OLM), "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560]);
scatter(bp_dist_OLM, bp_gneg_syn_number_per_area_OLM, "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560], 'filled');
title('Number of gneg synapses vs. Distance')
legend('Gneg HS', 'Gneg HS BP', 'Gneg OLM', 'Gneg OLM BP');
xlabel('Distance')
ylabel('Number of synapses / um2 dend')
txt105 = ['rho HS:' num2str(rho_dist_num_gneg_bp_HS)];
txt106 = ['pval HS:' num2str(pval_dist_num_gneg_bp_HS)];
txt107 = ['rho OLM:' num2str(rho_dist_num_gneg_bp_OLM)];
txt108 = ['pval OLM:' num2str(pval_dist_num_gneg_bp_OLM)];
text(300,2,txt105)
text(300,1.7,txt106)
text(300,1.4,txt107)
text(300,1.1,txt108)

figure(20)
hold on;
scatter(distance_from_soma_HS, (number_gpos_syn_HS./surface_area_HS), "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880]);
scatter(bp_dist_HS, bp_gpos_syn_number_per_area_HS, "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880], 'filled');
scatter(distance_from_soma_OLM, (number_gpos_syn_OLM./surface_area_OLM), "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560]);
scatter(bp_dist_OLM, bp_gpos_syn_number_per_area_OLM, "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560], 'filled');
title('Number of gpos synapses vs. Distance')
legend('Gpos HS', 'Gpos HS BP', 'Gpos OLM', 'Gpos OLM BP');
xlabel('Distance')
ylabel('Number of synapses / um2 dend')
txt109 = ['rho HS:' num2str(rho_dist_num_gpos_bp_HS)];
txt110 = ['pval HS:' num2str(pval_dist_num_gpos_bp_HS)];
txt111 = ['rho OLM:' num2str(rho_dist_num_gpos_bp_OLM)];
txt112 = ['pval OLM:' num2str(pval_dist_num_gpos_bp_OLM)];
text(300,0.4,txt109)
text(300,0.37,txt110)
text(300,0.34,txt111)
text(300,0.31,txt112)


figure(21)
hold on;
scatter(distance_from_soma_HS, gneg_syn_size_per_area_HS, "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880]);
scatter(bp_dist_HS, bp_gneg_syn_size_per_area_HS, "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880], 'filled');
scatter(distance_from_soma_OLM, gneg_syn_size_per_area_OLM, "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560]);
scatter(bp_dist_OLM, bp_gneg_syn_size_per_area_OLM, "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560], 'filled');
title('size of gneg synapses / area vs. Distance')
legend('Gneg HS', 'Gneg HS BP', 'Gneg OLM', 'Gneg OLM BP');
xlabel('Distance')
ylabel('syn size / um area')
txt113 = ['rho HS:' num2str(rho_dist_size_gneg_bp_HS)];
txt114 = ['pval HS:' num2str(pval_dist_size_gneg_bp_HS)];
txt115 = ['rho OLM:' num2str(rho_dist_size_gneg_bp_OLM)];
txt116 = ['pval OLM:' num2str(pval_dist_size_gneg_bp_OLM)];
text(300,0.2,txt113)
text(300,0.17,txt114)
text(300,0.14,txt115)
text(300,0.11,txt116)


figure(22)
hold on;
scatter(distance_from_soma_HS, gpos_syn_size_per_area_HS, "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880]);
scatter(bp_dist_HS, bp_gpos_syn_size_per_area_HS, "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880], 'filled');
scatter(distance_from_soma_OLM, gpos_syn_size_per_area_OLM, "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560]);
scatter(bp_dist_OLM, bp_gpos_syn_size_per_area_OLM, "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560], 'filled');
title('size of gpos synapses / area vs. Distance')
legend('Gpos HS', 'Gpos HS BP', 'Gpos OLM', 'Gpos OLM BP');
xlabel('Distance')
ylabel('syn size / um area')
txt117 = ['rho HS:' num2str(rho_dist_size_gpos_bp_HS)];
txt118 = ['pval HS:' num2str(pval_dist_size_gpos_bp_HS)];
txt119 = ['rho OLM:' num2str(rho_dist_size_gpos_bp_OLM)];
txt120 = ['pval OLM:' num2str(pval_dist_size_gpos_bp_OLM)];
text(300,0.2,txt117)
text(300,0.17,txt118)
text(300,0.14,txt119)
text(300,0.11,txt120)

figure(23)
hold on;
scatter(dendritic_order_HS, (number_gneg_syn_HS./surface_area_HS), "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880]);
scatter(bp_order_HS, bp_gneg_syn_number_per_area_HS, "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880], 'filled');
scatter(dendritic_order_OLM, (number_gneg_syn_OLM./surface_area_OLM), "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560]);
scatter(bp_order_OLM, bp_gneg_syn_number_per_area_OLM, "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560], 'filled');
title('Number of gneg synapses vs. Order')
legend('Gneg HS', 'Gneg HS BP', 'Gneg OLM','Gneg OLM BP');
xlabel('Order')
ylabel('Number of synapses / um2 dend')
txt121 = ['rho HS:' num2str(rho_order_num_gneg_bp_HS)];
txt122 = ['pval HS:' num2str(pval_order_num_gneg_bp_HS)];
txt123 = ['rho OLM:' num2str(rho_order_num_gneg_bp_OLM)];
txt124 = ['pval OLM:' num2str(pval_order_num_gneg_bp_OLM)];
text(2,2.7,txt121)
text(2,2.5,txt122)
text(2,2.3,txt123)
text(2,2.1,txt124)


figure(24)
hold on;
scatter(dendritic_order_HS, (number_gpos_syn_HS./surface_area_HS), "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880]);
scatter(bp_order_HS, bp_gpos_syn_number_per_area_HS, "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880], 'filled');
scatter(dendritic_order_OLM, (number_gpos_syn_OLM./surface_area_OLM), "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560]);
scatter(bp_order_OLM, bp_gpos_syn_number_per_area_OLM, "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560], 'filled');
title('Number of gpos synapses vs. Order')
legend('Gpos HS', 'Gpos HS BP', 'Gpos OLM', 'Gpos OLM BP');
xlabel('Order')
ylabel('Number of synapses / um2 dend')
txt125 = ['rho HS:' num2str(rho_order_num_gpos_bp_HS)];
txt126 = ['pval HS:' num2str(pval_order_num_gpos_bp_HS)];
txt127 = ['rho OLM:' num2str(rho_order_num_gpos_bp_OLM)];
txt128 = ['pval OLM:' num2str(pval_order_num_gpos_bp_OLM)];
text(2,0.5,txt125)
text(2,0.47,txt126)
text(2,0.44,txt127)
text(2,0.41,txt128)

figure(25)
hold on;
scatter(dendritic_order_HS, gneg_syn_size_per_area_HS, "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880]);
scatter(bp_order_HS, bp_gneg_syn_size_per_area_HS, "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880], 'filled');
scatter(dendritic_order_OLM, gneg_syn_size_per_area_OLM, "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560]);
scatter(bp_order_OLM, bp_gneg_syn_size_per_area_OLM, "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560], 'filled');
title('size of gneg synapses / area vs. Order')
legend('Gneg HS', 'Gneg HS BP', 'Gneg OLM', 'Gneg OLM BP');
xlabel('Order')
ylabel('syn size / um area')
txt129 = ['rho HS:' num2str(rho_order_size_gneg_bp_HS)];
txt130 = ['pval HS:' num2str(pval_order_size_gneg_bp_HS)];
txt131 = ['rho OLM:' num2str(rho_order_size_gneg_bp_OLM)];
txt132 = ['pval OLM:' num2str(pval_order_size_gneg_bp_OLM)];
text(4,0.35,txt129)
text(4,0.32,txt130)
text(4,0.29,txt131)
text(4,0.26,txt132)

figure(26)
hold on;
scatter(dendritic_order_HS, gpos_syn_size_per_area_HS, "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880]);
scatter(bp_order_HS, bp_gpos_syn_size_per_area_HS, "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880], 'filled');
scatter(dendritic_order_OLM, gpos_syn_size_per_area_OLM, "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560]);
scatter(bp_order_OLM, bp_gpos_syn_size_per_area_OLM, "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560], 'filled');
title('size of gpos synapses / area vs. Order')
legend('Gpos HS', 'Gpos HS BP', 'Gpos OLM','Gpos OLM BP');
xlabel('Order')
ylabel('syn size / um area')
txt133 = ['rho HS:' num2str(rho_order_size_gpos_bp_HS)];
txt134 = ['pval HS:' num2str(pval_order_size_gpos_bp_HS)];
txt135 = ['rho OLM:' num2str(rho_order_size_gpos_bp_OLM)];
txt136 = ['pval OLM:' num2str(pval_order_size_gpos_bp_OLM)];
text(7,0.25,txt133)
text(7,0.23,txt134)
text(7,0.21,txt135)
text(7,0.19,txt136)

%% Average synapse size

avg_gneg_size_HS = gneg_syn_size_per_length_HS./number_gneg_syn_HS;
avg_gpos_size_HS = gpos_syn_size_per_length_HS./number_gpos_syn_HS;
avg_gneg_size_OLM = gneg_syn_size_per_length_OLM./number_gneg_syn_OLM;
avg_gpos_size_OLM = gpos_syn_size_per_length_OLM./number_gpos_syn_OLM;

Inf_indices2 = find(~isfinite(avg_gpos_size_OLM));
avg_gpos_size_OLM(Inf_indices2) = [];

gneg_ratio_HS_OLM = mean(avg_gneg_size_HS, 'omitnan')/mean(avg_gneg_size_OLM, 'omitnan')
gpos_ratio_HS_OLM = mean(avg_gpos_size_HS, 'omitnan')/mean(avg_gpos_size_OLM, 'omitnan')

dist_avg_gneg_HS_fit = fitlm(distance_from_soma_HS,avg_gneg_size_HS);
dist_avg_gneg_OLM_fit = fitlm(distance_from_soma_OLM,avg_gneg_size_OLM);

order_avg_gneg_HS_fit = fitlm(dendritic_order_HS,avg_gneg_size_HS);
order_avg_gneg_OLM_fit = fitlm(dendritic_order_OLM,avg_gneg_size_OLM);

diam_avg_gneg_HS_fit = fitlm(diameter_from_volume_HS,avg_gneg_size_HS);
diam_avg_gneg_OLM_fit = fitlm(diameter_from_volume_OLM,avg_gneg_size_OLM);

dist_avg_gpos_HS_fit = fitlm(distance_from_soma_HS,avg_gpos_size_HS);

distance_from_soma_OLM_corr = distance_from_soma_OLM;
distance_from_soma_OLM_corr(Inf_indices2)= [];
dist_avg_gpos_OLM_fit = fitlm(distance_from_soma_OLM_corr,avg_gpos_size_OLM);

order_avg_gpos_HS_fit = fitlm(dendritic_order_HS,avg_gpos_size_HS);

dendritic_order_OLM_corr = dendritic_order_OLM;
dendritic_order_OLM_corr(Inf_indices2)= [];
order_avg_gpos_OLM_fit = fitlm(dendritic_order_OLM_corr,avg_gpos_size_OLM);

diam_avg_gpos_HS_fit = fitlm(diameter_from_volume_HS,avg_gpos_size_HS);

diameter_from_volume_OLM_corr = diameter_from_volume_OLM;
diameter_from_volume_OLM_corr(Inf_indices2) = [];
diam_avg_gpos_OLM_fit = fitlm(diameter_from_volume_OLM_corr,avg_gpos_size_OLM);

[rho_dist_avg_size_gneg_HS, pval_dist_avg_size_gneg_HS]= corr(distance_from_soma_HS',avg_gneg_size_HS','rows','pairwise','Type','Spearman');
[rho_dist_avg_size_gneg_OLM, pval_dist_avg_size_gneg_OLM]= corr(distance_from_soma_OLM',avg_gneg_size_OLM','rows','pairwise','Type','Spearman');

[rho_dist_avg_size_gpos_HS, pval_dist_avg_size_gpos_HS]= corr(distance_from_soma_HS',avg_gpos_size_HS','rows','pairwise','Type','Spearman');
[rho_dist_avg_size_gpos_OLM, pval_dist_avg_size_gpos_OLM]= corr(distance_from_soma_OLM_corr',avg_gpos_size_OLM','rows','pairwise','Type','Spearman');

[rho_order_avg_size_gneg_HS, pval_order_avg_size_gneg_HS]= corr(dendritic_order_HS',avg_gneg_size_HS','rows','pairwise','Type','Spearman');
[rho_order_avg_size_gneg_OLM, pval_order_avg_size_gneg_OLM]= corr(dendritic_order_OLM',avg_gneg_size_OLM','rows','pairwise','Type','Spearman');

[rho_order_avg_size_gpos_HS, pval_order_avg_size_gpos_HS]= corr(dendritic_order_HS',avg_gpos_size_HS','rows','pairwise','Type','Spearman');
[rho_order_avg_size_gpos_OLM, pval_order_avg_size_gpos_OLM]= corr(dendritic_order_OLM_corr',avg_gpos_size_OLM','rows','pairwise','Type','Spearman');

[rho_diam_avg_size_gneg_HS, pval_diam_avg_size_gneg_HS]= corr(diameter_from_volume_HS',avg_gneg_size_HS','rows','pairwise','Type','Spearman');
[rho_diam_avg_size_gneg_OLM, pval_diam_avg_size_gneg_OLM]= corr(diameter_from_volume_OLM',avg_gneg_size_OLM','rows','pairwise','Type','Spearman');

[rho_diam_avg_size_gpos_HS, pval_diam_avg_size_gpos_HS]= corr(diameter_from_volume_HS',avg_gpos_size_HS','rows','pairwise','Type','Spearman');
[rho_diam_avg_size_gpos_OLM, pval_diam_avg_size_gpos_OLM]= corr(diameter_from_volume_OLM_corr',avg_gpos_size_OLM','rows','pairwise','Type','Spearman');


figure(27)
hold on;
scatter(distance_from_soma_HS, avg_gneg_size_HS, "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880]);
lsline
scatter(distance_from_soma_OLM, avg_gneg_size_OLM, "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560]);
lsline
title('Average gneg area vs. Distance')
legend('Gneg HS', 'Gneg fitted line HS', 'Gneg OLM', 'Gneg fitted line OLM');
xlabel('Distance')
ylabel('AVG gneg syn area')
txt137=['R^2 gns HS:' num2str(dist_avg_gneg_HS_fit.Rsquared.Ordinary)];
txt138=['R^2 gns OLM:' num2str(dist_avg_gneg_OLM_fit.Rsquared.Ordinary)];
txt139 = ['rho HS:' num2str(rho_dist_avg_size_gneg_HS)];
txt140 = ['pval HS:' num2str(pval_dist_avg_size_gneg_HS)];
txt141 = ['rho OLM:' num2str(rho_dist_avg_size_gneg_OLM)];
txt142 = ['pval OLM:' num2str(pval_dist_avg_size_gneg_OLM)];
text(300,0.25,txt137)
text(300,0.23,txt138)
text(300,0.21,txt139)
text(460,0.19,txt140)
text(300,0.17,txt141)
text(300,0.15,txt142)

figure(28)
hold on;
scatter(distance_from_soma_HS, avg_gpos_size_HS, "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880]);
lsline
scatter(distance_from_soma_OLM_corr, avg_gpos_size_OLM, "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560]);
lsline
title('Average gpos area vs. Distance')
legend('Gpos HS', 'Gpos fitted line HS', 'Gpos OLM', 'Gpos fitted line OLM');
xlabel('Distance')
ylabel('AVG gpos syn area')
txt143=['R^2 gps HS:' num2str(dist_avg_gpos_HS_fit.Rsquared.Ordinary)];
txt144=['R^2 gps OLM:' num2str(dist_avg_gpos_OLM_fit.Rsquared.Ordinary)];
txt145 = ['rho HS:' num2str(rho_dist_avg_size_gneg_HS)];
txt146 = ['pval HS:' num2str(pval_dist_avg_size_gneg_HS)];
txt147 = ['rho OLM:' num2str(rho_dist_avg_size_gneg_OLM)];
txt148 = ['pval OLM:' num2str(pval_dist_avg_size_gneg_OLM)];
text(300,0.4,txt143)
text(300,0.35,txt144)
text(300,0.30,txt145)
text(460,0.25,txt146)
text(300,0.20,txt147)
text(300,0.15,txt148)

figure(29)
hold on;
scatter(dendritic_order_HS, avg_gneg_size_HS, "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880]);
lsline
scatter(dendritic_order_OLM, avg_gneg_size_OLM, "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560]);
lsline
title('Average gneg area vs. Order')
legend('Gneg HS', 'Gneg fitted line HS', 'Gneg OLM', 'Gneg fitted line OLM');
xlabel('Order')
ylabel('AVG gneg syn area')
txt149=['R^2 gns HS:' num2str(order_avg_gneg_HS_fit.Rsquared.Ordinary)];
txt150=['R^2 gns OLM:' num2str(order_avg_gneg_OLM_fit.Rsquared.Ordinary)];
txt151 = ['rho HS:' num2str(rho_order_avg_size_gneg_HS)];
txt152 = ['pval HS:' num2str(pval_order_avg_size_gneg_HS)];
txt153 = ['rho OLM:' num2str(rho_order_avg_size_gneg_OLM)];
txt154 = ['pval OLM:' num2str(pval_order_avg_size_gneg_OLM)];
text(6,0.25,txt149)
text(6,0.23,txt150)
text(6,0.21,txt151)
text(6,0.19,txt152)
text(6,0.17,txt153)
text(6,0.15,txt154)

figure(30)
hold on;
scatter(dendritic_order_HS, avg_gpos_size_HS, "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880]);
lsline
scatter(dendritic_order_OLM_corr, avg_gpos_size_OLM, "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560]);
lsline
title('Average gpos area vs. Order')
legend('Gpos HS', 'Gpos fitted line HS', 'Gpos OLM', 'Gpos fitted line OLM');
xlabel('Order')
ylabel('AVG gpos syn area')
txt155=['R^2 gps HS:' num2str(order_avg_gpos_HS_fit.Rsquared.Ordinary)];
txt156=['R^2 gps OLM:' num2str(order_avg_gpos_OLM_fit.Rsquared.Ordinary)];
txt157 = ['rho HS:' num2str(rho_order_avg_size_gneg_HS)];
txt158 = ['pval HS:' num2str(pval_order_avg_size_gneg_HS)];
txt159 = ['rho OLM:' num2str(rho_order_avg_size_gneg_OLM)];
txt160 = ['pval OLM:' num2str(pval_order_avg_size_gneg_OLM)];
text(6,0.4,txt155)
text(6,0.35,txt156)
text(6,0.3,txt157)
text(6,0.25,txt158)
text(6,0.2,txt159)
text(6,0.15,txt160)

figure(31)
hold on;
scatter(diameter_from_volume_HS, avg_gneg_size_HS, "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880]);
lsline
scatter(diameter_from_volume_OLM, avg_gneg_size_OLM, "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560]);
lsline
title('Average gneg area vs. Diam')
legend('Gneg HS', 'Gneg fitted line HS', 'Gneg OLM', 'Gneg fitted line OLM');
xlabel('Diam')
ylabel('AVG gneg syn area')
txt161=['R^2 gns HS:' num2str(diam_avg_gneg_HS_fit.Rsquared.Ordinary)];
txt162=['R^2 gns OLM:' num2str(diam_avg_gneg_OLM_fit.Rsquared.Ordinary)];
txt163 = ['rho HS:' num2str(rho_diam_avg_size_gneg_HS)];
txt164 = ['pval HS:' num2str(pval_diam_avg_size_gneg_HS)];
txt165 = ['rho OLM:' num2str(rho_diam_avg_size_gneg_OLM)];
txt166 = ['pval OLM:' num2str(pval_diam_avg_size_gneg_OLM)];
text(2,0.25,txt161)
text(2,0.23,txt162)
text(2,0.21,txt163)
text(2,0.19,txt164)
text(2,0.17,txt165)
text(2,0.15,txt166)

figure(32)
hold on;
scatter(diameter_from_volume_HS, avg_gpos_size_HS, "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880]);
lsline
scatter(diameter_from_volume_OLM_corr, avg_gpos_size_OLM, "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560]);
lsline
title('Average gpos area vs. Diam')
legend('Gpos HS', 'Gpos fitted line HS', 'Gpos OLM', 'Gpos fitted line OLM');
xlabel('Diam')
ylabel('AVG gpos syn area')
txt167=['R^2 gps HS:' num2str(diam_avg_gpos_HS_fit.Rsquared.Ordinary)];
txt168=['R^2 gps OLM:' num2str(diam_avg_gpos_OLM_fit.Rsquared.Ordinary)];
txt169 = ['rho HS:' num2str(rho_diam_avg_size_gneg_HS)];
txt170 = ['pval HS:' num2str(pval_diam_avg_size_gneg_HS)];
txt171 = ['rho OLM:' num2str(rho_diam_avg_size_gneg_OLM)];
txt172 = ['pval OLM:' num2str(pval_diam_avg_size_gneg_OLM)];
text(2,0.4,txt167)
text(2,0.35,txt168)
text(2,0.3,txt169)
text(2,0.25,txt170)
text(2,0.2,txt171)
text(2,0.15,txt172)

%% 3D plotting

X = [ones(size(distance_from_soma_HS)).' distance_from_soma_HS.' dendritic_order_HS.'];
X_2 = [ones(size(distance_from_soma_HS)).' distance_from_soma_HS.' diameter_from_volume_HS.'];
X_3 = [ones(size(dendritic_order_HS)).' dendritic_order_HS.' diameter_from_volume_HS.'];

y = number_gneg_syn_HS.';
y_2 = number_gpos_syn_HS.';
y_3 = gneg_syn_size_per_area_HS.';
y_4 = gpos_syn_size_per_area_HS.';

X_4 = [ones(size(distance_from_soma_OLM)).' distance_from_soma_OLM.' dendritic_order_OLM.'];
X_5 = [ones(size(distance_from_soma_OLM)).' distance_from_soma_OLM.' diameter_from_volume_OLM.'];
X_6 = [ones(size(dendritic_order_OLM)).' dendritic_order_OLM.' diameter_from_volume_OLM.'];

y_5 = number_gneg_syn_OLM.';
y_6 = number_gpos_syn_OLM.';
y_7 = gneg_syn_size_per_area_OLM.';
y_8 = gpos_syn_size_per_area_OLM.';

% [b,bint,r,rint,stats] = regress(y, X);
% txt173 = ['R^2:' num2str(stats(1))];
% 
% figure(33)
% scatter3(distance_from_soma_HS, dendritic_order_HS, number_gneg_syn_HS,'filled')
% hold on
% x1fit = min(distance_from_soma_HS):100:max(distance_from_soma_HS);
% x2fit = min(dendritic_order_HS):1:max(dendritic_order_HS);
% [X1FIT,X2FIT] = meshgrid(x1fit,x2fit);
% YFIT = b(1) + b(2)*X1FIT + b(3)*X2FIT;  % + b(4)*X1FIT.*X2FIT
% yfit_dist_order_ngneg_HS = b(1) + b(2)*distance_from_soma_HS + b(3)*dendritic_order_HS;
% mesh(X1FIT,X2FIT,YFIT)
% xlabel('distance from soma')
% ylabel('dendritic order')
% zlabel('number gneg syn HS')
% text(200, 4, 2, txt173);
% view(50,10)
% hold off

% [b,bint,r,rint,stats] = regress(y_2, X);
% txt174 = ['R^2:' num2str(stats(1))];
% 
% figure(34)
% scatter3(distance_from_soma_HS, dendritic_order_HS, number_gpos_syn_HS,'filled')
% hold on
% x1fit = min(distance_from_soma_HS):100:max(distance_from_soma_HS);
% x2fit = min(dendritic_order_HS):1:max(dendritic_order_HS);
% [X1FIT,X2FIT] = meshgrid(x1fit,x2fit);
% YFIT = b(1) + b(2)*X1FIT + b(3)*X2FIT;  % + b(4)*X1FIT.*X2FIT
% yfit_dist_order_ngpos_HS = b(1) + b(2)*distance_from_soma_HS + b(3)*dendritic_order_HS;
% mesh(X1FIT,X2FIT,YFIT)
% xlabel('distance from soma')
% ylabel('dendritic order')
% zlabel('number gpos syn HS')
% text(200, 4, 2, txt174);
% view(50,10)
% hold off

[b,bint,r,rint,stats] = regress(y_3, X);
txt175 = ['R^2:' num2str(stats(1))];

figure(35)
scatter3(distance_from_soma_HS, dendritic_order_HS, gneg_syn_size_per_area_HS,'filled')
hold on
x1fit = min(distance_from_soma_HS):100:max(distance_from_soma_HS);
x2fit = min(dendritic_order_HS):1:max(dendritic_order_HS);
[X1FIT,X2FIT] = meshgrid(x1fit,x2fit);
YFIT = b(1) + b(2)*X1FIT + b(3)*X2FIT;  % + b(4)*X1FIT.*X2FIT
mesh(X1FIT,X2FIT,YFIT)
xlabel('distance from soma')
ylabel('dendritic order')
zlabel('size gneg syn HS')
text(200, 4, 0.3, txt175);
view(50,10)
hold off

[b,bint,r,rint,stats] = regress(y_4, X);
txt176 = ['R^2:' num2str(stats(1))];

figure(36)
scatter3(distance_from_soma_HS, dendritic_order_HS, gpos_syn_size_per_area_HS,'filled')
hold on
x1fit = min(distance_from_soma_HS):100:max(distance_from_soma_HS);
x2fit = min(dendritic_order_HS):1:max(dendritic_order_HS);
[X1FIT,X2FIT] = meshgrid(x1fit,x2fit);
YFIT = b(1) + b(2)*X1FIT + b(3)*X2FIT;  % + b(4)*X1FIT.*X2FIT
mesh(X1FIT,X2FIT,YFIT)
xlabel('distance from soma')
ylabel('dendritic order')
zlabel('size gpos syn HS')
text(200, 4, 0.3, txt176);
view(50,10)
hold off

% [b,bint,r,rint,stats] = regress(y, X_2);
% txt177 = ['R^2:' num2str(stats(1))];
% 
% figure(36)
% scatter3(distance_from_soma_HS, diameter_from_volume_HS, number_gneg_syn_HS,'filled')
% hold on
% x1fit = min(distance_from_soma_HS):100:max(distance_from_soma_HS);
% x2fit = min(diameter_from_volume_HS):0.1:max(diameter_from_volume_HS);
% [X1FIT,X2FIT] = meshgrid(x1fit,x2fit);
% YFIT = b(1) + b(2)*X1FIT + b(3)*X2FIT;  % + b(4)*X1FIT.*X2FIT
% yfit_dist_diam_ngneg_HS =  b(1) + b(2)*distance_from_soma_HS + b(3)*diameter_from_volume_HS;
% coeffs_dist_diam_ngneg_HS = b;
% mesh(X1FIT,X2FIT,YFIT)
% xlabel('distance from soma')
% ylabel('diameter from volume HS')
% zlabel('number gneg syn HS')
% text(200, 4, 0.3, txt177);
% view(50,10)
% hold off

% [b,bint,r,rint,stats] = regress(y_2, X_2);
% txt178 = ['R^2:' num2str(stats(1))];
% 
% figure(37)
% scatter3(distance_from_soma_HS, diameter_from_volume_HS, number_gpos_syn_HS,'filled')
% hold on
% x1fit = min(distance_from_soma_HS):100:max(distance_from_soma_HS);
% x2fit = min(diameter_from_volume_HS):0.1:max(diameter_from_volume_HS);
% [X1FIT,X2FIT] = meshgrid(x1fit,x2fit);
% YFIT = b(1) + b(2)*X1FIT + b(3)*X2FIT;  % + b(4)*X1FIT.*X2FIT
% yfit_dist_diam_ngpos_HS = b(1) + b(2)*distance_from_soma_HS + b(3)*diameter_from_volume_HS;
% coeffs_dist_diam_ngpos_HS = b;
% mesh(X1FIT,X2FIT,YFIT)
% xlabel('distance from soma')
% ylabel('diameter from volume HS')
% zlabel('number gpos syn HS')
% text(200, 2, 0.3, txt178);
% view(50,10)
% hold off

[b,bint,r,rint,stats] = regress(y_3, X_2);
txt179 = ['R^2:' num2str(stats(1))];

figure(38)
scatter3(distance_from_soma_HS, diameter_from_volume_HS, gneg_syn_size_per_area_HS,'filled')
hold on
x1fit = min(distance_from_soma_HS):100:max(distance_from_soma_HS);
x2fit = min(diameter_from_volume_HS):0.1:max(diameter_from_volume_HS);
[X1FIT,X2FIT] = meshgrid(x1fit,x2fit);
YFIT = b(1) + b(2)*X1FIT + b(3)*X2FIT;  % + b(4)*X1FIT.*X2FIT
mesh(X1FIT,X2FIT,YFIT)
xlabel('distance from soma')
ylabel('diameter from volume HS')
zlabel('size gneg syn HS')
text(200, 2, 0.3, txt179);
view(50,10)
hold off

[b,bint,r,rint,stats] = regress(y_4, X_2);
txt180 = ['R^2:' num2str(stats(1))];

figure(40)
scatter3(distance_from_soma_HS, diameter_from_volume_HS, gpos_syn_size_per_area_HS,'filled')
hold on
x1fit = min(distance_from_soma_HS):100:max(distance_from_soma_HS);
x2fit = min(diameter_from_volume_HS):0.1:max(diameter_from_volume_HS);
[X1FIT,X2FIT] = meshgrid(x1fit,x2fit);
YFIT = b(1) + b(2)*X1FIT + b(3)*X2FIT;  % + b(4)*X1FIT.*X2FIT
mesh(X1FIT,X2FIT,YFIT)
xlabel('distance from soma')
ylabel('diameter from volume HS')
zlabel('size gpos syn HS')
text(200, 2, 0.3, txt180);
view(50,10)
hold off

% [b,bint,r,rint,stats] = regress(y, X_3);
% txt181 = ['R^2:' num2str(stats(1))];
% 
% figure(41)
% scatter3(dendritic_order_HS, diameter_from_volume_HS, number_gneg_syn_HS,'filled')
% hold on
% x1fit = min(dendritic_order_HS):1:max(dendritic_order_HS);
% x2fit = min(diameter_from_volume_HS):0.1:max(diameter_from_volume_HS);
% [X1FIT,X2FIT] = meshgrid(x1fit,x2fit);
% YFIT = b(1) + b(2)*X1FIT + b(3)*X2FIT;  % + b(4)*X1FIT.*X2FIT
% yfit_order_diam_ngneg_HS = b(1) + b(2)*dendritic_order_HS + b(3)*diameter_from_volume_HS;
% mesh(X1FIT,X2FIT,YFIT)
% xlabel('dendritic order HS')
% ylabel('diameter from volume HS')
% zlabel('number gneg syn HS')
% text(4, 4, 0.3, txt181);
% view(50,10)
% hold off

% [b,bint,r,rint,stats] = regress(y_2, X_3);
% txt182 = ['R^2:' num2str(stats(1))];
% 
% figure(42)
% scatter3(dendritic_order_HS, diameter_from_volume_HS, number_gpos_syn_HS,'filled')
% hold on
% x1fit = min(dendritic_order_HS):1:max(dendritic_order_HS);
% x2fit = min(diameter_from_volume_HS):0.1:max(diameter_from_volume_HS);
% [X1FIT,X2FIT] = meshgrid(x1fit,x2fit);
% YFIT = b(1) + b(2)*X1FIT + b(3)*X2FIT;  % + b(4)*X1FIT.*X2FIT
% yfit_order_diam_ngpos_HS = b(1) + b(2)*dendritic_order_HS + b(3)*diameter_from_volume_HS;
% mesh(X1FIT,X2FIT,YFIT)
% xlabel('dendritic order HS')
% ylabel('diameter from volume HS')
% zlabel('number gpos syn HS')
% text(4, 4, 0.3, txt182);
% view(50,10)
% hold off

[b,bint,r,rint,stats] = regress(y_3, X_3);
txt182 = ['R^2:' num2str(stats(1))];

figure(43)
scatter3(dendritic_order_HS, diameter_from_volume_HS, gneg_syn_size_per_area_HS,'filled')
hold on
x1fit = min(dendritic_order_HS):1:max(dendritic_order_HS);
x2fit = min(diameter_from_volume_HS):0.1:max(diameter_from_volume_HS);
[X1FIT,X2FIT] = meshgrid(x1fit,x2fit);
YFIT = b(1) + b(2)*X1FIT + b(3)*X2FIT;  % + b(4)*X1FIT.*X2FIT
mesh(X1FIT,X2FIT,YFIT)
xlabel('dendritic order HS')
ylabel('diameter from volume HS')
zlabel('gneg syn size per area HS')
text(4, 4, 0.3, txt182);
view(50,10)
hold off

[b,bint,r,rint,stats] = regress(y_4, X_3);
txt183 = ['R^2:' num2str(stats(1))];

figure(44)
scatter3(dendritic_order_HS, diameter_from_volume_HS, gpos_syn_size_per_area_HS,'filled')
hold on
x1fit = min(dendritic_order_HS):1:max(dendritic_order_HS);
x2fit = min(diameter_from_volume_HS):0.1:max(diameter_from_volume_HS);
[X1FIT,X2FIT] = meshgrid(x1fit,x2fit);
YFIT = b(1) + b(2)*X1FIT + b(3)*X2FIT;  % + b(4)*X1FIT.*X2FIT
mesh(X1FIT,X2FIT,YFIT)
xlabel('dendritic order HS')
ylabel('diameter from volume HS')
zlabel('gpos syn size per area HS')
text(4, 4, 0.3, txt183);
view(50,10)
hold off

% [b,bint,r,rint,stats] = regress(y_5, X_4);
% txt184 = ['R^2:' num2str(stats(1))];
% 
% figure(45)
% scatter3(distance_from_soma_OLM, dendritic_order_OLM, number_gneg_syn_OLM,'filled')
% hold on
% x1fit = min(distance_from_soma_OLM):100:max(distance_from_soma_OLM);
% x2fit = min(dendritic_order_OLM):1:max(dendritic_order_OLM);
% [X1FIT,X2FIT] = meshgrid(x1fit,x2fit);
% YFIT = b(1) + b(2)*X1FIT + b(3)*X2FIT;  % + b(4)*X1FIT.*X2FIT
% yfit_dist_order_ngneg_OLM = b(1) + b(2)*distance_from_soma_OLM + b(3)*dendritic_order_OLM;
% mesh(X1FIT,X2FIT,YFIT)
% xlabel('distance from soma')
% ylabel('dendritic order')
% zlabel('number gneg syn OLM')
% text(200, 4, 2, txt184);
% view(50,10)
% hold off
% 
% [b,bint,r,rint,stats] = regress(y_6, X_4);
% txt185 = ['R^2:' num2str(stats(1))];
% 
% figure(46)
% scatter3(distance_from_soma_OLM, dendritic_order_OLM, number_gpos_syn_OLM,'filled')
% hold on
% x1fit = min(distance_from_soma_OLM):100:max(distance_from_soma_OLM);
% x2fit = min(dendritic_order_OLM):1:max(dendritic_order_OLM);
% [X1FIT,X2FIT] = meshgrid(x1fit,x2fit);
% YFIT = b(1) + b(2)*X1FIT + b(3)*X2FIT;  % + b(4)*X1FIT.*X2FIT
% yfit_dist_order_ngpos_OLM = b(1) + b(2)*distance_from_soma_OLM + b(3)*dendritic_order_OLM;
% mesh(X1FIT,X2FIT,YFIT)
% xlabel('distance from soma')
% ylabel('dendritic order')
% zlabel('number gpos syn OLM')
% text(200, 4, 2, txt185);
% view(50,10)
% hold off

[b,bint,r,rint,stats] = regress(y_7, X_4);
txt186 = ['R^2:' num2str(stats(1))];

figure(47)
scatter3(distance_from_soma_OLM, dendritic_order_OLM, gneg_syn_size_per_area_OLM,'filled')
hold on
x1fit = min(distance_from_soma_OLM):100:max(distance_from_soma_OLM);
x2fit = min(dendritic_order_OLM):1:max(dendritic_order_OLM);
[X1FIT,X2FIT] = meshgrid(x1fit,x2fit);
YFIT = b(1) + b(2)*X1FIT + b(3)*X2FIT;  % + b(4)*X1FIT.*X2FIT
mesh(X1FIT,X2FIT,YFIT)
xlabel('distance from soma')
ylabel('dendritic order')
zlabel('size gneg syn OLM')
text(200, 4, 0.2, txt186);
view(50,10)
hold off

[b,bint,r,rint,stats] = regress(y_8, X_4);
txt187 = ['R^2:' num2str(stats(1))];

figure(48)
scatter3(distance_from_soma_OLM, dendritic_order_OLM, gpos_syn_size_per_area_OLM,'filled')
hold on
x1fit = min(distance_from_soma_OLM):100:max(distance_from_soma_OLM);
x2fit = min(dendritic_order_OLM):1:max(dendritic_order_OLM);
[X1FIT,X2FIT] = meshgrid(x1fit,x2fit);
YFIT = b(1) + b(2)*X1FIT + b(3)*X2FIT;  % + b(4)*X1FIT.*X2FIT
mesh(X1FIT,X2FIT,YFIT)
xlabel('distance from soma')
ylabel('dendritic order')
zlabel('size gpos syn OLM')
text(200, 4, 0.2, txt187);
view(50,10)
hold off

% [b,bint,r,rint,stats] = regress(y_5, X_5);
% txt188 = ['R^2:' num2str(stats(1))];
% 
% figure(49)
% scatter3(distance_from_soma_OLM, diameter_from_volume_OLM, number_gneg_syn_OLM,'filled')
% hold on
% x1fit = min(distance_from_soma_OLM):100:max(distance_from_soma_OLM);
% x2fit = min(diameter_from_volume_OLM):0.1:max(diameter_from_volume_OLM);
% [X1FIT,X2FIT] = meshgrid(x1fit,x2fit);
% YFIT = b(1) + b(2)*X1FIT + b(3)*X2FIT;  % + b(4)*X1FIT.*X2FIT
% yfit_dist_diam_ngneg_OLM =  b(1) + b(2)*distance_from_soma_OLM + b(3)*diameter_from_volume_OLM;
% coeffs_dist_diam_ngneg_OLM = b;
% mesh(X1FIT,X2FIT,YFIT)
% xlabel('distance from soma')
% ylabel('diameter from volume OLM')
% zlabel('number gneg syn OLM')
% text(200, 4, 0.2, txt188);
% view(50,10)
% hold off
% 
% [b,bint,r,rint,stats] = regress(y_6, X_5);
% txt189 = ['R^2:' num2str(stats(1))];
% 
% figure(50)
% scatter3(distance_from_soma_OLM, diameter_from_volume_OLM, number_gpos_syn_OLM,'filled')
% hold on
% x1fit = min(distance_from_soma_OLM):100:max(distance_from_soma_OLM);
% x2fit = min(diameter_from_volume_OLM):0.1:max(diameter_from_volume_OLM);
% [X1FIT,X2FIT] = meshgrid(x1fit,x2fit);
% YFIT = b(1) + b(2)*X1FIT + b(3)*X2FIT;  % + b(4)*X1FIT.*X2FIT
% yfit_dist_diam_ngpos_OLM = b(1) + b(2)*distance_from_soma_OLM + b(3)*diameter_from_volume_OLM;
% coeffs_dist_diam_ngpos_OLM = b;
% mesh(X1FIT,X2FIT,YFIT)
% xlabel('distance from soma')
% ylabel('diameter from volume OLM')
% zlabel('number gpos syn OLM')
% text(200, 2, 0.2, txt189);
% view(50,10)
% hold off

[b,bint,r,rint,stats] = regress(y_7, X_5);
txt190 = ['R^2:' num2str(stats(1))];

figure(51)
scatter3(distance_from_soma_OLM, diameter_from_volume_OLM, gneg_syn_size_per_area_OLM,'filled')
hold on
x1fit = min(distance_from_soma_OLM):100:max(distance_from_soma_OLM);
x2fit = min(diameter_from_volume_OLM):0.1:max(diameter_from_volume_OLM);
[X1FIT,X2FIT] = meshgrid(x1fit,x2fit);
YFIT = b(1) + b(2)*X1FIT + b(3)*X2FIT;  % + b(4)*X1FIT.*X2FIT
mesh(X1FIT,X2FIT,YFIT)
xlabel('distance from soma')
ylabel('diameter from volume OLM')
zlabel('size gneg syn OLM')
text(200, 2, 0.2, txt190);
view(50,10)
hold off

[b,bint,r,rint,stats] = regress(y_8, X_5);
txt191 = ['R^2:' num2str(stats(1))];

figure(52)
scatter3(distance_from_soma_OLM, diameter_from_volume_OLM, gpos_syn_size_per_area_OLM,'filled')
hold on
x1fit = min(distance_from_soma_OLM):100:max(distance_from_soma_OLM);
x2fit = min(diameter_from_volume_OLM):0.1:max(diameter_from_volume_OLM);
[X1FIT,X2FIT] = meshgrid(x1fit,x2fit);
YFIT = b(1) + b(2)*X1FIT + b(3)*X2FIT;  % + b(4)*X1FIT.*X2FIT
mesh(X1FIT,X2FIT,YFIT)
xlabel('distance from soma')
ylabel('diameter from volume OLM')
zlabel('size gpos syn OLM')
text(200, 2, 0.2, txt191);
view(50,10)
hold off

% [b,bint,r,rint,stats] = regress(y_5, X_6);
% txt192 = ['R^2:' num2str(stats(1))];
% 
% figure(53)
% scatter3(dendritic_order_OLM, diameter_from_volume_OLM, number_gneg_syn_OLM,'filled')
% hold on
% x1fit = min(dendritic_order_OLM):1:max(dendritic_order_OLM);
% x2fit = min(diameter_from_volume_OLM):0.1:max(diameter_from_volume_OLM);
% [X1FIT,X2FIT] = meshgrid(x1fit,x2fit);
% YFIT = b(1) + b(2)*X1FIT + b(3)*X2FIT;  % + b(4)*X1FIT.*X2FIT
% yfit_order_diam_ngneg_OLM = b(1) + b(2)*dendritic_order_OLM + b(3)*diameter_from_volume_OLM;
% mesh(X1FIT,X2FIT,YFIT)
% xlabel('dendritic order OLM')
% ylabel('diameter from volume OLM')
% zlabel('number gneg syn OLM')
% text(4, 4, 0.3, txt192);
% view(50,10)
% hold off
% 
% [b,bint,r,rint,stats] = regress(y_6, X_6);
% txt193 = ['R^2:' num2str(stats(1))];
% 
% figure(54)
% scatter3(dendritic_order_OLM, diameter_from_volume_OLM, number_gpos_syn_OLM,'filled')
% hold on
% x1fit = min(dendritic_order_OLM):1:max(dendritic_order_OLM);
% x2fit = min(diameter_from_volume_OLM):0.1:max(diameter_from_volume_OLM);
% [X1FIT,X2FIT] = meshgrid(x1fit,x2fit);
% YFIT = b(1) + b(2)*X1FIT + b(3)*X2FIT;  % + b(4)*X1FIT.*X2FIT
% yfit_order_diam_ngpos_OLM = b(1) + b(2)*dendritic_order_OLM + b(3)*diameter_from_volume_OLM;
% mesh(X1FIT,X2FIT,YFIT)
% xlabel('dendritic order OLM')
% ylabel('diameter from volume OLM')
% zlabel('number gpos syn OLM')
% text(4, 4, 0.3, txt193);
% view(50,10)
% hold off

[b,bint,r,rint,stats] = regress(y_7, X_6);
txt194 = ['R^2:' num2str(stats(1))];

figure(55)
scatter3(dendritic_order_OLM, diameter_from_volume_OLM, gneg_syn_size_per_area_OLM,'filled')
hold on
x1fit = min(dendritic_order_OLM):1:max(dendritic_order_OLM);
x2fit = min(diameter_from_volume_OLM):0.1:max(diameter_from_volume_OLM);
[X1FIT,X2FIT] = meshgrid(x1fit,x2fit);
YFIT = b(1) + b(2)*X1FIT + b(3)*X2FIT;  % + b(4)*X1FIT.*X2FIT
mesh(X1FIT,X2FIT,YFIT)
xlabel('dendritic order OLM')
ylabel('diameter from volume OLM')
zlabel('gneg syn size per area OLM')
text(2, 2, 0.2, txt194);
view(50,10)
hold off

[b,bint,r,rint,stats] = regress(y_8, X_6);
txt195 = ['R^2:' num2str(stats(1))];

figure(56)
scatter3(dendritic_order_OLM, diameter_from_volume_OLM, gpos_syn_size_per_area_OLM,'filled')
hold on
x1fit = min(dendritic_order_OLM):1:max(dendritic_order_OLM);
x2fit = min(diameter_from_volume_OLM):0.1:max(diameter_from_volume_OLM);
[X1FIT,X2FIT] = meshgrid(x1fit,x2fit);
YFIT = b(1) + b(2)*X1FIT + b(3)*X2FIT;  % + b(4)*X1FIT.*X2FIT
mesh(X1FIT,X2FIT,YFIT)
xlabel('dendritic order OLM')
ylabel('diameter from volume OLM')
zlabel('gpos syn size per area OLM')
text(2, 2, 0.2, txt195);
view(50,10)
hold off

%%
X_7 = [ones(size(distance_from_soma_HS)).' distance_from_soma_HS.' dendritic_order_HS.', diameter_from_volume_HS.'];
X_8 = [ones(size(distance_from_soma_OLM)).' distance_from_soma_OLM.' dendritic_order_OLM.', diameter_from_volume_OLM.'];

% y = number_gneg_syn_HS.';
% y_2 = number_gpos_syn_HS.';
% y_3 = gneg_syn_size_per_area_HS.';
% y_4 = gpos_syn_size_per_area_HS.';
% 
% y_5 = number_gneg_syn_OLM.';
% y_6 = number_gpos_syn_OLM.';
% y_7 = gneg_syn_size_per_area_OLM.';
% y_8 = gpos_syn_size_per_area_OLM.';

[b,bint,r,rint,stats] = regress(y, X_7);
r2_for_num_gneg_HS = stats(1)
yfit_ngneg_HS_for_all = b(1) + b(2)*distance_from_soma_HS + b(3)*dendritic_order_HS + b(4)*diameter_from_volume_HS;

[b,bint,r,rint,stats] = regress(y_2, X_7);
r2_for_num_gpos_HS = stats(1)
yfit_ngpos_HS_for_all = b(1) + b(2)*distance_from_soma_HS + b(3)*dendritic_order_HS + b(4)*diameter_from_volume_HS


[b,bint,r,rint,stats] = regress(y_3, X_7);
r2_for_size_gneg_HS = stats(1)

[b,bint,r,rint,stats] = regress(y_4, X_7);
r2_for_size_gpos_HS = stats(1)

[b,bint,r,rint,stats] = regress(y_5, X_8);
r2_for_num_gneg_OLM = stats(1)
yfit_ngneg_OLM_for_all = b(1) + b(2)*distance_from_soma_OLM + b(3)*dendritic_order_OLM + b(4)*diameter_from_volume_OLM;


[b,bint,r,rint,stats] = regress(y_6, X_8);
r2_for_num_gpos_OLM = stats(1)
yfit_ngpos_OLM_for_all = b(1) + b(2)*distance_from_soma_OLM + b(3)*dendritic_order_OLM + b(4)*diameter_from_volume_OLM;


[b,bint,r,~,stats] = regress(y_7, X_8);
r2_for_size_gneg_OLM = stats(1)

[b,bint,r,rint,stats] = regress(y_8, X_8);
r2_for_size_gpos_OLM = stats(1)

%%

ratio_of_gneg_gpos_HS = number_gneg_syn_HS./number_gpos_syn_HS;

ratio_of_gneg_gpos_OLM = number_gneg_syn_OLM./number_gpos_syn_OLM;

Inf_indices = find(~isfinite(ratio_of_gneg_gpos_OLM));
%NaN_indices = find(~isnan(ratio_of_gneg_gpos_OLM))
ratio_of_gneg_gpos_OLM_corrected = ratio_of_gneg_gpos_OLM;
ratio_of_gneg_gpos_OLM_corrected(Inf_indices) = [];

distance_from_soma_OLM_corrected = distance_from_soma_OLM;
dendritic_order_OLM_corrected = dendritic_order_OLM;
diameter_from_volume_OLM_corrected = diameter_from_volume_OLM;

distance_from_soma_OLM_corrected(Inf_indices) = [];
dendritic_order_OLM_corrected(Inf_indices) = [];
diameter_from_volume_OLM_corrected(Inf_indices) = [];

[rho_dist_num_gneg_HS_ratio, pval_dist_num_gneg_HS_ratio]= corr(distance_from_soma_HS',ratio_of_gneg_gpos_HS','rows','pairwise','Type','Spearman');
[rho_dist_num_gneg_OLM_ratio, pval_dist_num_gneg_OLM_ratio]= corr(distance_from_soma_OLM_corrected',ratio_of_gneg_gpos_OLM_corrected','rows','pairwise','Type','Spearman');

[rho_order_num_gneg_HS_ratio, pval_order_num_gneg_HS_ratio]= corr(dendritic_order_HS',ratio_of_gneg_gpos_HS','rows','pairwise','Type','Spearman');
[rho_order_num_gneg_OLM_ratio, pval_order_num_gneg_OLM_ratio]= corr(dendritic_order_OLM_corrected',ratio_of_gneg_gpos_OLM_corrected','rows','pairwise','Type','Spearman');

[rho_diam_num_gneg_HS_ratio, pval_diam_num_gneg_HS_ratio]= corr(diameter_from_volume_HS',ratio_of_gneg_gpos_HS','rows','pairwise','Type','Spearman');
[rho_diam_num_gneg_OLM_ratio, pval_diam_num_gneg_OLM_ratio]= corr(diameter_from_volume_OLM_corrected',ratio_of_gneg_gpos_OLM_corrected','rows','pairwise','Type','Spearman');

dist_ratio_gneg_HS_fit = fitlm(distance_from_soma_HS,ratio_of_gneg_gpos_HS);
dist_ratio_gneg_OLM_fit = fitlm(distance_from_soma_OLM_corrected,ratio_of_gneg_gpos_OLM_corrected);

order_ratio_gneg_HS_fit = fitlm(dendritic_order_HS,ratio_of_gneg_gpos_HS);
order_ratio_gneg_OLM_fit = fitlm(dendritic_order_OLM_corrected,ratio_of_gneg_gpos_OLM_corrected);

diam_ratio_gneg_HS_fit = fitlm(diameter_from_volume_HS,ratio_of_gneg_gpos_HS);
diam_ratio_gneg_OLM_fit = fitlm(diameter_from_volume_OLM_corrected,ratio_of_gneg_gpos_OLM_corrected);

figure(57)
hold on;
scatter(diameter_from_volume_HS, ratio_of_gneg_gpos_HS, "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880]);
lsline
scatter(diameter_from_volume_OLM_corrected, ratio_of_gneg_gpos_OLM_corrected, "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560]);
lsline
title('Ratio of excitatory/inhibitory syn vs. Diam')
legend('Ratio HS', 'Ratio fitted line HS', 'Ratio OLM', 'Ratio fitted line OLM');
xlabel('Diam')
ylabel('Ratio of excitatory/inhibitory syn')
txt196 = ['pval HS:' num2str(pval_diam_num_gneg_HS_ratio)];
txt197 = ['pval OLM:' num2str(pval_diam_num_gneg_OLM_ratio)];
txt202=['R^2 ratio HS:' num2str(diam_ratio_gneg_HS_fit.Rsquared.Ordinary)];
txt203=['R^2 ratio OLM:' num2str(diam_ratio_gneg_OLM_fit.Rsquared.Ordinary)];
text(2, 20,txt196)
text(2, 21,txt197)
text(2, 22,txt202)
text(2, 23,txt203)

figure(58)
hold on;
scatter(dendritic_order_HS, ratio_of_gneg_gpos_HS, "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880]);
lsline
scatter(dendritic_order_OLM_corrected, ratio_of_gneg_gpos_OLM_corrected, "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560]);
lsline
title('Ratio of excitatory/inhibitory syn vs. Order')
legend('Ratio HS', 'Ratio fitted line HS', 'Ratio OLM', 'Ratio fitted line OLM');
xlabel('Order')
ylabel('Ratio of excitatory/inhibitory syn')
txt198 = ['pval HS:' num2str(pval_order_num_gneg_HS_ratio)];
txt199 = ['pval OLM:' num2str(pval_order_num_gneg_OLM_ratio)];
txt204=['R^2 ratio HS:' num2str(order_ratio_gneg_HS_fit.Rsquared.Ordinary)];
txt205=['R^2 ratio OLM:' num2str(order_ratio_gneg_OLM_fit.Rsquared.Ordinary)];
text(7, 20,txt198)
text(7, 21,txt199)
text(7, 22,txt204)
text(7, 23,txt205)

figure(59)
hold on;
scatter(distance_from_soma_HS, ratio_of_gneg_gpos_HS, "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880]);
lsline
scatter(distance_from_soma_OLM_corrected, ratio_of_gneg_gpos_OLM_corrected, "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560]);
lsline
title('Ratio of excitatory/inhibitory syn vs. Distance')
legend('Ratio HS', 'Ratio fitted line HS', 'Ratio OLM', 'Ratio fitted line OLM');
xlabel('Distance')
ylabel('Ratio of excitatory/inhibitory syn')
txt200 = ['pval HS:' num2str(pval_dist_num_gneg_HS_ratio)];
txt201 = ['pval OLM:' num2str(pval_dist_num_gneg_OLM_ratio)];
txt206=['R^2 ratio HS:' num2str(dist_ratio_gneg_HS_fit.Rsquared.Ordinary)];
txt207=['R^2 ratio OLM:' num2str(dist_ratio_gneg_OLM_fit.Rsquared.Ordinary)];
text(300, 20,txt200)
text(300, 21,txt201)
text(300, 22,txt206)
text(300, 23,txt207)

%% Bayesian information Criterion

dfs_ngns_HS = fitlm(distance_from_soma_HS, number_gneg_syn_HS);
MSE_dfs_ngns_HS = 1.79^2;
number_gneg_syn_HS_corr = number_gneg_syn_HS(~isnan(number_gneg_syn_HS));
BIC_dfs_ngns_HS = numel(number_gneg_syn_HS_corr)*log(MSE_dfs_ngns_HS)+2*log(numel(number_gneg_syn_HS_corr))

dfs_ngps_HS = fitlm(distance_from_soma_HS, number_gpos_syn_HS);
MSE_dfs_ngps_HS = 0.512^2;
number_gpos_syn_HS_corr = number_gpos_syn_HS(~isnan(number_gpos_syn_HS));
BIC_dfs_ngps_HS = numel(number_gpos_syn_HS_corr)*log(MSE_dfs_ngps_HS)+2*log(numel(number_gpos_syn_HS_corr))

do_ngns_HS = fitlm(dendritic_order_HS, number_gneg_syn_HS);
MSE_do_ngns_HS = 1.86^2;
BIC_do_ngns_HS = numel(number_gneg_syn_HS_corr)*log(MSE_do_ngns_HS)+2*log(numel(number_gneg_syn_HS_corr))

do_ngps_HS = fitlm(dendritic_order_HS, number_gpos_syn_HS);
MSE_do_ngps_HS = 0.515^2;
BIC_do_ngps_HS = numel(number_gpos_syn_HS_corr)*log(MSE_do_ngps_HS)+2*log(numel(number_gpos_syn_HS_corr))

diam_ngns_HS = fitlm(diameter_from_volume_HS, number_gneg_syn_HS);
MSE_diam_ngns_HS = 1.14^2;
BIC_diam_ngns_HS = numel(number_gneg_syn_HS_corr)*log(MSE_diam_ngns_HS)+2*log(numel(number_gneg_syn_HS_corr))

diam_ngps_HS = fitlm(diameter_from_volume_HS, number_gpos_syn_HS);
MSE_diam_ngps_HS = 0.404^2;
BIC_diam_ngps_HS = numel(number_gpos_syn_HS_corr)*log(MSE_diam_ngps_HS)+2*log(numel(number_gpos_syn_HS_corr))

dfs_ngns_OLM = fitlm(distance_from_soma_OLM, number_gneg_syn_OLM);
number_gneg_syn_OLM_corr = number_gneg_syn_OLM(~isnan(number_gneg_syn_OLM));
MSE_dfs_ngns_OLM = 0.668^2;
BIC_dfs_ngns_OLM = numel(number_gneg_syn_OLM_corr)*log(MSE_dfs_ngns_OLM)+2*log(numel(number_gneg_syn_OLM_corr))

dfs_ngps_OLM = fitlm(distance_from_soma_OLM, number_gpos_syn_OLM);
number_gpos_syn_OLM_corr = number_gpos_syn_OLM(~isnan(number_gpos_syn_OLM));
MSE_dfs_ngps_OLM = 0.264^2;
BIC_dfs_ngps_OLM = numel(number_gpos_syn_OLM_corr)*log(MSE_dfs_ngps_OLM)+2*log(numel(number_gpos_syn_OLM_corr))

do_ngns_OLM = fitlm(dendritic_order_OLM, number_gneg_syn_OLM);
MSE_do_ngns_OLM = 0.711^2;
BIC_do_ngns_OLM = numel(number_gneg_syn_OLM_corr)*log(MSE_do_ngns_OLM)+2*log(numel(number_gneg_syn_OLM_corr))

do_ngps_OLM = fitlm(dendritic_order_OLM, number_gpos_syn_OLM);
MSE_do_ngps_OLM = 0.253^2;
BIC_do_ngps_OLM = numel(number_gpos_syn_OLM_corr)*log(MSE_do_ngps_OLM)+2*log(numel(number_gpos_syn_OLM_corr))

diam_ngns_OLM = fitlm(diameter_from_volume_OLM, number_gneg_syn_OLM);
MSE_diam_ngns_OLM = 0.613^2;
BIC_diam_ngns_OLM = numel(number_gneg_syn_OLM_corr)*log(MSE_diam_ngns_OLM)+2*log(numel(number_gneg_syn_OLM_corr))

diam_ngps_OLM = fitlm(diameter_from_volume_OLM, number_gpos_syn_OLM);
MSE_diam_ngps_OLM = 0.231^2;
BIC_diam_ngps_OLM = numel(number_gpos_syn_OLM_corr)*log(MSE_diam_ngps_OLM)+2*log(numel(number_gpos_syn_OLM_corr))

RSS_dist_diam_ngneg_HS = nansum((number_gneg_syn_HS-yfit_dist_diam_ngneg_HS).^2);
RSS_dist_diam_ngneg_OLM = nansum((number_gneg_syn_OLM-yfit_dist_diam_ngneg_OLM).^2);
RSS_dist_diam_ngpos_HS = nansum((number_gpos_syn_HS-yfit_dist_diam_ngpos_HS).^2);
RSS_dist_diam_ngpos_OLM = nansum((number_gpos_syn_OLM-yfit_dist_diam_ngpos_OLM).^2);

BIC_dist_diam_ngneg_HS = numel(number_gneg_syn_HS_corr)*log(RSS_dist_diam_ngneg_HS/numel(number_gneg_syn_HS_corr))+3*log(numel(number_gneg_syn_HS_corr))
BIC_dist_diam_ngneg_OLM = numel(number_gneg_syn_OLM_corr)*log(RSS_dist_diam_ngneg_OLM/numel(number_gneg_syn_OLM_corr))+3*log(numel(number_gneg_syn_OLM_corr))
BIC_dist_diam_ngpos_HS = numel(number_gpos_syn_HS_corr)*log(RSS_dist_diam_ngpos_HS/numel(number_gpos_syn_HS_corr))+3*log(numel(number_gpos_syn_HS_corr))
BIC_dist_diam_ngpos_OLM = numel(number_gpos_syn_OLM_corr)*log(RSS_dist_diam_ngpos_OLM/numel(number_gpos_syn_OLM_corr))+3*log(numel(number_gpos_syn_OLM_corr))

RSS_dist_order_ngneg_HS = nansum((number_gneg_syn_HS-yfit_dist_order_ngneg_HS).^2);
RSS_dist_order_ngneg_OLM =nansum((number_gneg_syn_OLM-yfit_dist_order_ngneg_OLM).^2);
RSS_dist_order_ngpos_HS = nansum((number_gpos_syn_HS-yfit_dist_order_ngpos_HS).^2);
RSS_dist_order_ngpos_OLM = nansum((number_gpos_syn_OLM-yfit_dist_order_ngpos_OLM).^2);

BIC_dist_order_ngneg_HS = numel(number_gneg_syn_HS_corr)*log(RSS_dist_order_ngneg_HS/numel(number_gneg_syn_HS_corr))+3*log(numel(number_gneg_syn_HS_corr))
BIC_dist_order_ngneg_OLM = numel(number_gneg_syn_OLM_corr)*log(RSS_dist_order_ngneg_OLM/numel(number_gneg_syn_OLM_corr))+3*log(numel(number_gneg_syn_OLM_corr))
BIC_dist_order_ngpos_HS = numel(number_gpos_syn_HS_corr)*log(RSS_dist_order_ngpos_HS/numel(number_gpos_syn_HS_corr))+3*log(numel(number_gpos_syn_HS_corr))
BIC_dist_order_ngpos_OLM = numel(number_gpos_syn_OLM_corr)*log(RSS_dist_order_ngpos_OLM/numel(number_gpos_syn_OLM_corr))+3*log(numel(number_gpos_syn_OLM_corr))

RSS_order_diam_ngneg_HS = nansum((number_gneg_syn_HS-yfit_order_diam_ngneg_HS).^2);
RSS_order_diam_ngneg_OLM = nansum((number_gneg_syn_OLM-yfit_order_diam_ngneg_OLM).^2);
RSS_order_diam_ngpos_HS = nansum((number_gpos_syn_HS-yfit_order_diam_ngpos_HS ).^2);
RSS_order_diam_ngpos_OLM = nansum((number_gpos_syn_OLM-yfit_order_diam_ngpos_OLM).^2);

BIC_order_diam_ngneg_HS = numel(number_gneg_syn_HS_corr)*log(RSS_order_diam_ngneg_HS/numel(number_gneg_syn_HS_corr))+3*log(numel(number_gneg_syn_HS_corr))
BIC_order_diam_ngneg_OLM = numel(number_gneg_syn_OLM_corr)*log(RSS_order_diam_ngneg_OLM/numel(number_gneg_syn_OLM_corr))+3*log(numel(number_gneg_syn_OLM_corr))
BIC_order_diam_ngpos_HS = numel(number_gpos_syn_HS_corr)*log(RSS_order_diam_ngpos_HS/numel(number_gpos_syn_HS_corr))+3*log(numel(number_gpos_syn_HS_corr))
BIC_order_diam_ngpos_OLM = numel(number_gpos_syn_OLM_corr)*log(RSS_order_diam_ngpos_OLM/numel(number_gpos_syn_OLM_corr))+3*log(numel(number_gpos_syn_OLM_corr))


RSS_all_gneg_HS = nansum((number_gneg_syn_HS-yfit_ngneg_HS_for_all).^2);
RSS_all_gneg_OLM = nansum((number_gneg_syn_OLM-yfit_ngneg_OLM_for_all).^2);
RSS_all_gpos_HS = nansum((number_gpos_syn_HS-yfit_ngpos_HS_for_all).^2);
RSS_all_gpos_OLM = nansum((number_gpos_syn_OLM-yfit_ngpos_OLM_for_all).^2);

BIC_all_gneg_HS = numel(number_gneg_syn_HS_corr)*log(RSS_all_gneg_HS/numel(number_gneg_syn_HS_corr))+4*log(numel(number_gneg_syn_HS_corr))
BIC_all_gneg_OLM = numel(number_gneg_syn_OLM_corr)*log(RSS_all_gneg_OLM/numel(number_gneg_syn_OLM_corr))+4*log(numel(number_gneg_syn_OLM_corr))
BIC_all_gpos_HS = numel(number_gpos_syn_HS_corr)*log(RSS_all_gpos_HS/numel(number_gpos_syn_HS_corr))+4*log(numel(number_gpos_syn_HS_corr))
BIC_all_gpos_OLM = numel(number_gpos_syn_OLM_corr)*log(RSS_all_gpos_OLM/numel(number_gpos_syn_OLM_corr))+4*log(numel(number_gpos_syn_OLM_corr))

%% Figures of num/area

num_per_surf_gneg_HS = number_gneg_syn_HS./surface_area_HS;
num_per_surf_gpos_HS = number_gpos_syn_HS./surface_area_HS;

num_per_surf_gneg_OLM = number_gneg_syn_OLM./surface_area_OLM;
num_per_surf_gpos_OLM = number_gpos_syn_OLM./surface_area_OLM;

fit_of_gneg_HS_to_dist = fitlm(distance_from_soma_HS ,num_per_surf_gneg_HS);
fit_of_gneg_HS_to_diam = fitlm(diameter_from_volume_HS, num_per_surf_gneg_HS);
fit_of_gneg_HS_to_order = fitlm(dendritic_order_HS, num_per_surf_gneg_HS);

fit_of_gpos_HS_to_dist = fitlm(distance_from_soma_HS,num_per_surf_gpos_HS);
fit_of_gpos_HS_to_diam = fitlm(diameter_from_volume_HS, num_per_surf_gpos_HS);
fit_of_gpos_HS_to_order = fitlm(dendritic_order_HS, num_per_surf_gpos_HS);

fit_of_gneg_OLM_to_dist = fitlm(distance_from_soma_OLM,num_per_surf_gneg_OLM);
fit_of_gneg_OLM_to_diam = fitlm(diameter_from_volume_OLM, num_per_surf_gneg_OLM);
fit_of_gneg_OLM_to_order = fitlm(dendritic_order_OLM, num_per_surf_gneg_OLM);

fit_of_gpos_OLM_to_dist = fitlm(distance_from_soma_OLM,num_per_surf_gpos_OLM);
fit_of_gpos_OLM_to_diam = fitlm(diameter_from_volume_OLM, num_per_surf_gpos_OLM);
fit_of_gpos_OLM_to_order = fitlm(dendritic_order_OLM, num_per_surf_gpos_OLM);

[rho_dist_num_per_surf_gneg_hs, pval_dist_num_per_surf_gneg_hs]= corr(distance_from_soma_HS',num_per_surf_gneg_HS','rows','pairwise','Type','Spearman');
[rho_dist_num_per_surf_gpos_hs, pval_dist_num_per_surf_gpos_hs]= corr(distance_from_soma_HS',num_per_surf_gpos_HS','rows','pairwise','Type','Spearman');
[rho_diam_num_per_surf_gneg_hs, pval_diam_num_per_surf_gneg_hs]= corr(diameter_from_volume_HS',num_per_surf_gneg_HS','rows','pairwise','Type','Spearman');
[rho_diam_num_per_surf_gpos_hs, pval_diam_num_per_surf_gpos_hs]= corr(diameter_from_volume_HS',num_per_surf_gpos_HS','rows','pairwise','Type','Spearman');
[rho_order_num_per_surf_gneg_hs, pval_order_num_per_surf_gneg_hs]= corr(dendritic_order_HS',num_per_surf_gneg_HS','rows','pairwise','Type','Spearman');
[rho_order_num_per_surf_gpos_hs, pval_order_num_per_surf_gpos_hs]= corr(dendritic_order_HS',num_per_surf_gpos_HS','rows','pairwise','Type','Spearman');

[rho_dist_num_per_surf_gneg_olm, pval_dist_num_per_surf_gneg_olm]= corr(distance_from_soma_OLM',num_per_surf_gneg_OLM','rows','pairwise','Type','Spearman');
[rho_dist_num_per_surf_gpos_olm, pval_dist_num_per_surf_gpos_olm]= corr(distance_from_soma_OLM',num_per_surf_gpos_OLM','rows','pairwise','Type','Spearman');
[rho_diam_num_per_surf_gneg_olm, pval_diam_num_per_surf_gneg_olm]= corr(diameter_from_volume_OLM',num_per_surf_gneg_OLM','rows','pairwise','Type','Spearman');
[rho_diam_num_per_surf_gpos_olm, pval_diam_num_per_surf_gpos_olm]= corr(diameter_from_volume_OLM',num_per_surf_gpos_OLM','rows','pairwise','Type','Spearman');
[rho_order_num_per_surf_gneg_olm, pval_order_num_per_surf_gneg_olm]= corr(dendritic_order_OLM',num_per_surf_gneg_OLM','rows','pairwise','Type','Spearman');
[rho_order_num_per_surf_gpos_olm, pval_order_num_per_surf_gpos_olm]= corr(dendritic_order_OLM',num_per_surf_gpos_OLM','rows','pairwise','Type','Spearman');

%%
figure(60)
hold on;
scatter(distance_from_soma_HS, num_per_surf_gneg_HS, "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880]);
lsline
scatter(distance_from_soma_OLM, num_per_surf_gneg_OLM, "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560]);
lsline
title('Number of gneg synapses / area vs. Distance')
legend('Gneg HS per area', 'Gneg fitted line HS', 'Gneg OLM per area', 'Gneg fitted line OLM');
xlabel('Distance')
ylabel('Number of synapses / um2 area')
txt208=['R^2 gns HS:' num2str(fit_of_gneg_HS_to_dist.Rsquared.Ordinary)];
txt209 = ['R^2 gns OLM:' num2str(fit_of_gneg_OLM_to_dist.Rsquared.Ordinary)];
txt210 = ['rho HS:' num2str(rho_dist_num_per_surf_gneg_hs)];
txt211 = ['pval HS:' num2str(pval_dist_num_per_surf_gneg_hs)];
txt212 = ['rho OLM:' num2str(rho_dist_num_per_surf_gneg_olm)];
txt213 = ['pval OLM:' num2str(pval_dist_num_per_surf_gneg_olm)];
text(300,0.8,txt208)
text(300,0.7,txt209)
text(300,0.6,txt210)
text(300,0.5,txt211)
text(300,0.4,txt212)
text(300,0.3,txt213)

figure(61)
hold on;
scatter(distance_from_soma_HS, num_per_surf_gpos_HS, "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880]);
lsline
scatter(distance_from_soma_OLM, num_per_surf_gpos_OLM, "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560]);
lsline
title('Number of gpos synapses / area vs. Distance')
legend('Gpos HS per area', 'Gpos fitted line HS', 'Gpos OLM per area', 'Gpos fitted line OLM');
xlabel('Distance')
ylabel('Number of synapses / um2 area')
txt214=['R^2 gps HS:' num2str(fit_of_gpos_HS_to_dist.Rsquared.Ordinary)];
txt215 = ['R^2 gps OLM:' num2str(fit_of_gpos_OLM_to_dist.Rsquared.Ordinary)];
txt216 = ['rho HS:' num2str(rho_dist_num_per_surf_gpos_hs)];
txt217 = ['pval HS:' num2str(pval_dist_num_per_surf_gpos_hs)];
txt218 = ['rho OLM:' num2str(rho_dist_num_per_surf_gpos_olm)];
txt219 = ['pval OLM:' num2str(pval_dist_num_per_surf_gpos_olm)];
text(300,0.3,txt214)
text(300,0.28,txt215)
text(300,0.26,txt216)
text(300,0.24,txt217)
text(300,0.22,txt218)
text(300,0.2,txt219)

figure(62)
hold on;
scatter(diameter_from_volume_HS, num_per_surf_gneg_HS, "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880]);
lsline
scatter(diameter_from_volume_OLM, num_per_surf_gneg_OLM, "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560]);
lsline
title('Number of gneg synapses / area vs. Diameter')
legend('Gneg HS per area', 'Gneg fitted line HS', 'Gneg OLM per area', 'Gneg fitted line OLM');
xlabel('Diameter')
ylabel('Number of synapses / um2 area')
txt220=['R^2 gns HS:' num2str(fit_of_gneg_HS_to_diam.Rsquared.Ordinary)];
txt221=['R^2 gns OLM:' num2str(fit_of_gneg_OLM_to_diam.Rsquared.Ordinary)];
txt222 = ['rho HS:' num2str(rho_diam_num_per_surf_gneg_hs)];
txt223 = ['pval HS:' num2str(pval_diam_num_per_surf_gneg_hs)];
txt224 = ['rho OLM:' num2str(rho_diam_num_per_surf_gneg_olm)];
txt225 = ['pval OLM:' num2str(pval_diam_num_per_surf_gneg_olm)];
text(2,0.8,txt220)
text(2,0.7,txt221)
text(2,0.6,txt222)
text(2,0.5,txt223)
text(2,0.4,txt224)
text(2,0.3,txt225)

figure(63)
hold on;
scatter(diameter_from_volume_HS, num_per_surf_gpos_HS, "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880]);
lsline
scatter(diameter_from_volume_OLM, num_per_surf_gpos_OLM, "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560]);
lsline
title('Number of gpos synapses / area vs. Diameter')
legend('Gpos HS per area', 'Gpos fitted line HS', 'Gpos OLM per area', 'Gpos fitted line OLM');
xlabel('Diameter')
ylabel('Number of synapses / um2 area')
txt220=['R^2 gps HS:' num2str(fit_of_gpos_HS_to_diam.Rsquared.Ordinary)];
txt221=['R^2 gps OLM:' num2str(fit_of_gpos_OLM_to_diam.Rsquared.Ordinary)];
txt222 = ['rho HS:' num2str(rho_diam_num_per_surf_gpos_hs)];
txt223 = ['pval HS:' num2str(pval_diam_num_per_surf_gpos_hs)];
txt224 = ['rho OLM:' num2str(rho_diam_num_per_surf_gpos_olm)];
txt225 = ['pval OLM:' num2str(pval_diam_num_per_surf_gpos_olm)];
text(2,0.3,txt220)
text(2,0.28,txt221)
text(2,0.26,txt222)
text(2,0.24,txt223)
text(2,0.22,txt224)
text(2,0.2,txt225)

figure(64)
hold on;
scatter(dendritic_order_HS, num_per_surf_gpos_HS, "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880]);
lsline
scatter(dendritic_order_OLM, num_per_surf_gpos_OLM, "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560]);
lsline
title('Number of gpos synapses / area vs. Order')
legend('Gpos HS per area', 'Gpos fitted line HS', 'Gpos OLM per area', 'Gpos fitted line OLM');
xlabel('Order')
ylabel('Number of synapses / um2 area')
txt226=['R^2 gps HS:' num2str(fit_of_gpos_HS_to_order.Rsquared.Ordinary)];
txt227=['R^2 gps OLM:' num2str(fit_of_gpos_OLM_to_order.Rsquared.Ordinary)];
txt228 = ['rho HS:' num2str(rho_order_num_per_surf_gpos_hs)];
txt229 = ['pval HS:' num2str(pval_order_num_per_surf_gpos_hs)];
txt230 = ['rho OLM:' num2str(rho_order_num_per_surf_gpos_olm)];
txt231 = ['pval OLM:' num2str(pval_order_num_per_surf_gpos_olm)];
text(8,0.3,txt226)
text(8,0.28,txt227)
text(8,0.26,txt228)
text(8,0.24,txt229)
text(8,0.22,txt230)
text(8,0.2,txt231)

figure(65)
hold on;
scatter(dendritic_order_HS, num_per_surf_gneg_HS, "MarkerFaceColor", [0.4660 0.6740 0.1880], "MarkerEdgeColor", [0.4660 0.6740 0.1880]);
lsline
scatter(dendritic_order_OLM, num_per_surf_gneg_OLM, "MarkerFaceColor", [0.4940 0.1840 0.5560], "MarkerEdgeColor", [0.4940 0.1840 0.5560]);
lsline
title('Number of gneg synapses / area vs. Order')
legend('Gneg HS per area', 'Gneg fitted line HS', 'Gneg OLM per area', 'Gneg fitted line OLM');
xlabel('Order')
ylabel('Number of synapses / um2 area')
txt232=['R^2 gns HS:' num2str(fit_of_gneg_HS_to_order.Rsquared.Ordinary)];
txt233=['R^2 gns OLM:' num2str(fit_of_gneg_OLM_to_order.Rsquared.Ordinary)];
txt234 = ['rho HS:' num2str(rho_order_num_per_surf_gneg_hs)];
txt235 = ['pval HS:' num2str(pval_order_num_per_surf_gneg_hs)];
txt236 = ['rho OLM:' num2str(rho_order_num_per_surf_gneg_olm)];
txt237 = ['pval OLM:' num2str(pval_order_num_per_surf_gneg_olm)];
text(8,0.8,txt232)
text(8,0.7,txt233)
text(8,0.6,txt234)
text(8,0.5,txt235)
text(8,0.4,txt236)
text(8,0.3,txt237)

%% 3D num/area


X_surf = [ones(size(distance_from_soma_HS)).' distance_from_soma_HS.' dendritic_order_HS.'];
X_2_surf = [ones(size(distance_from_soma_HS)).' distance_from_soma_HS.' diameter_from_volume_HS.'];
X_3_surf = [ones(size(dendritic_order_HS)).' dendritic_order_HS.' diameter_from_volume_HS.'];

y_surf = num_per_surf_gneg_HS.';
y_2_surf = num_per_surf_gpos_HS.';

X_4_surf = [ones(size(distance_from_soma_OLM)).' distance_from_soma_OLM.' dendritic_order_OLM.'];
X_5_surf = [ones(size(distance_from_soma_OLM)).' distance_from_soma_OLM.' diameter_from_volume_OLM.'];
X_6_surf = [ones(size(dendritic_order_OLM)).' dendritic_order_OLM.' diameter_from_volume_OLM.'];

y_5_surf = num_per_surf_gneg_OLM.';
y_6_surf = num_per_surf_gpos_OLM.';

[b,bint,r,rint,stats] = regress(y_surf, X_surf);
txt173 = ['R^2:' num2str(stats(1))];

figure(66)
scatter3(distance_from_soma_HS, dendritic_order_HS, num_per_surf_gneg_HS,'filled')
hold on
x1fit = min(distance_from_soma_HS):100:max(distance_from_soma_HS);
x2fit = min(dendritic_order_HS):1:max(dendritic_order_HS);
[X1FIT,X2FIT] = meshgrid(x1fit,x2fit);
YFIT = b(1) + b(2)*X1FIT + b(3)*X2FIT;  % + b(4)*X1FIT.*X2FIT
yfit_dist_order_ngneg_HS_surf = b(1) + b(2)*distance_from_soma_HS + b(3)*dendritic_order_HS;
mesh(X1FIT,X2FIT,YFIT)
xlabel('distance from soma')
ylabel('dendritic order')
zlabel('number gneg syn HS')
text(200, 4, 2, txt173);
view(50,10)
hold off

[b,bint,r,rint,stats] = regress(y_2_surf, X_surf);
txt174 = ['R^2:' num2str(stats(1))];

figure(67)
scatter3(distance_from_soma_HS, dendritic_order_HS, num_per_surf_gpos_HS,'filled')
hold on
x1fit = min(distance_from_soma_HS):100:max(distance_from_soma_HS);
x2fit = min(dendritic_order_HS):1:max(dendritic_order_HS);
[X1FIT,X2FIT] = meshgrid(x1fit,x2fit);
YFIT = b(1) + b(2)*X1FIT + b(3)*X2FIT;  % + b(4)*X1FIT.*X2FIT
yfit_dist_order_ngpos_HS_surf = b(1) + b(2)*distance_from_soma_HS + b(3)*dendritic_order_HS;
mesh(X1FIT,X2FIT,YFIT)
xlabel('distance from soma')
ylabel('dendritic order')
zlabel('number gpos syn HS')
text(200, 4, 2, txt174);
view(50,10)
hold off



[b,bint,r,rint,stats] = regress(y_surf, X_2_surf);
txt177 = ['R^2:' num2str(stats(1))];

figure(68)
scatter3(distance_from_soma_HS, diameter_from_volume_HS, num_per_surf_gneg_HS,'filled')
hold on
x1fit = min(distance_from_soma_HS):100:max(distance_from_soma_HS);
x2fit = min(diameter_from_volume_HS):0.1:max(diameter_from_volume_HS);
[X1FIT,X2FIT] = meshgrid(x1fit,x2fit);
YFIT = b(1) + b(2)*X1FIT + b(3)*X2FIT;  % + b(4)*X1FIT.*X2FIT
yfit_dist_diam_ngneg_HS_surf =  b(1) + b(2)*distance_from_soma_HS + b(3)*diameter_from_volume_HS;
coeffs_dist_diam_ngneg_HS_surf = b;
mesh(X1FIT,X2FIT,YFIT)
xlabel('distance from soma')
ylabel('diameter from volume HS')
zlabel('number gneg syn HS')
text(200, 4, 0.3, txt177);
view(50,10)
hold off

[b,bint,r,rint,stats] = regress(y_2_surf, X_2_surf);
txt178 = ['R^2:' num2str(stats(1))];

figure(69)
scatter3(distance_from_soma_HS, diameter_from_volume_HS, num_per_surf_gpos_HS,'filled')
hold on
x1fit = min(distance_from_soma_HS):100:max(distance_from_soma_HS);
x2fit = min(diameter_from_volume_HS):0.1:max(diameter_from_volume_HS);
[X1FIT,X2FIT] = meshgrid(x1fit,x2fit);
YFIT = b(1) + b(2)*X1FIT + b(3)*X2FIT;  % + b(4)*X1FIT.*X2FIT
yfit_dist_diam_ngpos_HS_surf = b(1) + b(2)*distance_from_soma_HS + b(3)*diameter_from_volume_HS;
coeffs_dist_diam_ngpos_HS_surf = b;
mesh(X1FIT,X2FIT,YFIT)
xlabel('distance from soma')
ylabel('diameter from volume HS')
zlabel('number gpos syn HS')
text(200, 2, 0.3, txt178);
view(50,10)
hold off


[b,bint,r,~,stats] = regress(y_surf, X_3_surf);
txt181 = ['R^2:' num2str(stats(1))];

figure(70)
scatter3(dendritic_order_HS, diameter_from_volume_HS, num_per_surf_gneg_HS,'filled')
hold on
x1fit = min(dendritic_order_HS):1:max(dendritic_order_HS);
x2fit = min(diameter_from_volume_HS):0.1:max(diameter_from_volume_HS);
[X1FIT,X2FIT] = meshgrid(x1fit,x2fit);
YFIT = b(1) + b(2)*X1FIT + b(3)*X2FIT;  % + b(4)*X1FIT.*X2FIT
yfit_order_diam_ngneg_HS_surf = b(1) + b(2)*dendritic_order_HS + b(3)*diameter_from_volume_HS;
mesh(X1FIT,X2FIT,YFIT)
xlabel('dendritic order HS')
ylabel('diameter from volume HS')
zlabel('number gneg syn HS')
text(4, 4, 0.3, txt181);
view(50,10)
hold off

[b,bint,r,rint,stats] = regress(y_2_surf, X_3_surf);
txt182 = ['R^2:' num2str(stats(1))];

figure(71)
scatter3(dendritic_order_HS, diameter_from_volume_HS, num_per_surf_gpos_HS,'filled')
hold on
x1fit = min(dendritic_order_HS):1:max(dendritic_order_HS);
x2fit = min(diameter_from_volume_HS):0.1:max(diameter_from_volume_HS);
[X1FIT,X2FIT] = meshgrid(x1fit,x2fit);
YFIT = b(1) + b(2)*X1FIT + b(3)*X2FIT;  % + b(4)*X1FIT.*X2FIT
yfit_order_diam_ngpos_HS_surf = b(1) + b(2)*dendritic_order_HS + b(3)*diameter_from_volume_HS;
mesh(X1FIT,X2FIT,YFIT)
xlabel('dendritic order HS')
ylabel('diameter from volume HS')
zlabel('number gpos syn HS')
text(4, 4, 0.3, txt182);
view(50,10)
hold off


[b,bint,r,rint,stats] = regress(y_5_surf, X_4_surf);
txt184 = ['R^2:' num2str(stats(1))];

figure(72)
scatter3(distance_from_soma_OLM, dendritic_order_OLM, num_per_surf_gneg_OLM,'filled')
hold on
x1fit = min(distance_from_soma_OLM):100:max(distance_from_soma_OLM);
x2fit = min(dendritic_order_OLM):1:max(dendritic_order_OLM);
[X1FIT,X2FIT] = meshgrid(x1fit,x2fit);
YFIT = b(1) + b(2)*X1FIT + b(3)*X2FIT;  % + b(4)*X1FIT.*X2FIT
yfit_dist_order_ngneg_OLM_surf = b(1) + b(2)*distance_from_soma_OLM + b(3)*dendritic_order_OLM;
mesh(X1FIT,X2FIT,YFIT)
xlabel('distance from soma')
ylabel('dendritic order')
zlabel('number gneg syn OLM')
text(200, 4, 2, txt184);
view(50,10)
hold off

[b,bint,r,rint,stats] = regress(y_6_surf, X_4_surf);
txt185 = ['R^2:' num2str(stats(1))];

figure(73)
scatter3(distance_from_soma_OLM, dendritic_order_OLM, num_per_surf_gpos_OLM,'filled')
hold on
x1fit = min(distance_from_soma_OLM):100:max(distance_from_soma_OLM);
x2fit = min(dendritic_order_OLM):1:max(dendritic_order_OLM);
[X1FIT,X2FIT] = meshgrid(x1fit,x2fit);
YFIT = b(1) + b(2)*X1FIT + b(3)*X2FIT;  % + b(4)*X1FIT.*X2FIT
yfit_dist_order_ngpos_OLM_surf = b(1) + b(2)*distance_from_soma_OLM + b(3)*dendritic_order_OLM;
mesh(X1FIT,X2FIT,YFIT)
xlabel('distance from soma')
ylabel('dendritic order')
zlabel('number gpos syn OLM')
text(200, 4, 2, txt185);
view(50,10)
hold off


[b,bint,r,rint,stats] = regress(y_5_surf, X_5_surf);
txt188 = ['R^2:' num2str(stats(1))];

figure(74)
scatter3(distance_from_soma_OLM, diameter_from_volume_OLM, num_per_surf_gneg_OLM,'filled')
hold on
x1fit = min(distance_from_soma_OLM):100:max(distance_from_soma_OLM);
x2fit = min(diameter_from_volume_OLM):0.1:max(diameter_from_volume_OLM);
[X1FIT,X2FIT] = meshgrid(x1fit,x2fit);
YFIT = b(1) + b(2)*X1FIT + b(3)*X2FIT;  % + b(4)*X1FIT.*X2FIT
yfit_dist_diam_ngneg_OLM_surf =  b(1) + b(2)*distance_from_soma_OLM + b(3)*diameter_from_volume_OLM;
coeffs_dist_diam_ngneg_OLM_surf = b;
mesh(X1FIT,X2FIT,YFIT)
xlabel('distance from soma')
ylabel('diameter from volume OLM')
zlabel('number gneg syn OLM')
text(200, 4, 0.2, txt188);
view(50,10)
hold off

[b,bint,r,rint,stats] = regress(y_6_surf, X_5_surf);
txt189 = ['R^2:' num2str(stats(1))];

figure(75)
scatter3(distance_from_soma_OLM, diameter_from_volume_OLM, num_per_surf_gpos_OLM,'filled')
hold on
x1fit = min(distance_from_soma_OLM):100:max(distance_from_soma_OLM);
x2fit = min(diameter_from_volume_OLM):0.1:max(diameter_from_volume_OLM);
[X1FIT,X2FIT] = meshgrid(x1fit,x2fit);
YFIT = b(1) + b(2)*X1FIT + b(3)*X2FIT;  % + b(4)*X1FIT.*X2FIT
yfit_dist_diam_ngpos_OLM_surf = b(1) + b(2)*distance_from_soma_OLM + b(3)*diameter_from_volume_OLM;
coeffs_dist_diam_ngpos_OLM_surf = b;
mesh(X1FIT,X2FIT,YFIT)
xlabel('distance from soma')
ylabel('diameter from volume OLM')
zlabel('number gpos syn OLM')
text(200, 2, 0.2, txt189);
view(50,10)
hold off


[b,bint,r,rint,stats] = regress(y_5_surf, X_6_surf);
txt192 = ['R^2:' num2str(stats(1))];

figure(76)
scatter3(dendritic_order_OLM, diameter_from_volume_OLM, num_per_surf_gneg_OLM,'filled')
hold on
x1fit = min(dendritic_order_OLM):1:max(dendritic_order_OLM);
x2fit = min(diameter_from_volume_OLM):0.1:max(diameter_from_volume_OLM);
[X1FIT,X2FIT] = meshgrid(x1fit,x2fit);
YFIT = b(1) + b(2)*X1FIT + b(3)*X2FIT;  % + b(4)*X1FIT.*X2FIT
yfit_order_diam_ngneg_OLM_surf = b(1) + b(2)*dendritic_order_OLM + b(3)*diameter_from_volume_OLM;
mesh(X1FIT,X2FIT,YFIT)
xlabel('dendritic order OLM')
ylabel('diameter from volume OLM')
zlabel('number gneg syn OLM')
text(4, 4, 0.3, txt192);
view(50,10)
hold off

[b,bint,r,rint,stats] = regress(y_6_surf, X_6_surf);
txt193 = ['R^2:' num2str(stats(1))];

figure(77)
scatter3(dendritic_order_OLM, diameter_from_volume_OLM, num_per_surf_gpos_OLM,'filled')
hold on
x1fit = min(dendritic_order_OLM):1:max(dendritic_order_OLM);
x2fit = min(diameter_from_volume_OLM):0.1:max(diameter_from_volume_OLM);
[X1FIT,X2FIT] = meshgrid(x1fit,x2fit);
YFIT = b(1) + b(2)*X1FIT + b(3)*X2FIT;  % + b(4)*X1FIT.*X2FIT
yfit_order_diam_ngpos_OLM_surf = b(1) + b(2)*dendritic_order_OLM + b(3)*diameter_from_volume_OLM;
mesh(X1FIT,X2FIT,YFIT)
xlabel('dendritic order OLM')
ylabel('diameter from volume OLM')
zlabel('number gpos syn OLM')
text(4, 4, 0.3, txt193);
view(50,10)
hold off

%%

X_7_surf = [ones(size(distance_from_soma_HS)).' distance_from_soma_HS.' dendritic_order_HS.', diameter_from_volume_HS.'];
X_8_surf = [ones(size(distance_from_soma_OLM)).' distance_from_soma_OLM.' dendritic_order_OLM.', diameter_from_volume_OLM.'];

y_surf = num_per_surf_gneg_HS.';
y_2_surf = num_per_surf_gpos_HS.';

y_5_surf = num_per_surf_gneg_OLM.';
y_6_surf = num_per_surf_gpos_OLM.';

[b,bint,r,rint,stats] = regress(y_surf, X_7_surf);
r2_for_num_gneg_HS_surf = stats(1)
yfit_ngneg_per_area_HS_for_all_surf = b(1) + b(2)*distance_from_soma_HS + b(3)*dendritic_order_HS + b(4)*diameter_from_volume_HS;

[b,bint,r,rint,stats] = regress(y_2_surf, X_7_surf);
r2_for_num_gpos_HS_surf = stats(1)
yfit_ngpos_per_area_HS_for_all_surf = b(1) + b(2)*distance_from_soma_HS + b(3)*dendritic_order_HS + b(4)*diameter_from_volume_HS;

[b,bint,r,rint,stats] = regress(y_5_surf, X_8_surf);
r2_for_num_gneg_OLM_surf = stats(1)
yfit_ngneg_per_area_OLM_for_all_surf = b(1) + b(2)*distance_from_soma_OLM + b(3)*dendritic_order_OLM + b(4)*diameter_from_volume_OLM;


[b,bint,r,rint,stats] = regress(y_6_surf, X_8_surf);
r2_for_num_gpos_OLM_surf = stats(1)
yfit_ngpos_per_area_OLM_for_all_surf = b(1) + b(2)*distance_from_soma_OLM + b(3)*dendritic_order_OLM + b(4)*diameter_from_volume_OLM;


%% BIC num/surf

MSE_gneg_dist_HS_surf = 0.159^2;
num_per_surf_gneg_HS_corr = num_per_surf_gneg_HS(~isnan(num_per_surf_gneg_HS));
BIC_gneg_dist_HS_surf = numel(num_per_surf_gneg_HS_corr)*log(MSE_gneg_dist_HS_surf)+2*log(numel(num_per_surf_gneg_HS_corr))
MSE_gneg_diam_HS_surf = 0.16^2;
BIC_gneg_diam_HS_surf = numel(num_per_surf_gneg_HS_corr)*log(MSE_gneg_diam_HS_surf)+2*log(numel(num_per_surf_gneg_HS_corr))
MSE_gneg_order_HS_surf = 0.168^2;
BIC_gneg_order_HS_surf = numel(num_per_surf_gneg_HS_corr)*log(MSE_gneg_order_HS_surf)+2*log(numel(num_per_surf_gneg_HS_corr))

MSE_gpos_dist_HS_surf = 0.0812^2;
num_per_surf_gpos_HS_corr = num_per_surf_gpos_HS(~isnan(num_per_surf_gpos_HS));
BIC_gpos_dist_H_surfS = numel(num_per_surf_gpos_HS_corr)*log(MSE_gpos_dist_HS_surf)+2*log(numel(num_per_surf_gpos_HS_corr))
MSE_gpos_diam_HS_surf = 0.0819^2;
BIC_gpos_diam_HS_surf = numel(num_per_surf_gpos_HS_corr)*log(MSE_gpos_diam_HS_surf)+2*log(numel(num_per_surf_gpos_HS_corr))
MSE_gpos_order_HS_surf = 0.0816^2;
BIC_gpos_order_HS_surf = numel(num_per_surf_gpos_HS_corr)*log(MSE_gpos_order_HS_surf)+2*log(numel(num_per_surf_gpos_HS_corr))

MSE_gneg_dist_OLM_surf = 0.139^2;
num_per_surf_gneg_OLM_corr = num_per_surf_gneg_OLM(~isnan(num_per_surf_gneg_OLM));
BIC_gneg_dist_OLM_surf = numel(num_per_surf_gneg_OLM_corr)*log(MSE_gneg_dist_OLM_surf)+2*log(numel(num_per_surf_gneg_OLM_corr))
MSE_gneg_diam_OLM_surf = 0.154^2;
BIC_gneg_diam_OLM_surf = numel(num_per_surf_gneg_OLM_corr)*log(MSE_gneg_diam_OLM_surf)+2*log(numel(num_per_surf_gneg_OLM_corr))
MSE_gneg_order_OLM_surf = 0.154^2;
BIC_gneg_order_OLM_surf = numel(num_per_surf_gneg_OLM_corr)*log(MSE_gneg_order_OLM_surf)+2*log(numel(num_per_surf_gneg_OLM_corr))

MSE_gpos_dist_OLM_surf = 0.0513^2;
num_per_surf_gpos_OLM_corr = num_per_surf_gpos_OLM(~isnan(num_per_surf_gpos_OLM));
BIC_gpos_dist_OLM_surf = numel(num_per_surf_gpos_OLM_corr)*log(MSE_gpos_dist_OLM_surf)+2*log(numel(num_per_surf_gpos_OLM_corr))
MSE_gpos_diam_OLM_surf = 0.0516^2;
BIC_gpos_diam_OLM_surf = numel(num_per_surf_gpos_OLM_corr)*log(MSE_gpos_diam_OLM_surf)+2*log(numel(num_per_surf_gpos_OLM_corr))
MSE_gpos_order_OLM_surf = 0.0515^2;
BIC_gpos_order_OLM_surf = numel(num_per_surf_gpos_OLM_corr)*log(MSE_gpos_order_OLM_surf)+2*log(numel(num_per_surf_gpos_OLM_corr))

%%

RSS_dist_diam_ngneg_HS_surf = nansum((num_per_surf_gneg_HS-yfit_dist_diam_ngneg_HS_surf).^2);
RSS_dist_diam_ngneg_OLM_surf = nansum((num_per_surf_gneg_OLM-yfit_dist_diam_ngneg_OLM_surf).^2);
RSS_dist_diam_ngpos_HS_surf = nansum((num_per_surf_gpos_HS-yfit_dist_diam_ngpos_HS_surf).^2);
RSS_dist_diam_ngpos_OLM_surf = nansum((num_per_surf_gpos_OLM-yfit_dist_diam_ngpos_OLM_surf).^2);

BIC_dist_diam_ngneg_HS_surf = numel(num_per_surf_gneg_HS_corr)*log(RSS_dist_diam_ngneg_HS_surf/numel(num_per_surf_gneg_HS_corr))+3*log(numel(num_per_surf_gneg_HS_corr))
BIC_dist_diam_ngneg_OLM_surf = numel(num_per_surf_gneg_OLM_corr)*log(RSS_dist_diam_ngneg_OLM_surf/numel(num_per_surf_gneg_OLM_corr))+3*log(numel(num_per_surf_gneg_OLM_corr))
BIC_dist_diam_ngpos_HS_surf = numel(num_per_surf_gpos_HS_corr)*log(RSS_dist_diam_ngpos_HS_surf/numel(num_per_surf_gpos_HS_corr))+3*log(numel(num_per_surf_gpos_HS_corr))
BIC_dist_diam_ngpos_OLM_surf = numel(num_per_surf_gpos_OLM_corr)*log(RSS_dist_diam_ngpos_OLM_surf/numel(num_per_surf_gpos_OLM_corr))+3*log(numel(num_per_surf_gpos_OLM_corr))

RSS_dist_order_ngneg_HS_surf = nansum((num_per_surf_gneg_HS-yfit_dist_order_ngneg_HS_surf).^2);
RSS_dist_order_ngneg_OLM_surf =nansum((num_per_surf_gneg_OLM-yfit_dist_order_ngneg_OLM_surf).^2);
RSS_dist_order_ngpos_HS_surf = nansum((num_per_surf_gpos_HS-yfit_dist_order_ngpos_HS_surf).^2);
RSS_dist_order_ngpos_OLM_surf = nansum((num_per_surf_gpos_OLM-yfit_dist_order_ngpos_OLM_surf).^2);

BIC_dist_order_ngneg_HS_surf = numel(num_per_surf_gneg_HS_corr)*log(RSS_dist_order_ngneg_HS_surf/numel(num_per_surf_gneg_HS_corr))+3*log(numel(num_per_surf_gneg_HS_corr))
BIC_dist_order_ngneg_OLM_surf = numel(num_per_surf_gneg_OLM_corr)*log(RSS_dist_order_ngneg_OLM_surf/numel(num_per_surf_gneg_OLM_corr))+3*log(numel(num_per_surf_gneg_OLM_corr))
BIC_dist_order_ngpos_HS_surf = numel(num_per_surf_gpos_HS_corr)*log(RSS_dist_order_ngpos_HS_surf/numel(num_per_surf_gpos_HS_corr))+3*log(numel(num_per_surf_gpos_HS_corr))
BIC_dist_order_ngpos_OLM_surf = numel(num_per_surf_gpos_OLM_corr)*log(RSS_dist_order_ngpos_OLM_surf/numel(num_per_surf_gpos_OLM_corr))+3*log(numel(num_per_surf_gpos_OLM_corr))

RSS_order_diam_ngneg_HS_surf = nansum((num_per_surf_gneg_HS-yfit_order_diam_ngneg_HS_surf).^2);
RSS_order_diam_ngneg_OLM_surf = nansum((num_per_surf_gneg_OLM-yfit_order_diam_ngneg_OLM_surf).^2);
RSS_order_diam_ngpos_HS_surf = nansum((num_per_surf_gpos_HS-yfit_order_diam_ngpos_HS_surf).^2);
RSS_order_diam_ngpos_OLM_surf = nansum((num_per_surf_gpos_OLM-yfit_order_diam_ngpos_OLM_surf).^2);

BIC_order_diam_ngneg_HS_surf = numel(num_per_surf_gneg_HS_corr)*log(RSS_order_diam_ngneg_HS_surf/numel(num_per_surf_gneg_HS_corr))+3*log(numel(num_per_surf_gneg_HS_corr))
BIC_order_diam_ngneg_OLM_surf = numel(num_per_surf_gneg_OLM_corr)*log(RSS_order_diam_ngneg_OLM_surf/numel(num_per_surf_gneg_OLM_corr))+3*log(numel(num_per_surf_gneg_OLM_corr))
BIC_order_diam_ngpos_HS_surf = numel(num_per_surf_gpos_HS_corr)*log(RSS_order_diam_ngpos_HS_surf/numel(num_per_surf_gpos_HS_corr))+3*log(numel(num_per_surf_gpos_HS_corr))
BIC_order_diam_ngpos_OLM_surf = numel(num_per_surf_gpos_OLM_corr)*log(RSS_order_diam_ngpos_OLM_surf/numel(num_per_surf_gpos_OLM_corr))+3*log(numel(num_per_surf_gpos_OLM_corr))

RSS_all_gneg_HS_surf = nansum((num_per_surf_gneg_HS-yfit_ngneg_per_area_HS_for_all_surf).^2);
RSS_all_gneg_OLM_surf = nansum((num_per_surf_gneg_OLM-yfit_ngneg_per_area_OLM_for_all_surf).^2);
RSS_all_gpos_HS_surf = nansum((num_per_surf_gpos_HS-yfit_ngpos_per_area_HS_for_all_surf).^2);
RSS_all_gpos_OLM_surf = nansum((num_per_surf_gpos_OLM-yfit_ngpos_per_area_OLM_for_all_surf).^2);

BIC_all_gneg_HS_surf = numel(num_per_surf_gneg_HS_corr)*log(RSS_all_gneg_HS_surf/numel(num_per_surf_gneg_HS_corr))+4*log(numel(num_per_surf_gneg_HS_corr))
BIC_all_gneg_OLM_surf = numel(num_per_surf_gneg_OLM_corr)*log(RSS_all_gneg_OLM_surf/numel(num_per_surf_gneg_OLM_corr))+4*log(numel(num_per_surf_gneg_OLM_corr))
BIC_all_gpos_HS_surf = numel(num_per_surf_gpos_HS_corr)*log(RSS_all_gpos_HS_surf/numel(num_per_surf_gpos_HS_corr))+4*log(numel(num_per_surf_gpos_HS_corr))
BIC_all_gpos_OLM_surf = numel(num_per_surf_gpos_OLM_corr)*log(RSS_all_gpos_OLM_surf/numel(num_per_surf_gpos_OLM_corr))+4*log(numel(num_per_surf_gpos_OLM_corr))


RSS_mean_gneg_HS_surf = sum((num_per_surf_gneg_HS_corr - mean(num_per_surf_gneg_HS_corr)).^2);
BIC_mean_gneg_HS_surf = numel(num_per_surf_gneg_HS_corr)*log(RSS_mean_gneg_HS_surf/numel(num_per_surf_gneg_HS_corr))+1*log(numel(num_per_surf_gneg_HS_corr))

RSS_mean_gpos_HS_surf = sum((num_per_surf_gpos_HS_corr - mean(num_per_surf_gpos_HS_corr)).^2);
BIC_mean_gpos_HS_surf = numel(num_per_surf_gpos_HS_corr)*log(RSS_mean_gpos_HS_surf/numel(num_per_surf_gpos_HS_corr))+1*log(numel(num_per_surf_gpos_HS_corr))

RSS_mean_gneg_OLM_surf = sum((num_per_surf_gneg_OLM_corr - mean(num_per_surf_gneg_OLM_corr)).^2)
BIC_mean_gneg_OLM_surf = numel(num_per_surf_gneg_OLM_corr)*log(RSS_mean_gneg_OLM_surf/numel(num_per_surf_gneg_OLM_corr))+1*log(numel(num_per_surf_gneg_OLM_corr))

RSS_mean_gpos_OLM_surf = sum((num_per_surf_gpos_OLM_corr - mean(num_per_surf_gpos_OLM_corr)).^2)
BIC_mean_gpos_OLM_surf = numel(num_per_surf_gpos_OLM_corr)*log(RSS_mean_gpos_OLM_surf/numel(num_per_surf_gpos_OLM_corr))+1*log(numel(num_per_surf_gpos_OLM_corr))

%% Bayesian information for size/area

MSE_gneg_size_dist_HS = 0.0364.^2;
gneg_syn_size_per_area_HS_corr = gneg_syn_size_per_area_HS(~isnan(gneg_syn_size_per_area_HS));
BIC_gneg_size_dist_HS = numel(gneg_syn_size_per_area_HS_corr)*log(MSE_gneg_size_dist_HS)+2*log(numel(gneg_syn_size_per_area_HS_corr))
MSE_gneg_size_diam_HS = 0.0384.^2;
BIC_gneg_size_diam_HS = numel(gneg_syn_size_per_area_HS_corr)*log(MSE_gneg_size_diam_HS)+2*log(numel(gneg_syn_size_per_area_HS_corr))
MSE_gneg_size_order_HS = 0.0381.^2;
BIC_gneg_size_order_HS = numel(gneg_syn_size_per_area_HS_corr)*log(MSE_gneg_size_order_HS)+2*log(numel(gneg_syn_size_per_area_HS_corr))

MSE_gpos_size_dist_HS = 0.0288.^2;
gpos_syn_size_per_area_HS_corr = gpos_syn_size_per_area_HS(~isnan(gpos_syn_size_per_area_HS));
BIC_gpos_size_dist_HS = numel(gpos_syn_size_per_area_HS_corr)*log(MSE_gpos_size_dist_HS)+2*log(numel(gpos_syn_size_per_area_HS_corr))
MSE_gpos_size_diam_HS = 0.0294.^2;
BIC_gpos_size_diam_HS = numel(gpos_syn_size_per_area_HS_corr)*log(MSE_gpos_size_diam_HS)+2*log(numel(gpos_syn_size_per_area_HS_corr))
MSE_gpos_size_order_HS = 0.029.^2;
BIC_gpos_size_order_HS = numel(gpos_syn_size_per_area_HS_corr)*log(MSE_gpos_size_order_HS)+2*log(numel(gpos_syn_size_per_area_HS_corr))

MSE_gneg_size_dist_OLM = 0.0285.^2;
gneg_syn_size_per_area_OLM_corr = gneg_syn_size_per_area_OLM(~isnan(gneg_syn_size_per_area_OLM));
BIC_gneg_size_dist_OLM = numel(gneg_syn_size_per_area_OLM_corr)*log(MSE_gneg_size_dist_OLM)+2*log(numel(gneg_syn_size_per_area_OLM_corr))
MSE_gneg_size_diam_OLM = 0.028.^2
BIC_gneg_size_diam_OLM = numel(gneg_syn_size_per_area_OLM_corr)*log(MSE_gneg_size_diam_OLM)+2*log(numel(gneg_syn_size_per_area_OLM_corr))
MSE_gneg_size_order_OLM = 0.0285.^2;
BIC_gneg_size_order_OLM = numel(gneg_syn_size_per_area_OLM_corr)*log(MSE_gneg_size_order_OLM)+2*log(numel(gneg_syn_size_per_area_OLM_corr))

MSE_gpos_size_dist_OLM = 0.0139.^2;
gpos_syn_size_per_area_OLM_corr = gpos_syn_size_per_area_OLM(~isnan(gpos_syn_size_per_area_OLM));
BIC_gpos_size_dist_OLM = numel(gpos_syn_size_per_area_OLM_corr)*log(MSE_gpos_size_dist_OLM)+2*log(numel(gpos_syn_size_per_area_OLM_corr))
MSE_gpos_size_diam_OLM = 0.014.^2;
BIC_gpos_size_diam_OLM = numel(gpos_syn_size_per_area_OLM_corr)*log(MSE_gpos_size_diam_OLM)+2*log(numel(gpos_syn_size_per_area_OLM_corr))
MSE_gpos_size_order_OLM = 0.0141.^2;
BIC_gpos_size_order_OLM = numel(gpos_syn_size_per_area_OLM_corr)*log(MSE_gpos_size_order_OLM)+2*log(numel(gpos_syn_size_per_area_OLM_corr))


X = [ones(size(distance_from_soma_HS)).' distance_from_soma_HS.' dendritic_order_HS.'];
X_2 = [ones(size(distance_from_soma_HS)).' distance_from_soma_HS.' diameter_from_volume_HS.'];
X_3 = [ones(size(dendritic_order_HS)).' dendritic_order_HS.' diameter_from_volume_HS.'];

y_3 = gneg_syn_size_per_area_HS.';
y_4 = gpos_syn_size_per_area_HS.';

X_4 = [ones(size(distance_from_soma_OLM)).' distance_from_soma_OLM.' dendritic_order_OLM.'];
X_5 = [ones(size(distance_from_soma_OLM)).' distance_from_soma_OLM.' diameter_from_volume_OLM.'];
X_6 = [ones(size(dendritic_order_OLM)).' dendritic_order_OLM.' diameter_from_volume_OLM.'];

y_7 = gneg_syn_size_per_area_OLM.';
y_8 = gpos_syn_size_per_area_OLM.';

X_7 = [ones(size(distance_from_soma_HS)).' distance_from_soma_HS.' dendritic_order_HS.', diameter_from_volume_HS.'];
X_8 = [ones(size(distance_from_soma_OLM)).' distance_from_soma_OLM.' dendritic_order_OLM.', diameter_from_volume_OLM.'];


[b,bint,r,rint,stats] = regress(y_3, X);
yfit_dist_order_gneg_size_HS = b(1) + b(2)*distance_from_soma_HS + b(3)*dendritic_order_HS;

[b,bint,r,rint,stats] = regress(y_4, X);
yfit_dist_order_gpos_size_HS = b(1) + b(2)*distance_from_soma_HS + b(3)*dendritic_order_HS;

[b,bint,r,rint,stats] = regress(y_3, X_2);
yfit_dist_diam_gneg_size_HS = b(1) + b(2)*distance_from_soma_HS + b(3)*diameter_from_volume_HS;

[b,bint,r,rint,stats] = regress(y_4, X_2);
yfit_dist_diam_gpos_size_HS = b(1) + b(2)*distance_from_soma_HS + b(3)*diameter_from_volume_HS;

[b,bint,r,rint,stats] = regress(y_3, X_3);
yfit_order_diam_gneg_size_HS = b(1) + b(2)*dendritic_order_HS + b(3)*diameter_from_volume_HS;

[b,bint,r,rint,stats] = regress(y_4, X_3);
yfit_order_diam_gpos_size_HS = b(1) + b(2)*dendritic_order_HS + b(3)*diameter_from_volume_HS;


[b,bint,r,rint,stats] = regress(y_7, X_4);
yfit_dist_order_gneg_size_OLM = b(1) + b(2)*distance_from_soma_OLM + b(3)*dendritic_order_OLM;

[b,bint,r,rint,stats] = regress(y_8, X_4);
yfit_dist_order_gpos_size_OLM = b(1) + b(2)*distance_from_soma_OLM + b(3)*dendritic_order_OLM;

[b,bint,r,rint,stats] = regress(y_7, X_5);
yfit_dist_diam_gneg_size_OLM = b(1) + b(2)*distance_from_soma_OLM + b(3)*diameter_from_volume_OLM;

[b,bint,r,rint,stats] = regress(y_8, X_5);
yfit_dist_diam_gpos_size_OLM = b(1) + b(2)*distance_from_soma_OLM + b(3)*diameter_from_volume_OLM;

[b,bint,r,rint,stats] = regress(y_7, X_6);
yfit_order_diam_gneg_size_OLM = b(1) + b(2)*dendritic_order_OLM + b(3)*diameter_from_volume_OLM;

[b,bint,r,rint,stats] = regress(y_8, X_6);
yfit_order_diam_gpos_size_OLM = b(1) + b(2)*dendritic_order_OLM + b(3)*diameter_from_volume_OLM;

[b,bint,r,rint,stats] = regress(y_3, X_7);
yfit_all_gneg_size_HS = b(1) + b(2)*distance_from_soma_HS + b(3)*dendritic_order_HS + b(4)*diameter_from_volume_HS;

[b,bint,r,rint,stats] = regress(y_4, X_7);
yfit_all_gpos_size_HS = b(1) + b(2)*distance_from_soma_HS + b(3)*dendritic_order_HS + b(4)*diameter_from_volume_HS;

[b,bint,r,rint,stats] = regress(y_7, X_8);
yfit_all_gneg_size_OLM = b(1) + b(2)*distance_from_soma_OLM + b(3)*dendritic_order_OLM + b(4)*diameter_from_volume_OLM;

[b,bint,r,rint,stats] = regress(y_8, X_8);
yfit_all_gpos_size_OLM = b(1) + b(2)*distance_from_soma_OLM + b(3)*dendritic_order_OLM + b(4)*diameter_from_volume_OLM;

RSS_gneg_size_dist_order_HS = nansum((gneg_syn_size_per_area_HS-yfit_dist_order_gneg_size_HS).^2);
RSS_gpos_size_dist_order_HS = nansum((gpos_syn_size_per_area_HS-yfit_dist_order_gpos_size_HS).^2);
RSS_gneg_size_dist_diam_HS = nansum((gneg_syn_size_per_area_HS-yfit_dist_diam_gneg_size_HS).^2);
RSS_gpos_size_dist_diam_HS = nansum((gpos_syn_size_per_area_HS-yfit_dist_diam_gpos_size_HS).^2);
RSS_gneg_size_order_diam_HS = nansum((gneg_syn_size_per_area_HS-yfit_order_diam_gneg_size_HS).^2);
RSS_gpos_size_order_diam_HS = nansum((gpos_syn_size_per_area_HS-yfit_order_diam_gpos_size_HS).^2);

RSS_gneg_size_dist_order_OLM = nansum((gneg_syn_size_per_area_OLM-yfit_dist_order_gneg_size_OLM).^2);
RSS_gpos_size_dist_order_OLM = nansum((gpos_syn_size_per_area_OLM-yfit_dist_order_gpos_size_OLM).^2);
RSS_gneg_size_dist_diam_OLM = nansum((gneg_syn_size_per_area_OLM-yfit_dist_diam_gneg_size_OLM).^2);
RSS_gpos_size_dist_diam_OLM = nansum((gpos_syn_size_per_area_OLM-yfit_dist_diam_gpos_size_OLM).^2);
RSS_gneg_size_order_diam_OLM = nansum((gneg_syn_size_per_area_OLM-yfit_order_diam_gneg_size_OLM).^2);
RSS_gpos_size_order_diam_OLM = nansum((gpos_syn_size_per_area_OLM-yfit_order_diam_gpos_size_OLM).^2);

RSS_gneg_size_all_HS = nansum((gneg_syn_size_per_area_HS-yfit_all_gneg_size_HS).^2);
RSS_gpos_size_all_HS = nansum((gpos_syn_size_per_area_HS-yfit_all_gpos_size_HS).^2);
RSS_gneg_size_all_OLM = nansum((gneg_syn_size_per_area_OLM-yfit_all_gneg_size_OLM).^2);
RSS_gpos_size_all_OLM = nansum((gpos_syn_size_per_area_OLM-yfit_all_gpos_size_OLM).^2);

BIC_dist_order_gneg_size_HS = numel(gneg_syn_size_per_area_HS_corr)*log(RSS_gneg_size_dist_order_HS/numel(gneg_syn_size_per_area_HS_corr))+3*log(numel(gneg_syn_size_per_area_HS_corr))
BIC_dist_order_gpos_size_HS = numel(gpos_syn_size_per_area_HS_corr)*log(RSS_gpos_size_dist_order_HS/numel(gpos_syn_size_per_area_HS_corr))+3*log(numel(gpos_syn_size_per_area_HS_corr))
BIC_dist_diam_gneg_size_HS = numel(gneg_syn_size_per_area_HS_corr)*log(RSS_gneg_size_dist_diam_HS/numel(gneg_syn_size_per_area_HS_corr))+3*log(numel(gneg_syn_size_per_area_HS_corr))
BIC_dist_diam_gpos_size_HS = numel(gpos_syn_size_per_area_HS_corr)*log(RSS_gpos_size_dist_diam_HS/numel(gpos_syn_size_per_area_HS_corr))+3*log(numel(gpos_syn_size_per_area_HS_corr))
BIC_order_diam_gneg_size_HS = numel(gneg_syn_size_per_area_HS_corr)*log(RSS_gneg_size_order_diam_HS/numel(gneg_syn_size_per_area_HS_corr))+3*log(numel(gneg_syn_size_per_area_HS_corr))
BIC_order_diam_gpos_size_HS = numel(gpos_syn_size_per_area_HS_corr)*log(RSS_gpos_size_order_diam_HS/numel(gpos_syn_size_per_area_HS_corr))+3*log(numel(gpos_syn_size_per_area_HS_corr))

BIC_dist_order_gneg_size_OLM = numel(gneg_syn_size_per_area_OLM_corr)*log(RSS_gneg_size_dist_order_OLM/numel(gneg_syn_size_per_area_OLM_corr))+3*log(numel(gneg_syn_size_per_area_OLM_corr))
BIC_dist_order_gpos_size_OLM = numel(gpos_syn_size_per_area_OLM_corr)*log(RSS_gpos_size_dist_order_OLM/numel(gpos_syn_size_per_area_OLM_corr))+3*log(numel(gpos_syn_size_per_area_OLM_corr))
BIC_dist_diam_gneg_size_OLM = numel(gneg_syn_size_per_area_OLM_corr)*log(RSS_gneg_size_dist_diam_OLM/numel(gneg_syn_size_per_area_OLM_corr))+3*log(numel(gneg_syn_size_per_area_OLM_corr))
BIC_dist_diam_gpos_size_OLM = numel(gpos_syn_size_per_area_OLM_corr)*log(RSS_gpos_size_dist_diam_OLM/numel(gpos_syn_size_per_area_OLM_corr))+3*log(numel(gpos_syn_size_per_area_OLM_corr))
BIC_order_diam_gneg_size_OLM = numel(gneg_syn_size_per_area_OLM_corr)*log(RSS_gneg_size_order_diam_OLM/numel(gneg_syn_size_per_area_OLM_corr))+3*log(numel(gneg_syn_size_per_area_OLM_corr))
BIC_order_diam_gpos_size_OLM = numel(gpos_syn_size_per_area_OLM_corr)*log(RSS_gpos_size_order_diam_OLM/numel(gpos_syn_size_per_area_OLM_corr))+3*log(numel(gpos_syn_size_per_area_OLM_corr))

BIC_all_gneg_size_HS = numel(gneg_syn_size_per_area_HS_corr)*log(RSS_gneg_size_all_HS/numel(gneg_syn_size_per_area_HS_corr))+4*log(numel(gneg_syn_size_per_area_HS_corr))
BIC_all_gpos_size_HS = numel(gpos_syn_size_per_area_HS_corr)*log(RSS_gpos_size_all_HS/numel(gpos_syn_size_per_area_HS_corr))+4*log(numel(gpos_syn_size_per_area_HS_corr))
BIC_all_gneg_size_OLM = numel(gneg_syn_size_per_area_OLM_corr)*log(RSS_gneg_size_all_OLM/numel(gneg_syn_size_per_area_OLM_corr))+4*log(numel(gneg_syn_size_per_area_OLM_corr))
BIC_all_gpos_size_OLM = numel(gpos_syn_size_per_area_OLM_corr)*log(RSS_gpos_size_all_OLM/numel(gpos_syn_size_per_area_OLM_corr))+4*log(numel(gpos_syn_size_per_area_OLM_corr))


RSS_mean_gneg_size_HS = sum((gneg_syn_size_per_area_HS_corr - mean(gneg_syn_size_per_area_HS_corr)).^2);
%RSS_mean_gneg_size_HS_2 = numel(gneg_syn_size_per_area_HS_corr)*var(gneg_syn_size_per_area_HS_corr,1)
BIC_mean_gneg_size_HS = numel(gneg_syn_size_per_area_HS_corr)*log(RSS_mean_gneg_size_HS/numel(gneg_syn_size_per_area_HS_corr))+1*log(numel(gneg_syn_size_per_area_HS_corr))

RSS_mean_gpos_size_HS = sum((gpos_syn_size_per_area_HS_corr - mean(gpos_syn_size_per_area_HS_corr)).^2);
%RSS_mean_gneg_size_HS_2 = numel(gneg_syn_size_per_area_HS_corr)*var(gneg_syn_size_per_area_HS_corr,1)
BIC_mean_gpos_size_HS = numel(gpos_syn_size_per_area_HS_corr)*log(RSS_mean_gpos_size_HS/numel(gpos_syn_size_per_area_HS_corr))+1*log(numel(gpos_syn_size_per_area_HS_corr))

RSS_mean_gneg_size_OLM = sum((gneg_syn_size_per_area_OLM_corr - mean(gneg_syn_size_per_area_OLM_corr)).^2);
%RSS_mean_gneg_size_HS_2 = numel(gneg_syn_size_per_area_HS_corr)*var(gneg_syn_size_per_area_HS_corr,1)
BIC_mean_gneg_size_OLM = numel(gneg_syn_size_per_area_OLM_corr)*log(RSS_mean_gneg_size_OLM/numel(gneg_syn_size_per_area_OLM_corr))+1*log(numel(gneg_syn_size_per_area_OLM_corr))

RSS_mean_gpos_size_OLM = sum((gpos_syn_size_per_area_OLM_corr - mean(gpos_syn_size_per_area_OLM_corr)).^2);
%RSS_mean_gneg_size_HS_2 = numel(gneg_syn_size_per_area_HS_corr)*var(gneg_syn_size_per_area_HS_corr,1)
BIC_mean_gpos_size_OLM = numel(gpos_syn_size_per_area_OLM_corr)*log(RSS_mean_gpos_size_OLM/numel(gpos_syn_size_per_area_OLM_corr))+1*log(numel(gpos_syn_size_per_area_OLM_corr))