Data files included:

1\) all.pres_global.csv: is a classic plot (on rows) x species (in column) dataset of presences for all alien species recorded at the global scale. These contain the Global Biodiversity Information Facility (GBIF) and European Vegetation Archive (EVA) presences of alien species recorded globally in the global buffer.

Columns correspond to:

*   source: can be either GBIF or EVA, depending on the original dataset from which data are sourced
*   Longitude\Latitude: two columns to georeference plots, coordinates in geographic WGS 84
*   cells: a unique identifier shared among all the datasets to identify the raster cell to which all other columns refer
*   93 columns of species names: these columns display 1 if the corresponding alien species have been found in the corresponding cell, and 0 if at least one other alien species has been found in the same cell. In this case, 0 does not correspond to absences but should be interpreted as a table filler
*   7 columns for the environmental variables: these represent the environmental variables extracted for the relevant cells in which at least one alien species was observed. Variable names match the original ones, refer to ly.names.def.csv for a more intuitive description

2\) all.pres_regional.csv: is a classic plot (on rows) x species (in column) dataset of presences for all alien species recorded at the local/regional scale, i.e., in Mediterranean Europe. These contain the Global Biodiversity Information Facility (GBIF) and European Vegetation Archive (EVA) presence of alien species in the regional buffer.

Columns correspond to:

*   source: can be either GBIF or EVA, depending on the original dataset from which data are sourced
*   Longitude\Latitude: two columns to georeference plots, coordinates in geographic WGS 84
*   cells: a unique identifier shared among all the datasets to identify the raster cell to which all other columns refer
*   93 columns of species names: these columns display 1 if the corresponding alien species have been found in the corresponding cell, and 0 if at least one other alien species has been found in the same cell. In this case, 0 does not correspond to absences but should be interpreted as a table filler
*   7 columns for the environmental variables: these represent the environmental variables extracted for the relevant cells in which at least one alien species was observed. Variable names match the original ones, refer to ly.names.def.csv for a more intuitive description

3\) ly.names.def.csv: is a character vector file (just one row) to define intuitive names of the environmental variables.

4\) Global_BKG.csv: represents all background points used to fit the global model. These were used to extract three sets of background points, after weithging by the regional sampling intensity.

Columns correspond to:

*   Longitude\Latitude: two columns to georeference plots, coordinates in geographic WGS 84
*   EVA_Nr._plots: the number of sampled EVA plots in the corresponding cell
*   cells: a unique identifier shared among all the datasets to identify the raster cell to which all other columns refer
*   GBIF_Nr._plots: the number of sampled GBIF plots in the corresponding cell. The two cell's number (i.e., EVA_Nr._plots and GBIF_Nr._plots) were summed and used to weigh absences (only once for all species) that were then used to randomly extract the three background point samples in the global background
*   7 columns for the environmental variables: these represent the environmental variables extracted for the relevant cells in which at least one alien species was observed. Variable names match the original ones, refer to ly.names.def.csv for a more intuitive description

5\) Local_BKG.csv: represents all background points used to fit the local/regional model. These were used to extract three sets of background points, after weithging by the regional sampling intensity.

Columns correspond to:

*   Longitude\Latitude: two columns to georeference plots, coordinates in geographic WGS 84
*   EVA_Nr._plots: the number of sampled EVA plots in the corresponding cell
*   cells: a unique identifier shared among all the datasets to identify the raster cell to which all other columns refer
*   GBIF_Nr._plots: the number of sampled GBIF plots in the corresponding cell . The two cells (i.e., EVA_Nr._plots and GBIF_Nr._plots) were summed and used to weight absences (only once for all species) that were then used to randomly extract the three background point samples in the local/regional background
*   7 columns for the environmental variables: these represent the environmental variables extracted for the relevant cells in which at least one alien species was observed. Variable names match the original ones, refer to ly.names.def.csv for a more intuitive description

6\) myexpl.var30... : by their extended name, represent the environmental variables used to project the model in the current and future environmental conditions of Mediterranean Europe. This is a raster stack and each layer name is defined by the file ly.names.def.csv, which order is matched.

7\) Distance_to_cities: is a raster file that can be uploaded in R using the raster (function), and represents a cellwise distance to the major cities.

8\) Distance_to_coast: is a raster file that can be uploaded in R using the raster (function), and represents a cellwise distance to the European coastline.

9\) Distance_to_ports: is a raster file that can be uploaded in R using the raster (function), and represents a cellwise distance to the major European ports.
