from re import T
import sys, os
sys.path.append(os.getcwd())
from utils import bcolors
tlut_unique_component = ['waccu', 'itemp', 'osmux', 'bpipe']
cris_unique_component = ['reuse']
cris_no_component = ['wfifo', 'ififo', 'ofifo', 'oaccu']
my_dpi = 300
fig_h = 1.2
# fig_h = 2
fig_h_short = 0.9
fig_h_long = 1.4
fig_w = 3.3115
size_tuple = (fig_w,fig_h)

y_ticks_map = {
    'isoarea_size_dram2': {
        'perf': [0, 0.5, 1, 1.5],
    },
    'isoarea_size_dram3': {
        'perf': [0, 0.5, 1, 1.5],
    },
    'isoarea_size_dram4': {
        'perf': [0, 0.5, 1, 1.5],
    },
    'opt_height_fp8': {
        'perf': [0, 2.5, 5],
    },
    'fp8-isca/ram/mlperf': {
        'perf': [0, 1, 2],
        'perf_norm': [50, 75, 100],
    },
    'asplos/drambw': {
        'perf': [0, 1, 2],
        'perf_norm': [50, 75, 100],
    },
    'asplos-rebuttal/drambw': {
        'perf': [0, 1, 2],
        'perf_norm': [50, 75, 100],
    },
    'fp8-isca/ram/fc': {
        'perf': [0, 1, 2],
        'perf_norm': [50, 75, 100],
    },
    'fp8-isca/ram/conv': {
        'perf': [0, 1, 2],
        'perf_norm': [50, 75, 100],
    },
    'fp8-isca/shape/mlperf': {
        'perf': [0,2,4],
        'area_breakdown': [0,1,2],
        'energy_breakdown': [0,1],
    },
    'fp8-isca/noc': {
        'access_sram': [0, 1],
        'access_dram': [0, 2, 4],
        'perf': [0,2,4,6],
        'throughput/energy': [0,1,2,3],
        'throughput/power': [0,0.5, 1, 1.5],
    },
    'asplos/noc': {
        'access_sram': [0, 1],
        'access_dram': [0, 2, 4],
        'perf': [1,2,3,4],
        'throughput/energy': [1,2,3,4,5],
        'throughput/power': [1,1.1,1.2,1.3],
    },
    'asplos-rebuttal/noc': {
        'access_sram': [0, 1],
        'access_dram': [0, 2, 4],
        'perf': [1,2,3,4],
        'throughput/energy': [1,2,3,4,5],
        'throughput/power': [1,1.1,1.2,1.3],
    },
    'fp8-isca/batch': {
        'perf': [0,3,6],
        'perf_norm': [0,50,100],

    },
    'asplos/batch/gmean': {
        'perf': [0,5,10,15],
        'perf_norm': [60,80,100],
    },
    'asplos/batch/permodel': {
        'perf': [0.1,1,10,100],
        'perf_norm': [0,25,50,75,100],
    },
    'asplos/shape': {
        'perf': [0,15,30],
        'perf_norm': [70,80,90,100],
    },

    'asplos-rebuttal/batch/gmean': {
        'perf': [0,5,10,15],
        'perf_norm': [60,80,100],
    },
    'asplos-rebuttal/batch/permodel': {
        'perf': [0.1,1,10,100],
        'perf_norm': [0,25,50,75,100],
    },
    'asplos-rebuttal/shape': {
        'perf': [0,5,10,15, 20,25],
        'perf_norm': [20,40,60,80,100],
        'area_breakdown_sram_and_rest': [0,1,2,3,4],
        'area_breakdown_nosramfifo': [0,1,2]
    },

    'fp8-isca/batch/convfc': {
        'perf': [0,40,80],
        'perf_norm': [0,50,100],
    },

    'fp8-isca/rebuttal/ram/mlperf': {
        'perf': [0, 1, 2],
        'perf_norm': [50, 75, 100],
    },
    'fp8-isca/rebuttal/ram/fc': {
        'perf': [0, 1, 2],
        'perf_norm': [50, 75, 100],
    },
    'fp8-isca/rebuttal/ram/conv': {
        'perf': [0, 1, 2],
        'perf_norm': [50, 75, 100],
    },
    'fp8-isca/rebuttal/shape/mlperf': {
        'perf': [0,2,4],
        'area_breakdown': [0,1,2],
        'energy_breakdown': [0,1],
    },
    'fp8-isca/rebuttal/noc': {
        'access_sram': [0, 1],
        'access_dram': [0, 2, 4],
        'perf': [0,2,4,6],
        'throughput/energy': [0,1,2,3],
        'throughput/power': [0,0.5, 1, 1.5],
    },
    'fp8-isca/rebuttal/batch': {
        'perf': [0,3,6],
        'perf_norm': [0,50,100],

    },
    'fp8-isca/rebuttal/batch/convfc': {
        'perf': [0,40,80],
        'perf_norm': [0,50,100],
    },

    
    'fp8-isca/rebuttal2/ram/mlperf': {
        'perf': [0, 1, 2],
        'perf_norm': [50, 75, 100],
    },
    'fp8-isca/rebuttal2/ram/fc': {
        'perf': [0, 1, 2],
        'perf_norm': [50, 75, 100],
    },
    'fp8-isca/rebuttal2/ram/conv': {
        'perf': [0, 1, 2],
        'perf_norm': [50, 75, 100],
    },
    'fp8-isca/rebuttal2/shape/mlperf': {
        'perf': [0,2,4],
        'area_breakdown': [0,1,2],
        'energy_breakdown': [0,1],
    },
    'fp8-isca/rebuttal2/noc': {
        'access_sram': [0, 1],
        'access_dram': [0, 2, 4],
        'perf': [0,2,4,6],
        'throughput/energy': [0,1,2,3],
        'throughput/power': [0,0.5, 1, 1.5],
    },
    'fp8-isca/rebuttal2/batch': {
        'perf': [0,3,6],
        'perf_norm': [0,50,100],

    },
    'fp8-isca/rebuttal2/batch/convfc': {
        'perf': [0,40,80],
        'perf_norm': [0,50,100],
    },

}

hatch_map = {
    'isram': '////',
    'wsram': '////',
    'osram': '////',
    'ififo': '||||',
    'wfifo': '----',
    'ofifo': '++++',
    'oaccu': 'OOOO',
    'compu': 'oooo',
    'waccu': 'xxxx', #
    'itemp': '....', #
    'osmux': '\\\\\\\\', #
    'bpipe': '****', #
    'sram': '////',
    'buffer': '||||',
    'compute': 'xxxx',

    'bf16': '\\\\\\\\',
    'fp8':  '--------',
    'int8': 'xxxxxxxx',
    'int4': '',
}
ls_arr = ['-', ':', '--', '-.']
marker_arr = ['o', '^', 'x', 's']

pie_color_map = {
    'SRAM':'#66C5CC',
    'FIFO':'#F6CF71',
    'ACC':'#F89C74',
    'PE': '#B497E7',
    'TC': '#87C55F',
    'OR': '#9EB9F3',
    'compu': '#dedede',
}
# "ctr", "mac", "reg", "sub"
pie_color_arr = ["#88CCEE", "#CC6577", "#DAA519", "#999932"]

sys_breakdown_map_ = {
    'isram': 'sram',
    'wsram': 'sram',
    'osram': 'sram',
    'ififo': 'buffer',
    'wfifo': 'buffer',
    'ofifo': 'buffer',
    'oaccu': 'compute',
    'compu': 'compute',
}
sys_breakdown_map = {
    'isram': 'SRAM',
    'wsram': 'SRAM',
    'osram': 'SRAM',
    'ififo': 'FIFO',
    'wfifo': 'FIFO',
    'ofifo': 'FIFO',
    'oaccu': 'ACC',
    'compu': 'PE',
}
sys_breakdown_map_sram_and_rest = {
    'isram': 'SRAM',
    'wsram': 'SRAM',
    'osram': 'SRAM',
    'ififo': 'Array',
    'wfifo': 'Array',
    'ofifo': 'Array',
    'oaccu': 'Array',
    'compu': 'Array',
}
sys_breakdown_map_pe_level = {
    'compu': 'PE',
}
carat_breakdown_map_pe_level = {
    'compu': 'PE',
}
cris_breakdown_map_pe_level = {
    'compu': 'PE',
}
usys_breakdown_map_pe_level = {
    'compu': 'PE',
}

usys_breakdown_map = {
    'isram': '',
    'wsram': '',
    'osram': '',
    'ififo': 'FIFO',
    'wfifo': 'FIFO',
    'ofifo': 'FIFO',
    'oaccu': 'ACC',
    'compu': 'PE',
}
usys_breakdown_map_sram_and_rest = {
    'isram': '',
    'wsram': '',
    'osram': '',
    'ififo': 'Array',
    'wfifo': 'Array',
    'ofifo': 'Array',
    'oaccu': 'Array',
    'compu': 'Array',
}

tlut_breakdown_map_ = {
    'isram': 'sram',
    'wsram': 'sram',
    'osram': 'sram',
    'ififo': 'buffer',
    'wfifo': 'buffer',
    'ofifo': 'buffer',
    'oaccu': 'compute',
    'compu': 'buffer',
    'waccu': 'compute',
    'itemp': 'buffer',
    'osmux': 'compute',
    'bpipe': 'buffer',
}

carat_breakdown_map = {
    'isram': 'SRAM',
    'wsram': 'SRAM',
    'osram': 'SRAM',
    'ififo': 'FIFO',
    'wfifo': 'FIFO',
    'ofifo': 'FIFO',
    'oaccu': 'ACC',
    'compu': 'PE',
    'waccu': 'ACC',
    'itemp': 'TC',
    'osmux': 'OR',
    'bpipe': 'TC',
}
carat_breakdown_map_sram_and_rest = {
    'isram': 'SRAM',
    'wsram': 'SRAM',
    'osram': 'SRAM',
    'ififo': 'Array',
    'wfifo': 'Array',
    'ofifo': 'Array',
    'oaccu': 'Array',
    'compu': 'Array',
    'waccu': 'Array',
    'itemp': 'Array',
    'osmux': 'Array',
    'bpipe': 'Array',
}

cris_breakdown_map = {
    'isram': 'SRAM',
    'wsram': 'SRAM',
    'osram': 'SRAM',
    'compu': 'PE',
    'reuse': 'PE',
}
cris_breakdown_map_sram_and_rest = {
    'isram': 'SRAM',
    'wsram': 'SRAM',
    'osram': 'SRAM',
    'compu': 'Array',
    'reuse': 'Array',
}

hatch_map_cg = {
    'SRAM': '////',
    'FIFO': '||||',
    'PE': 'xxxx',
    'ACC': '....',
    'TC': '****',
    'OR': '\\\\',
}

sys_color_map = {
    'systolic_edge_16x16_int8': bcolors.gray,
    'systolic_edge_16x16_int16': bcolors.gray,
    'systolic_edge_16x16_bf16': bcolors.gray,
    'systolic_edge_16x16_bf16_acc16': bcolors.gray,

    'systolic_edge_32x16_int8': bcolors.gray,
    'systolic_edge_32x16_int16': bcolors.gray,
    'systolic_edge_32x16_bf16': bcolors.gray,
    'systolic_edge_32x16_bf16_acc16': bcolors.gray,
    
    'systolic_edge_64x16_int8': bcolors.gray,
    'systolic_edge_64x16_int16': bcolors.gray,
    'systolic_edge_64x16_bf16': bcolors.gray,
    'systolic_edge_64x16_bf16_acc16': bcolors.gray,

    'systolic_edge_128x16_int8': bcolors.gray,
    'systolic_edge_128x16_int16': bcolors.gray,
    'systolic_edge_128x16_bf16': bcolors.gray,
    'systolic_edge_128x16_bf16_acc16': bcolors.gray,

    'systolic_edge_256x16_int8_s0': bcolors.gray,
    'systolic_edge_256x16_int8_s2': bcolors.gray,
    'systolic_edge_256x16_int8_s4': bcolors.gray,
    'systolic_edge_256x16_int8_s8': bcolors.gray,
    'systolic_edge_256x16_int8_b0': bcolors.gray,
    'systolic_edge_256x16_int8_b2': bcolors.gray,
    'systolic_edge_256x16_int8': bcolors.gray,
    'systolic_edge_256x16_int16': bcolors.gray,
    'systolic_edge_256x16_bf16_s0': bcolors.gray,
    'systolic_edge_256x16_bf16_s2': bcolors.gray,
    'systolic_edge_256x16_bf16_s4': bcolors.gray,
    'systolic_edge_256x16_bf16_s8': bcolors.gray,
    'systolic_edge_256x16_bf16_b0': bcolors.gray,
    'systolic_edge_256x16_bf16_b2': bcolors.gray,
    'systolic_edge_256x16_bf16': bcolors.gray,
    'systolic_edge_256x16_bf16_acc16': bcolors.gray,

    'systolic_edge_32x32_int8': bcolors.gray,
    'systolic_edge_32x32_int16': bcolors.gray,
    'systolic_edge_32x32_bf16': bcolors.gray,
    'systolic_edge_32x32_bf16_acc16': bcolors.gray,

    'systolic_edge_64x64_fp8_s4': bcolors.gray,
    'systolic_edge_64x64_fp8_acc16_s4': bcolors.gray,
    'systolic_edge_32x32_fp8_s4': bcolors.gray,
    'systolic_edge_64x32_fp8_s4': bcolors.gray,

    'systolic_edge_64x64_int8_s4': bcolors.gray,
    'systolic_edge_64x64_int4_s4': bcolors.gray,

    'systolic_edge_64x64_bf16_s4': bcolors.gray,
    'systolic_edge_64x64_bf16_acc16_s4': bcolors.gray,
}

tlut_color_map = {
    'tlut_intra_1024': bcolors.blue,
    'tlut_intra_1024_bf16_t1': bcolors.blue,
    'tlut_intra_1024_bf16_t1_acc16': bcolors.blue,
    'tlut_intra_1024_int16_t1': bcolors.blue,
    'tlut_intra_1024_int8_t1': bcolors.blue,

    'tlut_intra_1024_bf16_t2': bcolors.blue,
    'tlut_intra_1024_bf16_t2_acc16': bcolors.blue,
    'tlut_intra_1024_int16_t2': bcolors.blue,
    'tlut_intra_1024_int8_t2': bcolors.blue,

    'tlut_intra_1024_bf16_t4': bcolors.blue,
    'tlut_intra_1024_bf16_t4_acc16': bcolors.blue,
    'tlut_intra_1024_int16_t4': bcolors.blue,
    'tlut_intra_1024_int8_t4': bcolors.blue,

    'tlut_intra_1024_bf16_t8': bcolors.blue,
    'tlut_intra_1024_bf16_t8_acc16': bcolors.blue,
    'tlut_intra_1024_int16_t8': bcolors.blue,
    'tlut_intra_1024_int8_t8': bcolors.blue,

    ###################################
    'tlut_inter_1024': bcolors.orange,
    'tlut_inter_1024_bf16_t1': bcolors.orange,
    'tlut_inter_1024_bf16_t1_acc16': bcolors.orange,
    'tlut_inter_1024_int16_t1': bcolors.orange,
    'tlut_inter_1024_int8_t1': bcolors.orange,

    'tlut_inter_1024_bf16_t2': bcolors.orange,
    'tlut_inter_1024_bf16_t2_acc16': bcolors.orange,
    'tlut_inter_1024_int16_t2': bcolors.orange,
    'tlut_inter_1024_int8_t2': bcolors.orange,

    'tlut_inter_1024_bf16_t4': bcolors.orange,
    'tlut_inter_1024_bf16_t4_acc16': bcolors.orange,
    'tlut_inter_1024_int16_t4': bcolors.orange,
    'tlut_inter_1024_int8_t4': bcolors.orange,

    'tlut_inter_1024_bf16_t8': bcolors.orange,
    'tlut_inter_1024_bf16_t8_acc16': bcolors.orange,
    'tlut_inter_1024_int16_t8': bcolors.orange,
    'tlut_inter_1024_int8_t8': bcolors.orange,

    ###################################
    'tlut_intra_2048': bcolors.blue,
    'tlut_intra_2048_bf16_t1': bcolors.blue,
    'tlut_intra_2048_bf16_t1_acc16': bcolors.blue,
    'tlut_intra_2048_int16_t1': bcolors.blue,
    'tlut_intra_2048_int8_t1': bcolors.blue,

    'tlut_intra_2048_bf16_t2': bcolors.blue,
    'tlut_intra_2048_bf16_t2_acc16': bcolors.blue,
    'tlut_intra_2048_int16_t2': bcolors.blue,
    'tlut_intra_2048_int8_t2': bcolors.blue,

    'tlut_intra_2048_bf16_t4': bcolors.blue,
    'tlut_intra_2048_bf16_t4_acc16': bcolors.blue,
    'tlut_intra_2048_int16_t4': bcolors.blue,
    'tlut_intra_2048_int8_t4': bcolors.blue,

    'tlut_intra_2048_bf16_t8': bcolors.blue,
    'tlut_intra_2048_bf16_t8_acc16': bcolors.blue,
    'tlut_intra_2048_int16_t8': bcolors.blue,
    'tlut_intra_2048_int8_t8': bcolors.blue,

    ###################################
    'tlut_inter_2048': bcolors.orange,
    'tlut_inter_2048_bf16_t1': bcolors.orange,
    'tlut_inter_2048_bf16_t1_acc16': bcolors.orange,
    'tlut_inter_2048_int16_t1': bcolors.orange,
    'tlut_inter_2048_int8_t1': bcolors.orange,

    'tlut_inter_2048_bf16_t2': bcolors.orange,
    'tlut_inter_2048_bf16_t2_acc16': bcolors.orange,
    'tlut_inter_2048_int16_t2': bcolors.orange,
    'tlut_inter_2048_int8_t2': bcolors.orange,

    'tlut_inter_2048_bf16_t4': bcolors.orange,
    'tlut_inter_2048_bf16_t4_acc16': bcolors.orange,
    'tlut_inter_2048_int16_t4': bcolors.orange,
    'tlut_inter_2048_int8_t4': bcolors.orange,

    'tlut_inter_2048_bf16_t8': bcolors.orange,
    'tlut_inter_2048_bf16_t8_acc16': bcolors.orange,
    'tlut_inter_2048_int16_t8': bcolors.orange,
    'tlut_inter_2048_int8_t8': bcolors.orange,

    'tlut_intra_4096': bcolors.blue,
    'tlut_intra_4096_bf16_t1': bcolors.blue,
    'tlut_intra_4096_bf16_t1_acc16': bcolors.blue,
    'tlut_intra_4096_int16_t1': bcolors.blue,
    'tlut_intra_4096_int8_t1': bcolors.blue,

    'tlut_intra_4096_bf16_t2': bcolors.blue,
    'tlut_intra_4096_bf16_t2_acc16': bcolors.blue,
    'tlut_intra_4096_int16_t2': bcolors.blue,
    'tlut_intra_4096_int8_t2': bcolors.blue,

    'tlut_intra_4096_bf16_t4_s0': bcolors.blue,
    'tlut_intra_4096_bf16_t4_s2': bcolors.blue,
    'tlut_intra_4096_bf16_t4_s4': bcolors.blue,
    'tlut_intra_4096_bf16_t4_acc16_s4': bcolors.blue,
    'tlut_intra_4096_bf16_t4_s8': bcolors.blue,
    'tlut_intra_4096_bf16_t4_b0': bcolors.blue,
    'tlut_intra_4096_bf16_t4_b2': bcolors.blue,
    'tlut_intra_4096_bf16_t4': bcolors.blue,
    'tlut_intra_4096_bf16_t4_acc16': bcolors.blue,
    'tlut_intra_4096_int16_t4': bcolors.blue,
    'tlut_intra_4096_int8_t4_s0': bcolors.blue,
    'tlut_intra_4096_int8_t4_s2': bcolors.blue,
    'tlut_intra_4096_int8_t4_s4': bcolors.blue,
    'tlut_intra_4096_int8_t4_s8': bcolors.blue,
    'tlut_intra_4096_int8_t4_b0': bcolors.blue,
    'tlut_intra_4096_int8_t4_b2': bcolors.blue,
    'tlut_intra_4096_int8_t4': bcolors.blue,

    'tlut_intra_4096_bf16_t8': bcolors.blue,
    'tlut_intra_4096_bf16_t8_acc16': bcolors.blue,
    'tlut_intra_4096_int16_t8': bcolors.blue,
    'tlut_intra_4096_int8_t8': bcolors.blue,

    ###################################
    'tlut_inter_4096': bcolors.orange,
    'tlut_inter_4096_bf16_t1': bcolors.orange,
    'tlut_inter_4096_bf16_t1_acc16': bcolors.orange,
    'tlut_inter_4096_int16_t1': bcolors.orange,
    'tlut_inter_4096_int8_t1': bcolors.orange,

    'tlut_inter_4096_bf16_t2': bcolors.orange,
    'tlut_inter_4096_bf16_t2_acc16': bcolors.orange,
    'tlut_inter_4096_int16_t2': bcolors.orange,
    'tlut_inter_4096_int8_t2': bcolors.orange,

    'tlut_inter_4096_bf16_t4_s0': bcolors.orange,
    'tlut_inter_4096_bf16_t4_s2': bcolors.orange,
    'tlut_inter_4096_bf16_t4_s4': bcolors.orange,
    'tlut_inter_4096_bf16_t4_acc16_s4': bcolors.orange,
    'tlut_inter_4096_bf16_t4_s8': bcolors.orange,
    'tlut_inter_4096_bf16_t4_b0': bcolors.orange,
    'tlut_inter_4096_bf16_t4_b2': bcolors.orange,
    'tlut_inter_4096_bf16_t4': bcolors.orange,
    'tlut_inter_4096_bf16_t4_acc16': bcolors.orange,
    'tlut_inter_4096_int16_t4': bcolors.orange,
    'tlut_inter_4096_int8_t4_s0': bcolors.orange,
    'tlut_inter_4096_int8_t4_s2': bcolors.orange,
    'tlut_inter_4096_int8_t4_s4': bcolors.orange,
    'tlut_inter_4096_int8_t4_s8': bcolors.orange,
    'tlut_inter_4096_int8_t4_b0': bcolors.orange,
    'tlut_inter_4096_int8_t4_b2': bcolors.orange,
    'tlut_inter_4096_int8_t4': bcolors.orange,

    'tlut_inter_4096_bf16_t8': bcolors.orange,
    'tlut_inter_4096_bf16_t8_acc16': bcolors.orange,
    'tlut_inter_4096_int16_t8': bcolors.orange,
    'tlut_inter_4096_int8_t8': bcolors.orange,

    'tlut_inter_4096_fp8_t4_s4': bcolors.orange,
    'tlut_inter_4096_fp8_t4_acc16_s4': bcolors.orange,
    'tlut_inter_4096_fp8_t2_s4': bcolors.orange,
    'tlut_inter_4096_fp8_t1_s4': bcolors.orange,
    'tlut_intra_4096_fp8_t4_s4': bcolors.blue,
    'tlut_intra_4096_fp8_t4_acc16_s4': bcolors.blue,
    'tlut_intra_4096_fp8_t2_s4': bcolors.blue,
    'tlut_intra_4096_fp8_t1_s4': bcolors.blue,

    'tlut_inter_1024_fp8_t4_s4': bcolors.orange,
    'tlut_inter_2048_fp8_t4_s4': bcolors.orange,
    'tlut_intra_1024_fp8_t4_s4': bcolors.blue,
    'tlut_intra_2048_fp8_t4_s4': bcolors.blue,

    'tlut_intra_4096_fp8_t1_b2_s4': bcolors.blue,
    'tlut_inter_4096_fp8_t1_b2_s4': bcolors.orange,
    'tlut_intra_4096_fp8_t2_b2_s4': bcolors.blue,
    'tlut_inter_4096_fp8_t2_b2_s4': bcolors.orange,
    'tlut_intra_4096_fp8_t4_b2_s4': bcolors.blue,
    'tlut_inter_4096_fp8_t4_b2_s4': bcolors.orange,


    'tlut_intra_4096_int4_t4_s4': bcolors.blue,
    'tlut_inter_4096_int4_t4_s4': bcolors.orange,

}

carat_color_map = {
    'carat_16_fp8_acc16': bcolors.orange,
    'carat_32_fp8_acc16': bcolors.orange,
    'carat_64_fp8_acc16': bcolors.orange,
    'carat_128_fp8_acc16': bcolors.orange,
    'carat_256_fp8_acc16': bcolors.orange,
    'carat_512_fp8_acc16': bcolors.orange,
    'carat_4096_fp8_acc16': bcolors.orange,
    'carat_2048_fp8_acc16': bcolors.orange,
    'carat_1024_fp8_acc16': bcolors.orange,
}

carat_noc_color_map = {
    'carat_noc4x4_512_fp8_acc16': bcolors.orange,
    'carat_noc8x8_128_fp8_acc16': bcolors.orange,
}
carat_i1_color_map = {
    'carat_i1_4096_fp8_acc16': bcolors.cactus,
    'carat_i1_2048_fp8_acc16': bcolors.cactus,
    'carat_i1_1024_fp8_acc16': bcolors.cactus,
}
carat_idle8_color_map = {
    'carat_idle8_4096_fp8_acc16': bcolors.cactus,
    'carat_idle8_2048_fp8_acc16': bcolors.cactus,
    'carat_idle8_1024_fp8_acc16': bcolors.cactus,
}
cris_color_map = {
    'cris_16_fp8_acc16': bcolors.cactus,
    'cris_32_fp8_acc16': bcolors.cactus,
    'cris_64_fp8_acc16': bcolors.cactus,
    'cris_128_fp8_acc16': bcolors.cactus,
    'cris_256_fp8_acc16': bcolors.cactus,
}
cris_noc_color_map = {
    'cris_noc4x4_256_fp8_acc16': bcolors.cactus,
    'cris_noc8x8_64_fp8_acc16': bcolors.cactus,
}
usys_color_map = {
    'uSystolic_4x4_int8_acc24': bcolors.blue,
    'uSystolic_8x8_int8_acc24': bcolors.blue,
    'uSystolic_16x16_int8_acc24': bcolors.blue,
    'uSystolic_64x64_int8_acc24': bcolors.blue,
    'uSystolic_64x32_int8_acc24': bcolors.blue,
    'uSystolic_32x32_int8_acc24': bcolors.blue,
    'uSystolic_128x128_int8_acc24': bcolors.blue,
    'uSystolic_256x256_int8_acc24': bcolors.blue,
}
sys_color_map_new = {
    'systolic_4x4_fp8_acc16': bcolors.gray,
    'systolic_8x8_fp8_acc16': bcolors.gray,
    'systolic_16x16_fp8_acc16': bcolors.gray,
    'systolic_64x64_fp8_acc16': bcolors.gray,
    'systolic_64x32_fp8_acc16': bcolors.gray,
    'systolic_32x32_fp8_acc16': bcolors.gray,
}

color_map = {
    'arch_systolic_edge': sys_color_map,
    'arch_tlut_intra': tlut_color_map,
    'arch_tlut_inter': tlut_color_map,
    'arch_carat': carat_color_map,
    'arch_carat_i1': carat_i1_color_map,
    'arch_carat_idle8': carat_idle8_color_map,
    'arch_uSystolic': usys_color_map,
    'arch_systolic': sys_color_map_new,
    'arch_cris': cris_color_map,
    'arch_carat_noc': carat_noc_color_map,
    'arch_cris_noc': cris_noc_color_map,
}


sys_opac_map = {
    'systolic_16x16': 0.3,
    'systolic_edge_16x16_int8': 0.3,
    'systolic_edge_16x16_int16': 0.3,
    'systolic_edge_16x16_bf16': 0.3,
    'systolic_edge_16x16_bf16_acc16': 0.3,

    'systolic_32x16': 0.4,
    'systolic_edge_32x16_int8': 0.4,
    'systolic_edge_32x16_int16': 0.4,
    'systolic_edge_32x16_bf16': 0.4,
    'systolic_edge_32x16_bf16_acc16': 0.4,
    
    'systolic_64x16': 0.5,
    'systolic_edge_64x16_int8': 0.5,
    'systolic_edge_64x16_int16': 0.5,
    'systolic_edge_64x16_bf16': 0.5,
    'systolic_edge_64x16_bf16_acc16': 0.5,

    'systolic_32x32': 0.6,
    'systolic_edge_32x32_int8': 0.6,
    'systolic_edge_32x32_int16': 0.6,
    'systolic_edge_32x32_bf16': 0.6,
    'systolic_edge_32x32_bf16_acc16': 0.6,

    'systolic_128x16': 0.7,
    'systolic_edge_128x16_int8': 0.7,
    'systolic_edge_128x16_int16': 0.7,
    'systolic_edge_128x16_bf16': 0.7,
    'systolic_edge_128x16_bf16_acc16': 0.7,

    'systolic_256x16': 0.9,
    'systolic_edge_256x16_int8_s0': 0.9,
    'systolic_edge_256x16_int8_s2': 0.9,
    'systolic_edge_256x16_int8_s4': 0.9,
    'systolic_edge_256x16_int8_s8': 0.9,
    'systolic_edge_256x16_int8_b0': 0.9,
    'systolic_edge_256x16_int8_b2': 0.9,
    'systolic_edge_256x16_int8': 0.9,
    'systolic_edge_256x16_int16': 0.9,
    'systolic_edge_256x16_bf16_s0': 0.9,
    'systolic_edge_256x16_bf16_s2': 0.9,
    'systolic_edge_256x16_bf16_s4': 0.9,
    'systolic_edge_256x16_bf16_s8': 0.9,
    'systolic_edge_256x16_bf16_b0': 0.9,
    'systolic_edge_256x16_bf16_b2': 0.9,
    'systolic_edge_256x16_bf16': 0.9,
    'systolic_edge_256x16_bf16_acc16': 0.9,

    'systolic_edge_64x64_fp8_s4': 0.99,
    'systolic_edge_32x32_fp8_s4': 0.6,
    'systolic_edge_64x32_fp8_s4': 0.8,

    'systolic_edge_64x64_int4_s4': 0.99,
    'systolic_edge_64x64_int8_s4': 0.99,

    'systolic_edge_64x64_fp8_acc16_s4': 0.99,

    'systolic_edge_64x64_bf16_s4':0.99,
    'systolic_edge_64x64_bf16_acc16_s4':0.99,
    
}

tlut_opac_map = {
    'tlut_intra_1024': 0.6,
    'tlut_intra_1024_bf16_t1': 0.4,
    'tlut_intra_1024_bf16_t1_acc16': 0.4,
    'tlut_intra_1024_int16_t1': 0.4,
    'tlut_intra_1024_int8_t1': 0.4,

    'tlut_intra_1024_bf16_t2': 0.6,
    'tlut_intra_1024_bf16_t2_acc16': 0.6,
    'tlut_intra_1024_int16_t2': 0.6,
    'tlut_intra_1024_int8_t2': 0.6,

    'tlut_intra_1024_bf16_t4': 0.8,
    'tlut_intra_1024_bf16_t4_acc16': 0.8,
    'tlut_intra_1024_int16_t4': 0.8,
    'tlut_intra_1024_int8_t4': 0.8,

    'tlut_intra_1024_bf16_t8': 0.99,
    'tlut_intra_1024_bf16_t8_acc16': 0.99,
    'tlut_intra_1024_int16_t8': 0.99,
    'tlut_intra_1024_int8_t8': 0.99,

    ###################################
    'tlut_inter_1024': 0.6,
    'tlut_inter_1024_bf16_t1': 0.4,
    'tlut_inter_1024_bf16_t1_acc16': 0.4,
    'tlut_inter_1024_int16_t1': 0.4,
    'tlut_inter_1024_int8_t1': 0.4,

    'tlut_inter_1024_bf16_t2': 0.6,
    'tlut_inter_1024_bf16_t2_acc16': 0.6,
    'tlut_inter_1024_int16_t2': 0.6,
    'tlut_inter_1024_int8_t2': 0.6,

    'tlut_inter_1024_bf16_t4': 0.8,
    'tlut_inter_1024_bf16_t4_acc16': 0.8,
    'tlut_inter_1024_int16_t4': 0.8,
    'tlut_inter_1024_int8_t4': 0.8,

    'tlut_inter_1024_bf16_t8': 0.99,
    'tlut_inter_1024_bf16_t8_acc16': 0.99,
    'tlut_inter_1024_int16_t8': 0.99,
    'tlut_inter_1024_int8_t8': 0.99,

    ###################################
    'tlut_intra_2048': 0.8,
    'tlut_intra_2048_bf16_t1': 0.4,
    'tlut_intra_2048_bf16_t1_acc16': 0.4,
    'tlut_intra_2048_int16_t1': 0.4,
    'tlut_intra_2048_int8_t1': 0.4,

    'tlut_intra_2048_bf16_t2': 0.6,
    'tlut_intra_2048_bf16_t2_acc16': 0.6,
    'tlut_intra_2048_int16_t2': 0.6,
    'tlut_intra_2048_int8_t2': 0.6,

    'tlut_intra_2048_bf16_t4': 0.8,
    'tlut_intra_2048_bf16_t4_acc16': 0.8,
    'tlut_intra_2048_int16_t4': 0.8,
    'tlut_intra_2048_int8_t4': 0.8,

    'tlut_intra_2048_bf16_t8': 0.99,
    'tlut_intra_2048_bf16_t8_acc16': 0.99,
    'tlut_intra_2048_int16_t8': 0.99,
    'tlut_intra_2048_int8_t8': 0.99,

    ###################################
    'tlut_inter_2048': 0.8,
    'tlut_inter_2048_bf16_t1': 0.4,
    'tlut_inter_2048_bf16_t1_acc16': 0.4,
    'tlut_inter_2048_int16_t1': 0.4,
    'tlut_inter_2048_int8_t1': 0.4,

    'tlut_inter_2048_bf16_t2': 0.6,
    'tlut_inter_2048_bf16_t2_acc16': 0.6,
    'tlut_inter_2048_int16_t2': 0.6,
    'tlut_inter_2048_int8_t2': 0.6,

    'tlut_inter_2048_bf16_t4': 0.8,
    'tlut_inter_2048_bf16_t4_acc16': 0.8,
    'tlut_inter_2048_int16_t4': 0.8,
    'tlut_inter_2048_int8_t4': 0.8,

    'tlut_inter_2048_bf16_t8': 0.99,
    'tlut_inter_2048_bf16_t8_acc16': 0.99,
    'tlut_inter_2048_int16_t8': 0.99,
    'tlut_inter_2048_int8_t8': 0.99,

    ###################################
    'tlut_intra_4096': 0.99,
    'tlut_intra_4096_bf16_t1': 0.4,
    'tlut_intra_4096_bf16_t1_acc16': 0.4,
    'tlut_intra_4096_int16_t1': 0.4,
    'tlut_intra_4096_int8_t1': 0.4,

    'tlut_intra_4096_bf16_t2': 0.6,
    'tlut_intra_4096_bf16_t2_acc16': 0.6,
    'tlut_intra_4096_int16_t2': 0.6,
    'tlut_intra_4096_int8_t2': 0.6,

    'tlut_intra_4096_bf16_t4_s0': 0.7,
    'tlut_intra_4096_bf16_t4_s2': 0.9,
    'tlut_intra_4096_bf16_t4_s4': 0.99,
    'tlut_intra_4096_bf16_t4_acc16_s4': 0.99,
    'tlut_intra_4096_bf16_t4_s8': 0.99,
    'tlut_intra_4096_bf16_t4_b0': 0.6,
    'tlut_intra_4096_bf16_t4_b2': 0.99,
    'tlut_intra_4096_bf16_t4': 0.8,
    'tlut_intra_4096_bf16_t4_acc16': 0.8,
    'tlut_intra_4096_int16_t4': 0.8,
    'tlut_intra_4096_int8_t4_s0': 0.7,
    'tlut_intra_4096_int8_t4_s2': 0.9,
    'tlut_intra_4096_int8_t4_s4': 0.99,
    'tlut_intra_4096_int8_t4_s8': 0.99,
    'tlut_intra_4096_int8_t4_b0': 0.6,
    'tlut_intra_4096_int8_t4_b2': 0.99,
    'tlut_intra_4096_int8_t4': 0.8,

    'tlut_intra_4096_bf16_t8': 0.99,
    'tlut_intra_4096_bf16_t8_acc16': 0.99,
    'tlut_intra_4096_int16_t8': 0.99,
    'tlut_intra_4096_int8_t8': 0.99,

    ###################################
    'tlut_inter_4096': 0.99,
    'tlut_inter_4096_bf16_t1': 0.4,
    'tlut_inter_4096_bf16_t1_acc16': 0.4,
    'tlut_inter_4096_int16_t1': 0.4,
    'tlut_inter_4096_int8_t1': 0.4,

    'tlut_inter_4096_bf16_t2': 0.6,
    'tlut_inter_4096_bf16_t2_acc16': 0.6,
    'tlut_inter_4096_int16_t2': 0.6,
    'tlut_inter_4096_int8_t2': 0.6,

    'tlut_inter_4096_bf16_t4_s0': 0.7,
    'tlut_inter_4096_bf16_t4_s2': 0.9,
    'tlut_inter_4096_bf16_t4_s4': 0.99,
    'tlut_inter_4096_bf16_t4_acc16_s4': 0.99,
    'tlut_inter_4096_bf16_t4_s8': 0.99,
    'tlut_inter_4096_bf16_t4_b0': 0.6,
    'tlut_inter_4096_bf16_t4_b2': 0.99,
    'tlut_inter_4096_bf16_t4': 0.8,
    'tlut_inter_4096_bf16_t4_acc16': 0.8,
    'tlut_inter_4096_int16_t4': 0.8,
    'tlut_inter_4096_int8_t4_s0': 0.7,
    'tlut_inter_4096_int8_t4_s2': 0.9,
    'tlut_inter_4096_int8_t4_s4': 0.99,
    'tlut_inter_4096_int8_t4_s8': 0.99,
    'tlut_inter_4096_int8_t4_b0': 0.6,
    'tlut_inter_4096_int8_t4_b2': 0.99,
    'tlut_inter_4096_int8_t4': 0.8,

    'tlut_inter_4096_bf16_t8': 0.99,
    'tlut_inter_4096_bf16_t8_acc16': 0.99,
    'tlut_inter_4096_int16_t8': 0.99,
    'tlut_inter_4096_int8_t8': 0.99,

    'tlut_inter_4096_fp8_t4_s4': 0.99,
    'tlut_inter_4096_fp8_t4_acc16_s4': 0.99,
    'tlut_inter_4096_fp8_t2_s4': 0.8,
    'tlut_inter_4096_fp8_t1_s4': 0.6,
    'tlut_intra_4096_fp8_t4_s4': 0.99,
    'tlut_intra_4096_fp8_t4_acc16_s4': 0.99,
    'tlut_intra_4096_fp8_t2_s4': 0.8,
    'tlut_intra_4096_fp8_t1_s4': 0.6,

    'tlut_intra_1024_fp8_t4_s4': 0.6,
    'tlut_intra_2048_fp8_t4_s4': 0.8,
    'tlut_inter_1024_fp8_t4_s4': 0.6,
    'tlut_inter_2048_fp8_t4_s4': 0.8,

    'tlut_intra_4096_fp8_t1_b2_s4': 0.99,
    'tlut_inter_4096_fp8_t1_b2_s4': 0.99,
    'tlut_intra_4096_fp8_t2_b2_s4': 0.99,
    'tlut_inter_4096_fp8_t2_b2_s4': 0.99,
    'tlut_intra_4096_fp8_t4_b2_s4': 0.99,
    'tlut_inter_4096_fp8_t4_b2_s4': 0.99,

    'tlut_intra_4096_int4_t4_s4': 0.99,
    'tlut_inter_4096_int4_t4_s4': 0.99,

    ###################################
}

carat_opac_map = {
    'carat_16_fp8_acc16': 1,
    'carat_32_fp8_acc16': 1,
    'carat_64_fp8_acc16': 1,
    'carat_128_fp8_acc16': 1,
    'carat_256_fp8_acc16': 1,
    'carat_512_fp8_acc16': 1,
    'carat_4096_fp8_acc16': 0.99,
    'carat_2048_fp8_acc16': 0.8,
    'carat_1024_fp8_acc16': 0.6,
}

carat_noc_opac_map = {
    'carat_noc4x4_512_fp8_acc16': 1,
    'carat_noc8x8_128_fp8_acc16': 1,
}

carat_i1_opac_map = {
    'carat_i1_4096_fp8_acc16': 0.99,
    'carat_i1_2048_fp8_acc16': 0.8,
    'carat_i1_1024_fp8_acc16': 0.6,
}
carat_idle8_opac_map = {
    'carat_idle8_4096_fp8_acc16': 0.99,
    'carat_idle8_2048_fp8_acc16': 0.8,
    'carat_idle8_1024_fp8_acc16': 0.6,
}
cris_opac_map = {
    'cris_16_fp8_acc16': 1,
    'cris_32_fp8_acc16': 1,
    'cris_64_fp8_acc16': 1,
    'cris_128_fp8_acc16': 1,
    'cris_256_fp8_acc16': 1,
}

cris_noc_opac_map = {
    'cris_noc4x4_256_fp8_acc16': 1,
    'cris_noc8x8_64_fp8_acc16': 1,
}
sys_opac_map_new = {
    'systolic_4x4_fp8_acc16': 0.99,
    'systolic_8x8_fp8_acc16': 0.99,
    'systolic_16x16_fp8_acc16': 0.99,
    'systolic_64x64_fp8_acc16': 0.99,
    'systolic_64x32_fp8_acc16': 0.8,
    'systolic_32x32_fp8_acc16': 0.6,
}
usys_opac_map = {
    'uSystolic_4x4_int8_acc24': 0.99,
    'uSystolic_8x8_int8_acc24': 0.99,
    'uSystolic_16x16_int8_acc24': 0.99,
    'uSystolic_64x64_int8_acc24': 0.99,
    'uSystolic_64x32_int8_acc24': 0.8,
    'uSystolic_32x32_int8_acc24': 0.99,
    'uSystolic_128x128_int8_acc24': 0.6,
    'uSystolic_256x256_int8_acc24': 0.6,
}

opac_map = {
    'arch_systolic_edge': sys_opac_map,
    'arch_tlut_intra': tlut_opac_map,
    'arch_tlut_inter': tlut_opac_map,
    'arch_carat': carat_opac_map,
    'arch_carat_i1': carat_i1_opac_map,
    'arch_carat_idle8': carat_idle8_opac_map,
    'arch_cris': cris_opac_map,
    'arch_systolic': sys_opac_map_new,
    'arch_uSystolic': usys_opac_map,
    'arch_carat_noc': carat_noc_opac_map,
    'arch_cris_noc': cris_noc_opac_map,
}

yml_metric_map = {
    'perf_abs': 'flops per sec',
    'perf': 'flops per sec/norm',
    'perf_norm': 'perf_norm',
    'util_impl': 'utilization/impl',
    'rt_abs': 'runtime/impl',
    'rt_norm': 'runtime/impl/norm',
    'access_dram': 'total byte/dram/norm',
    'access_sram': 'access_sram/norm',#TODO
    'access_sram_dram':[
        'total byte/dram/norm',
        'access_sram/norm',
    ],

    'area_partition': 
        [\
        'isram/area/norm_percent', 'wsram/area/norm_percent', 'osram/area/norm_percent', \
        'ififo/area/norm_percent', 'wfifo/area/norm_percent', 'ofifo/area/norm_percent', \
        'oaccu/area/norm_percent', 'compu/area/norm_percent', \
        'waccu/area/norm_percent', 'itemp/area/norm_percent', 'osmux/area/norm_percent',  'bpipe/area/norm_percent', \
        ],
    'area_breakdown': 
        [\
        'SRAM/area/norm_percent', \
        'FIFO/area/norm_percent', \
        'PE/area/norm_percent', \
        'ACC/area/norm_percent', \
        'TC/area/norm_percent', \
        'OR/area/norm_percent', \
        ],
    'area_breakdown_pe_level': 
        [\
        'compu/area', \
        ],
    'area_breakdown_sram_and_rest':
        [\
        'SRAM/area/norm_percent', \
        'Array/area/norm_percent', \
        ],
    'area_breakdown_nosram': 
        [\
        'FIFO/area/norm_percent', \
        'PE/area/norm_percent', \
        'ACC/area/norm_percent', \
        'TC/area/norm_percent', \
        'OR/area/norm_percent', \
        ],

    'area_breakdown_array_level': 
        [\
        'FIFO/area', \
        'PE/area', \
        'ACC/area', \
        'TC/area', \
        'OR/area', \
        ],
    'area_breakdown_nosramfifo': 
        [\
        'PE/area/norm_percent', \
        'ACC/area/norm_percent', \
        'TC/area/norm_percent', \
        'OR/area/norm_percent', \
        ],
    'area_total': 'area_total/norm',
    'area_onchip': 'area_onchip/norm',
    'area_onchip_abs': 'area/onchip',
    'area_onchip_noc_abs': 'area_onchip_noc_abs',
    'area_dram': 'area/dram/norm',
    'area_sram': 'area/sram/norm',
    'area_compute': 'area/compute/norm',

    'power_total': 'power/total/total/norm',
    'power_onchip': 'power/onchip/total/norm',
    'power_dram': 'power/dram/total/norm',
    'power_sram': 'power/sram/total/norm',
    'power_compute': 'power/compute/total/norm',

    'energy_partition': 
        [\
        'isram/energy/total/percent', 'wsram/energy/total/percent', 'osram/energy/total/percent', \
        'ififo/energy/total/percent', 'wfifo/energy/total/percent', 'ofifo/energy/total/percent', \
        'oaccu/energy/total/percent', 'compu/energy/total/percent', \
        'waccu/energy/total/percent', 'itemp/energy/total/percent', 'osmux/energy/total/percent', 'bpipe/energy/total/percent', \
        ],
    'energy_breakdown': 
        [\
        'SRAM/energy/total/norm_percent', \
        'FIFO/energy/total/norm_percent', \
        'PE/energy/total/norm_percent', \
        'ACC/energy/total/norm_percent', \
        'TC/energy/total/norm_percent', \
        'OR/energy/total/norm_percent', \
        ],
    'energy_breakdown_pe_level': 
        [\
        'compu/energy/total', \
        ],
    'energy_breakdown_sram_and_rest': 
        [\
        'SRAM/energy/total/norm_percent', \
        'Array/energy/total/norm_percent', \
        ],
    'energy_breakdown_nosram': 
        [\
        'FIFO/energy/total/norm_percent', \
        'PE/energy/total/norm_percent', \
        'ACC/energy/total/norm_percent', \
        'TC/energy/total/norm_percent', \
        'OR/energy/total/norm_percent', \
        ],
    'energy_breakdown_array_level':
        [\
        'FIFO/energy/total', \
        'PE/energy/total', \
        'ACC/energy/total', \
        'TC/energy/total', \
        'OR/energy/total', \
        ],

    'energy_breakdown_nosramfifo': 
        [\
        'PE/energy/total/norm_percent', \
        'ACC/energy/total/norm_percent', \
        'TC/energy/total/norm_percent', \
        'OR/energy/total/norm_percent', \
        ],
    

    'power_breakdown': 
        [\
        'SRAM/power/total/norm_percent', \
        'FIFO/power/total/norm_percent', \
        'PE/power/total/norm_percent', \
        'ACC/power/total/norm_percent', \
        'TC/power/total/norm_percent', \
        'OR/power/total/norm_percent', \
        ],
    'power_breakdown_nosram': 
        [\
        'FIFO/power/total/norm_percent', \
        'PE/power/total/norm_percent', \
        'ACC/power/total/norm_percent', \
        'TC/power/total/norm_percent', \
        'OR/power/total/norm_percent', \
        ],
    'power_breakdown_nosramfifo': 
        [\
        'PE/power/total/norm_percent', \
        'ACC/power/total/norm_percent', \
        'TC/power/total/norm_percent', \
        'OR/power/total/norm_percent', \
        ],

    'energy_total': 'energy/total/total/norm',
    'energy_total_abs': 'energy/total/total',
    'energy_onchip': 'energy/onchip/total/norm',
    'energy_dram': 'energy/dram/total/norm',
    'energy_sram': 'energy/sram/total/norm',
    'energy_compute': 'energy/compute/total/norm',

    'throughput/area': 'throughput/area/norm', 
    'throughput/energy':'throughput/energy/norm', 
    'throughput/energy_abs':'throughput/energy_abs', 
    'throughput/power': 'throughput/power/norm',
    'throughput/power_abs': 'throughput/power_abs',

    'flops/area': 'flops/area/norm',
    'flops/energy': 'flops/energy/norm',
    'flops/power': 'flops/power/norm',

    'dram_access': 'dram_access/norm',
}

reduce_map = {
    'perf': 'geomean',
    'perf_norm': 'geomean',
    'util_impl': 'geomean',
    'rt_abs': 'sum',
    'rt_norm': 'geomean',

    'area_breakdown': 'geomean',
    'area_breakdown_nosram': 'geomean',
    'area_breakdown_array_level': 'geomean',
    'energy_breakdown_array_level': 'geomean',
    'area_breakdown_nosramfifo': 'geomean',
    'area_total': 'geomean',
    'area_onchip': 'geomean',
    'area_sram': 'geomean',
    'area_dram': 'geomean',
    'area_compute': 'geomean',

    'power_total': 'geomean',
    'power_onchip': 'geomean',
    'power_sram': 'geomean',
    'power_dram': 'geomean',
    'power_compute': 'geomean',

    'energy_partition': 'geomean',
    'energy_breakdown': 'geomean',
    'energy_breakdown_nosram': 'geomean',
    'energy_breakdown_nosramfifo': 'geomean',
    'energy_total': 'geomean',
    'energy_onchip': 'geomean',
    'energy_sram': 'geomean',
    'energy_dram': 'geomean',
    'energy_compute': 'geomean',

    'throughput/area': 'geomean',
    'throughput/energy': 'geomean',
    'throughput/power': 'geomean',

    'flops/area': 'geomean',
    'flops/energy': 'geomean',
    'flops/power': 'geomean',
}

single_multiple_map = {
    'perf': 'single',
    'perf_norm': 'single',
    'util_impl': 'single',
    'rt_abs': 'single',
    'rt_norm': 'single',

    'area_partition': 'multiple_single_n',
    'area_breakdown': 'multiple_single_n',
    'area_breakdown_nosram': 'multiple_single_n',
    'area_breakdown_nosramfifo': 'multiple_single_n',
    'area_total': 'single',
    'area_onchip': 'single',
    'area_dram': 'single',
    'area_sram': 'single',
    'area_compute': 'single',

    'power_total': 'single',
    'power_onchip': 'single',
    'power_dram': 'single',
    'power_sram': 'single',
    'power_compute': 'single',

    'energy_partition': 'multiple',
    'energy_breakdown': 'multiple',
    'energy_breakdown_nosram': 'multiple',
    'energy_breakdown_nosramfifo': 'multiple',
    'energy_total': 'single',
    'energy_onchip': 'single',
    'energy_dram': 'single',
    'energy_sram': 'single',
    'energy_compute': 'single',

    'throughput/area': 'single', 
    'throughput/energy':'single', 
    'throughput/power': 'single',

    'flops/area': 'single',
    'flops/energy': 'single',
    'flops/power': 'single',
}

partition_layerwise_reduction_map = {
    'area_partition': 'none',
    'area_breakdown': 'none',
    'area_breakdown_nosram': 'none',
    'area_breakdown_nosramfifo': 'none',
    'energy_partition': 'sum',
    'energy_breakdown': 'sum',
    'energy_breakdown_nosram': 'sum',
    'energy_breakdown_nosramfifo': 'sum',
}

axis_map = {
    'perf': 'Norm.\nthroughput\n(Gflops/s)',
    # 'perf_norm': 'Norm. Throughput (Flops/s)\n(normalized to respective peak)',
    'perf_norm': 'Compute\nutilization (%)',
    'util_impl': '\mathregular{Array utilization %}',
    'rt_abs': 'Total runtime\n(s)',
    'rt_norm': 'Norm. runtime\n(s)',
    'access_dram': 'Norm. DRAM\naccess',
    'access_sram': 'Norm. SRAM\naccess',

    'area_partition': 'Norm. on-chip\narea '+'($\mathregular{mm^{2}}$)',
    'area_breakdown': 'Norm. on-chip\narea '+'($\mathregular{mm^{2}}$)',
    'area_breakdown_sram_and_rest': 'Norm. on-chip\narea '+'($\mathregular{mm^{2}}$)',
    'area_breakdown_nosram': 'Norm. on-chip\narea '+'($\mathregular{mm^{2}}$)',
    'area_breakdown_nosramfifo': 'Norm. on-chip\narea '+'($\mathregular{mm^{2}}$)',
    'area_total': 'Norm. on-chip\narea '+'($\mathregular{mm^{2}}$)',
    'area_onchip': 'Norm. on-chip\narea '+'($\mathregular{mm^{2}}$)',
    'area_sram': 'Norm. SRAM area\n'+'($\mathregular{mm^{2}}$)',
    'area_dram': 'Norm. DRAM area\n'+'($\mathregular{mm^{2}}$)',
    'area_compute': 'Norm. compute area\n'+'($\mathregular{mm^{2}}$)',

    'power_total': 'Norm. total power\n(mW)',
    'power_onchip': 'Norm. on-chip power\n(mW)',
    'power_sram': 'Norm. SRAM power\n(mW)',
    'power_dram': 'Norm. DRAM power\n(mW)',
    'power_compute': 'Norm. compute power\n(mW)',
    'power_breakdown': 'Norm. compute power\n(mW)',
    'power_breakdown_nosram': 'Norm. compute power\n(mW)',
    'power_breakdown_nosramfifo': 'Norm. compute power\n(mW)',

    'energy_partition': 'Norm. on-chip\nenergy (nJ)',
    'energy_breakdown': 'Norm. on-chip\nenergy (nJ)',
    'energy_breakdown_sram_and_rest': 'Norm. on-chip\nenergy (nJ)',
    'energy_breakdown_nosram': 'Norm. on-chip\nenergy (nJ)',
    'energy_breakdown_nosramfifo': 'Norm. on-chip\nenergy (nJ)',
    'energy_total': 'Norm. total\nenergy (nJ)',
    'energy_onchip': 'Norm. on-chip\nenergy (nJ)',
    'energy_sram': 'Norm. SRAM\nenergy (nJ)',
    'energy_dram': 'Norm. DRAM\nenergy (nJ)',
    'energy_compute': 'Norm. compute\nenergy (nJ)',

    'throughput/area': 'Norm. area efficiency\n'+r'($\mathregular{(flop/s/mm^{2})}$)',
    'throughput/energy': 'Norm. energy\nefficiency\n(Gflop/s/J)',
    'throughput/power': 'Norm. power\nefficiency\n(Gflop/s/W)',

    'flops/area': r'Norm. area efficiency\n$\mathregular{(flop/mm^{2})}$',
    'flops/energy': 'Norm. energy efficiency\n(flop/nJ)',
    'flops/power': 'Norm. power efficiency\n(flop/mW)',

    'dram_access': "Norm. dram access"
}

mlperf_name_map = {
    'bert_base_uncased': 'BERT',
    'dlrm': 'DLRM',
    'resnet50': 'Resnet50',
    'RNNT': 'RNNT',
    'ssd300_vgg16': 'SSD',
    'UNet': 'UNet',
    'conv': 'Conv',
    'fc': 'FC',
}

legend_map = {
    'chunk_size_study_int8_1024': ['area_parition','area_onchip', 'area_breakdown', 'perf'],
    'dimension_study_int8': ['perf', 'energy_partition', 'area_breakdown'],
    'dimension_study_int8_dram2': ['perf', 'energy_partition', 'area_breakdown'],
    'format_study': ['perf', 'area_breakdown'],
    'format_study_dram2': ['perf', 'area_breakdown'],
    # 'bw_study': ['perf'],
    'size_study': ['perf'],
    'size_study_dram2': ['perf'],
    'bw_study': ['perf'],
    'bw_study_dram2': ['perf'],
    # 'size_study_int8': ['perf'],
    'dram_study': ['perf'],
    'size_dram2': ['perf'],
    'isopeak_size_dramx': ['area_partition', 'energy_partition'],
    'isoarea_size_dramx': ['area_partition', 'energy_partition'],
    'isoarea_size_dram2': ['perf', 'area_onchip'],
    'opt_chunksize_fp8': ['perf', 'area_onchip', 'area_breakdown'],
    'opt_height_fp8': ['perf', 'area_onchip', 'area_breakdown'],
    'opt_format': ['perf', 'area_breakdown'],
    'isoarea_size_dram3_s4_4formats': ['area_partition'],
    'fp8-isca/ram/dram51': ['perf'],
    'fp8-isca/ram/mlperf': ['perf'],
    'asplos/drambw': ['perf'],
    'asplos-rebuttal/drambw': ['perf'],
    # 'fp8-isca/ram/convfc': ['perf'],
    'fp8-isca/batch': ['perf'],
    'asplos/batch/gmean': ['perf'],
    'asplos/batch/permodel': ['perf'],
    'asplos-rebuttal/batch/gmean': ['perf'],
    'asplos-rebuttal/batch/permodel': ['perf'],
    'fp8-isca/batch/convfc': ['perf'],
    'fp8-isca/shape/mlperf': ['perf','area_breakdown'],
    'asplos/shape': ['perf','area_breakdown', 'power_breakdown',
                     'area_breakdown_nosram', 'area_breakdown_nosramfifo',
                     'area_breakdown_sram_and_rest',
                    #  'energy_breakdown_nosram', 'energy_breakdown_nosramfifo',
                    #  'power_breakdown_nosram', 'power_breakdown_nosramfifo',
    ],
    'asplos-rebuttal/shape': ['perf','area_breakdown', 'power_breakdown',
                     'area_breakdown_nosram', 'area_breakdown_nosramfifo',
                     'area_breakdown_sram_and_rest',
                     "area_breakdown_pe_level",
                     "area_breakdown_array_level",
                    #  'energy_breakdown_nosram', 'energy_breakdown_nosramfifo',
                    #  'power_breakdown_nosram', 'power_breakdown_nosramfifo',
    ],
    'asplos/shape/pie': [
                     'area_breakdown', 'area_breakdown_nosram', 
                     'energy_breakdown', 'power_breakdown',
                     'area_breakdown_nosramfifo',
                     'energy_breakdown_nosram', 'energy_breakdown_nosramfifo',
                     'power_breakdown_nosram', 'power_breakdown_nosramfifo',
                     "area_breakdown_array_level",

    ],
    'asplos-rebuttal/shape/pie': [
                     'area_breakdown', 
                     'area_breakdown_nosram', 
                     'energy_breakdown', 'power_breakdown',
                     'area_breakdown_nosramfifo',
                    #  'energy_breakdown_nosram', 
                     'energy_breakdown_nosramfifo',
                     'power_breakdown_nosram', 'power_breakdown_nosramfifo',
                     "area_breakdown_array_level",
    ],
    'fp8-isca/noc': ['perf',],
    'asplos/noc': ['perf',],
    'asplos-rebuttal/noc': ['perf',],

    'fp8-isca/rebuttal/ram/dram51': ['perf'],
    'fp8-isca/rebuttal/ram/mlperf': ['perf'],
    # 'fp8-isca/rebuttal/ram/convfc': ['perf'],
    'fp8-isca/rebuttal/batch': ['perf'],
    'fp8-isca/rebuttal/batch/convfc': ['perf'],
    'fp8-isca/rebuttal/shape/mlperf': ['perf','area_breakdown'],
    'fp8-isca/rebuttal/noc': ['perf',],

    'fp8-isca/rebuttal2/ram/dram51': ['perf'],
    'fp8-isca/rebuttal2/ram/mlperf': ['perf'],
    # 'fp8-isca/rebuttal2/ram/convfc': ['perf'],
    'fp8-isca/rebuttal2/batch': ['perf'],
    'fp8-isca/rebuttal2/batch/convfc': ['perf'],
    'fp8-isca/rebuttal2/shape/mlperf': ['perf','area_breakdown'],
    'fp8-isca/rebuttal2/noc': ['perf',],
}
legend_vec_map = {
    'fp8-isca/shape/mlperf': {
        'perf': [(0,0.9,0.5,0.1), 'upper left'],
    },
    'asplos/shape': {
        'perf': [(0,0.9,0.5,0.1), 'upper left'],
        'area_breakdown_sram_and_rest': [(0,0.9,0.5,0.1), 'upper left', 2],
    },
    'asplos-rebuttal/shape': {
        'perf': [(0,0.9,0.2,0.1), 'upper left'],
        'area_breakdown_sram_and_rest': [(0,0.9,0.86,0.1), 'upper left', 4],
        'area_breakdown': [(0,0.5,0.65,0.5), 'upper left', 3],
        'area_breakdown_pe_level': [(1,0,0.1,1), 'lower left', 1],
    },
    'fp8-isca/noc': {
        'access_sram': [(0.05,0.01,0.9,0.1), 'lower left', 2],
        'throughput/energy': [(0,0.9,0.5,0.1), 'upper left', 1],
    },
    'asplos/batch/permodel': {
        'perf': [(0,0.75,0.35,0.1), 'lower left', 3],
    },
    'asplos-rebuttal/batch/permodel': {
        'perf': [(0,1.3,0.55,0.05), 'lower left', 5],
    },
    'asplos/noc': {
        # 'perf': [(0,1,1,0.3), 'upper left', 4],
        # 'access_sram': [(0,1,1,0.3), 'lower left', 2],
        # 'throughput/energy': [(0,0.9,0.5,0.1), 'upper left', 1],
    },
    'asplos-rebuttal/noc': {
        # 'perf': [(0,1,1,0.3), 'upper left', 4],
        # 'access_sram': [(0,1,1,0.3), 'lower left', 2],
        # 'throughput/energy': [(0,0.9,0.5,0.1), 'upper left', 1],
    },
    'fp8-isca/rebuttal/shape/mlperf': {
        'perf': [(0,0.9,0.5,0.1), 'upper left'],
    },
    'fp8-isca/rebuttal/noc': {
        'access_sram': [(0.05,0.01,0.9,0.1), 'lower left', 2],
        'throughput/energy': [(0,0.9,0.5,0.1), 'upper left', 1],
    },
    'fp8-isca/rebuttal2/shape/mlperf': {
        'perf': [(0,0.9,0.5,0.1), 'upper left'],
    },
    'fp8-isca/rebuttal2/noc': {
        'access_sram': [(0.05,0.01,0.9,0.1), 'lower left', 2],
        'throughput/energy': [(0,0.9,0.5,0.1), 'upper left', 1],
    },
}

clip_map = {
    'chunk_size_study_int8_1024': {
        'area_partition': 4,
        'area_breakdown': 2.8,
        'area_onchip': 3,
        },
    'dimension_study_int8': {
        'area_partition': 3.7,
        'area_breakdown': 3.7,
        'area_onchip': 3.7,
        'perf': 3,
        'flops/energy': 2.5,
    },
    'dimension_study_int8_dram2': {
        'area_partition': 2,
        'area_breakdown': 2,
        'area_onchip': 2,
        'perf': 3,#TODO
        'flops/energy': 2.5,
    },
    'opt_height_fp8': {
        'area_partition': 2.25,
        'area_breakdown': 2.25,
        'area_onchip': 2.25,
    },
    'fp8-isca/shape/mlperf': {
        'energy_breakdown': 1.3,
    },
    'asplos/shape': {
        'energy_breakdown': 1.01,
        'energy_breakdown_sram_and_rest': 1.01,
        'energy_breakdown_nosram': 0.25,
        'energy_breakdown_nosramfifo': 0.15,
        'power_breakdown': 60,
        'power_breakdown_nosram': 21,
        'power_breakdown_nosramfifo': 21,
    },
    'asplos-rebuttal/shape': {
        'energy_breakdown': 1.01,
        'energy_breakdown_sram_and_rest': 1.38,
        'energy_breakdown': 1.38,
        'energy_breakdown_nosram': 0.25,
        'energy_breakdown_nosramfifo': 0.15,
        'power_breakdown': 60,
        'power_breakdown_nosram': 21,
        'power_breakdown_nosramfifo': 21,
        'area_breakdown_nosramfifo': 2,
        'area_breakdown': 4,
    },
    'fp8-isca/noc': {
        'access_sram': 1.2,
    },
    'asplos/noc': {
        'access_sram': 1.2,
    },
    'asplos-rebuttal/noc': {
        'access_sram': 1.2,
    },
    'fp8-isca/rebuttal/shape/mlperf': {
        'energy_breakdown': 1.3,
    },
    'fp8-isca/rebuttal/noc': {
        'access_sram': 1.2,
    },
    'fp8-isca/rebuttal2/shape/mlperf': {
        'energy_breakdown': 1.3,
    },
    'fp8-isca/rebuttal2/noc': {
        'access_sram': 1.2,
    },
}

size_map = {
    # 1/3=1.10383333
    # 1/2=1.65575
    'fp8-isca/noc': {
        'perf': (3.3115, 0.9),
        'access_sram': (1.65575, 1),
        'access_dram': (1.65575, 1),
        'throughput/energy': (1.65575, 1),
        'throughput/power': (1.65575, 1),
    },
    'asplos/noc': {
        'perf': (3.3115, 0.9),
        'access_sram': (1.65575, 1),
        'access_dram': (1.65575, 1),
        'throughput/energy': (1.65575, 1),
        'throughput/power': (1.65575, 1),
    },
    'asplos-rebuttal/noc': {
        'perf': (3.3115, 0.9),
        'access_sram': (1.65575, 1),
        'access_dram': (1.65575, 1),
        'throughput/energy': (1.65575, 1),
        'throughput/power': (1.65575, 1),
    },
    'fp8-isca/shape/mlperf': {
        'perf': (1.65575, 1.15),
        'perf_norm': (1.65575, 1.15),
    },
    'fp8-isca/ram/conv': {
        'perf': (1.65575, 1),
    },
    'fp8-isca/ram/fc': {
        'perf': (1.65575, 1),
    },
    'fp8-isca/ram/mlperf': {
        'perf': (3.3115, 1.1),
    },
    'asplos/drambw': {
        'perf': (3.3115, 1.1),
    },
    'asplos-rebuttal/drambw': {
        'perf': (3.3115, 1.1),
    },

    'fp8-isca/batch': {
        'perf': (3.3115, 1),
        'perf_norm': (3.3115, 0.9),
    },
    'asplos/batch/gmean': {
        'perf': (3.3115, 1),
        'perf_norm': (3.3115, 0.9),
    },
    'asplos-rebuttal/batch/gmean': {
        'perf': (3.3115, 1),
        'perf_norm': (3.3115, 0.9),
    },
    'asplos/batch/permodel': {
        'perf': (6.623, 1.1),
        'perf_norm': (6.623, 1.1),
    },
    'asplos-rebuttal/batch/permodel': {
        'perf': (6.623, 1.4),
        'perf_norm': (6.623, 1.1),
    },
    'asplos/shape/pie': {
        'area_breakdown': (3.3115, 5),
        'area_breakdown_nosram': (3.3115, 5),
        'area_breakdown_nosramfifo': (3.3115, 5),
        # 'area_breakdown': (50, 20),
        # 'perf_norm': (6.623, 0.9),
    },
    'asplos-rebuttal/shape/pie': {
        'area_breakdown': (3.3115, 5),
        'area_breakdown_nosram': (3.3115, 5),
        'area_breakdown_nosramfifo': (3.3115, 5),
        # 'area_breakdown': (50, 20),
        # 'perf_norm': (6.623, 0.9),
    },

    'asplos-rebuttal/shape/iso': {
        'perf': (1.65575, 0.95),
        'perf_norm': (1.65575, 0.95),
        'area_breakdown_sram_and_rest': (1.65575, 0.95),
        'energy_breakdown_sram_and_rest': (1.65575, 0.95),
    },
    'asplos/shape': {
        'perf': (1.65575, 1),
        'perf_norm': (1.65575, 1),
        'area_breakdown': (3.3115, 2),
        'area_breakdown_sram_and_rest': (3.3115, 0.9),
        'energy_breakdown': (3.3115, 1),
        'energy_breakdown_sram_and_rest': (3.3115, 0.9),
    },
    'asplos-rebuttal/shape': {
        'perf': (3.3115, 0.9),
        'perf_norm': (3.3115, 0.9),
        'area_breakdown': (3.3115, 1.55),
        'area_breakdown_sram_and_rest': (3.3115, 0.9),
        'energy_breakdown': (3.3115, 1),
        'energy_breakdown_sram_and_rest': (3.3115, 0.9),
    },
    'fp8-isca/batch/convfc': {
        'perf': (3.3115, 1.1),
        'perf_norm': (3.3115, 0.9),
    },

    'fp8-isca/rebuttal/noc': {
        'perf': (3.3115, 0.9),
        'access_sram': (1.65575, 1),
        'access_dram': (1.65575, 1),
        'throughput/energy': (1.65575, 1),
        'throughput/power': (1.65575, 1),
    },
    'fp8-isca/rebuttal/shape/mlperf': {
        'perf': (1.65575, 1.15),
        'perf_norm': (1.65575, 1.15),
    },
    'fp8-isca/rebuttal/ram/conv': {
        'perf': (1.65575, 1),
    },
    'fp8-isca/rebuttal/ram/fc': {
        'perf': (1.65575, 1),
    },
    'fp8-isca/rebuttal/ram/mlperf': {
        'perf': (3.3115, 1.1),
    },

    'fp8-isca/rebuttal/batch': {
        'perf': (3.3115, 1),
        'perf_norm': (3.3115, 0.9),

    },
    'fp8-isca/rebuttal/batch/convfc': {
        'perf': (3.3115, 1.1),
        'perf_norm': (3.3115, 0.9),
    },

    'fp8-isca/rebuttal2/noc': {
        'perf': (3.3115, 0.9),
        'access_sram': (1.65575, 1),
        'access_dram': (1.65575, 1),
        'throughput/energy': (1.65575, 1),
        'throughput/power': (1.65575, 1),
    },
    'fp8-isca/rebuttal2/shape/mlperf': {
        'perf': (1.65575, 1.15),
        'perf_norm': (1.65575, 1.15),
    },
    'fp8-isca/rebuttal2/ram/conv': {
        'perf': (1.65575, 1),
    },
    'fp8-isca/rebuttal2/ram/fc': {
        'perf': (1.65575, 1),
    },
    'fp8-isca/rebuttal2/ram/mlperf': {
        'perf': (3.3115, 1.1),
    },

    'fp8-isca/rebuttal2/batch': {
        'perf': (3.3115, 1),
        'perf_norm': (3.3115, 0.9),

    },
    'fp8-isca/rebuttal2/batch/convfc': {
        'perf': (3.3115, 1.1),
        'perf_norm': (3.3115, 0.9),
    },
}

default_ignore_vec = [False, False, False, False, False]
all_ignore_vec = [True, True, True, True, True]
default_ignore_vec_area = [True, True, False, False, False]
default_for_opac = [False, True, True, False, False]
ignore_vec_map = {
    #ignore_inter_intra, ignore_format, ignore_chunk, ignore_sys_dimension, ignore_tlut_dimension
    'fp8-isca/batch': {
        'perf': [True, True, True, True, True],
    },
    'asplos/batch/gmean': {
        'perf': [True, True, True, True, True],
    },
    'asplos-rebuttal/batch/gmean': {
        'perf': [True, True, True, True, True],
    },
    'asplos/batch/permodel': {
        'perf': [True, True, True, False, False],
    },
    'asplos-rebuttal/batch/permodel': {
        'perf': [True, True, True, False, False],
    },
    'fp8-isca/rebuttal/batch': {
        'perf': [True, True, True, True, True],
    },
    'fp8-isca/rebuttal2/batch': {
        'perf': [True, True, True, True, True],
    },
    'chunk_size_study_int8_1024': {
        'area_partition': [True, True, False, False, True],
        'area_breakdown': [True, True, False, False, True],
        'area_onchip': [True, True, False, False, True],
        'perf': [False, True, False, False, True],
        'perf_norm': [False, True, False, False, True],
        },
    'dimension_study_int8': {
        'area_partition': [True, True, True, False, False],
        'area_breakdown': [True, True, True, False, False],
        'area_onchip': [True, True, True, False, False],
        'perf': [False, True, True, False, False],
        'perf_norm': [False, True, True, False, False],
        'throughput/energy': [False, True, True, False, False],
    },
    'dimension_study_int8_dram2': {
        'area_partition': [True, True, True, False, False],
        'area_breakdown': [True, True, True, False, False],
        'area_onchip': [True, True, True, False, False],
        'perf': [False, True, True, False, False],
        'perf_norm': [False, True, True, False, False],
        'throughput/energy': [False, True, True, False, False],
    },
    'format_study': {
        'area_partition': [False,False,True,True,True],
        'area_breakdown': [False,False,True,True,True],
        'area_onchip': [False,False,True,True,True],
        'perf': [False, False, True, True, True],
        'perf_norm': [False, False, True, True, True],
        
    },
    'format_study_dram2': {
        'area_partition': [False,False,True,True,True],
        'area_breakdown': [False,False,True,True,True],
        'area_onchip': [False,False,True,True,True],
        'perf': [False, False, True, True, True],
        'perf_norm': [False, False, True, True, True],
        
    },
    'size_study_int8': {
        'perf': [False, False, True, True, True],
        'perf_norm': [False, False, True, True, True],
    },
    'size_study_bf16': {
        'perf': [False, False, True, True, True],
        'perf_norm': [False, False, True, True, True],
    },
    'bw_study_int8': {
        'perf': [False, False, True, True, True],
        'perf_norm': [False, False, True, True, True],
    },
    'bw_study_bf16': {
        'perf': [False, False, True, True, True],
        'perf_norm': [False, False, True, True, True],
    },
    'opt_chunksize_fp8': {
        'area_partition': [True, True, False, False, True],
        'area_breakdown': [True, True, False, False, True],
        'energy_breakdown': [False, True, False, False, True],
        'area_onchip': [True, True, False, False, True],
        'perf': [False, True, False, False, True],
        'perf_norm': [False, True, False, False, True],
        },
    'opt_height_fp8': {
        'area_partition': [True, True, True, False, False],
        'area_breakdown': [True, True, True, False, False],
        'energy_breakdown': [False, True, True, False, False],
        'area_onchip': [True, True, True, False, False],
        'perf': [False, True, True, False, False],
        'perf_norm': [False, True, True, False, False],
        'throughput/energy': [False, True, True, False, False],
    },
    'opt_format': {
        'energy_breakdown': [False, False, True, True, True],
    }
}

default_map={
    'none': 100,
}

def trim_item(item, ignore, trim_only=False):
    #0: ignore_inter_intra, 
    #1: ignore_format, 
    #2: ignore_chunk, 
    #3: ignore_sys_dimension, 
    #4: ignore_tlut_dimension
    new_item = item.split('/')[-1]
    new_item = new_item.replace('_edge', '')
    new_item = new_item.replace('_s4', '')
    new_item = new_item.replace('_dram2','')
    new_item = new_item.replace('_dram3','')
    new_item = new_item.replace('_dram4','')
    new_item = new_item.replace('_dram128','')
    new_item = new_item.replace('_dram256','')
    new_item = new_item.replace('_dram51','')
    new_item = new_item.replace('_dram25','')
    new_item = new_item.replace('_sram1','')
    if not trim_only: 
        new_item = new_item.replace('systolic', 'bSA')
        new_item = new_item.replace('carat', 'Carat')
        new_item = new_item.replace('uSystolic', 'uSA')
        new_item = new_item.replace('cris', 'RIS')
    
    if ignore[0]:
        new_item = new_item.replace('_inter', '')
        new_item = new_item.replace('_intra', '')
    else:
        if not trim_only:
            new_item = new_item.replace('_inter', '-r')
            new_item = new_item.replace('_intra', '-a')

    if ignore[1]:
        new_item = new_item.replace('_int8','')
        new_item = new_item.replace('_int4','')
        new_item = new_item.replace('_bf16','')
        new_item = new_item.replace('_fp8','')
        new_item = new_item.replace('_acc16','')
        new_item = new_item.replace('_acc24','')
        new_item = new_item.replace('_int16','')
    else:
        if not trim_only and ignore[4]:
            new_item = new_item.replace('_int8','$_{int8}$')
            new_item = new_item.replace('_bf16','$_{bf16}$')
            new_item = new_item.replace('_acc16','$_{\_acc16}$')
            new_item = new_item.replace('_int16','$_{int16}$')
            new_item = new_item.replace('_fp8','$_{fp8}$')
            new_item = new_item.replace('_int4','$_{int4}$')

    if ignore[2]:
        new_item = new_item.replace('_t1', '')
        new_item = new_item.replace('_t2', '')
        new_item = new_item.replace('_t4', '')
        new_item = new_item.replace('_t8', '')
    else: # fixing typo c for chunk
        if not trim_only and ignore[4]:
            new_item = new_item.replace('_t1', '$_{C1}$')
            new_item = new_item.replace('_t2', '$_{C2}$')
            new_item = new_item.replace('_t4', '$_{C4}$')
            new_item = new_item.replace('_t8', '$_{C8}$')
        else:
            new_item = new_item.replace('_t1', '_C1')
            new_item = new_item.replace('_t2', '_C2')
            new_item = new_item.replace('_t4', '_C4')
            new_item = new_item.replace('_t8', '_C8')

    if ignore[3]:
        new_item = new_item.replace('_8x8', '')
        new_item = new_item.replace('_4x4', '')
        new_item = new_item.replace('_32x16', '')
        new_item = new_item.replace('_64x16', '')
        new_item = new_item.replace('_16x16', '')
        new_item = new_item.replace('_32x32', '')
        new_item = new_item.replace('_128x16', '')
        new_item = new_item.replace('_256x16', '')
        new_item = new_item.replace('_64x32', '')
        new_item = new_item.replace('_64x64', '')
    else:
        if not trim_only:
            new_item = new_item.replace('_8x8', ' (8)')
            new_item = new_item.replace('_4x4', ' (4)')
            new_item = new_item.replace('_16x16', ' (16)')
            new_item = new_item.replace('_32x32', ' (32)')
            new_item = new_item.replace('_64x64', ' (64)')

    if ignore[4]:
        new_item = new_item.replace('_32', '')
        new_item = new_item.replace('_64', '')
        new_item = new_item.replace('_128', '')
        new_item = new_item.replace('_256', '')
        new_item = new_item.replace('_512', '')
        new_item = new_item.replace('_1024', '')
        new_item = new_item.replace('_2048', '')
        new_item = new_item.replace('_4096', '')
    else:
        if not trim_only:
            new_item = new_item.replace('_32', ' (32)')
            new_item = new_item.replace('_64', ' (64)')
            new_item = new_item.replace('_128', ' (128)')
            new_item = new_item.replace('_256', ' (256)')
            new_item = new_item.replace('_512', ' (512)')
            new_item = new_item.replace('_1024', ' (1024))')
            new_item = new_item.replace('_2048', ' (2048)')
            new_item = new_item.replace('_4096', ' (4096)')

    return r'{}'.format(new_item)
