from collections import OrderedDict
import sys, os
sys.path.append(os.getcwd())
from utils import yaml_load, bcolors,yaml_overwrite
import argparse
import numpy as np
import matplotlib.pyplot as plt
import matplotlib
from matplotlib.pyplot import cm
import os
import re
from scipy.stats import gmean
import math
import time
from plot_util import tlut_unique_component, hatch_map, ls_arr, marker_arr, \
    sys_breakdown_map, carat_breakdown_map, usys_breakdown_map, \
    hatch_map_cg, size_map, \
    color_map, opac_map, \
    yml_metric_map, reduce_map, single_multiple_map, \
    partition_layerwise_reduction_map, axis_map, \
    mlperf_name_map, legend_map, clip_map, default_map, \
    ignore_vec_map, default_ignore_vec, default_ignore_vec_area,default_for_opac, \
    my_dpi, fig_h, fig_h_short, fig_w, size_tuple, \
    y_ticks_map

# note that though this script is hard coded, the numbers can be extracted from running
# ./scripts/plot/asplos-rebuttal/plot_noc.sh

PEAK = 'peak flops per sec'

# matplotlib settings
font = {'serif':'Helvetica Neue', 'size': 6}
matplotlib.rc('font', **font)
matplotlib.rcParams['hatch.linewidth'] = 0.3
matplotlib.rcParams['lines.linewidth'] = 0.3
matplotlib.rcParams['axes.linewidth'] = 0.3
matplotlib.rcParams['axes.titlesize'] = 5
matplotlib.rcParams['xtick.major.width'] = 0.3
matplotlib.rcParams['ytick.major.width'] = 0.3
matplotlib.rcParams['xtick.labelsize'] = 5
matplotlib.rcParams['ytick.labelsize'] = 5
matplotlib.rcParams['xtick.major.size'] = 2
matplotlib.rcParams['ytick.major.size'] = 2
matplotlib.rcParams['legend.fontsize'] = 5
# matplotlib.rcParams['legend.handlelength'] = 2
matplotlib.rcParams['legend.labelspacing'] = 0.25

    
if __name__ == "__main__":
    size_tuple_local = (1.65575, 1)
    # display_group_list = ['single-\nnode', 'NoC-\n4x4', 'NoC-\n8x8', 'NoC-\n1x16', 'NoC-\n1x64']
    display_group_list = ['single-\nnode', 'NoC-\n4x4', 'NoC-\n8x8']
    os.makedirs('plot/mlperf', exist_ok=True)
    os.makedirs(f'plot/mlperf/noc', exist_ok=True)
    os.makedirs('plot/mlperf/asplos-rebuttal/noc', exist_ok=True)

    # plot_arr = [[1.0,2.518916227130392, 3.197041948831655, 0.15615780141161179, 0.1817216494373016]]
    plot_arr = [[1.0,2.518916227130392, 3.197041948831655]]
    fig, ax = plt.subplots(figsize=size_tuple_local, dpi=my_dpi)
    X_axis = np.arange(len(plot_arr[0]))
    plt.bar(
        X_axis, plot_arr[0],
        color=[bcolors.gray, bcolors.orange, bcolors.orange, bcolors.cactus, bcolors.cactus],
    )
    ax.set_xticks(range(len(display_group_list)))
    ax.set_xticklabels(display_group_list, rotation=0)
    # ax.legend()
    # display yticks
    yt = [1,2,3,4]
    ax.set_yticks(yt)
    ax.set_yticklabels(yt)
    ylab = axis_map['perf']
    ax.set_ylabel(ylab)
    fig_name = f'plot/mlperf/asplos-rebuttal/noc/perf'
    fig_name += '.pdf'
    fig.tight_layout()
    plt.savefig(fig_name, bbox_inches='tight', dpi=my_dpi, pad_inches=0.02)
    # print(bcolors.OKGREEN + f'Saved fig as {fig_name}' + bcolors.ENDC)



    # plot_arr = [[1.0,2.842676231213177, 4.133770741150261, 0.0009613685308744046, 0.00020607802149193288]]
    plot_arr = [[1.0,2.842676231213177, 4.133770741150261]]
    fig, ax = plt.subplots(figsize=size_tuple_local, dpi=my_dpi)
    X_axis = np.arange(len(plot_arr[0]))
    plt.bar(
        X_axis, plot_arr[0],
        color=[bcolors.gray, bcolors.orange, bcolors.orange, bcolors.cactus, bcolors.cactus],
    )
    ax.set_xticks(range(len(display_group_list)))
    ax.set_xticklabels(display_group_list, rotation=0)
    # display yticks
    yt = [1,2,3,4]
    ax.set_yticks(yt)
    ax.set_yticklabels(yt)
    ylab = axis_map['throughput/energy']
    ax.set_ylabel(ylab)
    fig_name = f'plot/mlperf/asplos-rebuttal/noc/throughput_energy'
    fig_name += '.pdf'
    fig.tight_layout()
    plt.savefig(fig_name, bbox_inches='tight', dpi=my_dpi, pad_inches=0.02)
    # print(bcolors.OKGREEN + f'Saved fig as {fig_name}' + bcolors.ENDC)

    # plot_arr = [[1.0, 1.128560314501431, 1.2934151307969863, 0.006156392404194856, 0.0011340314940478055]]
    plot_arr = [[1.0, 1.128560314501431, 1.2934151307969863]]
    fig, ax = plt.subplots(figsize=size_tuple_local, dpi=my_dpi)
    X_axis = np.arange(len(plot_arr[0]))
    plt.bar(
        X_axis, plot_arr[0],
        color=[bcolors.gray, bcolors.orange, bcolors.orange, bcolors.cactus, bcolors.cactus],
    )
    ax.set_xticks(range(len(display_group_list)))
    ax.set_xticklabels(display_group_list, rotation=0)
    # display yticks
    yt = [0,0.5,1,1.5]
    ax.set_yticks(yt)
    ax.set_yticklabels(yt)
    ylab = axis_map['throughput/power']
    ax.set_ylabel(ylab)
    fig_name = f'plot/mlperf/asplos-rebuttal/noc/throughput_power'
    fig_name += '.pdf'
    fig.tight_layout()
    plt.savefig(fig_name, bbox_inches='tight', dpi=my_dpi, pad_inches=0.02)
    # print(bcolors.OKGREEN + f'Saved fig as {fig_name}' + bcolors.ENDC)

    