from collections import OrderedDict
import sys, os
sys.path.append(os.getcwd())
from utils import yaml_load, bcolors,yaml_overwrite
import argparse
import numpy as np
import matplotlib.pyplot as plt
import matplotlib
from matplotlib.pyplot import cm
import os
import re
from scipy.stats import gmean
import math
import time
from plot_util import tlut_unique_component, hatch_map, \
    sys_breakdown_map, carat_breakdown_map, hatch_map_cg, \
    color_map, opac_map, \
    yml_metric_map, reduce_map, single_multiple_map, \
    partition_layerwise_reduction_map, axis_map, \
    mlperf_name_map, legend_map, clip_map, default_map, \
    ignore_vec_map, default_ignore_vec, default_ignore_vec_area,default_for_opac, \
    my_dpi, fig_h, fig_h_short, fig_w, size_tuple, \
    y_ticks_map
    
PEAK = 'peak flops per sec'

# matplotlib settings
font = {'serif':'Helvetica Neue', 'size': 6}
matplotlib.rc('font', **font)
matplotlib.rcParams['hatch.linewidth'] = 0.3
matplotlib.rcParams['lines.linewidth'] = 0.3
matplotlib.rcParams['axes.linewidth'] = 0.5
matplotlib.rcParams['xtick.major.width'] = 0.5
matplotlib.rcParams['ytick.major.width'] = 0.5
matplotlib.rcParams['xtick.major.size'] = 2
matplotlib.rcParams['ytick.major.size'] = 2

def construct_argparser():
    parser = argparse.ArgumentParser(description='plot')
    parser.add_argument('-p',
                        '--point',
                        nargs='+',
                        help='config',
                        default=[\
                            'arch_systolic_edge/systolic_edge_8x8_int8',\
                            'arch_systolic_edge/systolic_edge_16x16_int8', \
                            'arch_systolic_edge/systolic_edge_32x32_int8', \
                            'arch_tlut_intra/tlut_intra_1024_int8_t1',\
                            'arch_tlut_intra/tlut_intra_1024_int8_t2',\
                            'arch_tlut_intra/tlut_intra_1024_int8_t4',\
                            'arch_tlut_intra/tlut_intra_1024_int8_t8',\
                            'arch_tlut_inter/tlut_inter_1024_int8_t1',\
                            'arch_tlut_inter/tlut_inter_1024_int8_t2',\
                            'arch_tlut_inter/tlut_inter_1024_int8_t4',\
                            'arch_tlut_inter/tlut_inter_1024_int8_t8'
                            ],
                        )


    parser.add_argument('--use_universal_baseline', dest='use_universal_baseline', action='store_true')
    parser.add_argument('--no-use_universal_baseline', dest='use_universal_baseline', action='store_false')
    parser.set_defaults(use_universal_baseline=False)

    parser.add_argument('-d',
                        '--dirname',
                        help='dir name',
                        default=None)

    parser.add_argument('-n',
                        '--mlperf',
                        nargs='+',
                        help='networks in mlperf\n',
                        default=['resnet50', 'ssd300_vgg16', 'UNet''bert_base_uncased', 'dlrm', 'RNNT', ]
                        )

    parser.add_argument('-m',
                        '--metric',
                        nargs='+',
                        help='perf to plot',
                        choices=['perf', 'perf_norm', 'util_impl', \
                            'rt_abs', 'rt_norm', \
                            'area_total', 'area_onchip', 'area_dram', 'area_sram', 'area_compute',\
                            'area_partition', 'area_breakdown', 'energy_partition', 'energy_breakdown', \
                            'power_total', 'power_onchip', 'power_dram', 'power_sram', 'power_compute',\
                            'energy_total', 'energy_onchip', 'energy_dram', 'energy_sram', 'energy_compute',\
                            'throughput/area', 'throughput/energy', 'throughput/power',\
                            'flops/area', 'flops/energy', 'flops/power'
                            ],
                        default=['perf', 'perf_norm', 'util_impl', 
                            'rt_abs', 'rt_norm', \
                            'area_total', 'area_onchip', 'area_dram', 'area_sram', 'area_compute',\
                            'power_total', 'power_onchip', 'power_dram', 'power_sram', 'power_compute',\
                            'energy_total', 'energy_onchip', 'energy_dram', 'energy_sram', 'energy_compute',\
                            'throughput/area', 'throughput/energy', 'throughput/power',\
                            'flops/area', 'flops/energy', 'flops/power'
                            ],
                        )
    return parser

def gen_read_sets(data):
    print('*** metric: ', data)
    perf_read = set()
    cost_read = set()
    other = set()
    cost_layer_read = set()

    for metric in data:
        if metric == 'perf' or metric == 'perf_norm':
            perf_read.add('flops per sec')
        if metric == 'perf_norm':
            perf_read.add(PEAK)
            other.add(metric)
        if metric == 'util_impl':
            perf_read.add('utilization/impl')
        if metric == 'rt_abs' or metric == 'rt_norm':
            perf_read.add('runtime/impl')

        if metric == 'power_total':
            cost_read.add('power/total/total')
        if metric == 'power_onchip':
            cost_read.add('power/onchip/total')
        if metric == 'power_sram':
            cost_read.add('power/sram/total')
        if metric == 'power_dram':
            cost_read.add('power/dram/total')
        if metric == 'power_compute':
            cost_read.add('power/compute/total')
        
        if metric == 'area_total' or metric == 'area_onchip':
            cost_read.add('area/onchip')
        if metric == 'area_sram':
            cost_read.add('area/sram')
        if metric == 'area_total' or metric == 'area_dram':
            cost_read.add('area/dram')
        if metric == 'area_compute':
            cost_read.add('area/compute')
        if metric == 'area_total':
            other.add(metric)

        if metric == 'energy_total':
            cost_read.add('energy/total/total')
        if metric == 'energy_onchip':
            cost_read.add('energy/onchip/total')
        if metric == 'energy_sram':
            cost_read.add('energy/sram/total')
        if metric == 'energy_dram':
            cost_read.add('energy/dram/total')
        if metric == 'energy_compute':
            cost_read.add('energy/compute/total') 
        
        if metric == 'flops/energy':
            perf_read.add('flops')
            cost_read.add('energy/onchip/total')
            other.add(metric)
        if metric == 'flops/area':
            perf_read.add('flops')
            cost_read.add('area/onchip')
            cost_read.add('area/sram')
            cost_read.add('area/dram')
            cost_read.add('area/compute')
            other.add(metric)
        if metric == 'flops/power':
            perf_read.add('flops')
            cost_read.add('power/onchip/total')
            other.add(metric)

        if metric == 'throughput/energy':
            perf_read.add('flops per sec')
            cost_read.add('energy/onchip/total')
            other.add(metric)
        if metric == 'throughput/area':
            perf_read.add('flops per sec')
            cost_read.add('area/onchip')
            cost_read.add('area/sram')
            cost_read.add('area/dram')
            cost_read.add('area/compute')
            other.add(metric)
        if metric == 'throughput/power':
            perf_read.add('flops per sec')
            cost_read.add('power/onchip/total')
            other.add(metric)
        
        if metric == 'area_partition' or metric == 'area_breakdown':
            cost_read.add('area/onchip')
            cost_layer_read.add('compu/area')
            cost_layer_read.add('ififo/area')
            cost_layer_read.add('wfifo/area')
            cost_layer_read.add('ofifo/area')
            cost_layer_read.add('oaccu/area')
            cost_layer_read.add('isram/area')
            cost_layer_read.add('wsram/area')
            cost_layer_read.add('osram/area')
            cost_layer_read.add('waccu/area')
            cost_layer_read.add('itemp/area')
            cost_layer_read.add('osmux/area')
            cost_layer_read.add('bpipe/area')

        if metric == 'energy_partition' or metric == 'energy_breakdown':
            cost_read.add('energy/onchip/total')
            cost_layer_read.add('compu/energy/total')
            cost_layer_read.add('ififo/energy/total')
            cost_layer_read.add('wfifo/energy/total')
            cost_layer_read.add('ofifo/energy/total')
            cost_layer_read.add('oaccu/energy/total')
            cost_layer_read.add('isram/energy/total')
            cost_layer_read.add('wsram/energy/total')
            cost_layer_read.add('osram/energy/total')
            cost_layer_read.add('waccu/energy/total')
            cost_layer_read.add('itemp/energy/total')
            cost_layer_read.add('osmux/energy/total')
            cost_layer_read.add('bpipe/energy/total')
            # TODO: add more

    if len(perf_read) == 0 and len(cost_read) == 0 and len(other) == 0 and len(cost_layer_read) == 0: exit()
    return perf_read, cost_read, other, cost_layer_read

def read_perf_cost(run_set, perf_read, cost_read, other, cost_layer_read, ref_arch_name, use_universal_baseline):
    first_arch_in_all = True
    for group_dict in run_set.values():
        first_arch_in_group = True
        for arch_tuple in group_dict.items():
            arch = arch_tuple[1]
            if first_arch_in_all == True:
                first_arch_in_all = False
                ref_arch = arch
            # optional update if not universalbaseline
            if first_arch_in_group == True and use_universal_baseline == False: 
                first_arch_in_group = False
                ref_arch = arch
            
                
            for net_tuple in arch.items():
                net_name = net_tuple[0]
                net_dict = net_tuple[1]
                dir = net_dict['dir']
                if len(perf_read) != 0:
                    # process performance
                    perf_yml_file = f'runs/{dir}'+'/output/performance/workloadperf.summary.yaml'
                    perf_dict = yaml_load(perf_yml_file)
                    for perf in perf_read:
                        if perf == PEAK:
                            arch_yml_file = f'runs/{dir}'+'/input/architecture.yaml'
                            arch_dict = yaml_load(arch_yml_file)
                            wl_yml_file = f'runs/{dir}'+'/input/workload.yaml'
                            wl_dict = yaml_load(wl_yml_file)['workload']
                            for layer in wl_dict.values():
                                cycle = layer['cycle']
                                break
                            if 'systolic' in dir: peak = get_sys_peak_flops_per_sec(arch_dict, cycle)
                            elif 'tlut' in dir: 
                                chunk_size = math.log2(arch_dict['architecture']['compu']['num_instances'][1])
                                if 'int8' in dir:
                                    data_length = 8
                                elif 'int16' in dir:
                                    data_length = 16
                                elif 'int4' in dir:
                                    data_length = 4
                                elif 'bf16' in dir:
                                    data_length = 8
                                elif 'fp8' in dir:
                                    data_length = 4
                                else: assert False
                                peak = get_tlut_peak_flops_per_sec(arch_dict, chunk_size, data_length)
                            else: assert False, f'{dir}'
                            net_dict[perf] = peak
                            continue

                        level = perf.split('/')
                        thing = perf_dict['overall']
                        for l in level:
                            thing = thing[l]
                        net_dict[perf] = thing
                        net_dict[perf + '/norm'] = thing / ref_arch[net_name][perf]
                
                if len(cost_read) != 0:
                    # process cost
                    cost_yml_file = f'runs/{dir}'+'/output/cost/workloadcost.summary.yaml'
                    cost_dict = yaml_load(cost_yml_file)
                    for cost in cost_read:
                        level = cost.split('/')
                        thing = cost_dict['overall']
                        for l in level:
                            thing = thing[l]
                        net_dict[cost] = thing
                        net_dict[cost + '/norm'] = thing / ref_arch[net_name][cost]
                
                if len(cost_layer_read) != 0:
                    # process cost partition
                    cost_layer_yml_file = f'runs/{dir}'+'/output/cost/workloadcost.yaml'
                    cost_layer_dict = yaml_load(cost_layer_yml_file)
                    for dict_ in cost_layer_dict.items():
                        if dict_[0] in ['technology', 'frequency', 'overall']:
                            continue
                        else: break

                    # init breakdown record
                    for cost in cost_layer_read:
                        area_or_energy = cost.split('/')[1]
                        for breakdown in hatch_map_cg.keys():
                            cost_bd = breakdown + f'/{area_or_energy}'
                            if area_or_energy == 'energy':
                                cost_bd += '/total'
                            net_dict[cost_bd] = 0

                    for cost in cost_layer_read:
                        level = cost.split('/')
                        partition = level[0]
                        area_or_energy = level[1]
                        
                        if partition in tlut_unique_component and 'systolic' in dir:
                            continue

                        if area_or_energy == 'area':
                            thing = dict_[1]
                            total = cost_layer_dict['overall'][area_or_energy]['onchip']
                            for l in level:
                                thing = thing[l]
                            net_dict[cost] = thing
                            net_dict[cost + '/percent'] = thing / total
                            net_dict[cost + '/norm_percent'] = net_dict[cost + '/percent'] * net_dict[f'{area_or_energy}/onchip/norm']
                            if 'sys' in dir: cost_cg = sys_breakdown_map[partition] + f'/{area_or_energy}'
                            elif 'tlut' in dir: cost_cg = carat_breakdown_map[partition] + f'/{area_or_energy}'
                            else: assert False
                            # print(cost,cost_cg);exit()
                            net_dict[cost_cg] += thing
                            net_dict[cost_cg + '/percent'] = net_dict[cost_cg] / total
                            net_dict[cost_cg + '/norm_percent'] = net_dict[cost_cg + '/percent'] * net_dict[f'{area_or_energy}/onchip/norm']
                        
                        elif area_or_energy == 'energy':
                            net_dict[cost] = 0
                            for dict_ in cost_layer_dict.items():
                                if dict_[0] in ['technology', 'frequency', 'overall']:
                                    continue
                                else: 
                                    thing = dict_[1]
                                    for l in level:
                                        thing = thing[l]
                                    net_dict[cost] += thing
                            net_dict[cost + '/percent'] = net_dict[cost] / cost_layer_dict['overall'][area_or_energy]['onchip']['total']
                            net_dict[cost + '/norm_percent'] = net_dict[cost + '/percent'] * net_dict[f'{area_or_energy}/onchip/total/norm']
                            
                            if 'sys' in dir: cost_cg = sys_breakdown_map[partition] + f'/{area_or_energy}/total'
                            elif 'tlut' in dir: cost_cg = carat_breakdown_map[partition] + f'/{area_or_energy}/total'
                            else: assert False
                            net_dict[cost_cg] += net_dict[cost]
                            net_dict[cost_cg + '/percent'] = net_dict[cost_cg] / cost_layer_dict['overall'][area_or_energy]['onchip']['total']
                            net_dict[cost_cg + '/norm_percent'] = net_dict[cost_cg + '/percent'] * net_dict[f'{area_or_energy}/onchip/total/norm']

                
                if len(other) != 0:
                    # process other metrics
                    for m in other:
                        if m == 'perf_norm':
                            net_dict[m] = net_dict['flops per sec'] / net_dict[PEAK] * 100

                        if m == 'area_total': 
                            net_dict[m] = net_dict['area/onchip'] + net_dict['area/dram']

                        # NOTE: efficiency is in terms of onchip cost
                        if m == 'throughput/area': 
                            net_dict[m] = net_dict['flops per sec'] / \
                                (net_dict['area/onchip'])
                        if m == 'throughput/power': 
                            net_dict[m] = net_dict['flops per sec'] / net_dict['power/onchip/total']
                        if m == 'throughput/energy': 
                            net_dict[m] = net_dict['flops per sec'] / net_dict['energy/onchip/total']
                        
                        if m == 'flops/area': 
                            net_dict[m] = net_dict['flops'] / \
                                (net_dict['area/onchip'])
                        if m == 'flops/power': 
                            net_dict[m] = net_dict['flops'] / net_dict['power/onchip/total']
                        if m == 'flops/energy': 
                            net_dict[m] = net_dict['flops'] / net_dict['energy/onchip/total']

                        net_dict[m + '/norm'] = net_dict[m] / ref_arch[net_name][m]
                        
    return run_set

def plot_format_func(metric, group_list, run_set, dir_name, use_universal_baseline):
    if metric in yml_metric_map.keys():
        metric_in_yml_list = yml_metric_map[metric]
    else:
        assert False
    if type(metric_in_yml_list) == list: pass
    else:
        metric_in_yml_list = [metric_in_yml_list]
    print(metric_in_yml_list)
    if len(metric_in_yml_list) > 1: use_hatch = True
    else: use_hatch = False

    if metric in legend_map.get(dir_name, default_map): size_tuple_local = size_tuple
    else: size_tuple_local = (fig_w, fig_h_short)
    fig, ax = plt.subplots(figsize=size_tuple_local, dpi=my_dpi)
    use_str = np.arange(len(group_list))

    prev_list = dict()
    color_bar = []
    red_hatch = []
    lab_hatch_arr = []
    lab_arch_arr = []
    for t in np.arange(len(metric_in_yml_list)):
        metric_in_yml = metric_in_yml_list[t]
        print(metric_in_yml)
        plot_arr = []
        name_arr = []
        for group_name in group_list:
            group_dict = run_set.get(group_name)
            arch_arr = []
            name_arr_ = []
            for arch_item in group_dict.items():
                arch_name = arch_item[0]
                arch_dict = arch_item[1]
                # print('arch name=',arch_name)
                net_arr = []
                for net_item in arch_dict.items():
                    net_name = net_item[0]
                    net_dict = net_item[1]
                    perf = net_dict.get(metric_in_yml)
                    # print(f' net name={net_name}, perf={perf}')
                    net_arr.append(perf)
                gm = gmean(net_arr)
                arch_arr.append(gm)
                name_arr_.append(arch_name)
            # print(f'{group_name}, {arch_arr}')
            plot_arr.append(arch_arr)
            name_arr.append(name_arr_)
        # print(plot_arr)
        width=1.0/(len(plot_arr[0])+1)

        for i in np.arange(len(plot_arr[0])):
            arr_to_plot = []
            arr_name = []
            for j in np.arange(len(plot_arr)):
                arr_to_plot.append(plot_arr[j][i])
                arr_name.append(name_arr[j][i])
            print(arr_to_plot)
            print(arr_name)
            if 'systolic' in arr_name[0]: 
                arch_type = 'arch_systolic_edge'
                lab_arch = 'SA'
                op = 0.9
                if '128x16' in arr_name[0]: 
                    op = 0.7
                    lab_arch = 'SA'
                elif '256x16' in arr_name[0]:
                    op = 0.9
                    lab_arch = 'SA'
            elif 'tlut_intra' in arr_name[0]: 
                arch_type = 'arch_tlut_intra'
                lab_arch = 'CA-a'
                op = 0.99
            elif 'tlut_inter' in arr_name[0]: 
                arch_type = 'arch_tlut_inter'
                lab_arch = 'CA-r'
                op = 0.99
            else: assert False
            prev = prev_list.get((j,i), None)
            color_bar_ = plt.bar(use_str+width*i, np.array(arr_to_plot), width, \
                color=color_map[arch_type][arr_name[0].split('_dram')[0]], \
                alpha=op, \
                bottom=prev)
            if use_hatch:
                lab_hatch = metric_in_yml.split('/')[0]
                red_hatch_ = plt.bar(use_str+width*i, np.array(arr_to_plot), width, color='none', hatch=hatch_map[lab_hatch],edgecolor = bcolors.red,bottom=prev,linewidth=0.3)
                plt.bar(use_str+width*i, np.array(arr_to_plot), width, color='none',edgecolor = 'k', linewidth=0.3, bottom=prev)

            if prev == None:
                prev_list[(j,i)] = arr_to_plot
            else:
                prev_arr = np.array(prev)
                prev_arr += np.array(arr_to_plot)
                prev_list[(j,i)] = list(prev_arr)

            
            # adding hatch artist and legend
            if i == 0 and use_hatch: 
                red_hatch.append(red_hatch_[0])
                lab_hatch_arr.append(lab_hatch)
            # adding arch (bar) artist and legend
            if t == 0 and not use_hatch:
                color_bar.append(color_bar_[0])
                lab_arch_arr.append(lab_arch)
    
    if len(red_hatch) > 0:
        size_vec = (0.1,1.02,0.8,0.1)
    else:
        size_vec = (0,1.02,1,0.1)

    if metric in legend_map.get(dir_name, default_map):
        ax.legend(
            red_hatch+color_bar, lab_hatch_arr+lab_arch_arr, \
            # red_hatch, lab_hatch_arr, \
            bbox_to_anchor=size_vec, loc="lower left",\
            mode="expand", borderaxespad=0, ncol=4)
    else: print(f'format line436: no legend for {dir_name} {metric}')

    xticks_ = [i.upper() for i in group_list]
    xticks = [i.replace('_', '-') for i in xticks_]
    # print(xticks);exit()
    plt.xticks(use_str+width*float(i)/2, xticks)

    # display yticks based on y_ticks_map in util
    y_ticks_dict = y_ticks_map.get(dir_name, default_map)
    yt = y_ticks_dict.get(metric, default_map)
    if y_ticks_dict != default_map and \
        yt != default_map:
        ax.set_yticks(yt)
        ax.set_yticklabels(yt)

    ax.set_ylabel(axis_map[metric])
    os.makedirs('plot/mlperf', exist_ok=True)
    metric_name = metric.replace('/', '_')
    metric_name = metric_name.replace(' ', '_')

    if dir_name == None:
        fig_name = f'plot/mlperf/{metric_name}'#TODO: pdf
    else:
        os.makedirs(f'plot/mlperf/{dir_name}', exist_ok=True)
        
        fig_name = f'plot/mlperf/{dir_name}/{metric_name}'#TODO: pdf
    
    if use_universal_baseline: 
        fig_name += '_uni'

    fig_name += '.pdf'

    fig.tight_layout()
    plt.savefig(fig_name, bbox_inches='tight', dpi=my_dpi, pad_inches=0.02)
    print(bcolors.OKGREEN + f'Saved fig as {fig_name}' + bcolors.ENDC)

if __name__ == "__main__":
    parser = construct_argparser()
    args = parser.parse_args()

    print('*** mlperf: ', args.mlperf)
    print('*** dir: ', args.dirname)
    os.makedirs('plot/log', exist_ok=True)
    timestr = time.strftime("%Y%m%d-%H%M%S")
    if args.dirname != None:
        os.makedirs(f'plot/log/{args.dirname}', exist_ok=True)
        yml_name = f'./plot/log/{args.dirname}/plot_{timestr}.yml'
    else:
        yml_name = f'./plot/log/plot_{timestr}.yml'

    # === peak perf lambda functions ===
    get_sys_peak_flops_per_sec = lambda arch_dict, cycle:(arch_dict['architecture']['compu']['num_instances'][0] * \
        arch_dict['architecture']['compu']['num_instances'][1] * 2.0 + \
        arch_dict['architecture']['compu']['num_instances'][1]) / cycle * \
        arch_dict['architecture']['frequency'] * 10**6
    get_tlut_peak_flops_per_sec = lambda arch_dict, chunk_size, data_length: 2 * \
        arch_dict['architecture']['compu']['num_instances'][0] * \
        (float(chunk_size)/data_length) * arch_dict['architecture']['frequency'] * 10**6
    # === peak perf lambda functions ===

    print('*** points: ', args.point)

    if args.use_universal_baseline:
        print('*** using universal baseline')
    else:
        print('*** normalizing in terms of group (default)')

    # === construct run set ===
    print(bcolors.OKCYAN + f'Constructing run set...' + bcolors.ENDC)

    group_set = set()
    for point in args.point:
        if 'int8' in point: group_set.add('int8')
        elif 'int16' in point: group_set.add('int16')
        elif 'acc16' in point and 'bf16' in point: group_set.add('bf16_acc16')
        elif 'bf16' in point: group_set.add('bf16')
        elif 'acc16' in point and 'fp8' in point: group_set.add('fp8_acc16')
        elif 'fp8' in point: group_set.add('fp8')
        elif 'int4' in point: group_set.add('int4')
    group_list = list(group_set)
    # group_list.sort(reverse=True)
    group_list = ['int4', 'int8', 'fp8', 'fp8_acc16', 'bf16', 'bf16_acc16']
    print(f'*** group by {group_list}')


    run_set = OrderedDict()
    
    # index 1: format
    for format_ in group_list:
        format_chunks = format_.split('_')
        format_chunks = ['_' + c for c in format_chunks]
        format_dict = OrderedDict()
        # index2: arch
        for point in args.point:
            if_continue = False
            for c in format_chunks:
                if c not in point: 
                    if_continue = True
                    break
            if if_continue: continue
            if format_ == 'bf16' and '_acc16' in point: continue             
            arch_name = point.split('/')[-1]
            dir_append = point.replace(arch_name, '')
            myrootdir = f'runs/{dir_append}/'
            group = OrderedDict()
            # index3: network
            for net in args.mlperf:
                reg_name = re.compile(re.escape(arch_name) + '_' + net + r'_c\d{1,3}_n4096')
                dir_name = next(os.walk(myrootdir))[1]
                for dirnames in dir_name:
                    if reg_name.match(dirnames):
                        dirnames = f'{dir_append}/{dirnames}'
                        dict_ = OrderedDict()
                        dict_['dir'] = dirnames
                        group[net] = dict_
            format_dict[arch_name] = group
        run_set[format_] = format_dict

    # === register needed results ===
    perf_read, cost_read, other, cost_layer_read = gen_read_sets(args.metric)

    # === fill in perf results ===
    print(bcolors.OKCYAN + f'Reading yml...' + bcolors.ENDC)
    ref_arch_name = args.point[0].split('/')[-1]
    run_set = read_perf_cost(run_set, perf_read, cost_read, other, cost_layer_read, ref_arch_name, args.use_universal_baseline)
    
    yaml_overwrite(yml_name, run_set) # TODO: remove for speed and space

    print(bcolors.OKCYAN + f'ploting...' + bcolors.ENDC)
    for metric in args.metric:
        plot_format_func(metric, group_list, run_set, args.dirname, args.use_universal_baseline)