from collections import OrderedDict
import sys, os
sys.path.append(os.getcwd())
from utils import yaml_load
import argparse

def construct_argparser():
    parser = argparse.ArgumentParser(description='read layer util')
    parser.add_argument('-f',
                        '--file',
                        help='perf file absolute path',
                        default=\
                            '/mnt/ssd1/zwp/repo/Archer/runs/arch_systolic_edge/optPoint/dram3/systolic_edge_64x64_fp8_s4_dram3_RNNT_c1_n4096/output/performance/workloadperf.yaml')
    return parser
if __name__ == "__main__":
    parser = construct_argparser()
    args = parser.parse_args()

    perf_dict = yaml_load(args.file)
    layer = []
    for layername,layer_dict in perf_dict.items():
        if layername == 'technology': continue
        if layername == 'frequency': continue
        if layername == 'overall': continue
        impl_util = layer_dict['overall']['utilization']['impl']
        if impl_util < 80: continue
        tuple_ = (layername, impl_util)
        layer.append(tuple_)
    for i in layer:
        print(i)


