from collections import OrderedDict
import sys, os
sys.path.append(os.getcwd())
from utils import yaml_load
import argparse

def construct_argparser():
    parser = argparse.ArgumentParser(description='read layer util')
    parser.add_argument('-f',
                        '--file',
                        help='perf file absolute path',
                        default=\
                            '/mnt/ssd1/zwp/repo/Archer/plot/log/isoarea_size_dram3_s4_4formats/plot_20220928-214748.yml')
    
    parser.add_argument('-q',
                        '--query',
                        type=str,
                        help='query string',
                        default="flops per sec",
                        )
    return parser
if __name__ == "__main__":
    parser = construct_argparser()
    args = parser.parse_args()

    cost_dict = yaml_load(args.file)
    
    for catname,catdict in cost_dict.items():
        got = []
        archname_arr = []
        for archname,archdict in catdict.items():
            for netname, netdict in archdict.items():
                got_ = netdict[args.query]
                got.append(got_)
                # exit()
            archname_arr.append(archname)
        print(catname, archname_arr)
        print(got)


