from collections import OrderedDict


# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # 
# compute performance dict and record function
# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # 
def compute_dict():
    this_dict = OrderedDict({
                                "cycle": 0,
                                "utilization": 0,
                                "flops": 0,
                                })
    return this_dict


def compute_dict_record(this_dict: OrderedDict, result_dict: OrderedDict):
    this_dict["cycle"] = result_dict["cycle"]
    this_dict["utilization"] = result_dict["utilization"]
    this_dict["flops"] = result_dict["flops"]


# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # 
# sram performance dict and record function
# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # 
def sram_dict():
    this_dict = OrderedDict({ 
                                "access stall": OrderedDict({"rd": 0, "wr": 0}),
                                "byte total": OrderedDict({"rd": 0, "wr": 0}),
                                "access total": OrderedDict({"rd": 0, "wr": 0}),
                                })
    return this_dict


def sram_dict_record(this_dict: OrderedDict, result_dict: OrderedDict):
    for action in ["rd", "wr"]:
        this_dict["access stall"][action] += result_dict["access stall"][action]
        this_dict["byte total"][action] += result_dict["byte total"][action]
        this_dict["access total"][action] += result_dict["access total"][action]


# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # 
# dram performance dict and record function
# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # 
def dram_dict():
    this_dict = OrderedDict({ 
                                "access stall": OrderedDict({"rd": 0, "wr": 0}),
                                "byte total": OrderedDict({"rd": 0, "wr": 0}),
                                "access total": OrderedDict({"rd": 0, "wr": 0}),
                                "page total": OrderedDict({"rd": 0, "wr": 0}),
                                })
    return this_dict


def dram_dict_record(this_dict: OrderedDict, result_dict: OrderedDict):
    for action in ["rd", "wr"]:
        this_dict["access stall"][action] += result_dict["access stall"][action]
        this_dict["byte total"][action] += result_dict["byte total"][action]
        this_dict["access total"][action] += result_dict["access total"][action]
        this_dict["page total"][action] += result_dict["page total"][action]

