from collections import OrderedDict
import importlib


class CostEstimator:
    def __init__(self, name: str, arch_cnfg: OrderedDict, path: str) -> None:
        self.name = name
        self.arch_cnfg = arch_cnfg
        self.modu_cnfg = arch_cnfg[name] # module configuration
        self.path = path

    def estimate(self):
        loaded_type = importlib.import_module("implement")
        result = getattr(loaded_type, self.arch_cnfg[self.name]["type"])(self.name, self.arch_cnfg["technology"], self.arch_cnfg["frequency"], self.modu_cnfg, self.path)
        return result

