//https://github.com/satputeaditya/Parametric_barrel_shifter/blob/master/barrel_shifter.v
// barrel_shifter.v
`ifndef _shifter_
`define _shifter_
`include "register.sv"

module shifter #(  
    parameter WIDTH = 8,                   // number of PORTs
    parameter STAGE = $clog2(WIDTH)
)(
    input logic clk,
    input logic rst_n,
    input logic en,
    input logic clr,
    input logic [STAGE-1:0] select, 
    input logic [WIDTH-1:0] data_in, 
    output logic [WIDTH-1:0] data_out
);
    logic [(2*WIDTH)-1:0] data_in_double;
    logic [WIDTH-1:0] array [0:WIDTH-1];
    logic[WIDTH-1:0] data;
    assign data_in_double = {data_in,data_in};
    assign data = data_in_double[(select*1)+(WIDTH-1)-:WIDTH];

    register #(
        .WIDTH(WIDTH)
    ) U_REG(
        .clk(clk),
        .rst_n(rst_n),
        .en(en),
        .clr(clr),
        .i_data(data),
        .o_data(data_out)
    );

endmodule
`endif