`ifndef _serializer_
`define _serializer_

module serializer #(
    parameter WIDTH=8,
    parameter DEPTH=4
) (
    input logic clk,
    input logic rst_n,
    input logic load_en, // load enable
    input logic clr,
    input logic signed [WIDTH-1 : 0] i_data [DEPTH-1 : 0],
    output logic signed [WIDTH-1 : 0] o_data
);
    logic signed [WIDTH-1 : 0] buffer [DEPTH-1 : 0];
    assign o_data = buffer[DEPTH-1];

    always_ff @(posedge clk or negedge rst_n) begin
        if (~rst_n) begin
            for (integer i=0; i<DEPTH; i=i+1) begin
                  buffer[i] <= 0;
            end
        end else begin
            if (clr) begin
                for (integer i=0; i<DEPTH; i=i+1) begin
                      buffer[i] <= 0;
                end
            end else begin
                if (load_en) begin
                  buffer <= i_data;
                end else begin
                  for (integer i=1; i<DEPTH; i=i+1) begin
                      buffer[i] <= buffer[i-1];
                  end
                  buffer[0] <= '0;
                end
              end
          end
    end

endmodule

`endif
