`ifndef _register_file_
`define _register_file_
//single read port, single write port
module register_file #(
    parameter WIDTH=16,
    parameter DEPTH=8
) (
        input logic clk,
    	input logic rst_n,
	input logic wen,
	input logic unsigned [$clog2(DEPTH)-1:0] wsel,
        input logic signed [WIDTH-1 : 0] wdat,
	input logic unsigned [$clog2(DEPTH)-1:0] rsel,
	output logic signed [WIDTH-1 : 0] rdat
);

    logic signed [WIDTH-1 : 0] registers [DEPTH-1 : 0];
    always_ff @(negedge clk, negedge rst_n) begin
        if (~rst_n) begin
            for (int i = 0; i < DEPTH; i++) begin
                registers[i] <= '0;
            end
        end
        else begin
		if (wen==1'b1) begin
            		registers[wsel] <= wdat;
		end
		else begin
			for (int i = 0; i < DEPTH; i++) begin
				registers[i] <= registers[i];
			end
		end
        end
    end
    
    assign rdat = registers[rsel];
endmodule
`endif