`ifndef _or_bitwise_
`define _or_bitwise_
`include "register.sv"

module or_bitwise #(
    parameter WIDTH=1
) (
    input logic clk,
    input logic rst_n,
    input logic en,
    input logic clr,
    input logic unsigned [WIDTH-1 : 0] i_data0,
    input logic unsigned [WIDTH-1 : 0] i_data1,
    output logic unsigned [WIDTH-1 : 0] o_data_d
);
    logic unsigned [WIDTH-1 : 0] o_data;

    assign o_data = i_data0 | i_data1;

    register #(
        .WIDTH(WIDTH)
    ) U_REG(
        .clk(clk),
        .rst_n(rst_n),
        .en(en),
        .clr(clr),
        .i_data(o_data),
        .o_data(o_data_d)
    );

endmodule

`endif

