`ifndef _multiplier_
`define _multiplier_
`include "register.sv"

module multiplier #(
    parameter WIDTH=16
) (
    input logic clk,
    input logic rst_n,
    input logic en,
    input logic clr,
    input logic signed [WIDTH-1 : 0] i_data0,
    input logic signed [WIDTH-1 : 0] i_data1,
    output logic signed [WIDTH*2-1 : 0] o_data_d
);
    logic signed [WIDTH*2-1 : 0] o_data;
    assign o_data = i_data0 * i_data1;

    register #(
        .WIDTH(WIDTH*2)
    ) U_REG(
        .clk(clk),
        .rst_n(rst_n),
        .en(en),
        .clr(clr),
        .i_data(o_data),
        .o_data(o_data_d)
    );
    
endmodule

`endif