`ifndef _multiplexer_
`define _multiplexer_
`include "register.sv"

module multiplexer #(
    parameter WIDTH=32,
    parameter NUM_INPUTS=8
) (
    input logic clk,
    input logic rst_n,
    input logic en,
    input logic clr,
    input logic signed [WIDTH-1 : 0] i_data [NUM_INPUTS-1 : 0],
    input logic signed [$clog2(NUM_INPUTS)-1 : 0] i_select,
    output logic signed [WIDTH-1 : 0] o_data_d
);
    logic signed [WIDTH-1 : 0] o_data;

    assign o_data = i_data[i_select];

    register #(
        .WIDTH(WIDTH)
    ) U_REG(
        .clk(clk),
        .rst_n(rst_n),
        .en(en),
        .clr(clr),
        .i_data(o_data),
        .o_data(o_data_d)
    );

endmodule

`endif

