// https://github.com/georgia-tech-synergy-lab/SIGMA/blob/master/vmod/xbar.v
`ifndef _crossbar_
`define _crossbar_

/////////////////////////////////////////////////////////////////////////

// Design: xbar.v
// Author: Eric Qin

// Basic Crossbar implmenetation for the distribution network.

/////////////////////////////////////////////////////////////////////////

module crossbar # (
	parameter WIDTH = 16,
	parameter NUM_OUTPUTS = 64,
	parameter NUM_INPUTS = 64) (
	clk,
	rst,
	i_data_bus, // input data bus
	i_mux_bus, // mux select control bus
	o_dist_bus // output bus to the multipliers
);

	input clk;
	input rst;
	input [NUM_INPUTS*WIDTH-1 : 0] i_data_bus;
	input [$clog2(NUM_OUTPUTS) * NUM_OUTPUTS -1 : 0] i_mux_bus;
	
	output reg [NUM_OUTPUTS * WIDTH -1 : 0] o_dist_bus;
	
	wire [NUM_OUTPUTS * WIDTH -1 : 0] w_dist_bus;
	
	genvar i;
	generate
		for (i=0; i < NUM_OUTPUTS; i=i+1) begin : gen_out
			mux # (
				.WIDTH(WIDTH),
				.NUM_INPUTS(NUM_INPUTS),
				.SEL_SIZE($clog2(NUM_OUTPUTS))) my_mux (
				.clk(clk),
				.rst(rst),
				.i_data_bus(i_data_bus),
				.i_mux_sel(i_mux_bus[i*$clog2(NUM_OUTPUTS)+:$clog2(NUM_OUTPUTS)]),
				.o_dist(w_dist_bus[i*WIDTH+:WIDTH])
			);
		end
	endgenerate
	
	always @ (posedge clk) begin
		o_dist_bus = w_dist_bus;
	end
	
endmodule

module mux # (
	parameter WIDTH = 16,
	parameter NUM_INPUTS = 128,
	parameter SEL_SIZE = 7) (
	clk,
	rst,
	i_data_bus,
	i_mux_sel,
	o_dist
);
	input clk;
	input rst;
	input [NUM_INPUTS*WIDTH-1 : 0] i_data_bus;
	input [SEL_SIZE-1 : 0] i_mux_sel;
	
	output reg [WIDTH-1 : 0] o_dist;
	
	always @ (*) begin
		o_dist = i_data_bus[i_mux_sel*WIDTH+:WIDTH];
	end
	
endmodule

`endif

