`ifndef _comparator_
`define _comparator_
`include "register.sv"

module comparator #(
    parameter WIDTH=32
) (
    input logic clk,
    input logic rst_n,
    input logic en,
    input logic clr,
    input logic signed [WIDTH-1 : 0] i_data0,
    input logic signed [WIDTH-1 : 0] i_data1,
    output logic unsigned oBit
);
    logic tBit;

    assign tBit = i_data0 >= i_data1;

    register #(
        .WIDTH(1)
    ) U_REG(
        .clk(clk),
        .rst_n(rst_n),
        .en(en),
        .clr(clr),
        .i_data(tBit),
        .o_data(oBit)
    );

endmodule

`endif

