`ifndef _adder_
`define _adder_
`include "register.sv"

module adder #(
    parameter WIDTH=32
) (
    input logic clk,
    input logic rst_n,
    input logic en,
    input logic clr,
    input logic signed [WIDTH-1 : 0] i_data0,
    input logic signed [WIDTH-1 : 0] i_data1,
    output logic signed [WIDTH-1 : 0] o_data_d
);
    logic signed [WIDTH-1 : 0] o_data;
    assign o_data = i_data0 + i_data1;

    register #(
        .WIDTH(WIDTH)
    ) U_REG(
        .clk(clk),
        .rst_n(rst_n),
        .en(en),
        .clr(clr),
        .i_data(o_data),
        .o_data(o_data_d)
    );
    

endmodule

`endif

