from collections import OrderedDict
from .component import ComputeComponent
import numpy as np


def query(name: str, technology: float, frequency: float, config: OrderedDict, odir: str):
    """config is a OrderedDict for compute, it contains subcomponents, which can be looked up in the compute dir"""
    num_instances = int(np.product(np.array(config["num_instances"])) if "num_instances" in config.keys() else 1)
    component_dict = config["instance"]
    dynamic_power = 0
    leakage_power = 0
    area = 0
    for item in component_dict.keys():
        component = ComputeComponent(component_dict[item])
        # units are mW, mW, mm^2
        dynamic_pe, leakage_pe, area_pe = component.query(technology, frequency)
        dynamic_power += dynamic_pe * num_instances
        leakage_power += leakage_pe * num_instances
        area += area_pe * num_instances

    # units are mW, mW, mm^2
    return dynamic_power, leakage_power, area


if __name__ == "__main__":
    pass

    