/*****************************************************************************
 *                                CACTI 7.0
 *                      SOFTWARE LICENSE AGREEMENT
 *            Copyright 2015 Hewlett-Packard Development Company, L.P.
 *                          All Rights Reserved
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met: redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer;
 * redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution;
 * neither the name of the copyright holders nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.

 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.”
 *
 ***************************************************************************/



#ifndef __BANK_H__
#define __BANK_H__

#include "component.h"
#include "decoder.h"
#include "mat.h"
#include "htree2.h"


class Bank : public Component
{
  public:
    Bank(const DynamicParameter & dyn_p);
    ~Bank();
    double compute_delays(double inrisetime);  // return outrisetime
    void   compute_power_energy();

    const DynamicParameter & dp;
    Mat   mat;
    Htree2 *htree_in_add;
    Htree2 *htree_in_data;
    Htree2 *htree_out_data;
    Htree2 *htree_in_search;
    Htree2 *htree_out_search;

    int  num_addr_b_mat;
    int  num_mats_hor_dir;
    int  num_mats_ver_dir;

    int  num_addr_b_row_dec;
    int  num_addr_b_routed_to_mat_for_act;
    int  num_addr_b_routed_to_mat_for_rd_or_wr;

    double  array_leakage;
    double  wl_leakage;
    double  cl_leakage;
};



#endif
