from collections import OrderedDict


# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # 
# compute cost dict, record and publish function
# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # 
def compute_dict():
    this_dict = OrderedDict({
                                "dynamic power": 0,
                                "leakage power": 0,
                                "area": 0,
                                "energy": OrderedDict({"dynamic": 0, "leakage": 0, "total": 0}),
                                "power": OrderedDict({"dynamic": 0, "leakage": 0, "total": 0}),
                                })
    return this_dict


def compute_dict_record(this_dict: OrderedDict, numbers: tuple):
    this_dict["dynamic power"] = numbers[0] # mW
    this_dict["leakage power"] = numbers[1] # mW
    this_dict["area"] = numbers[2] # mm^2


def compute_dict_publish(name: str, cost: OrderedDict, performance: OrderedDict):
    compute_active_cycle = performance[name]["cycle"]
    period = performance["overall"]["runtime"]["arch"] / performance["overall"]["cycle"]["arch"] # second
    cost[name]["energy"]["dynamic"] = cost[name]["dynamic power"] * compute_active_cycle * period * 10**6 # nJ
    cost[name]["energy"]["leakage"] = cost[name]["leakage power"] * performance["overall"]["runtime"]["impl"] * 10**6 # nJ
    cost[name]["energy"]["total"] = cost[name]["energy"]["dynamic"] + cost[name]["energy"]["leakage"] # nJ
    
    cost[name]["power"]["dynamic"] = cost[name]["energy"]["dynamic"] / performance["overall"]["runtime"]["impl"] / 10**6 # mW
    cost[name]["power"]["leakage"] = cost[name]["energy"]["leakage"] / performance["overall"]["runtime"]["impl"] / 10**6  # mW
    cost[name]["power"]["total"] = cost[name]["power"]["dynamic"] + cost[name]["power"]["leakage"] # mW


# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # 
# sram cost dict, record and publish function
# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # 
def sram_dict():
    this_dict = OrderedDict({
                                "dynamic energy per access": OrderedDict({"rd": 0, "wr": 0}),
                                "leakage power": 0,
                                "area": 0,
                                "dynamic energy all access": OrderedDict({"rd": 0, "wr": 0}),
                                "energy": OrderedDict({"dynamic": 0, "leakage": 0, "total": 0}),
                                "power": OrderedDict({"dynamic": 0, "leakage": 0, "total": 0}),
                                })
    return this_dict


def sram_dict_record(this_dict: OrderedDict, numbers: tuple):
    this_dict["dynamic energy per access"]["rd"] = numbers[0] # nJ
    this_dict["dynamic energy per access"]["wr"] = numbers[1] # nJ
    this_dict["leakage power"] = numbers[2] # mW
    this_dict["area"] = numbers[3] # mm^2


def sram_dict_publish(name: str, cost: OrderedDict, performance: OrderedDict):
    cost[name]["dynamic energy all access"]["rd"] = cost[name]["dynamic energy per access"]["rd"] * performance[name]["access total"]["rd"] # nJ
    cost[name]["dynamic energy all access"]["wr"] = cost[name]["dynamic energy per access"]["wr"] * performance[name]["access total"]["wr"] # nJ
    
    cost[name]["energy"]["dynamic"] = cost[name]["dynamic energy all access"]["rd"] + cost[name]["dynamic energy all access"]["wr"] # nJ
    cost[name]["energy"]["leakage"] = cost[name]["leakage power"] * performance["overall"]["runtime"]["impl"] * 10**6 # nJ
    cost[name]["energy"]["total"] = cost[name]["energy"]["dynamic"] + cost[name]["energy"]["leakage"] # nJ
    
    cost[name]["power"]["dynamic"] = cost[name]["energy"]["dynamic"] / performance["overall"]["runtime"]["impl"] / 10**6 # mW
    cost[name]["power"]["leakage"] = cost[name]["energy"]["leakage"] / performance["overall"]["runtime"]["impl"] / 10**6 # mW
    cost[name]["power"]["total"] = cost[name]["power"]["dynamic"] + cost[name]["power"]["leakage"] # mW

# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # 
# dram cost dict, record and publish function
# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # 
def dram_dict():
    this_dict = OrderedDict({ 
                                "dynamic energy per page": 0,
                                "dynamic energy per access": OrderedDict({"rd": 0, "wr": 0}),
                                "leakage power": OrderedDict({"open page": 0, "closed page": 0}),
                                "area": 0,
                                "dynamic energy all access": OrderedDict({"rd": 0, "wr": 0}),
                                "energy": OrderedDict({"dynamic": 0, "leakage": 0, "total": 0}),
                                "power": OrderedDict({"dynamic": 0, "leakage": 0, "total": 0}),
                                })
    return this_dict


def dram_dict_record(this_dict: OrderedDict, numbers: tuple):
    this_dict["dynamic energy per page"] = numbers[0] # nJ
    this_dict["dynamic energy per access"]["rd"] = numbers[1] # nJ
    this_dict["dynamic energy per access"]["wr"] = numbers[2] # nJ
    this_dict["leakage power"]["open page"] = numbers[3] # mW
    this_dict["leakage power"]["closed page"] = numbers[4] # mW
    this_dict["area"] = numbers[5] # mm^2


def dram_dict_publish(name: str, cost: OrderedDict, performance: OrderedDict):
    cost[name]["dynamic energy all access"]["rd"] = cost[name]["dynamic energy per access"]["rd"] * performance[name]["access total"]["rd"] # nJ
    cost[name]["dynamic energy all access"]["wr"] = cost[name]["dynamic energy per access"]["wr"] * performance[name]["access total"]["wr"] # nJ
    cost[name]["energy"]["dynamic"] = cost[name]["dynamic energy per page"] * (performance[name]["page total"]["rd"] + performance[name]["page total"]["wr"]) + \
                                        cost[name]["dynamic energy all access"]["rd"] + cost[name]["dynamic energy all access"]["wr"] # nJ
    cost[name]["energy"]["leakage"] = cost[name]["leakage power"]["open page"] * performance["overall"]["runtime"]["impl"] * 10**6 # nJ
    cost[name]["energy"]["total"] = cost[name]["energy"]["dynamic"] + cost[name]["energy"]["leakage"] # nJ
    
    cost[name]["power"]["dynamic"] = cost[name]["energy"]["dynamic"] / performance["overall"]["runtime"]["impl"] / 10**6 # mW
    cost[name]["power"]["leakage"] = cost[name]["energy"]["leakage"] / performance["overall"]["runtime"]["impl"] / 10**6 # mW
    cost[name]["power"]["total"] = cost[name]["power"]["dynamic"] + cost[name]["power"]["leakage"] # mW

