from collections import OrderedDict
import os, shutil
from utils import bcolors, yaml_overwrite, yaml_load


run_dir = "runs"
design_list = ["systolic_edge_bypass", "stone", "sparse_snn"]
sparse_design_list = ["sparse_snn"]
task_list = ["vgg5", "vgg9", "MLPerf"]
nn_dict = {"vgg5": {    "stone":                ["snn_vgg5"], 
                        "systolic_edge_bypass": ["ann_vgg5"],
                        "sparse_snn":           ["snn_vgg5"]},
            "vgg9": {   "stone":                ["snn_vgg9"], 
                        "systolic_edge_bypass": ["ann_vgg9"],
                        "sparse_snn":           ["snn_vgg9"]},
            "MLPerf":{  "stone":                ["bert_base_uncased", "dlrm", "resnet50", "RNNT", "ssd300_vgg16", "UNet"], 
                        "systolic_edge_bypass": ["bert_base_uncased", "dlrm", "resnet50", "RNNT", "ssd300_vgg16", "UNet"],
                        "sparse_snn":           ["bert_base_uncased", "dlrm", "resnet50", "RNNT", "ssd300_vgg16", "UNet"]}}
sparsity_dict = {"stone":               [0],
                "systolic_edge_bypass": [0],
                "sparse_snn":           [82, 86, 90, 94, 98]}
timestep_dict = {"stone":               [8],
                "systolic_edge_bypass": [1],
                "sparse_snn":           [8]}
config_dict = {         "stone":                ["8x8", "16x16", "32x32"],
                        "systolic_edge_bypass": ["8x8", "16x16", "32x32"],
                        "sparse_snn":           ["1x16", "1x32", "1x64", "1x128", "1x256"]}

run_list_file = "configuration/stone_run_list.txt"
f = open(run_list_file, "w")

for task in task_list:
    for design in design_list:
        print("design: ", design)
        print("    task: ", task)
        srcdir = run_dir + "/arch_" + design
        dstdir = run_dir + "/run_arch_" + design
        assert os.path.exists(srcdir), \
            bcolors.FAIL + "Design <" + design + "> does not exists." + bcolors.ENDC
        
        if not os.path.exists(dstdir):
            os.mkdir(dstdir)

        for config in config_dict[design]:
            for timestep in timestep_dict[design]:
                for sparsity in sparsity_dict[design]:
                    for nn in nn_dict[task][design]:
                        now_dir = dstdir + "/" + config + "_timestep" + str(timestep) + "_sparsity" + str(sparsity) + "/"
                        if not os.path.exists(now_dir):
                            os.mkdir(now_dir)
                        
                        now_dir = now_dir + nn + "/"
                        if not os.path.exists(now_dir):
                            os.mkdir(now_dir)

                        if os.path.exists(now_dir + "/input/"):
                            shutil.rmtree(now_dir + "/input/")

                        os.mkdir(now_dir + "/input/")

                        # copy arch yaml
                        shutil.copy2(srcdir + "/" + config + "/input/architecture.yaml", now_dir + "/input/architecture.yaml")
                        
                        # create program yaml
                        program_text = OrderedDict({"program": OrderedDict({"evaluate performance": True, "evaluate cost": True, })})
                        yaml_overwrite(now_dir + "/input/program.yaml", program_text)
                        
                        # create workload yaml
                        this_workload = yaml_load("workload/" + nn + "/workload.yaml")
                        for prob in this_workload["workload"].keys():
                            this_workload["workload"][prob]["N"] = timestep
                            this_workload["workload"][prob]["sparsity"] = sparsity / 100
                        yaml_overwrite(now_dir + "/input/workload.yaml", this_workload)
                        f.write("run_arch_" + design + "/" + config + "_timestep" + str(timestep) + "_sparsity" + str(sparsity) + "/" + nn + "\n")

f.close()

