from utils import file_integrity_check, bcolors


class ConfigChecker:
    def __init__(self, config_dict_or_list: dict or list) -> None:
        self.config_dict_or_list = config_dict_or_list
    
    def check(self):
        is_dict = isinstance(self.config_dict_or_list, dict)
        is_list = isinstance(self.config_dict_or_list, list)
        assert is_dict or is_list, bcolors.FAIL + "Input needs to be of type either 'dict' or 'list'." + bcolors.ENDC
        if is_dict:
            file_integrity_check(list(self.config_dict_or_list.values()))
        elif is_list:
            file_integrity_check(self.config_dict_or_list)
        print(bcolors.OKCYAN + "All configuration files exist." + bcolors.ENDC)
        print()
        return None

