from utils import yaml_load, bcolors
import argparse
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.pyplot import cm
import os
import re
import math
import shutil


def construct_argparser():
    parser = argparse.ArgumentParser(description='Roofline')
    parser.add_argument('-r',
                        '--reference',
                        nargs='+',
                        help='search keyword',
                        default=[
                            'arch_tlut_intra/tlut_intra_1024x32_int8_t1',\
                            'arch_tlut_intra/tlut_intra_1024x32_int8_t2',\
                            'arch_tlut_intra/tlut_intra_1024x32_int8_t4',\
                            'arch_tlut_intra/tlut_intra_1024x32_int8_t8',\
                        ],
                        ),
    parser.add_argument('-p',
                        '--perf',
                        help='run perf',
                        action='store_true',
                        default=False),
    parser.add_argument('-c',
                        '--cost',
                        help='run cost',
                        action='store_true',
                        default=False)

    return parser

if __name__ == "__main__":
    parser = construct_argparser()
    args = parser.parse_args()

    source_file = f'runs/program_perf_cost.yaml'
    if args.cost == True and args.perf == True:
        pass
    elif args.cost == True:
        source_file = f'runs/program_cost.yaml'
    elif args.perf == True:
        source_file = f'runs/program_perf.yaml'
    print(source_file)

    for prefix in args.reference:
        prefix = prefix
        dir_append = prefix.split('/')[0]
        prefix = prefix.split('/')[1]
        myrootdir = f'runs/{dir_append}/'
        # print(myrootdir, prefix);exit()
        dir_set = []
        reg_name = re.compile(re.escape(prefix))
        dir_name = next(os.walk(myrootdir))[1]
        for dirnames in dir_name:
            if reg_name.match(dirnames):
                dest=f'runs/{dir_append}/{dirnames}/program.yaml'
                print(f'{dest}, perf={args.perf}, cost={args.cost}')
                shutil.copy2(source_file, dest)