from collections import OrderedDict
import importlib


def dataflow(
    arch_cnfg: OrderedDict,
    prob_cnfg: OrderedDict
):
    """
    This function calls the schedule for one of the supported stong operations:
    conv
    avgpool2d
    spike
    """

    applied_schedule = importlib.import_module("architecture.sparse-snn.schedule" + "_" + prob_cnfg["type"])
    output = getattr(applied_schedule, "dataflow")(arch_cnfg, prob_cnfg)

    return output
