import importlib
from collections import OrderedDict


class ArchBuilder:
    def __init__(self, arch_cnfg: OrderedDict, prob_name: str, prob_cnfg: OrderedDict, outp_path: str) -> None:
        applied_arch = importlib.import_module("architecture." + arch_cnfg["template"])
        self.arch = getattr(applied_arch, "architecture")(arch_cnfg, prob_name, prob_cnfg, outp_path)

    def eval_perf(self, *args):
        return self.arch.eval_perf(*args)

    def eval_cost(self, *args):
        return self.arch.eval_cost(*args)

