clear; close all; clc;

rho0 = 1020; cp = 4000;
alphaT = 2e-4; g = 9.81; Ric = 0.3;
fsize = 12;

load('tavg_stat.mat');
stat = tavg_stat; clear tavg_stat;
cases = 1:length(stat);
for m = cases
    fprintf('%d\t%s\n',m,stat(m).case_name);
end

for m = 1:length(stat)
     tmp = find(stat(m).Rig <= Ric & (stat(m).z <= -20 & stat(m).z >= -100));
     stat(m).MI_indx = tmp(1)+0;
     stat(m).zMI = stat(m).z(tmp(1));
     stat(m).Jtmax_indx = find(stat(m).Jq == min(stat(m).Jq));
     stat(m).zmax = stat(m).z(stat(m).Jtmax_indx);
     ustar = sqrt(-stat(m).tauw/rho0);
     stat(m).L_MO = ustar.^3/0.4/stat(m).Bo;
     stat(m).zMO = -ustar.^3/0.4/stat(m).Bo;
     tmp = find(stat(m).z<= -stat(m).L_MO);
     stat(m).LMO_indx = tmp(end);
end
z = stat(1).z;
tmp = jet;
for k = 1:27
    cs{k} = tmp(8*(k-1)+1,:);
    lg{k} = sprintf('%s',stat(k).case_name);
end



%% Background: S2, Rig, and Jq
figure('unit','in','position',[1 1 8.5 7.75]); 

sp(1) = subplot(2,2,1); hold on;
k = 24;
yindx = stat(k).MI_indx:stat(k).MLD_indx; 
var = stat(k).Jq;
indmin = find(var == min(var));
xx = [-200 var(yindx(end)) var(indmin) 0*var(yindx(1))];
yy = [0 z(yindx(end)) z(indmin) z(yindx(1))];

plot(var(yindx),z(yindx),'Color',cs{k});
plot(xx(2:4),yy(2:4),'r-','LineWidth',2);
plot(xx(2:4),yy(2:4),'rp','MarkerFaceColor','r','MarkerSize',15);
plot(xx(1),yy(1),'bp','MarkerFaceColor','b','MarkerSize',15);
text(xx(2)+30,yy(2),'MLD','FontSize',fsize+2);
text(xx(3)+30,yy(3),'z$^{max}$','FontSize',fsize+6);
text(xx(4)-10,yy(4)+5,'z$^{MI}$','FontSize',fsize+6);
lstring = sprintf('LES J_q in %s',stat(k).case_name);
legend(lstring,'parameterized J_{q,p}','Location','SouthWest');
xlabel('J$_{q,p}$ [W m$^{-2}]$');
ylabel('depth [m]');
text(-675,5,'(a)','FontSize',fsize+2);
box on; grid on;
ylim([-90 0]); xlim([-600 50]);
set(gca,'FontSize',fsize,'XTick',-600:100:0,'XTickLabel',-600:100:0,...
    'YTick',-80:20:0,'YTickLabel',-80:20:0);


for n = 2:4
    sp(n) = subplot(2,2,n); hold on;
    for k = 1:length(stat)
        yindx = stat(k).MI_indx:stat(k).MLD_indx; 
        switch n
            case 2
                var = stat(k).Jq;
                text(-675,5,'(b)','FontSize',fsize+2);
                xlim([-600 50]);
                xx(k) = stat(k).Jq(yindx(1))+10;
                yy(k) = stat(k).z(yindx(1));
                xlabel('J$_q$ [W m$^{-2}$]'); %ylabel('depth [m]');
                %text(xx(k),yy(k),num2str(k),'Fontsize',9,'Color',cs{k});
            case 3
                var = 1e2*sqrt(stat(k).S2);
                text(-0.4,5,'(c)','FontSize',fsize+2);
                xlim([0 3]);
                xx(k) = 1e2*sqrt(stat(k).S2(yindx(1)));
                yy(k) = stat(k).z(yindx(1))-2;
                xlabel('S [10$^{-2}$ s$^{-1}$]'); ylabel('depth [m]');
                %text(xx(k),yy(k),num2str(k),'Fontsize',9,'Color',cs{k});

            case 4
                var = stat(k).Rig;
                text(0.185,5,'(d)','FontSize',fsize+2);
                xlim([0.2 0.31]);
                xx(k) = stat(k).Rig(yindx(1))+0.002;
                yy(k) = stat(k).z(yindx(1));  
                xlabel('Ri$_g$'); %ylabel('depth [m]');  

        end         
        plot(var(yindx),z(yindx),'Color',cs{k});
    end  
    box on; grid on;
    ylim([-90 0]);
    if n == 4
        lgp = legend(lg);
    end
    if n == 2 || n == 4
        set(gca,'YTickLabel',[]);
    end
    lgp.Position = [0.86 0.25 0.1 0.5];
    set(gca,'FontSize',fsize,'YTick',-80:20:0)
end
set(sp(1),'Units','inches','Position',[0.5 4.25 3 3])
set(sp(2),'Units','inches','Position',[4 4.25 3 3])
set(sp(3),'Units','inches','Position',[0.5 0.5 3 3])
set(sp(4),'Units','inches','Position',[4 0.5 3 3])

exportgraphics(gcf,'./image/fig9_Jq_model.jpg','Resolution',300);


