clear; close all; clc;

rho0 = 1020; cp = 4000;
alphaT = 2e-4; g = 9.81;
Ric = 0.3;

fsize = 11; 

tmp = jet;
for k = 1:27
    cs{k} = tmp(8*(k-1)+1,:);
    lg{k} = sprintf('%2d',k);
end

load('tavg_stat.mat');
stat = tavg_stat; clear tavg_stat;

for m = 1:length(stat)
     tmp = find(stat(m).Rig <= Ric & (stat(m).z <= -20 & stat(m).z >= -100));
     stat(m).MI_indx = tmp(1)+0;
     stat(m).zMI = stat(m).z(tmp(1));
     stat(m).Jtmax_indx = find(stat(m).Jq == min(stat(m).Jq));
     stat(m).zmax = stat(m).z(stat(m).Jtmax_indx);
     stat(m).epsmax_indx = stat(m).Jtmax_indx;
     stat(m).epsmax = -min(stat(m).Diss(stat(m).Jtmax_indx));
end

%% Scaling for eps bulk
figure('unit','in','position',[1 1 8 7.5]); 

sp(1) = subplot(2,2,1);
hold on;
for m = 1:length(stat)
    ustar = sqrt(-stat(m).tauw/rho0);
    Bo_ns = stat(m).Bo;
    Smax = sqrt(stat(m).S2(stat(m).epsmax_indx));

    zMI = stat(m).z(stat(m).MI_indx);
    MLD = stat(m).MLD;
    z = stat(m).z;
    sz = stat(m).MI_indx;
    ez = stat(m).MLD_indx;
    eps = -stat(m).Diss(sz:ez)/ustar^2/Smax;
    zz = (z(sz:ez) - z(ez))/(z(ez)-z(sz));
    plot(eps,zz,'Color',cs{m});
end
box on; grid on;
xlabel('$\frac{\varepsilon}{u_\ast^2S^{max}}$');
ylabel('$\frac{z-MLD}{z^{MI}-MLD}$','FontSize',fsize+2);
text(-0.2,0.08,'(a)');
set(gca,'XTick',0:0.2:1,'FontSize',fsize)



sp(2) = subplot(2,2,2);
counter = 0;
hold on;
for m = 1:length(stat)
    counter = counter + 1;
    ustar = sqrt(-stat(m).tauw/rho0);
    z = stat(m).z;
    sz = stat(m).MI_indx;
    ez = stat(m).MLD_indx; 
    Smax = sqrt(stat(m).S2(stat(m).epsmax_indx));
    Bo_ns = stat(m).Bo;
    xx(counter) = ustar^2*Smax/Bo_ns;
    yy(counter) = stat(m).epsmax/ustar^2/Smax;
    plot(xx(counter),yy(counter),'o','Markersize',6,'Color',cs{m},'MarkerFaceColor',cs{m});
end

gamma_eps_max = @(ustar2Smax_Bo) 0.36./ustar2Smax_Bo + 0.18;

plot(linspace(0.4,max(xx)+10,100),gamma_eps_max(linspace(0.4,max(xx)+10,100)),'-k');

box on; grid on;
xlabel('$\frac{u_\ast^2 S^{max}}{B_0}$','FontSize',fsize)
ylabel('$\gamma_\varepsilon^{max} = \frac{\varepsilon^{max}}{u_\ast^2 S^{max}}$','Rotation',90,'FontSize',fsize+16);
text(5,0.9,'$\gamma_\varepsilon^{max} =  0.36 (\frac{u_\ast^2S^{max}}{B_0})^{-1} +  0.18$','FontSize',fsize);
text(5,0.8,'$r^2 = 0.93$','FontSize',fsize);
text(-10,1.07,'(b)','FontSize',fsize+2);
axis([0 60 0 1]);
set(gca,'FontSize',fsize);


sp(3) = subplot(2,2,3);
hold on;
for m = 1:length(stat)
    ustar = sqrt(-stat(m).tauw/rho0);
    Bo_ns = stat(m).Bo;
    zMI = stat(m).z(stat(m).MI_indx);
    MLD = stat(m).MLD;
    z = stat(m).z;
    sz = stat(m).MI_indx;
    ez = stat(m).MLD_indx;
    Smax = sqrt(stat(m).S2(stat(m).epsmax_indx));
    eps = -stat(m).Diss(sz:ez)/(0.36*Bo_ns + 0.18*ustar^2*Smax);
    zz = (z(sz:ez) - z(ez))/(z(ez)-z(sz));
    plot(eps,zz,'Color',cs{m});
end
box on; grid on;
xlabel('$\frac{\varepsilon}{0.36 B_0 + 0.18 u_\ast^2S^{max}}$');
ylabel('$\frac{z-MLD}{z^{MI}-MLD}$','FontSize',fsize+2);
text(-0.3,0.02,'(c)');
xlim([0 2])
set(gca,'XTick',0:0.5:2,'FontSize',fsize)
set(gca,'FontSize',fsize)

set(sp(1),'Units','inches','Position',[0.75 4.1 3 3])
set(sp(2),'Units','inches','Position',[4.5 4.1 3 3])
set(sp(3),'Units','inches','Position',[2.75 0.5 3 3])

exportgraphics(gcf,'./image/fig8_epsbulk_model.jpg','Resolution',300);


