clear; close all; clc;


rho0 = 1020; cp = 4000;
alphaT = 2e-4; g = 9.81;
Ric = 0.3;

fsize = 12; 

tmp = jet;
for k = 1:27
    cs{k} = tmp(8*(k-1)+1,:);
    lg{k} = sprintf('%2d',k);
end


load('tavg_stat.mat');
stat = tavg_stat; clear tavg_stat;

for m = 1:length(stat)
     tmp = find(stat(m).Rig <= Ric & (stat(m).z <= -20 & stat(m).z >= -100));
     stat(m).MI_indx = tmp(1)+0;
     stat(m).zMI = stat(m).z(tmp(1));
     stat(m).Jtmax_indx = find(stat(m).Jq == min(stat(m).Jq));
     stat(m).zmax = stat(m).z(stat(m).Jtmax_indx);
end


%% Scaling for <uw>
figure('unit','in','position',[1 1 7.75 4]); 

sp(1) = subplot(1,2,1);
hold on;
counter = 0;
for m = 1:length(stat)
    counter = counter + 1;
    z = stat(m).z;
    prod = stat(m).Prod(stat(m).Jtmax_indx);
    diss = stat(m).Diss(stat(m).Jtmax_indx);
    bflux = stat(m).Bflux(stat(m).Jtmax_indx);
    xx = log10(-bflux);
    balance(m) = (-bflux-diss)/prod;
    if m == 1
    leg(1) = plot(xx,-bflux/prod,'o','Markersize',6,'Color',cs{m},'MarkerFaceColor',cs{m});
    leg(2) = plot(xx,-diss/prod,'d','Markersize',6,'Color',cs{m});
    leg(3) = plot(xx,(-bflux-diss)/prod,'s','MarkerSize',6,'Color',cs{m});
    else
    plot(xx,-bflux/prod,'o','Markersize',6,'Color',cs{m},'MarkerFaceColor',cs{m});
    plot(xx,-diss/prod,'d','Markersize',6,'Color',cs{m});
    plot(xx,(-bflux-diss)/prod,'s','MarkerSize',6,'Color',cs{m});
    end
end

axis([-8.2 -6.4 0 1.4]);
box on; grid on;
text(-8.3,1.5,'(a)','FontSize',fsize+2);
xlabel('log$_{10}(-J_b^{max}$)','FontSize',fsize)
legend(leg,'-$J_b^{max}$/P$^{max}$','$\varepsilon^{max}$/P$^{max}$',...
      '(-$J_b^{max}$ + $\varepsilon^{max}$)/P$^{max}$','Location','NorthEast','Interpreter','latex')
set(gca,'FontSize',fsize)

sp(2) = subplot(1,2,2);
hold on;
counter = 0;
for m = 1:length(stat)
    counter = counter + 1;
    z = stat(m).z;
    ustar = sqrt(-stat(m).tauw/rho0);
    Jm = stat(m).Jm(stat(m).Jtmax_indx);
    bflux = stat(m).Bflux(stat(m).Jtmax_indx);
    xx(counter) = log10(-bflux);
    yy(counter) = Jm/ustar.^2;
    plot(xx(counter),yy(counter),'o','Markersize',6,'Color',cs{m},'MarkerFaceColor',cs{m});
end
axis([-8.2 -6.4 0 1.5]);
box on; grid on;
text(-8.3,1.6,'(b)','FontSize',fsize+2);
xlabel('log$_{10}(-J_b^{max}$)','FontSize',fsize)
ylabel('$\left<u''w''\right>^{max}/u_\ast^2$');
set(gca,'FontSize',fsize)

set(sp(1),'Units','inches','Position',[0.6 0.5 3 3])
set(sp(2),'Units','inches','Position',[4.25 0.5 3 3])

exportgraphics(gcf,'./image/fig7_Jm_energetic.jpg','Resolution',300);


