clear; clc; close all;

rho0 = 1020; cp = 4000;
alphaT = 2e-4; g = 9.81;
fsize = 12;

load('tavg_stat.mat');
z = tavg_stat(1).z;
cs = 'krbg';

figure('unit','in','position',[1 1 7.25 9.5]); 
for n = 1:6
    switch n
        case 1
            tstring = '(a) Convection';
            counter = 0;
            for m = 1:4
                for k = 1:length(tavg_stat)
                    if strcmp(tavg_stat(k).case_name,strrep('C*T4W1S1','*',num2str(m)))
                        counter = counter + 1;
                        cid{n}(counter) = k;
                        lstring{counter} = tavg_stat(k).case_name;
                    end
                end
            end
            
        case 2 %C2T*W2W2
            tstring = '(b) MI layer thickness';
            %cid{n} = [7,6,5,2];
            counter = 0;
            for m = 1:4
                for k = 1:length(tavg_stat)
                    if strcmp(tavg_stat(k).case_name,strrep('C2T*W3S2','*',num2str(m)))
                        counter = counter + 1;
                        cid{n}(counter) = k;
                        lstring{counter} = tavg_stat(k).case_name;
                    end
                end
            end

        case 3 %C2T4W*S2
            tstring = '(c) Wind with S2 shear';
            counter = 0;
            for m = 1:4
                for k = 1:length(tavg_stat)
                    if strcmp(tavg_stat(k).case_name,strrep('C2T4W*S2','*',num2str(m)+1))
                        counter = counter + 1;
                        cid{n}(counter) = k;
                        lstring{counter} = tavg_stat(k).case_name;
                    end
                end
            end

        case 4 %C2T4W*S3
            tstring = '(d) Wind with S3 shear';
            counter = 0;
            for m = 1:4
                for k = 1:length(tavg_stat)
                    if strcmp(tavg_stat(k).case_name,strrep('C2T4W*S3','*',num2str(m)+1))
                        counter = counter + 1;
                        cid{n}(counter) = k;
                        lstring{counter} = tavg_stat(k).case_name;
                    end
                end
            end
        case 5 %C2T4W2S*
            tstring = '(e) Shear with W3 wind';
            counter = 0;          
            for m = 1:4
                for k = 1:length(tavg_stat)
                    if strcmp(tavg_stat(k).case_name,strrep('C2T4W3S*','*',num2str(m)))
                        counter = counter + 1;
                        cid{n}(counter) = k;
                        lstring{counter} = tavg_stat(k).case_name;
                    end
                end
            end
        case 6 %C2T4W3S*
            tstring = '(f) Shear with W4 wind';            
            counter = 0;          
            for m = 1:4
                for k = 1:length(tavg_stat)
                    if strcmp(tavg_stat(k).case_name,strrep('C2T4W4S*','*',num2str(m)))
                        counter = counter + 1;
                        cid{n}(counter) = k;
                        lstring{counter} = tavg_stat(k).case_name;
                    end
                end
            end
            
    end
    sp(n) = subplot(3,2,n); hold on
    counter = 1;
    for m = 1:length(cid{n})
        var = tavg_stat(cid{n}(m)).Jq;
        plot(var(1:end-3),z(1:end-3),cs(counter));
        counter = counter +1;
    end
    box on; grid on;
    axis([-350 100 -100 0]);
    legend(lstring,'Location','SouthWest');
    text(-375,8,tstring,'FontSize',fsize+2);
    set(gca,'FontSize',fsize);
    set(gca,'XTick',-300:100:100,'XTickLabel',[])
    set(gca,'YTick',-100:20:0,'YTickLabel',[])
    if any(n == [1,3,5])
        ylabel('depth [m]')
        set(gca,'YTick',-100:20:0,'YTickLabel',-100:20:0)
    end
    if any(n == [5,6])
        xlabel('J$_q$ [W m$^{-2}$]')
        set(gca,'XTick',-300:100:100,'XTickLabel',-300:100:100)
    end

end

set(sp(1),'Units','inches','Position',[0.75 6.5 3 2.5])
set(sp(2),'Units','inches','Position',[4    6.5 3 2.5])
set(sp(3),'Units','inches','Position',[0.75 3.5 3 2.5])
set(sp(4),'Units','inches','Position',[4    3.5 3 2.5])
set(sp(5),'Units','inches','Position',[0.75 0.5 3 2.5])
set(sp(6),'Units','inches','Position',[4    0.5 3 2.5])
exportgraphics(gcf,'./image/fig6_Jq_all.jpg','Resolution',300);

