clear; clc; close all;

fsize = 12;
show_window = [0 24.0 -90 0];
yrange = [-90 0];
tickY = -80:20:0;
hMLD = -25;

load('convection.mat');
allstat = convection;

load('tavg_stat.mat');

for n = 1:length(allstat)
    for m = 1:length(tavg_stat)
        if strcmp(allstat(n).case_name,tavg_stat(m).case_name)
          allstat(n).z_avg = tavg_stat(m).z;
          allstat(n).N2_avg = tavg_stat(m).N2;
          allstat(n).S2_avg = tavg_stat(m).S2;
          allstat(n).Ri_avg = tavg_stat(m).Rig;
          allstat(n).Jq_avg = tavg_stat(m).Jq;
        end
    end
end
z = allstat(1).z;
z_avg = allstat(1).z_avg;

%%
figure('unit','in','position',[1 1 7 8.25])

for n = 1:4
    switch n
        case 1
            cid = 1; 
        case 2
            cid = 2;
        case 3
            cid = 3;
        case 4
            cid = 4;
    end
    tstring{n} = sprintf('(%s) Case %s',96+n,allstat(cid).case_name);

sp(2*n-1) = subplot(4,2,2*n-1);
hold on;
pcolor(allstat(cid).time/3600,z,log10(allstat(cid).eps)); shading interp;
plot(allstat(cid).time/3600,allstat(cid).MLDinst,'-w');
plot(allstat(cid).time/3600,allstat(cid).MLDinst,'--m');
caxis([-9 -5]);
ca = colorbar;
ca.Location = 'NorthOutside';
ca.Position = [0.3 0.98 0.35 0.0175];
ca.Ticks = -9:-5;
ca.AxisLocation = 'in';
axis(show_window);grid on; box on;
ylabel('depth [m]');
text(-2,9,tstring{n},'FontSize',fsize+1)
set(gca,'TickDir','out','XTick',0:3:24,'XTickLabel',[],'YTick',tickY)
set(gca,'FontSize',fsize);
if n == 1 
   text(4,28,'log$_{10}$ ($\epsilon$)','FontSize',fsize+4); 
elseif n == 4
   xlabel('time [hr]');
   set(gca,'XTickLabel',0:3:24);
end


sp(2*n) = subplot(4,2,2*n); hold on;
plot(1e4*4*allstat(cid).N2_avg,z_avg,'r');
plot(1e4*allstat(cid).S2_avg,z_avg,'b');
plot([0 2],mean(allstat(cid).MLDinst)*ones(1,2),':m');
axis([0 2 yrange]); grid on; box on;
set(gca,'TickDir','out','XTick',0:1:2,'XTickLabel',[],'YTick',tickY,'YTickLabel',[])
set(gca,'FontSize',fsize);
if n == 1
    legend('4N^2','S^2','Location','NorthOutSide'); 
elseif n == 4
     set(gca,'XTick',0:2,'XTickLabel',0:2)
     xlabel('[10$^{-4}$ s$^{-2}]$')
end

ax{2*n-1} = axes('unit','in','position',[5.9 6.1-1.8*(n-1) 0.9 1.5]);
plot(ax{2*n-1},allstat(cid).Ri_avg(z_avg < -20),z_avg(z_avg < -20),'--b'); hold on;
plot(ax{2*n-1},[0 1],mean(allstat(cid).MLDinst)*ones(1,2),':m');
axis([0 0.6 yrange]); grid on; box on; 
if n == 1
   xlabel('Ri$_g$'); 
   set(gca,'TickDir','out','XTick',0:0.2:0.6,'XTickLabel',0:0.2:0.6,'YTick',tickY,'YTickLabel',[])
else
   set(gca,'TickDir','out','XTick',0:0.2:0.6,'XTickLabel',[],'YTick',tickY,'YTickLabel',[])
end
set(gca,'FontSize',fsize,'XAxisLocation','top','XColor','b'); 

ax{2*n} = axes('unit','in','position',[5.9 6.1-1.8*(n-1) 0.9 1.5]);
plot(ax{2*n},allstat(cid).Jq_avg,z_avg,'r');
axis([-60 0 yrange]); grid on; box on;
set(gca,'TickDir','out','XTick',-40:20:0,'XTickLabel',[],'YTick',tickY,'YTickLabel',[])
set(gca,'FontSize',fsize,'Color','none','XAxisLocation','bottom','Xcolor','r'); 

if n == 4
xlabel('J$_q$ [W m$^{-2}$]')
set(gca,'TickDir','out','XTick',-40:20:0,'XTickLabel',...
           -40:20:0,'YTick',tickY,'YTickLabel',[])
set(gca,'FontSize',fsize,'Color','none','XAxisLocation','bottom','Xcolor','r'); 
end

end

for n = 1:2:7
    colormap(sp(n),cmocean('balance'));
end

set(sp(1),'unit','in','position',[0.5 6.1 4.25 1.5]);
set(sp(3),'unit','in','position',[0.5 4.3 4.25 1.5]);
set(sp(5),'unit','in','position',[0.5 2.5 4.25 1.5]);
set(sp(7),'unit','in','position',[0.5 0.7 4.25 1.5]);

set(sp(2),'unit','in','position',[4.9 6.1 0.9 1.5]);
set(sp(4),'unit','in','position',[4.9 4.3 0.9 1.5]);
set(sp(6),'unit','in','position',[4.9 2.5 0.9 1.5]);
set(sp(8),'unit','in','position',[4.9 0.7 0.9 1.5]);

exportgraphics(gcf,'./image/fig2_convection.jpg','Resolution',300);

