clear all; close all; clc;
load('meanIC.mat')

rho0 = 1020; cp = 4000;
alphaT = 2e-4; g = 9.81; 
Ric = 0.3;

z = meanIC(1).z;

fsize = 12;
cs = 'krbgm';

figure('units','inches','position',[1 1 7.25 7.5]);
% shear
cID = [5,6,8,20];
for m = 1:5
    sp(m) = subplot(3,5,m); hold on;
    c = 1;
    for n = 1:4
        switch m
            case 1
                var = meanIC(cID(n)).U;
                axis([-0.8 0.8 -100 0]);
                ylabel('depth [m]');
            case 2
                var = meanIC(cID(n)).T + 28;
                axis([18 28 -100 0]);
                set(gca,'XTick',18:3:27)               
            case 3
                var = 1e4*meanIC(cID(n)).S2;
                axis([0 7 -100 0]);
                set(gca,'XTick',0:2:6)
            case 4
                var = 1e4*meanIC(cID(n)).N2;
                axis([0 4.5 -100 0]);
                set(gca,'XTick',0:1:4)
            case 5
                var = meanIC(cID(n)).Rig;
                plot([0.25 0.25],[-100 0],'k--','LineWidth',0.5)
                axis([0 0.5 -100 0]);
                set(gca,'XTick',0:0.2:0.4);
        end
        plot(var,z,cs(c));
        c = c + 1;
    end
    box on; grid on;
    set(gca,'YTick',-100:20:0)

    if m ~= 1
        set(gca,'YTickLabel',[])
    end
    if m == 2; legend('S1','S2','S3','S4','Location','northwest'); end
    if m == 1; text(-1.5,10,'(a) Variablity of background shear','FontSize',fsize); end
    if m == 5
        ah = annotation('doublearrow',[0.81 0.81],[0.88 0.94],'LineWidth',0.5);
        ah.Head1Length = 5;
        ah.Head2Length = 5;
        ah.Head1Width = 5;
        ah.Head2Width = 5;
        text(0.05,-12,'mixed layer','Rotation',0,'FontSize',fsize)
        ah1 = annotation('doublearrow',[0.81 0.81],[0.75 0.87],'LineWidth',0.5);
        ah1.Head1Length = 5;
        ah1.Head2Length = 5;
        ah1.Head1Width = 5;
        ah1.Head2Width = 5;
        text(0.05,-55,'MI layer','Rotation',0,'FontSize',fsize)


    end
    set(gca,'FontSize',fsize)

end

% MI depth
cID = [9,10,13,12];
for m = 1:5
    sp(m+5) = subplot(3,5,m+5); hold on;
    c = 1;
    for n = 1:4
        legend_string{n} = meanIC(cID(n)).case_name(3:4);
        switch m
            case 1
                var = meanIC(cID(n)).U;
                axis([-0.8 0.8 -100 0]);
                ylabel('depth [m]');  xlabel('U [m s$^{-1}$]');
            case 2
                var = meanIC(cID(n)).T + 28;
                axis([18 28 -100 0]);
                set(gca,'XTick',18:3:27); xlabel('T [$^\circ$C]');
            case 3
                var = 1e4*meanIC(cID(n)).S2;
                axis([0 7 -120 0]); xlabel('S$_0^2$ [10$^{-4}$ s$^{-2}$]');
                set(gca,'XTick',0:2:6);
            case 4
                var = 1e4*meanIC(cID(n)).N2;
                axis([0 4.5 -100 0]); xlabel('N$^2$ [10$^{-4}$ s$^{-2}$]');
                set(gca,'XTick',0:1:4)
            case 5
                var = meanIC(cID(n)).Rig;
                plot([0.25 0.25],[-100 0],'k--','LineWidth',0.5)
                axis([0 0.5 -100 0]); xlabel('Ri$_g$');
                set(gca,'XTick',0:0.2:0.4)
        end
        plot(var,z,cs(c));
        c = c + 1;
    end
    box on; grid on;
    set(gca,'YTick',-100:20:0)
    if m ~= 1; set(gca,'YTickLabel',[]);end
    if m == 2; legend(legend_string,'Location','northwest'); end
    if m == 1; text(-1.5,10,'(b) Variability of MI layer thickness','FontSize',fsize); end
    set(gca,'FontSize',fsize)
end

load('tavg_stat.mat');
stat = tavg_stat; clear tavg_stat;

clear cs
sp(11) = subplot(3,5,11); hold on;
tmp = jet;
for k = 1:27
    cs{k} = tmp(8*(k-1)+1,:);
end

counter = 0;
for m = 1:length(stat)
    counter = counter + 1;
    lstring{counter} = stat(m).case_name;

    tmp = find(stat(m).Rig <= Ric & (stat(m).z <= -20 & stat(m).z >= -100));
    stat(m).MI_indx = tmp(1)+0;
    stat(m).zMI = stat(m).z(tmp(1));
    sz = stat(m).MI_indx;
    ez = stat(m).MLD_indx;
    stat(m).epsmax_indx = find(stat(m).Jq == min(stat(m).Jq(sz:ez)));
    ustar = sqrt(-stat(m).tauw/rho0);
    S = sqrt(stat(m).S2);
    intS = trapz(z(sz:ez),S(sz:ez));
    Savg = intS/(z(ez)-z(sz));
    Bo_ns = stat(m).Bo;
    yy(counter) = Bo_ns*1e8;
    xx(counter) = log10(ustar^2*Savg);
    plot(xx(counter),yy(counter),'o','Markersize',6,'Color',cs{m},'MarkerFaceColor',cs{m});
end
box on; grid on;
xlabel('$log_{10}(u_\ast^2S^b)$')
ylabel('$B_0 \, [\times 10^{-8} \, m^2 s^{-3}$] ')
ylim([4 9]);
xlim([-8 -5]);
legend(lstring,'NumColumns',3,'Location','eastoutside');
text(-8.6,9.5,'(c) Variability of turbulent intensity','FontSize',fsize); 

set(sp(1),'Units','inches','Position',[0.6 5.1+0.2 1.1 1.75])
set(sp(2),'Units','inches','Position',[1.9 5.1+0.2 1.1 1.75])
set(sp(3),'Units','inches','Position',[3.2 5.1+0.2 1.1 1.75])
set(sp(4),'Units','inches','Position',[4.5 5.1+0.2 1.1 1.75])
set(sp(5),'Units','inches','Position',[5.8 5.1+0.2 1.1 1.75])

set(sp(6),'Units','inches','Position',[0.6 2.8+0.2 1.1 1.75])
set(sp(7),'Units','inches','Position',[1.9 2.8+0.2 1.1 1.75])
set(sp(8),'Units','inches','Position',[3.2 2.8+0.2 1.1 1.75])
set(sp(9),'Units','inches','Position',[4.5 2.8+0.2 1.1 1.75])
set(sp(10),'Units','inches','Position',[5.8 2.8+0.2 1.1 1.75])
set(sp(11),'Units','inches','Position',[0.6 0.5 2.25 1.75])

exportgraphics(gcf,'./image/fig1_meanIC.jpg','Resolution',300);
