clear; close all; clc;

fsize = 12;
tmp = jet;
for k = 1:12
    cs{k} = tmp(21*(k-1)+1,:);
    lg{k} = sprintf('%2d',k);
end
cs = circshift(cs,8);


blue=0.5*[0 0 1];
red= 0.5*[1 0 0];
grey=.5*[1 1 1];
lgrey=.9*[1 1 1];
magenta = 0.5*[1 0 1];
cyan = 0.5*[0 1 1];



%%
load('Jqsvar.mat');
month = {'Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'};

for m = 1:12
    seasonal(m).month = month{m};
    seasonal(m).Qsw = Jqsvar.Jq0_swr(1,m); 
    seasonal(m).Qns = Jqsvar.Jq0_ns(1,m); 
    seasonal(m).Qnet = Jqsvar.Jq0_net(1,m); 

    seasonal(m).Jq_chipod = Jqsvar.Jq_chipod(1,m); 
    seasonal(m).Jq_chipod_mn1 = Jqsvar.Jq_chipod(2,m); 
    seasonal(m).Jq_chipod_mn2 = Jqsvar.Jq_chipod(3,m); 
    seasonal(m).Jq_M89 = Jqsvar.Jq_M89(1,m);
    seasonal(m).Jq_M89_mn1 = Jqsvar.Jq_M89(2,m);
    seasonal(m).Jq_M89_mn2 = Jqsvar.Jq_M89(3,m);

    seasonal(m).Jq_S21 = Jqsvar.Jq_S21(1,m);
    seasonal(m).Jq_S21_mn1 = Jqsvar.Jq_S21(2,m);
    seasonal(m).Jq_S21_mn2 = Jqsvar.Jq_S21(3,m);

    seasonal(m).Jq_M22 = Jqsvar.Jq_M22(1,m);
    seasonal(m).Jq_M22_mn1 = Jqsvar.Jq_M22(2,m);
    seasonal(m).Jq_M22_mn2 = Jqsvar.Jq_M22(3,m);

    seasonal(m).Jq_P23 = Jqsvar.Jq_P23_bulk(1,m);
    seasonal(m).Jq_P23_mn1 = Jqsvar.Jq_P23_bulk(2,m);
    seasonal(m).Jq_P23_mn2 = Jqsvar.Jq_P23_bulk(3,m);

    seasonal(m).Jq_P23_max = Jqsvar.Jq_P23_max(1,m);
    seasonal(m).Jq_P23_max_mn1 = Jqsvar.Jq_P23_max(2,m);
    seasonal(m).Jq_P23_max_mn2 = Jqsvar.Jq_P23_max(3,m);
    
    seasonal(m).zmax_P23 = Jqsvar.zmax(1,m);
    seasonal(m).zmax_P23_mn1 = Jqsvar.zmax(2,m);
    seasonal(m).zmax_P23_mn2 = Jqsvar.zmax(3,m);

    seasonal(m).dJqdz_chim = Jqsvar.dJqdz_chim(1,m);
    seasonal(m).dJqdz_chim_mn1 = Jqsvar.dJqdz_chim(2,m);
    seasonal(m).dJqdz_chim_mn2 = Jqsvar.dJqdz_chim(3,m);

    seasonal(m).dJqdz_S21 = Jqsvar.dJqdz_S21(1,m);
    seasonal(m).dJqdz_S21_mn1 = Jqsvar.dJqdz_S21(2,m);
    seasonal(m).dJqdz_S21_mn2 = Jqsvar.dJqdz_S21(3,m);

    seasonal(m).dJqdz_M22 = Jqsvar.dJqdz_M22(1,m);
    seasonal(m).dJqdz_M22_mn1 = Jqsvar.dJqdz_M22(2,m);
    seasonal(m).dJqdz_M22_mn2 = Jqsvar.dJqdz_M22(3,m);

    seasonal(m).dJqdz_P23 = Jqsvar.dJqdz_P23(1,m);
    seasonal(m).dJqdz_P23_mn1 = Jqsvar.dJqdz_P23(2,m);
    seasonal(m).dJqdz_P23_mn2 = Jqsvar.dJqdz_P23(3,m);
end

%% Plot seasonal profile

figure('unit','in','position',[1 1 8 9.75]);

sp(1) = subplot(1,3,1); hold on;

yyaxis left;
set(gca,'YColor','k')

x1=[1:1:12 12:-1:1];
y2=[ [seasonal.Jq_P23_max_mn1] fliplr([seasonal.Jq_P23_max_mn2])];
pk=~isnan(x1.*y2);
p2p=patch(x1(pk),y2(pk),[grey+[1 1 1]]/2);hold on
p2p.EdgeColor = grey;

p2 = plot([seasonal.Jq_P23_max],'--k');
box on; grid on;
ylabel('$J_{q,p}^{max}$ [W m$^{-2}$]');
set(gca,'XTick',1:12,'XTickLabel',month)
xlim([0.8 12.2]);
ylim([-200 -50]);
set(gca,'FontSize',fsize);
text(0.5,-40,'(a) $J_{q,p}^{max}$ and $z^{max}_p$','FontSize',fsize + 2)
set(gca,'FontSize',fsize);

yyaxis right;
set(gca,'YColor','r')

x1=[1:1:12 12:-1:1];

y1=[ [seasonal.zmax_P23_mn1] fliplr([seasonal.zmax_P23_mn2])];
pk=~isnan(x1.*y1);
p1p=patch(x1(pk),y1(pk),[red+[1 1 1]]/2);hold on
p1p.EdgeColor = red;

p1 = plot([seasonal.zmax_P23],'--r');

ylabel('z$^{max}_p$ [m]')
ylim([-60 -30]);

legend([p2 p1],'J_{q,p}^{max}','z^{max}_p','Location','NorthEast')

sp(2) = subplot(1,3,2); hold on;

x1=[1:1:12 12:-1:1];
y1=[ [seasonal.Jq_chipod_mn1] fliplr([seasonal.Jq_chipod_mn2])];
pk=~isnan(x1.*y1);
p=patch(x1(pk),y1(pk),[grey+[1 1 1]]/2);hold on

y3=[ [seasonal.Jq_M89_mn1] fliplr([seasonal.Jq_M89_mn2])];
pk=~isnan(x1.*y3);
p3p=patch(x1(pk),y3(pk),[cyan+[1 1 1]]/2);hold on
p3p.EdgeColor = cyan;

y4=[ [seasonal.Jq_S21_mn1] fliplr([seasonal.Jq_S21_mn2])];
pk=~isnan(x1.*y4);
p4p=patch(x1(pk),y4(pk),[blue+[1 1 1]]/2);hold on
p4p.EdgeColor = blue;

y5=[ [seasonal.Jq_M22_mn1] fliplr([seasonal.Jq_M22_mn2])];
pk=~isnan(x1.*y5);
p5p=patch(x1(pk),y5(pk),[magenta+[1 1 1]]/2);hold on
p5p.EdgeColor = magenta;

y2=[ [seasonal.Jq_P23_mn1] fliplr([seasonal.Jq_P23_mn2])];
pk=~isnan(x1.*y2);
p2p=patch(x1(pk),y2(pk),[red+[1 1 1]]/2);hold on
p2p.EdgeColor = red;

p1 = plot([seasonal.Jq_chipod],'-k');

p2 = plot([seasonal.Jq_P23],'--r');

p3 = plot([seasonal.Jq_M89],'--c');

p4 = plot([seasonal.Jq_S21],'--b');

p5 = plot([seasonal.Jq_M22],'--m');

lg = legend([p1,p2,p3,p4,p5],'$\chi$-{pod}', ...
    '$\bar{J}_{q,p}$', ...
    '$\bar{J}_{q,p1}$', ...
    '$\bar{J}_{q,p2}$', ...
    '$\bar{J}_{q,p3}$',...
    'location','SouthWest','NumColumns',1,'AutoUpdate','off','Interpreter','latex');
lg.Position = [0.005 0.4 0.6248 0.0564]

box on; grid on;
ylabel('Heat flux [W m$^{-2}$]');
set(gca,'XTick',1:12,'XTickLabel',month)
xlim([0.8 12.2]);
ylim([-220 0]);
set(gca,'FontSize',fsize);
text(0.5,15,'(b) Depth-averaged seasonal heat fluxes','FontSize',fsize + 2)
set(gca,'FontSize',fsize);


clear p p3p p4p p4p p2p


sp(3) = subplot(1,3,3); hold on;

y2=[ [seasonal.dJqdz_P23_mn1] fliplr([seasonal.dJqdz_P23_mn2])];
pk=~isnan(x1.*y2);
p2p=patch(x1(pk),y2(pk),[grey+[1 1 1]]/2);hold on
p2p.EdgeColor = grey;

p2 = plot([seasonal.dJqdz_P23],'--k');
plot(-1:13,zeros(1,15),':k');


text(2.5,0.2,'warming','Color','k');
annotation('doublearrow',[0.13 0.38],[0.18 0.18],'Color','k')
text(8.5,0.2,'cooling','Color','k');
annotation('doublearrow',[0.4 0.87],[0.18 0.18],'Color','k')

box on; grid on;
xlabel('month');
ylabel('$\frac{-1}{\rho_0 c_p} \frac{Q_{net} + I^{max} + J_{q,p}^{max}}{z^{max}_p}$ [K month$^{-1}$]');
set(gca,'XTick',1:12,'XTickLabel',month)
xlim([0.8 12.2]);
ylim([-1.5 1.5]);
set(gca,'FontSize',fsize);
text(0.5,1.7,'(c) Heat flux divergence','FontSize',fsize + 2)
set(gca,'FontSize',fsize);


set(sp(1),'unit','in','position',[0.7 6.7 6.5 2.5])
set(sp(2),'unit','in','position',[0.7 3.6 6.5 2.5])
set(sp(3),'unit','in','position',[0.7 0.5 6.5 2.5])


exportgraphics(gcf,'./image/fig14_seasonal_parameterization.jpg','Resolution',300);

